/*
 * Decompiled with CFR 0.152.
 */
package ghidra.python;

import db.Transaction;
import generic.jar.ResourceFile;
import ghidra.app.script.GhidraState;
import ghidra.framework.plugintool.PluginTool;
import ghidra.program.model.listing.Program;
import ghidra.python.PythonPlugin;
import ghidra.python.PythonScript;
import ghidra.util.task.TaskMonitor;
import java.io.File;
import java.io.PrintWriter;
import java.util.concurrent.atomic.AtomicBoolean;
import org.python.core.PyException;
import org.python.core.PyObject;

class PythonPluginExecutionThread
extends Thread {
    private PythonPlugin plugin;
    private String cmd;
    private AtomicBoolean moreInputWanted;

    PythonPluginExecutionThread(PythonPlugin plugin, String cmd, AtomicBoolean moreInputWanted) {
        super("Python plugin execution thread");
        this.plugin = plugin;
        this.cmd = cmd;
        this.moreInputWanted = moreInputWanted;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        TaskMonitor interactiveTaskMonitor = this.plugin.getInteractiveTaskMonitor();
        PythonScript interactiveScript = this.plugin.getInteractiveScript();
        Program program = this.plugin.getCurrentProgram();
        try (Transaction tx = program != null ? program.openTransaction("Python command") : null;){
            interactiveTaskMonitor.clearCancelled();
            interactiveScript.setSourceFile(new ResourceFile(new File("python")));
            PluginTool tool = this.plugin.getTool();
            interactiveScript.set(new GhidraState(tool, tool.getProject(), program, this.plugin.getProgramLocation(), this.plugin.getProgramSelection(), this.plugin.getProgramHighlight()), interactiveTaskMonitor, new PrintWriter(this.plugin.getConsole().getStdOut()));
            this.moreInputWanted.set(false);
            this.moreInputWanted.set(this.plugin.getInterpreter().push(this.cmd, this.plugin.getInteractiveScript()));
        }
        catch (PyException pye) {
            String exceptionName = PyException.exceptionClassName((PyObject)pye.type);
            if (exceptionName.equalsIgnoreCase("exceptions.SystemExit")) {
                this.plugin.reset();
            } else {
                this.plugin.getConsole().getErrWriter().println("Suppressing exception: " + PyException.exceptionClassName((PyObject)pye.type));
            }
        }
        catch (StackOverflowError soe) {
            this.plugin.getConsole().getErrWriter().println("Stack overflow!");
        }
        finally {
            interactiveScript.end(false);
        }
    }
}

