/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.functiongraph;

import ghidra.app.plugin.core.colorizer.ColorizingService;
import ghidra.app.plugin.core.functiongraph.FGColorProvider;
import ghidra.app.plugin.core.functiongraph.FunctionGraphPlugin;
import ghidra.app.plugin.core.functiongraph.graph.vertex.FGVertex;
import ghidra.app.plugin.core.functiongraph.mvc.FunctionGraphVertexAttributes;
import ghidra.framework.options.SaveState;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.listing.Program;
import java.awt.Color;
import java.util.List;

class ToolBasedColorProvider
implements FGColorProvider {
    private final ColorizingService service;
    private final FunctionGraphPlugin plugin;

    ToolBasedColorProvider(FunctionGraphPlugin plugin, ColorizingService colorizingService) {
        this.plugin = plugin;
        this.service = colorizingService;
    }

    @Override
    public boolean isUsingCustomColors() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setVertexColor(FGVertex vertex, Color color) {
        Program program = this.plugin.getCurrentProgram();
        int id = program.startTransaction("Set Background Color");
        try {
            this.service.setBackgroundColor(vertex.getAddresses(), color);
        }
        finally {
            program.endTransaction(id, true);
        }
        vertex.setBackgroundColor(color);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clearVertexColor(FGVertex vertex) {
        Program program = this.plugin.getCurrentProgram();
        int id = program.startTransaction("Set Background Color");
        try {
            this.service.clearBackgroundColor(vertex.getAddresses());
        }
        finally {
            program.endTransaction(id, true);
        }
        vertex.clearColor();
    }

    @Override
    public Color getColorFromUser(Color startColor) {
        return this.service.getColorFromUser(startColor);
    }

    @Override
    public Color getMostRecentColor() {
        return this.service.getMostRecentColor();
    }

    @Override
    public List<Color> getRecentColors() {
        return this.service.getRecentColors();
    }

    @Override
    public void savePluginColors(SaveState saveState) {
    }

    @Override
    public void loadPluginColor(SaveState saveState) {
    }

    @Override
    public void saveVertexColors(FGVertex vertex, FunctionGraphVertexAttributes settings) {
    }

    @Override
    public void loadVertexColors(FGVertex vertex, FunctionGraphVertexAttributes settings) {
        AddressSetView addresses = vertex.getAddresses();
        AddressSetView allColorAddress = this.service.getAllBackgroundColorAddresses();
        if (!allColorAddress.contains(addresses)) {
            return;
        }
        Color savedColor = this.service.getBackgroundColor(vertex.getVertexAddress());
        if (savedColor != null) {
            vertex.restoreColor(savedColor);
        }
    }
}

