/*
 * Decompiled with CFR 0.152.
 */
package ghidra.feature.vt.api.correlator.program;

import ghidra.app.plugin.match.FunctionHasher;
import ghidra.app.plugin.match.MatchFunctions;
import ghidra.feature.vt.api.main.VTAssociationType;
import ghidra.feature.vt.api.main.VTMatchInfo;
import ghidra.feature.vt.api.main.VTMatchSet;
import ghidra.feature.vt.api.main.VTScore;
import ghidra.feature.vt.api.util.VTAbstractProgramCorrelator;
import ghidra.framework.options.ToolOptions;
import ghidra.framework.plugintool.ServiceProvider;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.listing.Function;
import ghidra.program.model.listing.Program;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.TaskMonitor;
import java.util.ArrayList;
import java.util.List;

public class FunctionMatchProgramCorrelator
extends VTAbstractProgramCorrelator {
    private final String name;
    private final boolean oneToOne;
    private final FunctionHasher hasher;

    public FunctionMatchProgramCorrelator(ServiceProvider serviceProvider, Program sourceProgram, AddressSetView sourceAddressSet, Program destinationProgram, AddressSetView destinationAddressSet, ToolOptions options, String name, boolean oneToOne, FunctionHasher hasher) {
        super(serviceProvider, sourceProgram, sourceAddressSet, destinationProgram, destinationAddressSet, options);
        this.name = name;
        this.oneToOne = oneToOne;
        this.hasher = hasher;
    }

    @Override
    protected void doCorrelate(VTMatchSet matchSet, TaskMonitor monitor) throws CancelledException {
        int functionMinimumSize = this.getOptions().getInt("Function Minimum Size", 10);
        List matchedFunctions = MatchFunctions.matchFunctions((Program)this.getSourceProgram(), (AddressSetView)this.getSourceAddressSet(), (Program)this.getDestinationProgram(), (AddressSetView)this.getDestinationAddressSet(), (int)functionMinimumSize, (boolean)this.oneToOne, (!this.oneToOne ? 1 : 0) != 0, (FunctionHasher)this.hasher, (TaskMonitor)monitor);
        monitor.setMessage("Scoring " + matchedFunctions.size() + " matches...");
        monitor.initialize((long)matchedFunctions.size());
        ArrayList<VTMatchInfo> results = new ArrayList<VTMatchInfo>();
        for (MatchFunctions.MatchedFunctions matchedFunction : matchedFunctions) {
            if (monitor.isCancelled()) {
                return;
            }
            monitor.incrementProgress(1L);
            VTMatchInfo matchInfo = this.generateMatchFromMatchedFunctions(matchSet, matchedFunction, monitor);
            if (matchInfo == null) continue;
            results.add(matchInfo);
        }
        monitor.setMessage("Adding " + results.size() + " match objects...");
        monitor.initialize((long)results.size());
        for (VTMatchInfo info : results) {
            if (monitor.isCancelled()) {
                return;
            }
            monitor.incrementProgress(1L);
            matchSet.addMatch(info);
        }
    }

    private VTMatchInfo generateMatchFromMatchedFunctions(VTMatchSet matchSet, MatchFunctions.MatchedFunctions matchedFunction, TaskMonitor monitor) {
        int destinationLength;
        Address sourceAddress = matchedFunction.getAFunctionAddress();
        Address destinationAddress = matchedFunction.getBFunctionAddress();
        VTScore similarity = new VTScore(1.0);
        VTScore confidence = new VTScore(10.0 / (double)(matchedFunction.getBMatchNum() * matchedFunction.getAMatchNum()));
        Function sourceFunction = this.getSourceProgram().getFunctionManager().getFunctionAt(sourceAddress);
        Function destinationFunction = this.getDestinationProgram().getFunctionManager().getFunctionAt(destinationAddress);
        int sourceLength = (int)sourceFunction.getBody().getNumAddresses();
        if (sourceLength != (destinationLength = (int)destinationFunction.getBody().getNumAddresses())) {
            return null;
        }
        VTMatchInfo matchInfo = new VTMatchInfo(matchSet);
        matchInfo.setSimilarityScore(similarity);
        matchInfo.setConfidenceScore(confidence);
        matchInfo.setSourceLength(sourceLength);
        matchInfo.setDestinationLength(destinationLength);
        matchInfo.setSourceAddress(sourceAddress);
        matchInfo.setDestinationAddress(destinationAddress);
        matchInfo.setTag(null);
        matchInfo.setAssociationType(VTAssociationType.FUNCTION);
        return matchInfo;
    }

    @Override
    public String getName() {
        return this.name;
    }
}

