/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.database.references;

import ghidra.program.database.external.ExternalManagerDB;
import ghidra.program.database.references.ReferenceDB;
import ghidra.program.model.address.Address;
import ghidra.program.model.listing.Program;
import ghidra.program.model.symbol.ExternalLocation;
import ghidra.program.model.symbol.ExternalReference;
import ghidra.program.model.symbol.RefType;
import ghidra.program.model.symbol.Reference;
import ghidra.program.model.symbol.SourceType;

class ExternalReferenceDB
extends ReferenceDB
implements ExternalReference {
    private Program program;

    public ExternalReferenceDB(Program program, Address fromAddr, Address toAddr, RefType refType, int opIndex, SourceType sourceType) {
        super(fromAddr, toAddr, refType, opIndex, sourceType, true, -1L);
        this.program = program;
    }

    @Override
    public boolean equals(Object obj) {
        ExternalLocation externalLocation;
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof ExternalReference)) {
            return false;
        }
        Reference ref = (Reference)obj;
        if (this.fromAddr.equals(ref.getFromAddress()) && this.opIndex == ref.getOperandIndex() && this.sourceType == ref.getSource() && this.refType == ref.getReferenceType() && (externalLocation = this.getExternalLocation()) != null) {
            return externalLocation.isEquivalent(((ExternalReference)ref).getExternalLocation());
        }
        return false;
    }

    @Override
    public String toString() {
        return "->" + this.getExternalLocation();
    }

    @Override
    public boolean isExternalReference() {
        return true;
    }

    @Override
    public ExternalLocation getExternalLocation() {
        ExternalManagerDB extMgr = (ExternalManagerDB)this.program.getExternalManager();
        return extMgr.getExtLocation(this.toAddr);
    }

    @Override
    public String getLibraryName() {
        return this.getExternalLocation().getLibraryName();
    }

    @Override
    public String getLabel() {
        return this.getExternalLocation().getLabel();
    }
}

