/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.database.data;

import db.DBHandle;
import db.DBRecord;
import db.Field;
import db.RecordIterator;
import db.Schema;
import ghidra.program.database.data.FunctionParameterAdapterNoTable;
import ghidra.program.database.data.FunctionParameterAdapterV0;
import ghidra.program.database.data.FunctionParameterAdapterV1;
import ghidra.util.exception.CancelledException;
import ghidra.util.exception.VersionException;
import ghidra.util.task.TaskMonitor;
import java.io.IOException;

abstract class FunctionParameterAdapter {
    static final String PARAMETER_TABLE_NAME = "Function Parameters";
    static final Schema PARAMETER_SCHEMA = FunctionParameterAdapterV1.V1_PARAMETER_SCHEMA;
    static final int PARAMETER_PARENT_ID_COL = 0;
    static final int PARAMETER_DT_ID_COL = 1;
    static final int PARAMETER_NAME_COL = 2;
    static final int PARAMETER_COMMENT_COL = 3;
    static final int PARAMETER_ORDINAL_COL = 4;
    static final int PARAMETER_DT_LENGTH_COL = 5;

    FunctionParameterAdapter() {
    }

    static FunctionParameterAdapter getAdapter(DBHandle handle, int openMode, String tablePrefix, TaskMonitor monitor) throws VersionException, IOException, CancelledException {
        if (openMode == 0) {
            return new FunctionParameterAdapterV1(handle, tablePrefix, true);
        }
        try {
            return new FunctionParameterAdapterV1(handle, tablePrefix, false);
        }
        catch (VersionException e) {
            if (!e.isUpgradable() || openMode == 1) {
                throw e;
            }
            FunctionParameterAdapter adapter = FunctionParameterAdapter.findReadOnlyAdapter(handle);
            if (openMode == 3) {
                adapter = FunctionParameterAdapter.upgrade(handle, adapter, tablePrefix, monitor);
            }
            return adapter;
        }
    }

    private static FunctionParameterAdapter findReadOnlyAdapter(DBHandle handle) throws VersionException {
        try {
            return new FunctionParameterAdapterV0(handle);
        }
        catch (VersionException e) {
            if (!e.isUpgradable()) {
                throw e;
            }
            return new FunctionParameterAdapterNoTable(handle);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static FunctionParameterAdapter upgrade(DBHandle handle, FunctionParameterAdapter oldAdapter, String tablePrefix, TaskMonitor monitor) throws VersionException, IOException, CancelledException {
        DBHandle tmpHandle = new DBHandle();
        long id = tmpHandle.startTransaction();
        FunctionParameterAdapterV1 tmpAdapter = null;
        try {
            tmpAdapter = new FunctionParameterAdapterV1(tmpHandle, tablePrefix, true);
            RecordIterator it = oldAdapter.getRecords();
            while (it.hasNext()) {
                monitor.checkCancelled();
                DBRecord rec = it.next();
                ((FunctionParameterAdapter)tmpAdapter).updateRecord(rec);
            }
            oldAdapter.deleteTable(handle);
            FunctionParameterAdapterV1 newAdapter = new FunctionParameterAdapterV1(handle, tablePrefix, true);
            it = ((FunctionParameterAdapter)tmpAdapter).getRecords();
            while (it.hasNext()) {
                monitor.checkCancelled();
                DBRecord rec = it.next();
                newAdapter.updateRecord(rec);
            }
            FunctionParameterAdapterV1 functionParameterAdapterV1 = newAdapter;
            return functionParameterAdapterV1;
        }
        finally {
            tmpHandle.endTransaction(id, true);
            tmpHandle.close();
        }
    }

    protected abstract RecordIterator getRecords() throws IOException;

    protected abstract void deleteTable(DBHandle var1) throws IOException;

    abstract DBRecord createRecord(long var1, long var3, int var5, String var6, String var7, int var8) throws IOException;

    abstract DBRecord getRecord(long var1) throws IOException;

    abstract void updateRecord(DBRecord var1) throws IOException;

    abstract boolean removeRecord(long var1) throws IOException;

    abstract Field[] getParameterIdsInFunctionDef(long var1) throws IOException;
}

