/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.database;

import db.DBHandle;
import db.Field;
import db.IntField;
import db.util.ErrorHandler;
import ghidra.program.database.IntRangeMap;
import ghidra.program.database.ProgramDB;
import ghidra.program.database.map.AddressMap;
import ghidra.program.database.util.AddressRangeMapDB;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressRange;
import ghidra.program.model.address.AddressRangeIterator;
import ghidra.program.model.address.AddressSet;
import ghidra.program.model.address.AddressSetView;
import ghidra.util.Lock;
import ghidra.util.exception.CancelledException;
import ghidra.util.exception.DuplicateNameException;
import ghidra.util.task.TaskMonitor;
import java.util.ConcurrentModificationException;

public class IntRangeMapDB
implements IntRangeMap {
    private static final String MY_PREFIX = "IntMap - ";
    public static final String TABLE_PREFIX = "Range Map - IntMap - ";
    private ProgramDB program;
    private String mapName;
    private Lock lock;
    private AddressRangeMapDB propertyMap;
    private boolean invalid;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static IntRangeMapDB getPropertyMap(ProgramDB program, String mapName, ErrorHandler errHandler, AddressMap addrMap, Lock lock) {
        lock.acquire();
        try {
            DBHandle dbh = program.getDBHandle();
            String tableName = TABLE_PREFIX + mapName;
            if (dbh.getTable(tableName) != null) {
                IntRangeMapDB intRangeMapDB = new IntRangeMapDB(program, mapName, (ErrorHandler)program, addrMap, lock);
                return intRangeMapDB;
            }
        }
        finally {
            lock.release();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static IntRangeMapDB createPropertyMap(ProgramDB program, String mapName, ErrorHandler errHandler, AddressMap addrMap, Lock lock) throws DuplicateNameException {
        lock.acquire();
        try {
            DBHandle dbh = program.getDBHandle();
            String tableName = TABLE_PREFIX + mapName;
            if (dbh.getTable(tableName) != null) {
                throw new DuplicateNameException("Address Set Property Map named " + mapName + " already exists.");
            }
            IntRangeMapDB intRangeMapDB = new IntRangeMapDB(program, mapName, (ErrorHandler)program, addrMap, lock);
            return intRangeMapDB;
        }
        finally {
            lock.release();
        }
    }

    private IntRangeMapDB(ProgramDB program, String mapName, ErrorHandler errHandler, AddressMap addrMap, Lock lock) {
        this.program = program;
        this.mapName = mapName;
        this.lock = lock;
        this.propertyMap = new AddressRangeMapDB(program.getDBHandle(), program.getAddressMap(), program.getLock(), MY_PREFIX + mapName, errHandler, (Field)IntField.INSTANCE, true);
    }

    public void delete() {
        this.invalid = true;
        this.propertyMap.dispose();
    }

    private void checkDeleted() {
        if (this.invalid) {
            throw new ConcurrentModificationException("AddressSetPropertyMap has been deleted.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setValue(Address start, Address end, int value) {
        this.checkDeleted();
        this.lock.acquire();
        try {
            this.propertyMap.paintRange(start, end, (Field)new IntField(value));
            this.program.setChanged(172, null, this.mapName);
        }
        finally {
            this.lock.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setValue(AddressSetView addresses, int value) {
        this.checkDeleted();
        this.lock.acquire();
        try {
            AddressRangeIterator iter = addresses.getAddressRanges();
            while (iter.hasNext()) {
                AddressRange range = (AddressRange)iter.next();
                this.setValue(range.getMinAddress(), range.getMaxAddress(), value);
            }
            this.program.setChanged(172, null, this.mapName);
        }
        finally {
            this.lock.release();
        }
    }

    @Override
    public void clearAll() {
        this.checkDeleted();
        this.lock.acquire();
        try {
            this.propertyMap.dispose();
            this.program.setChanged(172, null, this.mapName);
        }
        finally {
            this.lock.release();
        }
    }

    @Override
    public void clearValue(Address startAddr, Address endAddr) {
        this.checkDeleted();
        this.lock.acquire();
        try {
            this.propertyMap.clearRange(startAddr, endAddr);
            this.program.setChanged(172, null, this.mapName);
        }
        finally {
            this.lock.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clearValue(AddressSetView addresses) {
        this.checkDeleted();
        this.lock.acquire();
        try {
            AddressRangeIterator iter = addresses.getAddressRanges();
            while (iter.hasNext()) {
                AddressRange range = (AddressRange)iter.next();
                this.clearValue(range.getMinAddress(), range.getMaxAddress());
            }
            this.program.setChanged(172, null, this.mapName);
        }
        finally {
            this.lock.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Integer getValue(Address address) {
        this.checkDeleted();
        this.lock.acquire();
        try {
            Field value = this.propertyMap.getValue(address);
            if (value == null) {
                Integer n = null;
                return n;
            }
            Integer n = ((IntField)value).getIntValue();
            return n;
        }
        finally {
            this.lock.release();
        }
    }

    @Override
    public AddressSet getAddressSet() {
        this.checkDeleted();
        this.lock.acquire();
        try {
            AddressSet addressSet = this.propertyMap.getAddressSet();
            return addressSet;
        }
        finally {
            this.lock.release();
        }
    }

    @Override
    public AddressSet getAddressSet(int value) {
        this.checkDeleted();
        this.lock.acquire();
        try {
            AddressSet addressSet = this.propertyMap.getAddressSet((Field)new IntField(value));
            return addressSet;
        }
        finally {
            this.lock.release();
        }
    }

    @Override
    public void moveAddressRange(Address fromAddr, Address toAddr, long length, TaskMonitor monitor) throws CancelledException {
        this.propertyMap.moveAddressRange(fromAddr, toAddr, length, monitor);
    }
}

