/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.byteviewer;

import docking.widgets.fieldpanel.field.Field;
import docking.widgets.fieldpanel.field.SimpleTextField;
import docking.widgets.fieldpanel.support.FieldHighlightFactory;
import docking.widgets.fieldpanel.support.Highlight;
import ghidra.app.plugin.core.byteviewer.ByteViewerComponentProvider;
import ghidra.app.plugin.core.byteviewer.IndexMap;
import ghidra.app.plugin.core.format.IndexedByteBlockInfo;
import java.awt.Color;
import java.awt.FontMetrics;
import java.math.BigInteger;

class IndexFieldFactory {
    private FontMetrics fm;
    private int width;
    private IndexMap indexMap;
    private int charWidth;
    private String noValueStr;
    private int startX;
    private Color missingValueColor;
    private FieldHighlightFactory highlightFactory = new DummyHighlightFactory();

    IndexFieldFactory(FontMetrics fm) {
        this.fm = fm;
        this.charWidth = fm.charWidth('W');
        this.width = 8 * this.charWidth;
        this.missingValueColor = ByteViewerComponentProvider.SEPARATOR_COLOR;
    }

    public Field getField(BigInteger index) {
        String locRep;
        if (this.indexMap == null) {
            return null;
        }
        IndexedByteBlockInfo info = this.indexMap.getBlockInfo(index, 0);
        if (info == null) {
            for (int i = 0; i < this.indexMap.getBytesPerLine() && (info = this.indexMap.getBlockInfo(index, i)) == null; ++i) {
            }
            if (info == null) {
                if (this.indexMap.isBlockSeparatorIndex(index)) {
                    SimpleTextField sf = new SimpleTextField(this.noValueStr, this.fm, this.startX, this.width, false, this.highlightFactory);
                    sf.setForeground(this.missingValueColor);
                    return sf;
                }
                return null;
            }
        }
        if ((locRep = info.getBlock().getLocationRepresentation(info.getOffset())) == null) {
            return null;
        }
        return new SimpleTextField(locRep, this.fm, this.startX, this.width, false, this.highlightFactory);
    }

    public FontMetrics getMetrics() {
        return this.fm;
    }

    public void setStartX(int x) {
        this.startX = x;
    }

    public int getStartX() {
        return this.startX;
    }

    public int getWidth() {
        return this.width;
    }

    void setIndexMap(IndexMap indexMap, int maxWidth) {
        this.indexMap = indexMap;
        this.width = maxWidth - 2 * this.charWidth;
        int nchars = this.width / this.charWidth;
        if (indexMap != null) {
            StringBuffer sb = new StringBuffer();
            for (int i = 0; i < nchars; ++i) {
                sb.append(".");
            }
            this.noValueStr = sb.toString();
        }
    }

    void setMissingValueColor(Color c) {
        this.missingValueColor = c;
    }

    static class DummyHighlightFactory
    implements FieldHighlightFactory {
        private final Highlight[] NO_HIGHLIGHTS = new Highlight[0];

        public Highlight[] createHighlights(Field field, String text, int cursorTextOffset) {
            return this.NO_HIGHLIGHTS;
        }
    }
}

