/*
 * Decompiled with CFR 0.152.
 */
package agent.dbgmodel.impl.dbgmodel.bridge;

import agent.dbgeng.dbgeng.DebugClient;
import agent.dbgeng.dbgeng.DebugModule;
import agent.dbgmodel.dbgmodel.bridge.HostDataModelAccess;
import agent.dbgmodel.dbgmodel.datamodel.DataModelManager1;
import agent.dbgmodel.dbgmodel.debughost.DebugHost;
import agent.dbgmodel.dbgmodel.debughost.DebugHostContext;
import agent.dbgmodel.dbgmodel.debughost.DebugHostEvaluator2;
import agent.dbgmodel.dbgmodel.debughost.DebugHostModule1;
import agent.dbgmodel.dbgmodel.debughost.DebugHostSymbol1;
import agent.dbgmodel.dbgmodel.debughost.DebugHostSymbolEnumerator;
import agent.dbgmodel.dbgmodel.debughost.DebugHostSymbols;
import agent.dbgmodel.dbgmodel.main.ModelObject;
import agent.dbgmodel.jna.dbgmodel.DbgModelNative;
import com.sun.jna.WString;
import com.sun.jna.platform.win32.Variant;
import ghidra.dbg.util.PathUtils;
import ghidra.util.Msg;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class HDMAUtil {
    private DebugClient client;
    private HostDataModelAccess access;

    public HDMAUtil(HostDataModelAccess access) {
        this.access = access;
        this.client = access.getClient();
    }

    public DataModelManager1 getManager() {
        return this.access.getManager();
    }

    public DebugHost getHost() {
        return this.access.getHost();
    }

    public ModelObject getRootNamespace() {
        ModelObject rootNamespace = this.getManager().getRootNamespace();
        if (rootNamespace == null) {
            Msg.debug((Object)this, (Object)("resetting HostDataModelAccess manager/host " + this.access));
            this.access.getDataModel();
            rootNamespace = this.getManager().getRootNamespace();
        }
        return rootNamespace;
    }

    public DebugHostContext getCurrentContext() {
        return this.getHost().getCurrentContext();
    }

    public ModelObject getSessionOf(DebugHostContext obj) {
        return this.getRootNamespace().getKeyValue("Debugger").getKeyValue("Sessions");
    }

    public ModelObject getProcessOf(DebugHostContext obj) {
        return this.getSessionOf(obj).getKeyValue("Processes");
    }

    public ModelObject getThreadOf(DebugHostContext obj) {
        return this.getProcessOf(obj).getKeyValue("Threads");
    }

    public Variant.VARIANT string2variant(String id) {
        Integer decode = id == null ? 0 : Integer.decode(id);
        return new Variant.VARIANT(decode.intValue());
    }

    public Map<String, ModelObject> getAttributes(List<String> path) {
        Map<String, ModelObject> map;
        ModelObject target = this.getTerminalModelObject(path);
        if (target == null) {
            return new HashMap<String, ModelObject>();
        }
        DbgModelNative.ModelObjectKind kind = target.getKind();
        if (kind.equals((Object)DbgModelNative.ModelObjectKind.OBJECT_ERROR)) {
            HashMap<String, ModelObject> map2 = new HashMap<String, ModelObject>();
            map2.put("ERROR", target);
            return map2;
        }
        if ((kind.equals((Object)DbgModelNative.ModelObjectKind.OBJECT_INTRINSIC) || kind.equals((Object)DbgModelNative.ModelObjectKind.OBJECT_TARGET_OBJECT) || kind.equals((Object)DbgModelNative.ModelObjectKind.OBJECT_TARGET_OBJECT_REFERENCE)) && !(map = target.getRawValueMap()).isEmpty()) {
            return map;
        }
        return target.getKeyValueMap();
    }

    public List<ModelObject> getElements(List<String> path) {
        ModelObject target = this.getTerminalModelObject(path);
        if (target == null) {
            return new ArrayList<ModelObject>();
        }
        DbgModelNative.ModelObjectKind kind = target.getKind();
        if (kind.equals((Object)DbgModelNative.ModelObjectKind.OBJECT_ERROR)) {
            ArrayList<ModelObject> list = new ArrayList<ModelObject>();
            list.add(target);
            return list;
        }
        return target.getElements();
    }

    public ModelObject getMethod(List<String> path) {
        DebugHostEvaluator2 eval = this.getHost().asEvaluator();
        DebugHostContext context = this.getHost().getCurrentContext();
        List npath = PathUtils.parent(path);
        int last = path.size() - 1;
        String cmd = path.get(last);
        ModelObject parentModel = this.getTerminalModelObject(npath);
        return eval.evaluateExtendedExpression(context, new WString(cmd), parentModel);
    }

    public ModelObject getTerminalModelObject(List<String> path) {
        ModelObject target = this.getRootNamespace();
        for (String str : path) {
            ModelObject element;
            String indexStr = null;
            if (str.endsWith(")") && (target = this.evaluatePredicate(target, str)).getKind().equals((Object)DbgModelNative.ModelObjectKind.OBJECT_ERROR)) {
                return target;
            }
            if (str.endsWith("]")) {
                indexStr = str.substring(str.indexOf("[") + 1, str.indexOf("]"));
                str = str.substring(0, str.indexOf("["));
            }
            if (!str.equals("")) {
                ModelObject keyValue = target.getKeyValueByEnum(str);
                if (keyValue != null) {
                    target = keyValue;
                    continue;
                }
                ModelObject rawValue = target.getRawValueByEnum(str);
                if (rawValue != null) {
                    target = rawValue;
                    continue;
                }
            }
            if (indexStr != null && (element = target.getElement(indexStr)) != null) {
                target = element;
                continue;
            }
            return null;
        }
        return target;
    }

    private ModelObject evaluatePredicate(ModelObject target, String call) {
        DebugHostEvaluator2 eval = this.getHost().asEvaluator();
        DebugHostContext context = this.getHost().getCurrentContext();
        return eval.evaluateExtendedExpression(context, new WString(call), target);
    }

    public ModelObject getSession(String id) {
        return this.getRootNamespace().getKeyValue("Debugger").getKeyValue("Sessions");
    }

    public ModelObject getProcess(ModelObject session, String id) {
        ModelObject processes = session.getKeyValue("Processes");
        return processes.getChild(this.getManager(), this.string2variant(id));
    }

    public ModelObject getThread(ModelObject process, String id) {
        ModelObject threads = process.getKeyValue("Threads");
        return threads.getChild(this.getManager(), this.string2variant(id));
    }

    public ModelObject getSettings() {
        return this.getRootNamespace().getKeyValue("Debugger").getKeyValue("Settings");
    }

    public ModelObject getVariables() {
        return this.getRootNamespace().getKeyValue("Debugger").getKeyValue("State").getKeyValue("DebuggerVariables");
    }

    public ModelObject getCurrentSession() {
        return this.getVariables().getKeyValue("cursession");
    }

    public ModelObject getCurrentProcess() {
        return this.getVariables().getKeyValue("curprocess");
    }

    public ModelObject getCurrentThread() {
        return this.getVariables().getKeyValue("curthread");
    }

    public ModelObject getCurrentStack() {
        return this.getCurrentThread().getKeyValue("Stack");
    }

    public ModelObject getCurrentFrame() {
        return this.getVariables().getKeyValue("curframe");
    }

    public List<ModelObject> getCurrentModuleList() {
        ModelObject process = this.getCurrentProcess();
        ModelObject modules = process.getKeyValue("Modules");
        return modules.getElements();
    }

    public List<DebugModule> getModuleList() {
        DebugHostSymbol1 next;
        DebugHostSymbols symbols = this.getHost().asSymbols();
        DebugHostSymbolEnumerator enumerator = symbols.enumerateModules(this.getCurrentContext());
        ArrayList<DebugModule> modules = new ArrayList<DebugModule>();
        int index = 0;
        while ((next = enumerator.getNext()) != null) {
            DebugHostModule1 module = next.asModule();
            String name = module.getName();
            DebugModule debugModule = this.client.getSymbols().getModuleByModuleName(name, index++);
            modules.add(debugModule);
        }
        return modules;
    }

    public List<ModelObject> getRunningProcesses(String id) {
        ModelObject session = this.getSession(id);
        ModelObject processes = session.getKeyValue("Processes");
        return processes.getElements();
    }

    public List<ModelObject> getRunningThreads(ModelObject session, String id) {
        ModelObject process = this.getProcess(session, id);
        ModelObject threads = process.getKeyValue("Threads");
        return threads.getElements();
    }

    public ModelObject getProcessDescription(String sid, int systemId) {
        ModelObject session = this.getSession(sid);
        return this.getProcess(session, Integer.toHexString(systemId));
    }

    public void setCurrentProcess(ModelObject context, String id) {
        Variant.VARIANT v = new Variant.VARIANT(id);
        context.switchTo(this.getManager(), v);
    }

    public void setCurrentThread(ModelObject context, String id) {
        Variant.VARIANT v = new Variant.VARIANT(id);
        context.switchTo(this.getManager(), v);
    }

    public String getCtlId(ModelObject object) {
        ModelObject value = object.getKeyValue("Id");
        return value == null ? "" : value.getValueString();
    }
}

