/*
 * Decompiled with CFR 0.152.
 */
package ghidra.dbg.gadp.server;

import ghidra.comm.service.AbstractAsyncServer;
import ghidra.dbg.DebuggerModelClosedReason;
import ghidra.dbg.DebuggerModelListener;
import ghidra.dbg.DebuggerObjectModel;
import ghidra.dbg.gadp.error.GadpErrorException;
import ghidra.dbg.gadp.protocol.Gadp;
import ghidra.dbg.gadp.server.GadpClientHandler;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressRange;
import ghidra.program.model.address.AddressRangeImpl;
import ghidra.program.model.address.AddressSpace;
import ghidra.util.Msg;
import java.io.IOException;
import java.net.SocketAddress;
import java.nio.channels.AsynchronousSocketChannel;
import java.util.concurrent.CompletableFuture;

public abstract class AbstractGadpServer
extends AbstractAsyncServer<AbstractGadpServer, GadpClientHandler>
implements DebuggerModelListener {
    public static final String LISTENING_ON = "GADP Server listening on ";
    public static final String READY = "GADP Server model ready";
    protected final DebuggerObjectModel model;
    private boolean exitOnClosed = true;

    public AbstractGadpServer(DebuggerObjectModel model, SocketAddress addr) throws IOException {
        super(addr);
        this.model = model;
        System.out.println(LISTENING_ON + this.getLocalAddress());
        model.addModelListener((DebuggerModelListener)this);
    }

    public CompletableFuture<Void> launchAsyncService() {
        System.out.println(READY);
        return super.launchAsyncService();
    }

    public DebuggerObjectModel getModel() {
        return this.model;
    }

    protected boolean checkAcceptable(AsynchronousSocketChannel sock) {
        return true;
    }

    protected GadpClientHandler newHandler(AsynchronousSocketChannel sock) {
        return new GadpClientHandler(this, sock);
    }

    protected AddressRange getAddressRange(Gadp.AddressRange range) {
        AddressSpace space = this.model.getAddressSpace(range.getSpace());
        if (space == null) {
            throw new GadpErrorException(Gadp.ErrorCode.EC_BAD_ADDRESS, "Unrecognized address space: " + range);
        }
        Address min = space.getAddress(range.getOffset());
        return new AddressRangeImpl(min, min.add(Integer.toUnsignedLong(range.getExtend())));
    }

    public void modelClosed(DebuggerModelClosedReason reason) {
        if (this.exitOnClosed) {
            System.exit(0);
        }
    }

    public void setExitOnClosed(boolean exitOnClosed) {
        this.exitOnClosed = exitOnClosed;
    }

    public void terminate() throws IOException {
        super.terminate();
        this.model.close().exceptionally(ex -> {
            Msg.error((Object)((Object)this), (Object)"Problem closing GADP-served model", (Throwable)ex);
            return null;
        });
    }
}

