/*
 * Decompiled with CFR 0.152.
 */
package agent.lldb.model.impl;

import SWIG.SBFrame;
import SWIG.StateType;
import agent.lldb.manager.LldbReason;
import agent.lldb.model.iface2.LldbModelTargetProcess;
import agent.lldb.model.iface2.LldbModelTargetStack;
import agent.lldb.model.iface2.LldbModelTargetStackFrame;
import agent.lldb.model.iface2.LldbModelTargetThread;
import agent.lldb.model.impl.LldbModelTargetObjectImpl;
import agent.lldb.model.impl.LldbModelTargetStackFrameImpl;
import ghidra.dbg.target.TargetObject;
import ghidra.dbg.target.schema.TargetAttributeType;
import ghidra.dbg.target.schema.TargetElementType;
import ghidra.dbg.target.schema.TargetObjectSchema;
import ghidra.dbg.target.schema.TargetObjectSchemaInfo;
import ghidra.util.datastruct.WeakValueHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;

@TargetObjectSchemaInfo(name="Stack", elementResync=TargetObjectSchema.ResyncMode.ALWAYS, elements={@TargetElementType(type=LldbModelTargetStackFrameImpl.class)}, attributes={@TargetAttributeType(type=Void.class)}, canonicalContainer=true)
public class LldbModelTargetStackImpl
extends LldbModelTargetObjectImpl
implements LldbModelTargetStack {
    protected final LldbModelTargetThread thread;
    public static final String NAME = "Stack";
    protected final Map<Integer, LldbModelTargetStackFrameImpl> framesByLevel = new WeakValueHashMap();

    public LldbModelTargetStackImpl(LldbModelTargetThread thread, LldbModelTargetProcess process) {
        super(thread.getModel(), (TargetObject)thread, NAME, NAME);
        this.thread = thread;
        this.requestElements(false);
    }

    public CompletableFuture<Void> requestElements(boolean refresh) {
        return this.getManager().listStackFrames(this.thread.getThread()).thenAccept(f -> {
            List frames;
            LldbModelTargetStackImpl lldbModelTargetStackImpl = this;
            synchronized (lldbModelTargetStackImpl) {
                frames = f.values().stream().map(this::getTargetFrame).collect(Collectors.toList());
            }
            this.setElements(frames, Map.of(), "Refreshed");
        });
    }

    @Override
    public synchronized LldbModelTargetStackFrame getTargetFrame(SBFrame frame) {
        return this.framesByLevel.compute((int)frame.GetFrameID(), (l, f) -> {
            if (f == null) {
                return new LldbModelTargetStackFrameImpl(this, this.thread, frame);
            }
            f.setFrame(frame);
            return f;
        });
    }

    public void threadStateChangedSpecific(StateType state, LldbReason reason) {
        if (state.equals(StateType.eStateStopped)) {
            this.requestElements(true).thenAccept(__ -> {
                for (TargetObject element : this.getCachedElements().values()) {
                    if (!(element instanceof LldbModelTargetStackFrame)) continue;
                    LldbModelTargetStackFrameImpl frame = (LldbModelTargetStackFrameImpl)element;
                    frame.threadStateChangedSpecific(state, reason);
                }
            });
        }
    }
}

