/*
 * Decompiled with CFR 0.152.
 */
package agent.lldb.model.impl;

import SWIG.ByteOrder;
import SWIG.SBTarget;
import agent.lldb.model.iface2.LldbModelTargetSession;
import agent.lldb.model.iface2.LldbModelTargetSessionAttributes;
import agent.lldb.model.impl.LldbModelTargetObjectImpl;
import agent.lldb.model.impl.LldbModelTargetSessionAttributesEnvironmentImpl;
import agent.lldb.model.impl.LldbModelTargetSessionAttributesPlatformImpl;
import ghidra.dbg.target.TargetObject;
import ghidra.dbg.target.schema.TargetAttributeType;
import ghidra.dbg.target.schema.TargetElementType;
import ghidra.dbg.target.schema.TargetObjectSchemaInfo;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;

@TargetObjectSchemaInfo(name="SessionAttributes", elements={@TargetElementType(type=Void.class)}, attributes={@TargetAttributeType(name="Environment", type=LldbModelTargetSessionAttributesEnvironmentImpl.class, fixed=true), @TargetAttributeType(name="Platform", type=LldbModelTargetSessionAttributesPlatformImpl.class, fixed=true), @TargetAttributeType(type=Void.class)})
public class LldbModelTargetSessionAttributesImpl
extends LldbModelTargetObjectImpl
implements LldbModelTargetSessionAttributes {
    protected final LldbModelTargetSessionAttributesPlatformImpl platformAttributes = new LldbModelTargetSessionAttributesPlatformImpl(this);
    protected final LldbModelTargetSessionAttributesEnvironmentImpl environment = new LldbModelTargetSessionAttributesEnvironmentImpl(this);

    public LldbModelTargetSessionAttributesImpl(LldbModelTargetSession session) {
        super(session.getModel(), (TargetObject)session, "Attributes", "SessionAttributes");
        SBTarget target = (SBTarget)session.getModelObject();
        String[] triple = target.GetTriple().split("-");
        ByteOrder order = target.GetByteOrder();
        String orderStr = "invalid";
        if (order.equals(ByteOrder.eByteOrderLittle)) {
            orderStr = "little";
        }
        if (order.equals(ByteOrder.eByteOrderBig)) {
            orderStr = "big";
        }
        if (order.equals(ByteOrder.eByteOrderPDP)) {
            orderStr = "pdp";
        }
        this.changeAttributes(List.of(), List.of(this.platformAttributes, this.environment), Map.of("_arch", triple[0], "_debugger", "lldb", "_os", triple[2], "_endian", orderStr), "Initialized");
        this.getManager().addEventsListener(this);
    }

    public CompletableFuture<Void> requestElements(boolean refresh) {
        return CompletableFuture.completedFuture(null);
    }

    @Override
    public void refreshInternal() {
        this.platformAttributes.refreshInternal();
    }
}

