/*
 * Decompiled with CFR 0.152.
 */
package agent.lldb.gadp;

import agent.lldb.gadp.impl.LldbGadpServerImpl;
import ghidra.async.AsyncUtils;
import ghidra.dbg.agent.AgentWindow;
import ghidra.util.Msg;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;

public interface LldbGadpServer
extends AutoCloseable {
    public static void main(String[] args) throws Exception {
        new LldbRunner().run(args);
    }

    public static LldbGadpServer newInstance(SocketAddress addr) throws IOException {
        return new LldbGadpServerImpl(addr);
    }

    public CompletableFuture<Void> startLLDB(String[] var1);

    public SocketAddress getLocalAddress();

    public void terminate() throws IOException;

    public boolean isRunning();

    @Override
    default public void close() throws IOException {
        this.terminate();
    }

    public static class LldbRunner {
        protected InetSocketAddress bindTo;
        protected List<String> lldbArgs = new ArrayList<String>();
        protected byte busId = 1;
        protected String remote = null;

        public void run(String[] args) throws IOException, InterruptedException, ExecutionException {
            this.parseArguments(args);
            try (LldbGadpServer server = LldbGadpServer.newInstance(this.bindTo);){
                server.startLLDB(this.lldbArgs.toArray(new String[0])).exceptionally(e -> {
                    e = AsyncUtils.unwrapThrowable((Throwable)e);
                    Msg.error((Object)this, (Object)("Error starting lldb/GADP: " + e));
                    System.exit(-1);
                    return null;
                });
                new AgentWindow("LLDB Agent for Ghidra", server.getLocalAddress());
                while (server.isRunning()) {
                    Thread.sleep(1000L);
                }
                System.exit(0);
            }
        }

        protected void parseArguments(String[] args) {
            String iface = "localhost";
            int port = 12345;
            Iterator<String> ait = Arrays.asList(args).iterator();
            while (ait.hasNext()) {
                String a = ait.next();
                if ("-h".equals(a) || "--help".equals(a)) {
                    this.printUsage();
                    System.exit(0);
                    continue;
                }
                if ("-p".equals(a) || "--port".equals(a)) {
                    if (!ait.hasNext()) {
                        System.err.println("Expected PORT");
                        this.printUsage();
                        System.exit(-1);
                    }
                    String portStr = ait.next();
                    try {
                        port = Integer.parseInt(portStr);
                    }
                    catch (NumberFormatException e) {
                        System.err.println("Integer required. Got " + portStr);
                        this.printUsage();
                        System.exit(-1);
                    }
                    continue;
                }
                if ("-H".equals(a) || "--host".equals(a)) {
                    if (!ait.hasNext()) {
                        System.err.println("Expected HOST/ADDR");
                        this.printUsage();
                        System.exit(-1);
                    }
                    iface = ait.next();
                    continue;
                }
                System.err.println("Unknown option: " + a);
                this.printUsage();
                System.exit(-1);
            }
            this.bindTo = new InetSocketAddress(iface, port);
        }

        protected void printUsage() {
            System.out.println("This is the GADP server for LLVM's lldb.  Usage:");
            System.out.println();
            System.out.println("     [-H HOST/ADDR] [-p PORT] [-i ID] [-t TRANSPORT] [-r REMOTE]");
            System.out.println();
            System.out.println("Options:");
            System.out.println("  --host/-H          The address of the interface on which to listen.");
            System.out.println("                     Default is localhost");
            System.out.println("  --port/-p          The TCP port on which to listen for GADP. Default is 12345");
        }
    }
}

