/*
 * Decompiled with CFR 0.152.
 */
package ghidra.util;

import ghidra.framework.OperatingSystem;
import ghidra.framework.Platform;
import ghidra.framework.options.CustomOption;
import ghidra.framework.options.SaveState;
import ghidra.util.SystemUtilities;

public class ManualViewerCommandWrappedOption
implements CustomOption {
    public static final String OPTIONS_CATEGORY_NAME = "Processor Manuals";
    public static final String MANUAL_VIEWER_OPTIONS = "Manual Viewer Options";
    static final String HTTP_URL_REPLACEMENT_STRING = "${HTTP_URL}";
    static final String FILE_URL_REPLACEMENT_STRING = "${FILE_URL}";
    static final String FILENAME_REPLACEMENT_STRING = "${FILENAME}";
    private static final String COMMAND_STRING = "commandString";
    private static final String COMMAND_ARGUMENTS = "commandArguments";
    private static final String URL_STRING = "urlReplacementString";
    private static final String DEFAULT_URL_REPLACEMENT_STRING = "${HTTP_URL}";
    private String commandString;
    private String[] commandArguments;
    private String urlReplacementString;

    public void readState(SaveState saveState) {
        this.commandString = saveState.getString(COMMAND_STRING, null);
        this.commandArguments = saveState.getStrings(COMMAND_ARGUMENTS, null);
        this.urlReplacementString = saveState.getString(URL_STRING, null);
    }

    public void writeState(SaveState saveState) {
        saveState.putString(COMMAND_STRING, this.commandString);
        saveState.putStrings(COMMAND_ARGUMENTS, this.commandArguments);
        saveState.putString(URL_STRING, this.urlReplacementString);
    }

    public int hashCode() {
        int hash = 0;
        hash += this.commandString == null ? 0 : this.commandString.hashCode();
        hash += this.urlReplacementString == null ? 0 : this.urlReplacementString.hashCode();
        if (this.commandArguments != null) {
            for (String arg : this.commandArguments) {
                hash += arg.hashCode();
            }
        }
        return hash;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof ManualViewerCommandWrappedOption)) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        ManualViewerCommandWrappedOption otherOption = (ManualViewerCommandWrappedOption)obj;
        return SystemUtilities.isEqual((Object)this.commandString, (Object)otherOption.commandString) && SystemUtilities.isEqual((Object)this.urlReplacementString, (Object)otherOption.urlReplacementString) && SystemUtilities.isArrayEqual((Object[])this.commandArguments, (Object[])otherOption.commandArguments);
    }

    public String getCommandString() {
        return this.commandString;
    }

    public void setCommandString(String commandString) {
        this.commandString = commandString;
    }

    public String[] getCommandArguments() {
        return this.commandArguments;
    }

    public void setCommandArguments(String[] commandArguments) {
        this.commandArguments = commandArguments;
    }

    public String getUrlReplacementString() {
        return this.urlReplacementString;
    }

    public void setUrlReplacementString(String urlReplacementString) {
        this.urlReplacementString = urlReplacementString;
    }

    public static ManualViewerCommandWrappedOption getDefaultBrowserLoaderOptions() {
        ManualViewerCommandWrappedOption option = new ManualViewerCommandWrappedOption();
        if (Platform.CURRENT_PLATFORM.getOperatingSystem() == OperatingSystem.WINDOWS) {
            option.setCommandString(System.getenv("ComSpec"));
            String[] args = new String[]{"/c", "start"};
            option.setCommandArguments(args);
            option.setUrlReplacementString("${HTTP_URL}");
        } else if (Platform.CURRENT_PLATFORM.getOperatingSystem() == OperatingSystem.LINUX) {
            option.setCommandString("firefox");
            option.setCommandArguments(new String[0]);
            option.setUrlReplacementString("${HTTP_URL}");
        } else if (Platform.CURRENT_PLATFORM.getOperatingSystem() == OperatingSystem.MAC_OS_X) {
            option.setCommandString("open");
            option.setCommandArguments(new String[0]);
            option.setUrlReplacementString("${HTTP_URL}");
        } else {
            option.setCommandString("");
            option.setCommandArguments(new String[0]);
            option.setUrlReplacementString("${HTTP_URL}");
        }
        return option;
    }
}

