/*
 * Decompiled with CFR 0.152.
 */
package ghidra.plugins.fsbrowser;

import docking.ComponentProvider;
import docking.action.DockingAction;
import docking.action.DockingActionIf;
import docking.action.builder.ActionBuilder;
import docking.widgets.OptionDialog;
import docking.widgets.dialogs.MultiLineMessageDialog;
import docking.widgets.filechooser.GhidraFileChooser;
import docking.widgets.filechooser.GhidraFileChooserMode;
import docking.widgets.label.GIconLabel;
import docking.widgets.tree.GTree;
import docking.widgets.tree.GTreeNode;
import ghidra.app.services.ProgramManager;
import ghidra.app.services.TextEditorService;
import ghidra.app.util.bin.ByteProvider;
import ghidra.formats.gfilesystem.FSRL;
import ghidra.formats.gfilesystem.FSRLRoot;
import ghidra.formats.gfilesystem.FSUtilities;
import ghidra.formats.gfilesystem.FileSystemProbeConflictResolver;
import ghidra.formats.gfilesystem.FileSystemRef;
import ghidra.formats.gfilesystem.FileSystemService;
import ghidra.formats.gfilesystem.GFile;
import ghidra.formats.gfilesystem.GFileSystem;
import ghidra.formats.gfilesystem.GIconProvider;
import ghidra.formats.gfilesystem.RefdFile;
import ghidra.formats.gfilesystem.SelectFromListDialog;
import ghidra.formats.gfilesystem.crypto.CachedPasswordProvider;
import ghidra.formats.gfilesystem.crypto.CryptoProviders;
import ghidra.formats.gfilesystem.fileinfo.FileAttribute;
import ghidra.formats.gfilesystem.fileinfo.FileAttributeType;
import ghidra.formats.gfilesystem.fileinfo.FileAttributeTypeGroup;
import ghidra.formats.gfilesystem.fileinfo.FileAttributes;
import ghidra.framework.main.AppInfo;
import ghidra.framework.model.DomainFile;
import ghidra.framework.plugintool.PluginTool;
import ghidra.plugin.importer.ImporterUtilities;
import ghidra.plugin.importer.ProgramMappingService;
import ghidra.plugins.fsbrowser.FSBActionContext;
import ghidra.plugins.fsbrowser.FSBDirNode;
import ghidra.plugins.fsbrowser.FSBFileNode;
import ghidra.plugins.fsbrowser.FSBNode;
import ghidra.plugins.fsbrowser.FSBRootNode;
import ghidra.plugins.fsbrowser.FSBUtils;
import ghidra.plugins.fsbrowser.FileSystemBrowserComponentProvider;
import ghidra.plugins.fsbrowser.FileSystemBrowserPlugin;
import ghidra.plugins.fsbrowser.ImageManager;
import ghidra.plugins.fsbrowser.tasks.GFileSystemExtractAllTask;
import ghidra.plugins.importer.batch.BatchImportDialog;
import ghidra.program.model.listing.Program;
import ghidra.util.HTMLUtilities;
import ghidra.util.Msg;
import ghidra.util.Swing;
import ghidra.util.exception.CancelledException;
import ghidra.util.exception.CryptoException;
import ghidra.util.task.Task;
import ghidra.util.task.TaskLauncher;
import ghidra.util.task.TaskMonitor;
import java.awt.Component;
import java.awt.Window;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import javax.swing.Icon;
import javax.swing.JOptionPane;
import org.apache.commons.io.FilenameUtils;

class FSBActionManager {
    private static final int MAX_PROJECT_SIZE_TO_SEARCH_WITHOUT_WARNING_USER = 1000;
    private static final int MAX_TEXT_FILE_LEN = 65536;
    DockingAction actionImport;
    DockingAction actionOpenPrograms;
    DockingAction actionOpenFileSystemChooser;
    DockingAction actionOpenFileSystemNewWindow;
    DockingAction actionOpenFileSystemNested;
    DockingAction actionGetInfo;
    DockingAction actionListMountedFileSystems;
    DockingAction actionViewAsText;
    DockingAction actionViewAsImage;
    DockingAction actionExportAll;
    DockingAction actionExport;
    DockingAction actionExpand;
    DockingAction actionCollapse;
    DockingAction actionImportBatch;
    DockingAction actionCloseFileSystem;
    DockingAction actionClearCachedPasswords;
    protected FileSystemBrowserPlugin plugin;
    protected FileSystemBrowserComponentProvider provider;
    private TextEditorService textEditorService;
    private GTree gTree;
    private GhidraFileChooser chooserExport;
    private GhidraFileChooser chooserExportAll;
    private List<DockingAction> actions = new ArrayList<DockingAction>();
    private FileSystemService fsService = FileSystemService.getInstance();
    private static final Function<Object, String> PLAIN_TOSTRING = o -> o.toString();
    private static final Function<Object, String> SIZE_TOSTRING = o -> o instanceof Long ? FSUtilities.formatSize((Long)o) : o.toString();
    private static final Function<Object, String> UNIX_ACL_TOSTRING = o -> o instanceof Number ? String.format("%05o", (Number)o) : o.toString();
    private static final Function<Object, String> DATE_TOSTRING = o -> o instanceof Date ? FSUtilities.formatFSTimestamp((Date)o) : o.toString();
    private static final Function<Object, String> FSRL_TOSTRING = o -> o instanceof FSRL ? ((FSRL)o).toPrettyString().replace("|", "|\n\t") : o.toString();
    private static final Map<FileAttributeType, Function<Object, String>> FAT_TOSTRING_FUNCS = Map.ofEntries(Map.entry(FileAttributeType.FSRL_ATTR, FSRL_TOSTRING), Map.entry(FileAttributeType.SIZE_ATTR, SIZE_TOSTRING), Map.entry(FileAttributeType.COMPRESSED_SIZE_ATTR, SIZE_TOSTRING), Map.entry(FileAttributeType.CREATE_DATE_ATTR, DATE_TOSTRING), Map.entry(FileAttributeType.MODIFIED_DATE_ATTR, DATE_TOSTRING), Map.entry(FileAttributeType.ACCESSED_DATE_ATTR, DATE_TOSTRING), Map.entry(FileAttributeType.UNIX_ACL_ATTR, UNIX_ACL_TOSTRING));

    FSBActionManager(FileSystemBrowserPlugin plugin, FileSystemBrowserComponentProvider provider, TextEditorService textEditorService, GTree gTree) {
        this.plugin = plugin;
        this.provider = provider;
        this.textEditorService = textEditorService;
        this.gTree = gTree;
        this.createActions();
    }

    private void createActions() {
        this.actionCloseFileSystem = this.createCloseAction();
        this.actions.add(this.actionCloseFileSystem);
        this.actionOpenPrograms = this.createOpenProgramsAction();
        this.actions.add(this.actionOpenPrograms);
        this.actionImport = this.createImportAction();
        this.actions.add(this.actionImport);
        this.actionImportBatch = this.createBatchImportAction();
        this.actions.add(this.actionImportBatch);
        this.actionOpenFileSystemNewWindow = this.createOpenFileSystemNewWindowAction();
        this.actions.add(this.actionOpenFileSystemNewWindow);
        this.actionOpenFileSystemNested = this.createOpenFileSystemNestedAction();
        this.actions.add(this.actionOpenFileSystemNested);
        this.actionOpenFileSystemChooser = this.createOpenNewFileSystemAction();
        this.actions.add(this.actionOpenFileSystemChooser);
        this.actionExpand = this.createExpandAllAction();
        this.actions.add(this.actionExpand);
        this.actionCollapse = this.createCollapseAllAction();
        this.actions.add(this.actionCollapse);
        this.actionViewAsImage = this.createViewAsImageAction();
        this.actions.add(this.actionViewAsImage);
        this.actionViewAsText = this.createViewAsTextAction();
        this.actions.add(this.actionViewAsText);
        this.actionExport = this.createExportAction();
        this.actions.add(this.actionExport);
        this.actionExportAll = this.createExportAllAction();
        this.actions.add(this.actionExportAll);
        this.actionGetInfo = this.createGetInfoAction();
        this.actions.add(this.actionGetInfo);
        this.actionListMountedFileSystems = this.createListMountedFilesystemsAction();
        this.actions.add(this.actionListMountedFileSystems);
        this.actionClearCachedPasswords = this.createClearCachedPasswordsAction();
        this.actions.add(this.actionClearCachedPasswords);
        this.actions.add(this.createRefreshAction());
    }

    private void removeActions() {
        for (DockingAction action : this.actions) {
            this.plugin.getTool().removeLocalAction((ComponentProvider)this.provider, (DockingActionIf)action);
        }
    }

    public void registerComponentActionsInTool() {
        for (DockingAction action : this.actions) {
            this.plugin.getTool().addLocalAction((ComponentProvider)this.provider, (DockingActionIf)action);
        }
    }

    public void dispose() {
        this.removeActions();
    }

    private void openProgramFromFile(FSRL file, FSBNode node, String suggestedDestinationPath) {
        ProgramManager pm = FSBUtils.getProgramManager(this.plugin.getTool(), false);
        if (pm == null) {
            return;
        }
        this.gTree.runTask(monitor -> {
            boolean success = this.doOpenProgramFromFile(file, suggestedDestinationPath, pm, monitor);
            if (!success) {
                if (!this.ensureFileAccessable(file, node, monitor)) {
                    return;
                }
                ImporterUtilities.showImportDialog(this.plugin.getTool(), pm, file, null, suggestedDestinationPath, monitor);
            }
        });
    }

    private boolean doOpenProgramFromFile(FSRL fsrl, String suggestedDestinationPath, ProgramManager programManager, TaskMonitor monitor) {
        Object consumer = new Object();
        Program program = ProgramMappingService.findMatchingProgramOpenIfNeeded(fsrl, consumer, programManager, 1);
        if (program != null) {
            program.release(consumer);
            return true;
        }
        return this.searchProjectForMatchingFileOrFail(fsrl, suggestedDestinationPath, programManager, monitor);
    }

    private boolean searchProjectForMatchingFileOrFail(FSRL fsrl, String suggestedDestinationPath, ProgramManager programManager, TaskMonitor monitor) {
        boolean doSearch = this.isProjectSmallEnoughToSearchWithoutWarningUser() || OptionDialog.showYesNoDialog(null, (String)"Search Project for matching program?", (String)"Search entire Project for matching program? (WARNING, could take large amount of time)") == 1;
        Map<Object, Object> matchedFSRLs = doSearch ? ProgramMappingService.searchProjectForMatchingFiles(List.of(fsrl), monitor) : Map.of();
        DomainFile domainFile = (DomainFile)matchedFSRLs.get(fsrl);
        if (domainFile != null) {
            ProgramMappingService.createAssociation(fsrl, domainFile);
            this.showProgramInProgramManager(fsrl, domainFile, programManager, true);
            return true;
        }
        return false;
    }

    private void openProgramsFromFiles(List<FSRL> files) {
        ProgramManager pm = FSBUtils.getProgramManager(this.plugin.getTool(), false);
        if (pm == null) {
            return;
        }
        this.gTree.runTask(monitor -> {
            List<FSRL> unmatchedFiles = this.doOpenProgramsFromFiles(files, pm, monitor);
            if (unmatchedFiles.size() == 1) {
                ImporterUtilities.showImportDialog(this.plugin.getTool(), pm, unmatchedFiles.get(0), null, null, monitor);
            } else if (unmatchedFiles.size() > 1) {
                BatchImportDialog.showAndImport(this.plugin.getTool(), null, unmatchedFiles, null, pm);
            }
        });
    }

    private List<FSRL> doOpenProgramsFromFiles(List<FSRL> fsrls, ProgramManager programManager, TaskMonitor monitor) {
        int programsOpened = 0;
        List<FSRL> unmatchedFiles = new ArrayList<FSRL>();
        Object consumer = new Object();
        for (FSRL fsrl : fsrls) {
            Program program = ProgramMappingService.findMatchingProgramOpenIfNeeded(fsrl, consumer, programManager, programsOpened == 0 ? 1 : 2);
            if (program == null) {
                unmatchedFiles.add(fsrl);
                continue;
            }
            program.release(consumer);
            ++programsOpened;
        }
        if (!unmatchedFiles.isEmpty()) {
            unmatchedFiles = this.searchProjectForMatchingFilesOrFail(unmatchedFiles, programManager, monitor, programsOpened);
        }
        return unmatchedFiles;
    }

    private List<FSRL> searchProjectForMatchingFilesOrFail(List<FSRL> fsrlList, ProgramManager programManager, TaskMonitor monitor, int programsOpened) {
        boolean doSearch = this.isProjectSmallEnoughToSearchWithoutWarningUser() || OptionDialog.showYesNoDialog(null, (String)"Search Project for matching programs?", (String)"Search entire Project for matching programs? (WARNING, could take large amount of time)") == 1;
        Map matchedFSRLs = doSearch ? ProgramMappingService.searchProjectForMatchingFiles(fsrlList, monitor) : Map.of();
        ArrayList<FSRL> unmatchedFSRLs = new ArrayList<FSRL>();
        for (FSRL fsrl : fsrlList) {
            DomainFile domainFile = (DomainFile)matchedFSRLs.get(fsrl);
            if (domainFile != null) {
                ProgramMappingService.createAssociation(fsrl, domainFile);
            }
            if (this.showProgramInProgramManager(fsrl, domainFile, programManager, programsOpened == 0)) {
                ++programsOpened;
                continue;
            }
            unmatchedFSRLs.add(fsrl);
        }
        return unmatchedFSRLs;
    }

    private boolean isProjectSmallEnoughToSearchWithoutWarningUser() {
        int fc = AppInfo.getActiveProject().getProjectData().getFileCount();
        return fc >= 0 && fc < 1000;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean showProgramInProgramManager(FSRL fsrl, DomainFile domainFile, ProgramManager programManager, boolean show) {
        Program program = null;
        Object consumer = new Object();
        try {
            program = ProgramMappingService.findMatchingProgramOpenIfNeeded(fsrl, domainFile, consumer, programManager, show ? 1 : 2);
            boolean bl = program != null;
            return bl;
        }
        finally {
            if (program != null) {
                program.release(consumer);
            }
        }
    }

    private DockingAction createExportAction() {
        return (DockingAction)new ActionBuilder("FSB Export", this.plugin.getName()).withContext(FSBActionContext.class).enabledWhen(ac -> ac.notBusy() && ac.getFileFSRL() != null).popupMenuIcon((Icon)ImageManager.EXTRACT).popupMenuPath(new String[]{"Export..."}).popupMenuGroup("F", "B").onAction(ac -> {
            int answer;
            FSRL fsrl = ac.getFileFSRL();
            if (fsrl == null) {
                return;
            }
            if (this.chooserExport == null) {
                this.chooserExport = new GhidraFileChooser((Component)this.provider.getComponent());
                this.chooserExport.setFileSelectionMode(GhidraFileChooserMode.FILES_ONLY);
                this.chooserExport.setTitle("Select Where To Export File");
                this.chooserExport.setApproveButtonText("Export");
            }
            File selectedFile = new File(this.chooserExport.getCurrentDirectory(), fsrl.getName());
            this.chooserExport.setSelectedFile(selectedFile);
            File outputFile = this.chooserExport.getSelectedFile();
            if (outputFile == null) {
                return;
            }
            if (outputFile.exists() && (answer = OptionDialog.showYesNoDialog((Component)this.provider.getComponent(), (String)"Confirm Overwrite", (String)(outputFile.getAbsolutePath() + "\nThe file already exists.\nDo you want to overwrite it?"))) == 2) {
                return;
            }
            this.gTree.runTask(monitor -> this.doExtractFile(fsrl, outputFile, ac.getSelectedNode(), monitor));
        }).build();
    }

    private DockingAction createExportAllAction() {
        return (DockingAction)new ActionBuilder("FSB Export All", this.plugin.getName()).withContext(FSBActionContext.class).enabledWhen(ac -> ac.notBusy() && ac.isSelectedAllDirs()).popupMenuIcon((Icon)ImageManager.EXTRACT).popupMenuPath(new String[]{"Export All..."}).popupMenuGroup("F", "C").onAction(ac -> {
            FSRL fsrl = ac.getFSRL(true);
            if (fsrl == null) {
                return;
            }
            if (fsrl instanceof FSRLRoot) {
                fsrl = fsrl.appendPath("/");
            }
            if (this.chooserExportAll == null) {
                this.chooserExportAll = new GhidraFileChooser((Component)this.provider.getComponent());
                this.chooserExportAll.setFileSelectionMode(GhidraFileChooserMode.DIRECTORIES_ONLY);
                this.chooserExportAll.setTitle("Select Export Directory");
                this.chooserExportAll.setApproveButtonText("Export All");
            }
            this.chooserExportAll.setSelectedFile(null);
            File outputFile = this.chooserExportAll.getSelectedFile();
            if (outputFile == null) {
                return;
            }
            if (!outputFile.isDirectory()) {
                Msg.showInfo((Object)this, (Component)this.provider.getComponent(), (String)"Export All", (Object)"Selected file is not a directory.");
                return;
            }
            Window parentComp = this.plugin.getTool().getActiveWindow();
            TaskLauncher.launch((Task)new GFileSystemExtractAllTask(fsrl, outputFile, parentComp));
        }).build();
    }

    private DockingAction createViewAsImageAction() {
        return (DockingAction)new ActionBuilder("FSB View As Image", this.plugin.getName()).withContext(FSBActionContext.class).enabledWhen(ac -> ac.notBusy() && ac.getFileFSRL() != null).popupMenuIcon((Icon)ImageManager.VIEW_AS_IMAGE).popupMenuPath(new String[]{"View As Image"}).popupMenuGroup("G").onAction(ac -> {
            FSRL fsrl = ac.getFileFSRL();
            if (fsrl != null) {
                this.gTree.runTask(monitor -> this.doViewAsImage(fsrl, ac.getSelectedNode(), monitor));
            }
        }).build();
    }

    private DockingAction createViewAsTextAction() {
        return (DockingAction)new ActionBuilder("FSB View As Text", this.plugin.getName()).withContext(FSBActionContext.class).enabledWhen(ac -> ac.notBusy() && ac.getFileFSRL() != null).popupMenuIcon((Icon)ImageManager.VIEW_AS_TEXT).popupMenuPath(new String[]{"View As Text"}).popupMenuGroup("G").onAction(ac -> {
            FSRL fsrl = ac.getFileFSRL();
            if (fsrl != null) {
                this.gTree.runTask(monitor -> this.doViewAsText(fsrl, ac.getSelectedNode(), monitor));
            }
        }).build();
    }

    private DockingAction createListMountedFilesystemsAction() {
        return (DockingAction)((ActionBuilder)new ActionBuilder("FSB List Mounted Filesystems", this.plugin.getName()).description("List Mounted Filesystems")).withContext(FSBActionContext.class).enabledWhen(FSBActionContext::notBusy).toolBarIcon((Icon)ImageManager.LIST_MOUNTED).toolBarGroup("ZZZZ").popupMenuIcon((Icon)ImageManager.LIST_MOUNTED).popupMenuPath(new String[]{"List Mounted Filesystems"}).popupMenuGroup("L").onAction(ac -> {
            FileSystemRef fsRef;
            FSRLRoot fsFSRL = SelectFromListDialog.selectFromList(this.fsService.getMountedFilesystems(), "Select filesystem", "Choose filesystem to view", f -> f.toPrettyString());
            if (fsFSRL != null && (fsRef = this.fsService.getMountedFilesystem(fsFSRL)) != null) {
                this.plugin.createNewFileSystemBrowser(fsRef, true);
            }
        }).build();
    }

    private DockingAction createExpandAllAction() {
        return (DockingAction)new ActionBuilder("FSB Expand All", this.plugin.getName()).withContext(FSBActionContext.class).enabledWhen(ac -> ac.notBusy() && ac.getSelectedCount() == 1 && ac.isSelectedAllDirs()).popupMenuIcon((Icon)ImageManager.EXPAND_ALL).popupMenuPath(new String[]{"Expand All"}).popupMenuGroup("B", "A").onAction(ac -> {
            FSBNode selectedNode = ac.getSelectedNode();
            if (selectedNode != null) {
                this.gTree.expandTree((GTreeNode)selectedNode);
            }
        }).build();
    }

    private DockingAction createCollapseAllAction() {
        return (DockingAction)new ActionBuilder("FSB Collapse All", this.plugin.getName()).withContext(FSBActionContext.class).enabledWhen(ac -> ac.notBusy() && ac.getSelectedCount() == 1 && ac.isSelectedAllDirs()).popupMenuIcon((Icon)ImageManager.COLLAPSE_ALL).popupMenuPath(new String[]{"Collapse All"}).popupMenuGroup("B", "B").onAction(ac -> {
            FSBNode selectedNode = ac.getSelectedNode();
            if (selectedNode != null) {
                this.gTree.collapseAll((GTreeNode)selectedNode);
            }
        }).build();
    }

    private DockingAction createGetInfoAction() {
        return (DockingAction)new ActionBuilder("Get Info", this.plugin.getName()).withContext(FSBActionContext.class).enabledWhen(ac -> ac.notBusy() && ac.getFSRL(true) != null).popupMenuPath(new String[]{"Get Info"}).popupMenuGroup("A").popupMenuIcon((Icon)ImageManager.INFO).description("Show information about a file").onAction(ac -> {
            FSRL fsrl = ac.getFSRL(true);
            this.gTree.runTask(monitor -> this.showInfoForFile(fsrl, monitor));
        }).build();
    }

    private DockingAction createOpenFileSystemNewWindowAction() {
        return (DockingAction)new ActionBuilder("FSB Open File System In New Window", this.plugin.getName()).withContext(FSBActionContext.class).enabledWhen(ac -> ac.notBusy() && ac.getSelectedNode() instanceof FSBFileNode).popupMenuIcon((Icon)ImageManager.OPEN_FILE_SYSTEM).popupMenuPath(new String[]{"Open File System in new window"}).popupMenuGroup("C").onAction(ac -> {
            if (!(ac.getSelectedNode() instanceof FSBFileNode) || ac.getSelectedNode().getFSRL() == null) {
                return;
            }
            FSBFileNode selectedNode = (FSBFileNode)ac.getSelectedNode();
            FSRL containerFSRL = selectedNode.getFSRL();
            if (containerFSRL != null) {
                this.gTree.runTask(monitor -> this.doOpenFileSystem(containerFSRL, selectedNode, false, monitor));
            }
        }).build();
    }

    private DockingAction createOpenFileSystemNestedAction() {
        return (DockingAction)new ActionBuilder("FSB Open File System Nested", this.plugin.getName()).withContext(FSBActionContext.class).enabledWhen(ac -> ac.notBusy() && ac.getSelectedNode() instanceof FSBFileNode).popupMenuIcon((Icon)ImageManager.OPEN_FILE_SYSTEM).popupMenuPath(new String[]{"Open File System"}).popupMenuGroup("C").onAction(ac -> {
            if (!(ac.getSelectedNode() instanceof FSBFileNode) || ac.getSelectedNode().getFSRL() == null) {
                return;
            }
            FSBFileNode selectedNode = (FSBFileNode)ac.getSelectedNode();
            FSRL containerFSRL = selectedNode.getFSRL();
            if (containerFSRL != null) {
                this.gTree.runTask(monitor -> this.doOpenFileSystem(containerFSRL, selectedNode, true, monitor));
            }
        }).build();
    }

    private DockingAction createOpenNewFileSystemAction() {
        return (DockingAction)((ActionBuilder)new ActionBuilder("FSB Open File System Chooser", this.plugin.getName()).description("Open File System Chooser")).withContext(FSBActionContext.class).enabledWhen(FSBActionContext::notBusy).toolBarIcon((Icon)ImageManager.OPEN_FILE_SYSTEM).toolBarGroup("B").onAction(ac -> this.plugin.openFileSystem()).build();
    }

    private DockingAction createOpenProgramsAction() {
        return (DockingAction)new ActionBuilder("FSB Open Programs", this.plugin.getName()).withContext(FSBActionContext.class).enabledWhen(ac -> ac.notBusy() && this.plugin.hasProgramManager() && !ac.getLoadableFSRLs().isEmpty()).popupMenuIcon((Icon)ImageManager.OPEN_ALL).popupMenuPath(new String[]{"Open Program(s)"}).popupMenuGroup("D", "B").onAction(ac -> {
            if (!this.plugin.hasProgramManager()) {
                Msg.showInfo((Object)this, (Component)this.plugin.getTool().getActiveWindow(), (String)"Open Program Error", (Object)"There is no tool currently open that can be used to show a program.");
                return;
            }
            List<FSRL> files = ac.getLoadableFSRLs();
            if (files.size() == 1) {
                String treePath = FilenameUtils.getFullPathNoEndSeparator((String)ac.getFormattedTreePath());
                this.openProgramFromFile(files.get(0), ac.getSelectedNodes().get(0), treePath);
            } else if (files.size() > 1) {
                this.openProgramsFromFiles(files);
            }
        }).build();
    }

    private DockingAction createCloseAction() {
        return (DockingAction)new ActionBuilder("FSB Close", this.plugin.getName()).withContext(FSBActionContext.class).enabledWhen(ac -> ac.notBusy() && ac.getSelectedNode() instanceof FSBRootNode).description("Close").toolBarIcon((Icon)ImageManager.CLOSE).toolBarGroup("ZZZZ").popupMenuIcon((Icon)ImageManager.CLOSE).popupMenuPath(new String[]{"Close"}).popupMenuGroup("ZZZZ").onAction(ac -> {
            FSBNode selectedNode = ac.getSelectedNode();
            if (!(selectedNode instanceof FSBRootNode)) {
                return;
            }
            FSBRootNode node = (FSBRootNode)selectedNode;
            if (node.getParent() == null) {
                if (OptionDialog.showYesNoDialog((Component)this.provider.getComponent(), (String)"Close File System", (String)("Do you want to close the filesystem browser for " + node.getName() + "?")) == 1) {
                    this.provider.componentHidden();
                }
            } else {
                this.gTree.runTask(monitor -> node.swapBackPrevModelNodeAndDispose());
            }
        }).build();
    }

    private DockingAction createImportAction() {
        return (DockingAction)new ActionBuilder("FSB Import Single", this.plugin.getName()).withContext(FSBActionContext.class).enabledWhen(ac -> ac.notBusy() && ac.getLoadableFSRL() != null).popupMenuIcon((Icon)ImageManager.IMPORT).popupMenuPath(new String[]{"Import"}).popupMenuGroup("F", "A").onAction(ac -> {
            FSRL fsrl = ac.getLoadableFSRL();
            if (fsrl == null) {
                return;
            }
            String treePath = ac.getFormattedTreePath();
            String suggestedPath = FilenameUtils.getFullPathNoEndSeparator((String)treePath).replaceAll(":/", "/");
            PluginTool tool = this.plugin.getTool();
            ProgramManager pm = FSBUtils.getProgramManager(tool, false);
            this.gTree.runTask(monitor -> {
                if (!this.ensureFileAccessable(fsrl, ac.getSelectedNode(), monitor)) {
                    return;
                }
                ImporterUtilities.showImportDialog(tool, pm, fsrl, null, suggestedPath, monitor);
            });
        }).build();
    }

    private DockingAction createBatchImportAction() {
        return (DockingAction)new ActionBuilder("FSB Import Batch", this.plugin.getName()).withContext(FSBActionContext.class).enabledWhen(ac -> ac.notBusy() && ac.getSelectedCount() > 0).popupMenuIcon((Icon)ImageManager.IMPORT).popupMenuPath(new String[]{"Batch Import"}).popupMenuGroup("F", "B").onAction(ac -> {
            List<FSRL> files = ac.getFSRLs(true);
            if (files.isEmpty()) {
                return;
            }
            boolean allDirs = ac.isSelectedAllDirs();
            if (files.size() > 1 && !allDirs) {
                files = ac.getFileFSRLs();
            }
            BatchImportDialog.showAndImport(this.plugin.getTool(), null, files, null, FSBUtils.getProgramManager(this.plugin.getTool(), false));
        }).build();
    }

    private DockingAction createClearCachedPasswordsAction() {
        return (DockingAction)new ActionBuilder("FSB Clear Cached Passwords", this.plugin.getName()).withContext(FSBActionContext.class).enabledWhen(FSBActionContext::notBusy).popupMenuPath(new String[]{"Clear Cached Passwords"}).popupMenuGroup("Z", "B").description("Clear cached container file passwords").onAction(ac -> {
            CachedPasswordProvider ccp = CryptoProviders.getInstance().getCachedCryptoProvider();
            int preCount = ccp.getCount();
            ccp.clearCache();
            Msg.info((Object)this, (Object)("Cleared " + (preCount - ccp.getCount()) + " cached passwords."));
        }).build();
    }

    private DockingAction createRefreshAction() {
        return (DockingAction)new ActionBuilder("FSB Refresh", this.plugin.getName()).withContext(FSBActionContext.class).enabledWhen(ac -> ac.notBusy() && ac.hasSelectedNodes()).popupMenuPath(new String[]{"Refresh"}).popupMenuGroup("Z", "Z").description("Refresh file info").onAction(ac -> this.gTree.runTask(monitor -> this.doRefreshInfo(ac.getSelectedNodes(), monitor))).build();
    }

    private void doExtractFile(FSRL fsrl, File outputFile, FSBNode node, TaskMonitor monitor) {
        if (!this.ensureFileAccessable(fsrl, node, monitor)) {
            return;
        }
        monitor.setMessage("Exporting...");
        try (ByteProvider fileBP = this.fsService.getByteProvider(fsrl, false, monitor);){
            long bytesCopied = FSUtilities.copyByteProviderToFile(fileBP, outputFile, monitor);
            Msg.info((Object)this, (Object)("Exported " + fsrl.getName() + " to " + outputFile + ", " + bytesCopied + " bytes copied."));
        }
        catch (CancelledException | IOException | UnsupportedOperationException e) {
            FSUtilities.displayException(this, this.plugin.getTool().getActiveWindow(), "Error Exporting File", e.getMessage(), e);
        }
    }

    private void doOpenFileSystem(FSRL containerFSRL, FSBFileNode node, boolean nested, TaskMonitor monitor) {
        try {
            if (!this.ensureFileAccessable(containerFSRL, node, monitor)) {
                return;
            }
            monitor.setMessage("Probing " + containerFSRL.getName() + " for filesystems");
            FileSystemRef ref = this.fsService.probeFileForFilesystem(containerFSRL, monitor, FileSystemProbeConflictResolver.GUI_PICKER);
            if (ref == null) {
                Msg.showWarn((Object)this, (Component)this.plugin.getTool().getActiveWindow(), (String)"Open Filesystem", (Object)("No filesystem detected in " + containerFSRL.getName()));
                return;
            }
            Swing.runLater(() -> {
                if (nested) {
                    FSBFileNode modelFileNode = (FSBFileNode)this.gTree.getModelNodeForPath(node.getTreePath());
                    FSBRootNode nestedRootNode = new FSBRootNode(ref, modelFileNode);
                    try {
                        nestedRootNode.setChildren(nestedRootNode.generateChildren(monitor));
                    }
                    catch (CancelledException e) {
                        Msg.warn((Object)this, (Object)"Failed to populate FSB root node with children");
                    }
                    int indexInParent = modelFileNode.getIndexInParent();
                    GTreeNode parent = modelFileNode.getParent();
                    parent.removeNode((GTreeNode)modelFileNode);
                    parent.addNode(indexInParent, (GTreeNode)nestedRootNode);
                    this.gTree.expandPath((GTreeNode)nestedRootNode);
                    this.provider.contextChanged();
                } else {
                    this.plugin.createNewFileSystemBrowser(ref, true);
                }
            });
        }
        catch (CancelledException | IOException e) {
            FSUtilities.displayException(this, this.plugin.getTool().getActiveWindow(), "Open Filesystem", "Error opening filesystem for " + containerFSRL.getName(), e);
        }
    }

    private void doViewAsImage(FSRL fsrl, FSBNode node, TaskMonitor monitor) {
        if (!this.ensureFileAccessable(fsrl, node, monitor)) {
            return;
        }
        Window parent = this.plugin.getTool().getActiveWindow();
        try (RefdFile refdFile = this.fsService.getRefdFile(fsrl, monitor);){
            Icon icon = GIconProvider.getIconForFile(refdFile.file, monitor);
            if (icon == null) {
                Msg.showError((Object)this, (Component)parent, (String)"Unable To View Image", (Object)("Unable to view " + fsrl.getName() + " as an image."));
                return;
            }
            Swing.runLater(() -> {
                GIconLabel label = new GIconLabel(icon);
                JOptionPane.showMessageDialog(null, label, "Image Viewer: " + fsrl.getName(), 1);
            });
        }
        catch (CancelledException | IOException e) {
            FSUtilities.displayException(this, parent, "Error Viewing Image File", e.getMessage(), e);
        }
    }

    private void doViewAsText(FSRL fsrl, FSBNode node, TaskMonitor monitor) {
        if (!this.ensureFileAccessable(fsrl, node, monitor)) {
            return;
        }
        Window parent = this.plugin.getTool().getActiveWindow();
        try (ByteProvider fileBP = this.fsService.getByteProvider(fsrl, false, monitor);){
            if (fileBP.length() > 65536L) {
                Msg.showInfo((Object)this, (Component)parent, (String)"View As Text Failed", (Object)"File too large to view as text inside Ghidra. Please use the \"EXPORT\" action.");
                return;
            }
            if (fileBP.length() == 0L) {
                Msg.showInfo((Object)this, (Component)parent, (String)"View As Text Failed", (Object)("File " + fsrl.getName() + " is empty (0 bytes)."));
                return;
            }
            try {
                ByteArrayInputStream bais = new ByteArrayInputStream(fileBP.readBytes(0L, fileBP.length()));
                Swing.runLater(() -> this.textEditorService.edit(fsrl.getName(), bais));
            }
            catch (IOException e) {
                Msg.showError((Object)this, (Component)parent, (String)"View As Text Failed", (Object)("Error when trying to view text file " + fsrl.getName()), (Throwable)e);
            }
        }
        catch (CancelledException | IOException e) {
            FSUtilities.displayException(this, parent, "Error Viewing Text File", e.getMessage(), e);
        }
    }

    void doRefreshInfo(List<FSBNode> nodes, TaskMonitor monitor) {
        HashSet<FSBRootNode> rootNodes = new HashSet<FSBRootNode>();
        for (FSBNode node : nodes) {
            if (node instanceof FSBFileNode) {
                if (!((FSBFileNode)node).needsFileAttributesUpdate(monitor)) continue;
                rootNodes.add(node.getFSBRootNode());
                continue;
            }
            if (node instanceof FSBDirNode) {
                rootNodes.add(node.getFSBRootNode());
                continue;
            }
            if (!(node instanceof FSBRootNode)) continue;
            rootNodes.add((FSBRootNode)node);
        }
        try {
            for (FSBRootNode rootNode : rootNodes) {
                rootNode.updateFileAttributes(monitor);
            }
            this.gTree.refilterLater();
        }
        catch (CancelledException cancelledException) {
            // empty catch block
        }
        Swing.runLater(() -> this.gTree.repaint());
    }

    private boolean ensureFileAccessable(FSRL fsrl, FSBNode node, TaskMonitor monitor) {
        boolean bl;
        block11: {
            FSBFileNode fileNode = node instanceof FSBFileNode ? (FSBFileNode)node : null;
            monitor.initialize(0L);
            monitor.setMessage("Testing file access");
            boolean wasMissingPasword = fileNode != null ? fileNode.hasMissingPassword() : false;
            ByteProvider bp = this.fsService.getByteProvider(fsrl, false, monitor);
            try {
                if (fileNode != null && wasMissingPasword) {
                    this.doRefreshInfo(List.of(fileNode), monitor);
                }
                bl = true;
                if (bp == null) break block11;
            }
            catch (Throwable throwable) {
                try {
                    if (bp != null) {
                        try {
                            bp.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (CryptoException e) {
                    Msg.showWarn((Object)this, (Component)this.gTree, (String)"Crypto / Password Error", (Object)("Unable to access the specified file.\nThis could be caused by not entering the correct password or because of missing crypto information.\n\n" + e.getMessage()));
                    return false;
                }
                catch (IOException e) {
                    Msg.showError((Object)this, (Component)this.gTree, (String)"File IO Error", (Object)("Unable to access the specified file.\n\n" + e.getMessage()), (Throwable)e);
                    return false;
                }
                catch (CancelledException e) {
                    return false;
                }
            }
            bp.close();
        }
        return bl;
    }

    private void showInfoForFile(FSRL fsrl, TaskMonitor monitor) {
        if (fsrl == null) {
            Msg.showError((Object)this, null, (String)"Missing File", (Object)"Unable to retrieve information");
            return;
        }
        List<FSRL> fsrls = fsrl instanceof FSRLRoot && ((FSRLRoot)fsrl).hasContainer() ? List.of(((FSRLRoot)fsrl).getContainer(), fsrl) : List.of(fsrl);
        String title = "Info about " + fsrls.get(0).getName();
        ArrayList<FileAttributes> fattrs = new ArrayList<FileAttributes>();
        for (FSRL fsrl2 : fsrls) {
            try {
                fattrs.add(this.getAttrsFor(fsrl2, monitor));
            }
            catch (IOException e) {
                Msg.warn((Object)this, (Object)("Failed to get info for file " + fsrl2), (Throwable)e);
            }
            catch (CancelledException e) {
                return;
            }
        }
        String html = this.getHTMLInfoStringForAttributes(fattrs);
        MultiLineMessageDialog.showMessageDialog((Component)this.plugin.getTool().getActiveWindow(), (String)title, null, (String)html, (int)1);
    }

    private FileAttributes getAttrsFor(FSRL fsrl, TaskMonitor monitor) throws CancelledException, IOException {
        try (RefdFile refdFile = this.fsService.getRefdFile(fsrl, monitor);){
            GFileSystem fs = refdFile.fsRef.getFilesystem();
            GFile file = refdFile.file;
            FileAttributes fattrs = fs.getFileAttributes(file, monitor);
            if (fattrs == null) {
                fattrs = FileAttributes.EMPTY;
            }
            fattrs = fattrs.clone();
            DomainFile associatedDomainFile = ProgramMappingService.getCachedDomainFileFor(fsrl);
            if (associatedDomainFile != null) {
                fattrs.add(FileAttributeType.PROJECT_FILE_ATTR, (Object)associatedDomainFile.getPathname());
            }
            if (!fattrs.contains(FileAttributeType.NAME_ATTR)) {
                fattrs.add(FileAttributeType.NAME_ATTR, (Object)file.getName());
            }
            if (!fattrs.contains(FileAttributeType.PATH_ATTR)) {
                fattrs.add(FileAttributeType.PATH_ATTR, (Object)FilenameUtils.getFullPath((String)file.getPath()));
            }
            if (!fattrs.contains(FileAttributeType.FSRL_ATTR)) {
                fattrs.add(FileAttributeType.FSRL_ATTR, (Object)file.getFSRL());
            }
            FileAttributes fileAttributes = fattrs;
            return fileAttributes;
        }
    }

    private String getHTMLInfoStringForAttributes(List<FileAttributes> fileAttributesList) {
        StringBuilder sb = new StringBuilder("<html>\n<table>\n");
        sb.append("<tr><th>Property</th><th>Value</th></tr>\n");
        for (FileAttributes fattrs : fileAttributesList) {
            if (fattrs != fileAttributesList.get(0)) {
                sb.append("<tr><td colspan=2><hr></td></tr>");
            }
            List<FileAttribute<?>> sortedAttribs = fattrs.getAttributes();
            Collections.sort(sortedAttribs, (o1, o2) -> Integer.compare(o1.getAttributeType().ordinal(), o2.getAttributeType().ordinal()));
            FileAttributeTypeGroup group = null;
            for (FileAttribute<?> attr : sortedAttribs) {
                if (attr.getAttributeType().getGroup() != group && (group = attr.getAttributeType().getGroup()) != FileAttributeTypeGroup.GENERAL_INFO) {
                    sb.append("<tr><td><b>").append(group.getDescriptiveName()).append("</b></td><td><hr></td></tr>\n");
                }
                String valStr = FAT_TOSTRING_FUNCS.getOrDefault((Object)attr.getAttributeType(), PLAIN_TOSTRING).apply(attr.getAttributeValue());
                String html = HTMLUtilities.escapeHTML((String)valStr);
                html = html.replace("\n", "<br>\n");
                sb.append("<tr><td>").append(attr.getAttributeDisplayName()).append(":</td><td>").append(html).append("</td></tr>\n");
            }
        }
        sb.append("</table>");
        return sb.toString();
    }
}

