/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.viewer.util;

import docking.widgets.fieldpanel.support.FieldLocation;
import docking.widgets.fieldpanel.support.FieldRange;
import docking.widgets.fieldpanel.support.FieldSelection;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressOverflowException;
import ghidra.program.model.address.AddressRange;
import ghidra.program.model.address.AddressSet;
import ghidra.program.model.address.AddressSetView;
import ghidra.util.Msg;
import java.math.BigInteger;
import java.util.Arrays;

public class AddressIndexMap {
    public static BigInteger PERCENT_DIVIDER = BigInteger.valueOf(100L);
    public static BigInteger DEFAULT_UNVIEWABLE_GAP_SIZE = BigInteger.valueOf(50L);
    private BigInteger numAddresses;
    private BigInteger[] indexList;
    private Address[] addressList;
    private BigInteger minIndex;
    private BigInteger maxIndex;
    private int lastUsedRangeIndex;
    private AddressSetView originalAddressSet;
    private AddressSet currentViewAddressSet;
    private BigInteger minimumUnviewableGapSize;

    public AddressIndexMap() {
        this.maxIndex = this.minIndex = BigInteger.valueOf(-1L);
        this.numAddresses = BigInteger.ZERO;
        this.indexList = new BigInteger[1];
        this.indexList[0] = BigInteger.ZERO;
        this.addressList = new Address[0];
        this.currentViewAddressSet = new AddressSet();
        this.originalAddressSet = new AddressSet();
    }

    public AddressIndexMap(AddressSetView addrSet) {
        this.maxIndex = this.minIndex = BigInteger.valueOf(-1L);
        this.originalAddressSet = addrSet;
        this.currentViewAddressSet = new AddressSet(addrSet);
        this.buildMapping();
    }

    private AddressIndexMap(AddressIndexMap source) {
        this.maxIndex = this.minIndex = BigInteger.valueOf(-1L);
        this.numAddresses = source.numAddresses;
        this.indexList = source.indexList;
        this.addressList = source.addressList;
        this.currentViewAddressSet = source.currentViewAddressSet;
        this.originalAddressSet = source.getOriginalAddressSet();
    }

    public BigInteger getIndexCount() {
        return this.numAddresses;
    }

    public boolean isGapIndex(BigInteger index) {
        if (BigInteger.ZERO.equals(index)) {
            return false;
        }
        if (index.compareTo(this.minIndex) > 0 && index.compareTo(this.maxIndex) < 0) {
            return false;
        }
        return this.isGapAddress(this.getAddress(index));
    }

    public boolean isGapAddress(Address address) {
        if (address == null) {
            return false;
        }
        if (address.equals((Object)this.originalAddressSet.getMinAddress())) {
            return false;
        }
        AddressRange rangeContaining = this.originalAddressSet.getRangeContaining(address);
        return rangeContaining.getMinAddress().equals((Object)address);
    }

    public Address getAddress(BigInteger index) {
        if (index == null || index.compareTo(BigInteger.ZERO) < 0 || index.compareTo(this.numAddresses) >= 0) {
            return null;
        }
        int arrIndex = 0;
        int compareTo = index.compareTo(this.minIndex);
        if (compareTo == 0) {
            return this.addressList[this.lastUsedRangeIndex];
        }
        if (index.compareTo(this.minIndex) > 0 && index.compareTo(this.maxIndex) < 0) {
            arrIndex = this.lastUsedRangeIndex;
        } else {
            arrIndex = Arrays.binarySearch(this.indexList, index);
            if (arrIndex >= 0) {
                this.minIndex = this.indexList[arrIndex];
                this.maxIndex = this.indexList[arrIndex + 1];
                this.lastUsedRangeIndex = arrIndex;
                return this.addressList[arrIndex];
            }
            arrIndex = -arrIndex - 2;
            this.minIndex = this.indexList[arrIndex];
            this.maxIndex = this.indexList[arrIndex + 1];
            this.lastUsedRangeIndex = arrIndex;
        }
        BigInteger offset = index.subtract(this.indexList[arrIndex]);
        try {
            return this.addressList[arrIndex].addNoWrap(offset);
        }
        catch (AddressOverflowException e) {
            Msg.showError((Object)this, null, (String)"Bad Index Map", (Object)e.getMessage());
            return null;
        }
    }

    public BigInteger getIndex(Address addr) {
        int arrIndex = Arrays.binarySearch(this.addressList, addr);
        if (arrIndex >= 0) {
            return this.indexList[arrIndex];
        }
        if ((arrIndex = -arrIndex - 2) < 0) {
            return null;
        }
        if (!addr.getAddressSpace().equals(this.addressList[arrIndex].getAddressSpace())) {
            return null;
        }
        BigInteger offset = addr.getOffsetAsBigInteger().subtract(this.addressList[arrIndex].getOffsetAsBigInteger());
        BigInteger index = this.indexList[arrIndex].add(offset);
        if (index.compareTo(this.indexList[arrIndex + 1]) >= 0) {
            return null;
        }
        return index;
    }

    public BigInteger getIndexAtOrAfter(Address addr) {
        int rangeIndex = Arrays.binarySearch(this.addressList, addr);
        if (rangeIndex >= 0) {
            return this.indexList[rangeIndex];
        }
        if ((rangeIndex = -rangeIndex - 2) < 0) {
            return BigInteger.ZERO;
        }
        if (!addr.getAddressSpace().equals(this.addressList[rangeIndex].getAddressSpace())) {
            return this.indexList[rangeIndex + 1];
        }
        BigInteger offset = addr.getOffsetAsBigInteger().subtract(this.addressList[rangeIndex].getOffsetAsBigInteger());
        BigInteger index = this.indexList[rangeIndex].add(offset);
        if (index.compareTo(this.indexList[rangeIndex + 1]) >= 0) {
            return this.indexList[rangeIndex + 1];
        }
        return index;
    }

    public AddressSet getAddressSet(FieldSelection sel) {
        AddressSet addrSet = new AddressSet();
        int n = sel.getNumRanges();
        for (int i = 0; i < n; ++i) {
            FieldRange range = sel.getFieldRange(i);
            FieldLocation end = range.getEnd();
            BigInteger endIndex = end.getIndex();
            if (end.getFieldNum() == 0 && end.getRow() == 0 && end.getCol() == 0) {
                endIndex = endIndex.subtract(BigInteger.ONE);
            }
            this.addToAddressSet(addrSet, range.getStart().getIndex(), endIndex);
        }
        return addrSet;
    }

    public FieldSelection getFieldSelection(AddressSetView set) {
        AddressSet addrSet = this.currentViewAddressSet.intersect(set);
        FieldSelection fs = new FieldSelection();
        for (AddressRange range : addrSet) {
            BigInteger minRangeIndex = this.getIndex(range.getMinAddress());
            BigInteger maxRangeIndex = this.getIndex(range.getMaxAddress());
            if (maxRangeIndex == null || minRangeIndex == null) continue;
            fs.addRange(minRangeIndex, maxRangeIndex.add(BigInteger.ONE));
        }
        return fs;
    }

    public AddressSetView getOriginalAddressSet() {
        return this.originalAddressSet;
    }

    public AddressSetView getIndexedAddressSet() {
        return this.currentViewAddressSet;
    }

    public BigInteger getMaxIndex(Address addr) {
        int rangeIndex = Arrays.binarySearch(this.addressList, addr);
        if (rangeIndex < 0) {
            rangeIndex = -rangeIndex - 2;
        }
        if (rangeIndex < 0) {
            return null;
        }
        return this.indexList[rangeIndex + 1].subtract(BigInteger.ONE);
    }

    public BigInteger getMinIndex(Address addr) {
        int rangeIndex = Arrays.binarySearch(this.addressList, addr);
        if (rangeIndex < 0) {
            rangeIndex = -rangeIndex - 2;
        }
        if (rangeIndex < 0) {
            return null;
        }
        return this.indexList[rangeIndex];
    }

    public void removeUnviewableAddressRanges(AddressSet addressSet) {
        this.currentViewAddressSet.delete((AddressSetView)addressSet);
        this.buildMapping();
    }

    public BigInteger getMiniumUnviewableGapSize() {
        return this.minimumUnviewableGapSize;
    }

    public AddressIndexMap reset() {
        AddressIndexMap currentMap = new AddressIndexMap(this);
        this.currentViewAddressSet = new AddressSet(this.originalAddressSet);
        this.buildMapping();
        return currentMap;
    }

    private void addToAddressSet(AddressSet set, BigInteger startIndex, BigInteger endIndex) {
        int rangeIndex = Arrays.binarySearch(this.indexList, startIndex);
        if (rangeIndex < 0) {
            rangeIndex = -rangeIndex - 2;
        }
        if (rangeIndex >= this.addressList.length) {
            return;
        }
        Address startAddr = this.getAddress(rangeIndex, startIndex);
        while (endIndex.compareTo(this.indexList[rangeIndex + 1]) >= 0) {
            Address endAddr = this.getAddress(rangeIndex, this.indexList[rangeIndex + 1].subtract(BigInteger.ONE));
            set.addRange(startAddr, endAddr);
            if (++rangeIndex >= this.addressList.length) {
                return;
            }
            startAddr = this.addressList[rangeIndex];
        }
        set.addRange(startAddr, this.getAddress(rangeIndex, endIndex));
    }

    private Address getAddress(int rangeIndex, BigInteger index) {
        if (index.equals(this.indexList[rangeIndex])) {
            return this.addressList[rangeIndex];
        }
        try {
            return this.addressList[rangeIndex].addNoWrap(index.subtract(this.indexList[rangeIndex]));
        }
        catch (AddressOverflowException e) {
            Msg.error((Object)this, (Object)"AddressOverflow can't happen here", (Throwable)e);
            return null;
        }
    }

    private void buildMapping() {
        int numRanges = this.currentViewAddressSet.getNumAddressRanges();
        this.indexList = new BigInteger[numRanges + 1];
        this.addressList = new Address[numRanges];
        BigInteger index = BigInteger.ZERO;
        int i = 0;
        for (AddressRange range : this.currentViewAddressSet) {
            this.indexList[i] = index;
            this.addressList[i] = range.getMinAddress();
            index = index.add(range.getBigLength());
            ++i;
        }
        this.indexList[numRanges] = index;
        this.numAddresses = index;
        this.maxIndex = this.minIndex = BigInteger.valueOf(-1L);
        this.minimumUnviewableGapSize = this.numAddresses.divide(PERCENT_DIVIDER);
        if (this.minimumUnviewableGapSize.compareTo(DEFAULT_UNVIEWABLE_GAP_SIZE) < 0) {
            this.minimumUnviewableGapSize = DEFAULT_UNVIEWABLE_GAP_SIZE;
        }
    }
}

