/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.viewer.field;

import docking.widgets.fieldpanel.field.AttributedString;
import docking.widgets.fieldpanel.field.CompositeFieldElement;
import docking.widgets.fieldpanel.field.FieldElement;
import docking.widgets.fieldpanel.field.TextFieldElement;
import ghidra.app.util.viewer.field.AnnotatedStringHandler;
import ghidra.app.util.viewer.field.Annotation;
import ghidra.app.util.viewer.field.SymbolAnnotatedStringHandler;
import ghidra.program.model.listing.Program;
import ghidra.util.StringUtilities;
import ghidra.util.WordLocation;
import ghidra.util.bean.field.AnnotatedTextFieldElement;
import ghidra.util.exception.AssertException;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Toolkit;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;

public class CommentUtils {
    private static final Pattern ANNOTATION_START_PATTERN = CommentUtils.createAnnotationStartPattern();

    public static String fixupAnnoations(String rawCommentText, Program program) {
        if (rawCommentText == null) {
            return null;
        }
        AttributedString prototype = CommentUtils.createPrototype();
        Function<Annotation, Annotation> symbolFixer = annotation -> {
            AnnotatedStringHandler handler = annotation.getHandler();
            if (!(handler instanceof SymbolAnnotatedStringHandler)) {
                return annotation;
            }
            String rawText = annotation.getAnnotationText();
            String[] annotationParts = annotation.getAnnotationParts();
            String updatedText = SymbolAnnotatedStringHandler.convertAnnotationSymbolToAddress(annotationParts, rawText, program);
            if (updatedText == null) {
                return annotation;
            }
            return new Annotation(updatedText, prototype, program);
        };
        StringBuilder buffy = new StringBuilder();
        List<Object> parts = CommentUtils.doParseTextIntoTextAndAnnotations(rawCommentText, symbolFixer, program, prototype);
        for (Object part : parts) {
            if (part instanceof String) {
                String s = (String)part;
                buffy.append(s);
                continue;
            }
            if (part instanceof Annotation) {
                Annotation a = (Annotation)part;
                buffy.append(a.getAnnotationText());
                continue;
            }
            throw new AssertException("Unhandled annotation piece: " + part);
        }
        return buffy.toString();
    }

    private static AttributedString createPrototype() {
        Font dummyFont = new Font("monospaced", 0, 12);
        FontMetrics fontMetrics = Toolkit.getDefaultToolkit().getFontMetrics(dummyFont);
        return new AttributedString("", Color.BLACK, fontMetrics);
    }

    public static String getDisplayString(String rawCommentText, Program program) {
        AttributedString prototype = CommentUtils.createPrototype();
        FieldElement element = CommentUtils.parseTextForAnnotations(rawCommentText, program, prototype, 0);
        String displayText = element.getText();
        return displayText;
    }

    public static FieldElement parseTextForAnnotations(String text, Program program, AttributedString prototypeString, int row) {
        Function<Annotation, Annotation> noFixing = Function.identity();
        return CommentUtils.doParseTextForAnnotations(text, noFixing, program, prototypeString, row);
    }

    private static FieldElement doParseTextForAnnotations(String text, Function<Annotation, Annotation> fixerUpper, Program program, AttributedString prototype, int row) {
        text = StringUtilities.convertTabsToSpaces((String)text);
        int column = 0;
        List<Object> parts = CommentUtils.doParseTextIntoTextAndAnnotations(text, fixerUpper, program, prototype);
        ArrayList<Object> fields = new ArrayList<Object>();
        for (Object part : parts) {
            if (part instanceof String) {
                String s = (String)part;
                AttributedString as = prototype.deriveAttributedString(s);
                fields.add(new TextFieldElement(as, row, column));
                column += s.length();
                continue;
            }
            if (part instanceof Annotation) {
                Annotation a = (Annotation)part;
                fields.add((Object)new AnnotatedTextFieldElement(a, row, column));
                column += a.getAnnotationText().length();
                continue;
            }
            throw new AssertException("Unhandled annotation piece: " + part);
        }
        return new CompositeFieldElement(fields.toArray(new FieldElement[fields.size()]));
    }

    private static List<Object> doParseTextIntoTextAndAnnotations(String text, Function<Annotation, Annotation> fixerUpper, Program program, AttributedString prototype) {
        ArrayList<Object> results = new ArrayList<Object>();
        List<WordLocation> annotations = CommentUtils.getCommentAnnotations(text);
        if (annotations.isEmpty()) {
            results.add(text);
            return results;
        }
        int offset = 0;
        for (WordLocation word : annotations) {
            int start = word.getStart();
            if (offset != start) {
                String preceeding = text.substring(offset, start);
                results.add(preceeding);
            }
            String annotationText = word.getWord();
            Annotation annotation = new Annotation(annotationText, prototype, program);
            annotation = fixerUpper.apply(annotation);
            results.add(annotation);
            offset = start + annotationText.length();
        }
        if (offset != text.length()) {
            results.add(text.substring(offset));
        }
        return results;
    }

    static List<WordLocation> getCommentAnnotations(String comment) {
        ArrayList<WordLocation> starts = new ArrayList<WordLocation>();
        Matcher matcher = ANNOTATION_START_PATTERN.matcher(comment);
        while (matcher.find()) {
            int position = matcher.start();
            String text = matcher.group();
            starts.add(new WordLocation(comment, text, position));
        }
        ArrayList<WordLocation> results = new ArrayList<WordLocation>();
        for (WordLocation word : starts) {
            int start = word.getStart();
            int offset = start + word.getWord().length();
            int end = CommentUtils.findAnnotationEnd(comment, offset);
            if (end == -1) continue;
            String annotation = comment.substring(start, end);
            results.add(new WordLocation(comment, annotation, start));
        }
        return results;
    }

    private static Pattern createAnnotationStartPattern() {
        Set<String> names = Annotation.getAnnotationNames();
        String namePatternString = StringUtils.join(names, (String)"|");
        return Pattern.compile("(?<!\\\\)(\\{@(" + namePatternString + ")\\s+?)");
    }

    private static int findAnnotationEnd(String comment, int start) {
        boolean startQuote = false;
        int count = 0;
        for (int i = start; i < comment.length(); ++i) {
            char prev;
            char c = prev = i == 0 ? (char)'\u0000' : comment.charAt(i - 1);
            if (prev == '\\') continue;
            char c2 = comment.charAt(i);
            if (c2 == '\"') {
                count = startQuote ? --count : ++count;
                startQuote = !startQuote;
                continue;
            }
            if (c2 != '}' || count != 0) continue;
            return i + 1;
        }
        return -1;
    }
}

