/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.opinion;

import ghidra.app.util.MemoryBlockUtils;
import ghidra.app.util.Option;
import ghidra.app.util.OptionUtils;
import ghidra.app.util.bin.ByteProvider;
import ghidra.app.util.bin.ByteProviderWrapper;
import ghidra.app.util.bin.FileByteProvider;
import ghidra.app.util.bin.format.macho.CpuTypes;
import ghidra.app.util.bin.format.macho.MachConstants;
import ghidra.app.util.bin.format.macho.MachException;
import ghidra.app.util.bin.format.macho.MachHeader;
import ghidra.app.util.bin.format.ubi.FatArch;
import ghidra.app.util.bin.format.ubi.FatHeader;
import ghidra.app.util.bin.format.ubi.UbiException;
import ghidra.app.util.importer.MessageLog;
import ghidra.app.util.opinion.AbstractLibrarySupportLoader;
import ghidra.app.util.opinion.LoadSpec;
import ghidra.app.util.opinion.Loader;
import ghidra.app.util.opinion.MachoPrelinkProgramBuilder;
import ghidra.app.util.opinion.MachoPrelinkUtils;
import ghidra.app.util.opinion.MachoProgramBuilder;
import ghidra.app.util.opinion.QueryOpinionService;
import ghidra.app.util.opinion.QueryResult;
import ghidra.formats.gfilesystem.FileSystemService;
import ghidra.framework.model.DomainObject;
import ghidra.program.database.mem.FileBytes;
import ghidra.program.model.listing.Program;
import ghidra.util.LittleEndianDataConverter;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.TaskMonitor;
import java.io.File;
import java.io.IOException;
import java.nio.file.AccessMode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class MachoLoader
extends AbstractLibrarySupportLoader {
    public static final String MACH_O_NAME = "Mac OS X Mach-O";
    private static final long MIN_BYTE_LENGTH = 4L;
    static final String ADD_CHAINED_FIXUPS_RELOCATIONS_OPTION_NAME = "Add relocation entries for chained fixups";
    static final boolean ADD_CHAINED_FIXUPS_RELOCATIONS_OPTION_DEFAULT = true;

    @Override
    public Collection<LoadSpec> findSupportedLoadSpecs(ByteProvider provider) throws IOException {
        ArrayList<LoadSpec> loadSpecs = new ArrayList<LoadSpec>();
        if (provider.length() < 4L) {
            return loadSpecs;
        }
        byte[] magicBytes = provider.readBytes(0L, 4L);
        if (!MachConstants.isMagic(LittleEndianDataConverter.INSTANCE.getInt(magicBytes))) {
            return loadSpecs;
        }
        try {
            MachHeader machHeader = new MachHeader(provider);
            String magic = CpuTypes.getMagicString(machHeader.getCpuType(), machHeader.getCpuSubType());
            List<QueryResult> results = QueryOpinionService.query(this.getName(), magic, null);
            for (QueryResult result : results) {
                loadSpecs.add(new LoadSpec((Loader)this, machHeader.getImageBase(), result));
            }
            if (loadSpecs.isEmpty()) {
                loadSpecs.add(new LoadSpec((Loader)this, machHeader.getImageBase(), true));
            }
        }
        catch (MachException machException) {
            // empty catch block
        }
        return loadSpecs;
    }

    @Override
    public void load(ByteProvider provider, LoadSpec loadSpec, List<Option> options, Program program, TaskMonitor monitor, MessageLog log) throws IOException {
        try {
            FileBytes fileBytes = MemoryBlockUtils.createFileBytes(program, provider, monitor);
            if (MachoPrelinkUtils.isMachoPrelink(provider, monitor)) {
                MachoPrelinkProgramBuilder.buildProgram(program, provider, fileBytes, this.shouldAddChainedFixupsRelocations(options), log, monitor);
            } else {
                MachoProgramBuilder.buildProgram(program, provider, fileBytes, this.shouldAddChainedFixupsRelocations(options), log, monitor);
            }
        }
        catch (CancelledException e) {
            return;
        }
        catch (IOException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }

    @Override
    public String getName() {
        return MACH_O_NAME;
    }

    @Override
    public List<Option> getDefaultOptions(ByteProvider provider, LoadSpec loadSpec, DomainObject domainObject, boolean loadIntoProgram) {
        List<Option> list = super.getDefaultOptions(provider, loadSpec, domainObject, loadIntoProgram);
        if (!loadIntoProgram) {
            list.add(new Option(ADD_CHAINED_FIXUPS_RELOCATIONS_OPTION_NAME, true, Boolean.class, "-loader-addChainedFixupsRelocations"));
        }
        return list;
    }

    private boolean shouldAddChainedFixupsRelocations(List<Option> options) {
        return OptionUtils.getOption(ADD_CHAINED_FIXUPS_RELOCATIONS_OPTION_NAME, options, true);
    }

    @Override
    protected ByteProvider createLibraryByteProvider(File libFile, LoadSpec loadSpec, MessageLog log) throws IOException {
        if (!libFile.isFile()) {
            return null;
        }
        FileByteProvider provider = new FileByteProvider(libFile, FileSystemService.getInstance().getLocalFSRL(libFile), AccessMode.READ);
        try {
            FatHeader header = new FatHeader(provider);
            List<FatArch> architectures = header.getArchitectures();
            if (architectures.isEmpty()) {
                log.appendMsg("WARNING! No archives found in the UBI: " + libFile);
                return null;
            }
            for (FatArch architecture : architectures) {
                ByteProviderWrapper bp = new ByteProviderWrapper(provider, architecture.getOffset(), architecture.getSize());
                LoadSpec libLoadSpec = this.matchSupportedLoadSpec(loadSpec, provider);
                if (libLoadSpec == null) continue;
                return bp;
            }
        }
        catch (MachException | UbiException exception) {
            // empty catch block
        }
        return provider;
    }
}

