/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.importer;

import ghidra.app.util.importer.MultipleProgramsException;
import ghidra.program.model.listing.Program;
import java.util.List;

public interface MultipleProgramsStrategy {
    public static final MultipleProgramsStrategy ALL_PROGRAMS = new MultipleProgramsStrategy(){

        @Override
        public List<Program> handlePrograms(List<Program> programs, Object consumer) {
            return programs;
        }
    };
    public static final MultipleProgramsStrategy ONE_PROGRAM_OR_EXCEPTION = new MultipleProgramsStrategy(){

        @Override
        public List<Program> handlePrograms(List<Program> programs, Object consumer) {
            if (programs != null && programs.size() > 1) {
                for (Program program : programs) {
                    program.release(consumer);
                }
                throw new MultipleProgramsException();
            }
            return programs;
        }
    };
    public static final MultipleProgramsStrategy ONE_PROGRAM_OR_NULL = new MultipleProgramsStrategy(){

        @Override
        public List<Program> handlePrograms(List<Program> programs, Object consumer) {
            if (programs != null && programs.size() > 1) {
                for (Program program : programs) {
                    program.release(consumer);
                }
                return null;
            }
            return programs;
        }
    };

    public List<Program> handlePrograms(List<Program> var1, Object var2);
}

