/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.macho.dyld;

import ghidra.program.model.address.Address;
import ghidra.program.model.mem.Memory;
import ghidra.program.model.mem.MemoryAccessException;

public class DyldChainedPtr {
    public static final int DYLD_CHAINED_PTR_START_NONE = 65535;
    public static final int DYLD_CHAINED_PTR_START_MULTI = 32768;
    public static final int DYLD_CHAINED_PTR_START_LAST = 32768;

    public static long getStride(DyldChainType ptrFormat) {
        switch (ptrFormat) {
            case DYLD_CHAINED_PTR_ARM64E: 
            case DYLD_CHAINED_PTR_ARM64E_USERLAND: 
            case DYLD_CHAINED_PTR_ARM64E_USERLAND24: {
                return 8L;
            }
            case DYLD_CHAINED_PTR_64: 
            case DYLD_CHAINED_PTR_64_OFFSET: 
            case DYLD_CHAINED_PTR_ARM64E_KERNEL: 
            case DYLD_CHAINED_PTR_64_KERNEL_CACHE: 
            case DYLD_CHAINED_PTR_ARM64E_FIRMWARE: 
            case DYLD_CHAINED_PTR_32: 
            case DYLD_CHAINED_PTR_32_CACHE: 
            case DYLD_CHAINED_PTR_32_FIRMWARE: {
                return 4L;
            }
            case DYLD_CHAINED_PTR_X86_64_KERNEL_CACHE: {
                return 1L;
            }
        }
        return 1L;
    }

    public static void setChainValue(Memory memory, Address chainLoc, DyldChainType ptrFormat, long value) throws MemoryAccessException {
        switch (ptrFormat) {
            case DYLD_CHAINED_PTR_ARM64E: 
            case DYLD_CHAINED_PTR_ARM64E_USERLAND: 
            case DYLD_CHAINED_PTR_ARM64E_USERLAND24: 
            case DYLD_CHAINED_PTR_64: 
            case DYLD_CHAINED_PTR_64_OFFSET: 
            case DYLD_CHAINED_PTR_ARM64E_KERNEL: 
            case DYLD_CHAINED_PTR_64_KERNEL_CACHE: 
            case DYLD_CHAINED_PTR_ARM64E_FIRMWARE: 
            case DYLD_CHAINED_PTR_X86_64_KERNEL_CACHE: {
                memory.setLong(chainLoc, value);
                break;
            }
            case DYLD_CHAINED_PTR_32: 
            case DYLD_CHAINED_PTR_32_CACHE: 
            case DYLD_CHAINED_PTR_32_FIRMWARE: {
                memory.setInt(chainLoc, (int)(value & 0xFFFFFFFFL));
                break;
            }
        }
    }

    public static long getChainValue(Memory memory, Address chainLoc, DyldChainType ptrFormat) throws MemoryAccessException {
        switch (ptrFormat) {
            case DYLD_CHAINED_PTR_ARM64E: 
            case DYLD_CHAINED_PTR_ARM64E_USERLAND: 
            case DYLD_CHAINED_PTR_ARM64E_USERLAND24: 
            case DYLD_CHAINED_PTR_64: 
            case DYLD_CHAINED_PTR_64_OFFSET: 
            case DYLD_CHAINED_PTR_ARM64E_KERNEL: 
            case DYLD_CHAINED_PTR_64_KERNEL_CACHE: 
            case DYLD_CHAINED_PTR_ARM64E_FIRMWARE: 
            case DYLD_CHAINED_PTR_X86_64_KERNEL_CACHE: {
                return memory.getLong(chainLoc);
            }
            case DYLD_CHAINED_PTR_32: 
            case DYLD_CHAINED_PTR_32_CACHE: 
            case DYLD_CHAINED_PTR_32_FIRMWARE: {
                return (long)memory.getInt(chainLoc) & 0xFFFFFFFFL;
            }
        }
        return 0L;
    }

    public static boolean isBound(DyldChainType ptrFormat, long chainValue) {
        switch (ptrFormat) {
            case DYLD_CHAINED_PTR_ARM64E: 
            case DYLD_CHAINED_PTR_ARM64E_USERLAND: 
            case DYLD_CHAINED_PTR_ARM64E_USERLAND24: {
                return (chainValue >>> 62 & 1L) != 0L;
            }
            case DYLD_CHAINED_PTR_64: 
            case DYLD_CHAINED_PTR_64_OFFSET: {
                return (chainValue >>> 63 & 1L) != 0L;
            }
            case DYLD_CHAINED_PTR_32: {
                return (chainValue >>> 31 & 1L) != 0L;
            }
        }
        return false;
    }

    public static boolean isAuthenticated(DyldChainType ptrFormat, long chainValue) {
        switch (ptrFormat) {
            case DYLD_CHAINED_PTR_64: 
            case DYLD_CHAINED_PTR_64_OFFSET: 
            case DYLD_CHAINED_PTR_32: 
            case DYLD_CHAINED_PTR_32_CACHE: 
            case DYLD_CHAINED_PTR_32_FIRMWARE: {
                return false;
            }
        }
        boolean isAuthenticated = (chainValue >>> 63 & 1L) != 0L;
        return isAuthenticated;
    }

    public static long getDiversity(DyldChainType ptrFormat, long chainValue) {
        if (!DyldChainedPtr.isAuthenticated(ptrFormat, chainValue)) {
            return 0L;
        }
        long diversityData = chainValue >>> 32 & 0xFFFFL;
        return diversityData;
    }

    public static boolean hasAddrDiversity(DyldChainType ptrFormat, long chainValue) {
        if (!DyldChainedPtr.isAuthenticated(ptrFormat, chainValue)) {
            return false;
        }
        return (chainValue >>> 48 & 1L) == 1L;
    }

    public static long getKey(DyldChainType ptrFormat, long chainValue) {
        if (!DyldChainedPtr.isAuthenticated(ptrFormat, chainValue)) {
            return 0L;
        }
        return chainValue >>> 49 & 3L;
    }

    public static long getTarget(DyldChainType ptrFormat, long chainValue) {
        long target = 0L;
        if (DyldChainedPtr.isBound(ptrFormat, chainValue)) {
            return -1L;
        }
        if (DyldChainedPtr.isAuthenticated(ptrFormat, chainValue)) {
            switch (ptrFormat) {
                case DYLD_CHAINED_PTR_ARM64E: 
                case DYLD_CHAINED_PTR_ARM64E_USERLAND: 
                case DYLD_CHAINED_PTR_ARM64E_USERLAND24: 
                case DYLD_CHAINED_PTR_ARM64E_KERNEL: {
                    return chainValue & 0xFFFFFFFFL;
                }
                case DYLD_CHAINED_PTR_64_KERNEL_CACHE: 
                case DYLD_CHAINED_PTR_X86_64_KERNEL_CACHE: {
                    return chainValue & 0x3FFFFFFFL;
                }
            }
        }
        switch (ptrFormat) {
            case DYLD_CHAINED_PTR_ARM64E: 
            case DYLD_CHAINED_PTR_ARM64E_USERLAND: 
            case DYLD_CHAINED_PTR_ARM64E_USERLAND24: 
            case DYLD_CHAINED_PTR_ARM64E_KERNEL: {
                long top8Bits = chainValue >> 43 & 0xFFL;
                long bottom43Bits = chainValue & 0x7FFFFFFFFFFL;
                if (top8Bits == 128L) {
                    top8Bits = 0L;
                }
                target = top8Bits << 56 | bottom43Bits;
                break;
            }
            case DYLD_CHAINED_PTR_64: 
            case DYLD_CHAINED_PTR_64_OFFSET: {
                long top8Bits = chainValue >> 36 & 0xFFL;
                long bottom36Bits = chainValue & 0xFFFFFFFFFL;
                if (top8Bits == 128L) {
                    top8Bits = 0L;
                }
                target = top8Bits << 56 | bottom36Bits;
                break;
            }
            case DYLD_CHAINED_PTR_32: {
                target = chainValue & 0x3FFFFFL;
                break;
            }
            case DYLD_CHAINED_PTR_32_CACHE: {
                target = chainValue & 0x3FFFFFFFL;
                break;
            }
            case DYLD_CHAINED_PTR_32_FIRMWARE: {
                target = chainValue & 0x3FFFFFL;
                break;
            }
            case DYLD_CHAINED_PTR_64_KERNEL_CACHE: 
            case DYLD_CHAINED_PTR_X86_64_KERNEL_CACHE: {
                target = chainValue & 0x3FFFFFFFL;
                break;
            }
            default: {
                return 0L;
            }
        }
        return target;
    }

    public static long getAddend(DyldChainType ptrFormat, long chainValue) {
        if (!DyldChainedPtr.isBound(ptrFormat, chainValue)) {
            return 0L;
        }
        switch (ptrFormat) {
            case DYLD_CHAINED_PTR_ARM64E: 
            case DYLD_CHAINED_PTR_ARM64E_USERLAND: 
            case DYLD_CHAINED_PTR_ARM64E_USERLAND24: {
                long addend = chainValue >>> 32 & 0x7FFFFL;
                addend = (addend & 0x40000L) != 0L ? addend | 0xFFFFFFFFFFFC0000L : addend;
                return addend;
            }
            case DYLD_CHAINED_PTR_64: 
            case DYLD_CHAINED_PTR_64_OFFSET: {
                return chainValue >>> 24 & 0xFFL;
            }
            case DYLD_CHAINED_PTR_32: {
                return chainValue >>> 20 & 0x3FL;
            }
        }
        return 0L;
    }

    public static long getOrdinal(DyldChainType ptrFormat, long chainValue) {
        long ordinal = -1L;
        if (!DyldChainedPtr.isBound(ptrFormat, chainValue)) {
            return -1L;
        }
        switch (ptrFormat) {
            case DYLD_CHAINED_PTR_ARM64E: 
            case DYLD_CHAINED_PTR_ARM64E_USERLAND: {
                ordinal = chainValue & 0xFFFFL;
                break;
            }
            case DYLD_CHAINED_PTR_ARM64E_USERLAND24: 
            case DYLD_CHAINED_PTR_64: 
            case DYLD_CHAINED_PTR_64_OFFSET: {
                ordinal = chainValue & 0xFFFFFFL;
                break;
            }
            case DYLD_CHAINED_PTR_32: {
                ordinal = chainValue & 0xFFFFFL;
                break;
            }
            case DYLD_CHAINED_PTR_ARM64E_KERNEL: 
            case DYLD_CHAINED_PTR_64_KERNEL_CACHE: 
            case DYLD_CHAINED_PTR_ARM64E_FIRMWARE: 
            case DYLD_CHAINED_PTR_32_CACHE: 
            case DYLD_CHAINED_PTR_32_FIRMWARE: 
            case DYLD_CHAINED_PTR_X86_64_KERNEL_CACHE: {
                break;
            }
        }
        return ordinal;
    }

    public static long getNext(DyldChainType ptrFormat, long chainValue) {
        long next = 1L;
        switch (ptrFormat) {
            case DYLD_CHAINED_PTR_ARM64E: 
            case DYLD_CHAINED_PTR_ARM64E_USERLAND: 
            case DYLD_CHAINED_PTR_ARM64E_USERLAND24: 
            case DYLD_CHAINED_PTR_ARM64E_KERNEL: {
                next = chainValue >>> 51 & 0x7FFL;
                break;
            }
            case DYLD_CHAINED_PTR_64: 
            case DYLD_CHAINED_PTR_64_OFFSET: 
            case DYLD_CHAINED_PTR_64_KERNEL_CACHE: 
            case DYLD_CHAINED_PTR_X86_64_KERNEL_CACHE: {
                next = chainValue >>> 51 & 0xFFFL;
                break;
            }
            case DYLD_CHAINED_PTR_32: {
                next = chainValue >>> 26 & 0x1FL;
                break;
            }
            case DYLD_CHAINED_PTR_ARM64E_FIRMWARE: {
                next = 0L;
                break;
            }
            case DYLD_CHAINED_PTR_32_CACHE: {
                next = chainValue >>> 30 & 3L;
                break;
            }
            case DYLD_CHAINED_PTR_32_FIRMWARE: {
                next = chainValue >>> 26 & 0x3FL;
                break;
            }
        }
        return next;
    }

    public static enum DyldChainType {
        DYLD_CHAINED_PTR_ARM64E(1),
        DYLD_CHAINED_PTR_64(2),
        DYLD_CHAINED_PTR_32(3),
        DYLD_CHAINED_PTR_32_CACHE(4),
        DYLD_CHAINED_PTR_32_FIRMWARE(5),
        DYLD_CHAINED_PTR_64_OFFSET(6),
        DYLD_CHAINED_PTR_ARM64E_KERNEL(7),
        DYLD_CHAINED_PTR_64_KERNEL_CACHE(8),
        DYLD_CHAINED_PTR_ARM64E_USERLAND(9),
        DYLD_CHAINED_PTR_ARM64E_FIRMWARE(10),
        DYLD_CHAINED_PTR_X86_64_KERNEL_CACHE(11),
        DYLD_CHAINED_PTR_ARM64E_USERLAND24(12),
        DYLD_CHAINED_PTR_TYPE_UNKNOWN(-1);

        private final int val;
        private final String name;

        private DyldChainType(int v) {
            this.val = v;
            this.name = this.name().substring("DYLD_CHAINED_".length());
        }

        public static DyldChainType lookupChainPtr(int val) {
            switch (val) {
                case 1: {
                    return DYLD_CHAINED_PTR_ARM64E;
                }
                case 2: {
                    return DYLD_CHAINED_PTR_64;
                }
                case 3: {
                    return DYLD_CHAINED_PTR_32;
                }
                case 4: {
                    return DYLD_CHAINED_PTR_32_CACHE;
                }
                case 5: {
                    return DYLD_CHAINED_PTR_32_FIRMWARE;
                }
                case 6: {
                    return DYLD_CHAINED_PTR_64_OFFSET;
                }
                case 7: {
                    return DYLD_CHAINED_PTR_ARM64E_KERNEL;
                }
                case 8: {
                    return DYLD_CHAINED_PTR_64_KERNEL_CACHE;
                }
                case 9: {
                    return DYLD_CHAINED_PTR_ARM64E_USERLAND;
                }
                case 10: {
                    return DYLD_CHAINED_PTR_ARM64E_FIRMWARE;
                }
                case 11: {
                    return DYLD_CHAINED_PTR_X86_64_KERNEL_CACHE;
                }
                case 12: {
                    return DYLD_CHAINED_PTR_ARM64E_USERLAND24;
                }
            }
            return DYLD_CHAINED_PTR_TYPE_UNKNOWN;
        }

        public int getValue() {
            return this.val;
        }

        public String getName() {
            return this.name;
        }
    }
}

