/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.elf;

import ghidra.app.util.bin.BinaryReader;
import ghidra.app.util.bin.format.elf.ElfDynamic;
import ghidra.app.util.bin.format.elf.ElfDynamicType;
import ghidra.app.util.bin.format.elf.ElfFileSection;
import ghidra.app.util.bin.format.elf.ElfHeader;
import ghidra.program.model.data.ArrayDataType;
import ghidra.program.model.data.CategoryPath;
import ghidra.program.model.data.DWordDataType;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.EnumDataType;
import ghidra.program.model.data.QWordDataType;
import ghidra.program.model.data.StructureDataType;
import ghidra.util.DataConverter;
import ghidra.util.exception.DuplicateNameException;
import ghidra.util.exception.NotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class ElfDynamicTable
implements ElfFileSection {
    private List<ElfDynamic> dynamics = new ArrayList<ElfDynamic>();
    private ElfHeader header;
    private long fileOffset;
    private long addrOffset;

    public ElfDynamicTable(BinaryReader reader, ElfHeader header, long fileOffset, long addrOffset) throws IOException {
        ElfDynamic dyn;
        long oldptr = reader.getPointerIndex();
        this.header = header;
        this.fileOffset = fileOffset;
        this.addrOffset = addrOffset;
        reader.setPointerIndex(fileOffset);
        do {
            dyn = new ElfDynamic(reader, header);
            this.dynamics.add(dyn);
        } while (dyn.getTag() != ElfDynamicType.DT_NULL.value);
        reader.setPointerIndex(oldptr);
    }

    public void addDynamic(ElfDynamic dyn, int index) {
        this.dynamics.add(index, dyn);
    }

    public ElfDynamic[] getDynamics() {
        ElfDynamic[] array = new ElfDynamic[this.dynamics.size()];
        this.dynamics.toArray(array);
        return array;
    }

    public ElfDynamic[] getDynamics(long type) {
        ArrayList<ElfDynamic> list = new ArrayList<ElfDynamic>();
        for (int i = 0; i < this.dynamics.size(); ++i) {
            ElfDynamic dyn = this.dynamics.get(i);
            if ((long)dyn.getTag() != type) continue;
            list.add(dyn);
        }
        ElfDynamic[] arr = new ElfDynamic[list.size()];
        list.toArray(arr);
        return arr;
    }

    public ElfDynamic[] getDynamics(ElfDynamicType type) {
        return this.getDynamics(type.value);
    }

    public void setDynamicValue(long type, long value) {
        for (int i = 0; i < this.dynamics.size(); ++i) {
            ElfDynamic dyn = this.dynamics.get(i);
            if ((long)dyn.getTag() != type) continue;
            dyn.setValue(value);
        }
    }

    public void setDynamicValue(ElfDynamicType type, long value) {
        this.setDynamicValue(type.value, value);
    }

    public long getDynamicValue(long type) throws NotFoundException {
        for (int i = 0; i < this.dynamics.size(); ++i) {
            ElfDynamic dyn = this.dynamics.get(i);
            if ((long)dyn.getTag() != type) continue;
            return dyn.getValue();
        }
        throw new NotFoundException("Dynamic table entry not found: 0x" + Long.toHexString(type));
    }

    public boolean containsDynamicValue(ElfDynamicType type) {
        return this.containsDynamicValue(type.value);
    }

    public boolean containsDynamicValue(long type) {
        for (int i = 0; i < this.dynamics.size(); ++i) {
            ElfDynamic dyn = this.dynamics.get(i);
            if ((long)dyn.getTag() != type) continue;
            return true;
        }
        return false;
    }

    public long getDynamicValue(ElfDynamicType type) throws NotFoundException {
        return this.getDynamicValue(type.value);
    }

    @Override
    public long getFileOffset() {
        return this.fileOffset;
    }

    @Override
    public long getAddressOffset() {
        return this.addrOffset;
    }

    @Override
    public DataType toDataType() throws DuplicateNameException, IOException {
        Object name;
        String typeSuffix = this.header.getTypeSuffix();
        boolean is32bit = this.header.is32Bit();
        Object object = name = is32bit ? "Elf32_Dyn" : "Elf64_Dyn";
        if (typeSuffix != null) {
            name = (String)name + typeSuffix;
        }
        StructureDataType structure = new StructureDataType(new CategoryPath("/ELF"), (String)name, 0);
        structure.add(this.getTagDataType(), "d_tag", null);
        if (is32bit) {
            structure.add(DWORD, "d_val", null);
        } else {
            structure.add(QWORD, "d_val", null);
        }
        return new ArrayDataType((DataType)structure, this.dynamics.size(), structure.getLength());
    }

    private DataType getTagDataType() {
        boolean is32bit = this.header.is32Bit();
        int size = is32bit ? 4 : 8;
        HashMap<Integer, ElfDynamicType> dynamicTypeMap = this.header.getDynamicTypeMap();
        if (dynamicTypeMap == null) {
            return is32bit ? DWordDataType.dataType : QWordDataType.dataType;
        }
        Object name = is32bit ? "Elf32_DynTag" : "Elf64_DynTag";
        String typeSuffix = this.header.getTypeSuffix();
        if (typeSuffix != null) {
            name = (String)name + typeSuffix;
        }
        EnumDataType dynamicTagEnum = new EnumDataType(new CategoryPath("/ELF"), (String)name, size);
        for (ElfDynamicType type : dynamicTypeMap.values()) {
            dynamicTagEnum.add(type.name, (long)type.value);
        }
        return dynamicTagEnum;
    }

    @Override
    public long getLength() {
        return this.dynamics.size() * this.getEntrySize();
    }

    @Override
    public int getEntrySize() {
        return this.header.is32Bit() ? 8 : 16;
    }

    public byte[] toBytes(DataConverter dc) throws ArrayIndexOutOfBoundsException {
        byte[] data = new byte[(int)this.getLength()];
        int entrySize = this.getEntrySize();
        for (int i = 0; i < this.dynamics.size(); ++i) {
            ElfDynamic dyn = this.dynamics.get(i);
            dyn.write(data, i * entrySize, dc);
        }
        return data;
    }
}

