/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin;

import ghidra.app.util.bin.StructConverter;
import ghidra.program.model.data.ArrayDataType;
import ghidra.program.model.data.ByteDataType;
import ghidra.program.model.data.DWordDataType;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.DoubleDataType;
import ghidra.program.model.data.FloatDataType;
import ghidra.program.model.data.QWordDataType;
import ghidra.program.model.data.StructureDataType;
import ghidra.program.model.data.WordDataType;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.List;

public final class StructConverterUtil {
    public static DataType toDataType(Object object) {
        return StructConverterUtil.toDataType(object.getClass(), object);
    }

    public static DataType toDataType(Class<?> clazz) {
        return StructConverterUtil.toDataType(clazz, null);
    }

    private static DataType toDataType(Class<?> clazz, Object object) {
        String name = StructConverterUtil.parseName(clazz);
        StructureDataType struct = new StructureDataType(name, 0);
        List<Field> fields = StructConverterUtil.getFields(clazz);
        for (Field field : fields) {
            if (!StructConverterUtil.isValidField(field)) continue;
            DataType dt = StructConverterUtil.getDataType(field, object);
            struct.add(dt, field.getName(), null);
        }
        return struct;
    }

    private static List<Field> getFields(Class<?> clazz) {
        ArrayList<Field> fieldList = new ArrayList<Field>();
        if (clazz != null) {
            Field[] fields;
            fieldList.addAll(StructConverterUtil.getFields(clazz.getSuperclass()));
            for (Field field : fields = clazz.getDeclaredFields()) {
                fieldList.add(field);
            }
        }
        return fieldList;
    }

    private static boolean isValidField(Field field) {
        int modifiers = field.getModifiers();
        if (Modifier.isStatic(modifiers)) {
            return false;
        }
        if (!Modifier.isPrivate(modifiers) && !Modifier.isProtected(modifiers)) {
            return false;
        }
        return !field.getName().startsWith("_");
    }

    private static DataType getDataType(Field field, Object object) {
        Class<?> fieldClazz = field.getType();
        if (fieldClazz.isArray()) {
            return StructConverterUtil.getArrayDataType(field, object, fieldClazz);
        }
        if (fieldClazz.equals(Byte.TYPE) || fieldClazz.equals(Byte.class)) {
            return new ByteDataType();
        }
        if (fieldClazz.equals(Short.TYPE) || fieldClazz.equals(Short.class)) {
            return new WordDataType();
        }
        if (fieldClazz.equals(Integer.TYPE) || fieldClazz.equals(Integer.class)) {
            return new DWordDataType();
        }
        if (fieldClazz.equals(Long.TYPE) || fieldClazz.equals(Long.class)) {
            return new QWordDataType();
        }
        if (fieldClazz.equals(Float.TYPE) || fieldClazz.equals(Float.class)) {
            return new FloatDataType();
        }
        if (fieldClazz.equals(Double.TYPE) || fieldClazz.equals(Double.class)) {
            return new DoubleDataType();
        }
        if (StructConverter.class.isAssignableFrom(fieldClazz)) {
            return StructConverterUtil.toDataType(fieldClazz);
        }
        throw new RuntimeException("Unsupported datatype for automatic structure conversion - " + fieldClazz);
    }

    private static DataType getArrayDataType(Field field, Object object, Class<?> clazz) {
        Class<?> arrayClazz = clazz.getComponentType();
        if (arrayClazz.equals(Byte.TYPE)) {
            try {
                field.setAccessible(true);
                byte[] array = (byte[])field.get(object);
                int nElements = array.length;
                ByteDataType arrayDataType = new ByteDataType();
                return new ArrayDataType((DataType)arrayDataType, nElements, arrayDataType.getLength());
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        if (arrayClazz.equals(Integer.TYPE)) {
            try {
                field.setAccessible(true);
                int[] array = (int[])field.get(object);
                int nElements = array.length;
                DWordDataType arrayDataType = new DWordDataType();
                return new ArrayDataType((DataType)arrayDataType, nElements, arrayDataType.getLength());
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        throw new RuntimeException("Unsupported array datatype for automatic structure conversion - " + clazz);
    }

    public static String parseName(Class<?> clazz) {
        String fullyQualifiedName = clazz.getName();
        int pos = fullyQualifiedName.lastIndexOf(46);
        if (pos == -1) {
            return fullyQualifiedName;
        }
        return fullyQualifiedName.substring(pos + 1);
    }

    public static void main(String[] args) {
        Byte[] objectArray = new Byte[25];
        System.out.println("here " + objectArray.length);
    }
}

