/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.debug;

import ghidra.app.events.ProgramActivatedPluginEvent;
import ghidra.app.plugin.debug.DomainEventComponentProvider;
import ghidra.framework.model.DomainObject;
import ghidra.framework.model.DomainObjectChangeRecord;
import ghidra.framework.model.DomainObjectChangedEvent;
import ghidra.framework.model.DomainObjectListener;
import ghidra.framework.plugintool.Plugin;
import ghidra.framework.plugintool.PluginEvent;
import ghidra.framework.plugintool.PluginInfo;
import ghidra.framework.plugintool.PluginTool;
import ghidra.framework.plugintool.util.PluginStatus;
import ghidra.program.model.listing.Program;
import ghidra.program.util.ChangeManager;
import ghidra.program.util.CodeUnitPropertyChangeRecord;
import ghidra.program.util.ProgramChangeRecord;
import ghidra.util.datastruct.IntObjectHashtable;
import help.Help;
import help.HelpService;
import java.awt.Font;
import java.lang.reflect.Field;
import java.util.Date;

@PluginInfo(status=PluginStatus.RELEASED, packageName="Developer", category="Testing", shortDescription="Displays domain object events", description="This plugin provides a component to display domain object event as they are generated. The maximum number of messages shown is 200.  Useful for debugging.", eventsConsumed={ProgramActivatedPluginEvent.class})
public class DomainEventDisplayPlugin
extends Plugin
implements DomainObjectListener {
    private Program currentProgram;
    private DomainEventComponentProvider provider;
    private IntObjectHashtable<String> eventHt = new IntObjectHashtable();
    private String padString;

    public DomainEventDisplayPlugin(PluginTool tool) {
        super(tool);
        String dateStr = new Date() + ": ";
        this.padString = dateStr.replaceAll(".", " ");
        this.provider = new DomainEventComponentProvider(tool, this.getName());
        HelpService helpService = Help.getHelpService();
        helpService.excludeFromHelp((Object)this.provider);
    }

    public void processEvent(PluginEvent event) {
        if (event instanceof ProgramActivatedPluginEvent) {
            ProgramActivatedPluginEvent ev = (ProgramActivatedPluginEvent)event;
            Program newProg = ev.getActiveProgram();
            if (this.currentProgram != null) {
                this.currentProgram.removeListener((DomainObjectListener)this);
            }
            if (newProg != null) {
                newProg.addListener((DomainObjectListener)this);
            }
        }
    }

    public void dispose() {
        if (this.currentProgram != null) {
            this.currentProgram.removeListener((DomainObjectListener)this);
        }
    }

    public void domainObjectChanged(DomainObjectChangedEvent ev) {
        if (this.tool != null && this.provider.isVisible()) {
            this.update(ev);
        }
    }

    public Font getFont() {
        return this.provider.getFont();
    }

    public void setFont(Font font) {
        this.provider.setFont(font);
        this.tool.setConfigChanged(true);
    }

    private void update(DomainObjectChangedEvent event) {
        for (int i = 0; i < event.numRecords(); ++i) {
            Object s = null;
            String start = null;
            String end = null;
            String oldValue = null;
            String newValue = null;
            String affectedObj = null;
            String dateStr = new Date() + ": ";
            int eventType = 0;
            DomainObjectChangeRecord docr = event.getChangeRecord(i);
            eventType = docr.getEventType();
            if (docr instanceof ProgramChangeRecord) {
                record = (ProgramChangeRecord)docr;
                try {
                    start = "" + record.getStart();
                    end = "" + record.getEnd();
                    oldValue = "" + record.getOldValue();
                    newValue = "" + record.getNewValue();
                    affectedObj = "" + record.getObject();
                }
                catch (Exception e) {
                    s = dateStr + this.getEventName(eventType) + " (" + eventType + ") => *** Event data is not available ***\n";
                }
            } else if (docr instanceof CodeUnitPropertyChangeRecord) {
                record = (CodeUnitPropertyChangeRecord)docr;
                s = dateStr + this.getEventName(eventType) + " (" + eventType + ") ==> propertyName = " + record.getPropertyName() + ", code unit address = " + record.getAddress() + " old value = " + record.getOldValue() + ", new value = " + record.getNewValue() + "\n";
            } else {
                s = this.getEventName(eventType, DomainObject.class);
                if (s != null) {
                    s = dateStr + "DomainObject Event (" + eventType + "): " + (String)s + "\n";
                }
            }
            if (s == null) {
                s = dateStr + this.getEventName(eventType) + " (" + eventType + ") => start param = " + start + ", end param = " + end + "\n" + this.padString + "old value = " + oldValue + ", new value = " + newValue + ", affected object = " + affectedObj + ", (source=" + event.getSource() + ")\n";
            }
            this.provider.displayEvent((String)s);
        }
    }

    private String getEventName(int eventType) {
        String eventName = (String)this.eventHt.get(eventType);
        if (eventName != null) {
            return eventName;
        }
        eventName = this.getEventName(eventType, ChangeManager.class);
        if (eventName == null) {
            eventName = this.getEventName(eventType, DomainObject.class);
        }
        this.eventHt.put(eventType, (Object)eventName);
        return eventName;
    }

    private String getEventName(int eventType, Class<?> c) {
        Field[] fields;
        String eventName = null;
        for (Field field : fields = c.getFields()) {
            try {
                Object obj = field.get(null);
                int value = field.getInt(obj);
                if (eventType != value) continue;
                eventName = field.getName();
                break;
            }
            catch (IllegalArgumentException illegalArgumentException) {
            }
            catch (IllegalAccessException illegalAccessException) {
                // empty catch block
            }
        }
        return eventName;
    }
}

