/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.script;

import docking.widgets.tree.GTreeNode;
import ghidra.app.plugin.core.script.ScriptCategoryNode;
import java.util.List;
import javax.swing.Icon;
import resources.ResourceManager;

class RootNode
extends GTreeNode {
    private static Icon icon = ResourceManager.loadImage((String)"images/play.png");

    RootNode() {
    }

    public Icon getIcon(boolean expanded) {
        return icon;
    }

    public String getName() {
        return "Scripts";
    }

    public String getToolTip() {
        return null;
    }

    public boolean isLeaf() {
        return false;
    }

    void insert(String[] categoryPath) {
        RootNode parent = this;
        for (String categoryName : categoryPath) {
            GTreeNode child = this.getChildRegardlessOfFilter(parent, categoryName);
            if (child == null) {
                child = new ScriptCategoryNode(categoryName);
                this.insertSorted(parent, child);
            }
            parent = child;
        }
    }

    private GTreeNode getChildRegardlessOfFilter(GTreeNode parent, String name) {
        List children = parent.getChildren();
        for (GTreeNode child : children) {
            if (!child.getName().equals(name)) continue;
            return child;
        }
        return null;
    }

    private void insertSorted(GTreeNode parent, GTreeNode newChild) {
        List allChildren = parent.getChildren();
        for (GTreeNode child : allChildren) {
            String newNodeName;
            String nodeName = child.getName();
            if (nodeName.compareToIgnoreCase(newNodeName = newChild.getName()) <= 0) continue;
            parent.addNode(parent.getIndexOfChild(child), newChild);
            return;
        }
        parent.addNode(newChild);
    }
}

