/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.progmgr;

import docking.action.MenuData;
import ghidra.app.plugin.core.progmgr.AbstractProgramNameSwitchingAction;
import ghidra.app.plugin.core.progmgr.ProgramManagerPlugin;
import ghidra.program.model.listing.Program;
import ghidra.util.HTMLUtilities;

public class SaveAsProgramAction
extends AbstractProgramNameSwitchingAction {
    public SaveAsProgramAction(ProgramManagerPlugin plugin, String group, int subGroup) {
        super(plugin, "Save As File");
        MenuData menuData = new MenuData(new String[]{"&File", "S&ave As..."});
        menuData.setMenuGroup(group);
        menuData.setMenuSubGroup(Integer.toString(subGroup));
        this.setMenuBarData(menuData);
    }

    @Override
    protected void programChanged(Program program) {
        if (program == null) {
            this.getMenuBarData().setMenuItemName("S&ave As...");
        } else {
            String progName = program.getDomainFile().getName();
            this.getMenuBarData().setMenuItemNamePlain("Save '%s' As...'".formatted(progName));
            this.getMenuBarData().setMnemonic(Character.valueOf('a'));
            this.setDescription("<html>Save '%s' As".formatted(HTMLUtilities.escapeHTML((String)progName)));
        }
    }

    @Override
    public void actionPerformed(Program program) {
        this.plugin.saveProgramAs(program);
    }
}

