/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.functioncompare.actions;

import docking.ActionContext;
import docking.DialogComponentProvider;
import docking.action.DockingAction;
import docking.action.KeyBindingData;
import docking.action.MenuData;
import docking.action.ToolBarData;
import docking.widgets.dialogs.TableSelectionDialog;
import docking.widgets.table.RowObjectTableModel;
import ghidra.app.plugin.core.functioncompare.FunctionComparisonProvider;
import ghidra.app.plugin.core.functionwindow.FunctionTableModel;
import ghidra.app.services.FunctionComparisonService;
import ghidra.app.services.ProgramManager;
import ghidra.framework.plugintool.PluginTool;
import ghidra.program.model.listing.Function;
import ghidra.program.model.listing.Program;
import ghidra.util.HelpLocation;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import resources.MultiIcon;
import resources.ResourceManager;
import resources.icons.ScaledImageIcon;
import resources.icons.TranslateIcon;
import util.CollectionUtils;

public class OpenFunctionTableAction
extends DockingAction {
    private static final Icon ADD_ICON = ResourceManager.loadImage((String)"images/Plus.png");
    private static final Icon SCALED_ADD_ICON = new ScaledImageIcon(ADD_ICON, 10, 10);
    private static final ImageIcon COMPARISON_ICON = ResourceManager.loadImage((String)"images/page_white_c.png");
    private static final Icon TRANSLATED_ADD_ICON = new TranslateIcon(SCALED_ADD_ICON, 8, 1);
    private static final String ADD_COMPARISON_GROUP = "A9_AddToComparison";
    private static final Icon ADD_TO_COMPARISON_ICON = new MultiIcon((Icon)COMPARISON_ICON, new Icon[]{TRANSLATED_ADD_ICON});
    protected PluginTool tool;
    protected ProgramManager programManagerService;
    protected FunctionComparisonService comparisonService;

    public OpenFunctionTableAction(PluginTool tool, FunctionComparisonProvider provider) {
        super("Add Functions To Comparison", provider.getOwner());
        this.tool = tool;
        this.programManagerService = (ProgramManager)tool.getService(ProgramManager.class);
        this.comparisonService = (FunctionComparisonService)tool.getService(FunctionComparisonService.class);
        this.setDescription("Add functions to comparison");
        this.setPopupMenuData(new MenuData(new String[]{"Add functions"}, ADD_TO_COMPARISON_ICON, ADD_COMPARISON_GROUP));
        ToolBarData newToolBarData = new ToolBarData(ADD_TO_COMPARISON_ICON, ADD_COMPARISON_GROUP);
        this.setToolBarData(newToolBarData);
        HelpLocation helpLocation = new HelpLocation("FunctionComparison", "Add_To_Comparison");
        this.setHelpLocation(helpLocation);
        KeyBindingData data = new KeyBindingData('A', 64);
        this.setKeyBindingData(data);
    }

    public boolean isEnabledForContext(ActionContext context) {
        return context.getComponentProvider() instanceof FunctionComparisonProvider;
    }

    public void actionPerformed(ActionContext context) {
        FunctionComparisonProvider provider = (FunctionComparisonProvider)context.getComponentProvider();
        Program currentProgram = this.programManagerService.getCurrentProgram();
        FunctionTableModel model = new FunctionTableModel(this.tool, currentProgram);
        model.reload(this.programManagerService.getCurrentProgram());
        TableSelectionDialog diag = new TableSelectionDialog("Select Functions: " + currentProgram.getName(), (RowObjectTableModel)model, true);
        this.tool.showDialog((DialogComponentProvider)diag);
        List rows = diag.getSelectionItems();
        if (CollectionUtils.isBlank((Collection)rows)) {
            return;
        }
        Set functions = rows.stream().map(row -> row.getFunction()).collect(Collectors.toSet());
        this.comparisonService.compareFunctions(new HashSet<Function>(functions), provider);
    }
}

