/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.function.editor;

import docking.widgets.textfield.IntegerTextField;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.MouseEvent;
import java.math.BigInteger;
import java.util.EventObject;
import javax.swing.AbstractCellEditor;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.table.TableCellEditor;

class VarnodeSizeCellEditor
extends AbstractCellEditor
implements TableCellEditor {
    private IntegerTextField input;

    VarnodeSizeCellEditor() {
    }

    @Override
    public Object getCellEditorValue() {
        BigInteger value = this.input.getValue();
        if (value == null) {
            return null;
        }
        return value.intValue();
    }

    @Override
    public boolean isCellEditable(EventObject e) {
        if (e instanceof MouseEvent) {
            return ((MouseEvent)e).getClickCount() > 1;
        }
        return true;
    }

    @Override
    public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
        this.input = new IntegerTextField();
        this.input.setAllowNegativeValues(false);
        this.input.setDecimalMode();
        Integer size = (Integer)value;
        if (size != null) {
            this.input.setValue(size.longValue());
            FocusAdapter focusListener = new FocusAdapter(){

                @Override
                public void focusGained(FocusEvent e) {
                    VarnodeSizeCellEditor.this.input.selectAll();
                    VarnodeSizeCellEditor.this.input.getComponent().removeFocusListener(this);
                }
            };
            this.input.getComponent().addFocusListener(focusListener);
        }
        this.input.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                VarnodeSizeCellEditor.this.stopCellEditing();
            }
        });
        JComponent component = this.input.getComponent();
        component.setBorder(BorderFactory.createLineBorder(Color.GRAY, 1));
        return component;
    }
}

