/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.datamgr;

import docking.ActionContext;
import docking.action.DockingAction;
import docking.action.DockingActionIf;
import docking.action.MenuData;
import docking.action.ToolBarData;
import docking.menu.MultiActionDockingAction;
import ghidra.app.plugin.core.datamgr.DataTypesProvider;
import ghidra.app.util.datatype.DataTypeUrl;
import ghidra.base.actions.HorizontalRuleAction;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.DataTypeManager;
import ghidra.util.HelpLocation;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import resources.Icons;
import util.HistoryList;

class NextPreviousDataTypeAction
extends MultiActionDockingAction {
    private boolean isNext;
    private String owner;
    private DataTypesProvider provider;
    private HistoryList<DataTypeUrl> history;
    private static int navigationActionIdCount = 0;

    public NextPreviousDataTypeAction(DataTypesProvider provider, String owner, boolean isNext) {
        super(isNext ? "Next Data Type in History" : "Previous Data Type in History", owner);
        this.owner = owner;
        this.provider = provider;
        this.isNext = isNext;
        ImageIcon icon = null;
        icon = isNext ? Icons.RIGHT_ALTERNATE_ICON : Icons.LEFT_ALTERNATE_ICON;
        this.setToolBarData(new ToolBarData((Icon)icon, "1_Navigation"));
        this.setDescription(isNext ? "Go to next data type in history" : "Go to previous data type in history");
        this.setHelpLocation(new HelpLocation("DataTypeManagerPlugin", "Navigation_Actions"));
        this.setEnabled(false);
        this.history = provider.getNavigationHistory();
    }

    public void actionPerformed(ActionContext context) {
        List<DockingActionIf> actions = this.getActionList(context);
        DockingActionIf action = actions.get(0);
        action.actionPerformed(context);
        this.provider.contextChanged();
    }

    public boolean isEnabledForContext(ActionContext context) {
        return !this.getActionList(context).isEmpty();
    }

    public List<DockingActionIf> getActionList(ActionContext context) {
        return this.createNavigationActions();
    }

    private List<DockingActionIf> createNavigationActions() {
        DataTypeManager lastDtm = null;
        ArrayList<DockingActionIf> results = new ArrayList<DockingActionIf>();
        List types = this.isNext ? this.history.getNextHistoryItems() : this.history.getPreviousHistoryItems();
        for (DataTypeUrl url : types) {
            DataType dt = url.getDataType(this.provider.getPlugin());
            if (dt == null) continue;
            DataTypeManager dtm = dt.getDataTypeManager();
            if (dtm != lastDtm && !results.isEmpty()) {
                results.add(this.createHorizontalRule(lastDtm, dtm));
            }
            results.add((DockingActionIf)new NavigationAction(url, dt));
            lastDtm = dtm;
        }
        return results;
    }

    private DockingActionIf createHorizontalRule(DataTypeManager lastDtm, DataTypeManager nextDtm) {
        String topName = lastDtm.getName();
        String bottomName = nextDtm.getName();
        return new HorizontalRuleAction(this.getName(), topName, bottomName);
    }

    private class NavigationAction
    extends DockingAction {
        private DataTypeUrl url;

        private NavigationAction(DataTypeUrl url, DataType dt) {
            super("DataTypeNavigationAction_" + ++navigationActionIdCount, NextPreviousDataTypeAction.this.owner);
            this.url = url;
            this.setMenuBarData(new MenuData(new String[]{dt.getDisplayName()}));
            this.setEnabled(true);
            this.setHelpLocation(new HelpLocation("DataTypeManagerPlugin", "Navigation_Actions"));
        }

        public void actionPerformed(ActionContext context) {
            if (NextPreviousDataTypeAction.this.isNext) {
                NextPreviousDataTypeAction.this.history.goForwardTo((Object)this.url);
            } else {
                NextPreviousDataTypeAction.this.history.goBackTo((Object)this.url);
            }
            NextPreviousDataTypeAction.this.provider.contextChanged();
        }
    }
}

