/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.compositeeditor;

import docking.DialogComponentProvider;
import docking.widgets.OptionDialog;
import docking.widgets.dialogs.InputDialog;
import docking.widgets.dialogs.InputDialogListener;
import docking.widgets.fieldpanel.support.FieldRange;
import docking.widgets.fieldpanel.support.FieldSelection;
import docking.widgets.table.GTableHeaderRenderer;
import ghidra.app.plugin.core.compositeeditor.CompEditorModel;
import ghidra.app.plugin.core.compositeeditor.DataTypeHelper;
import ghidra.app.plugin.core.compositeeditor.StructureEditorProvider;
import ghidra.program.model.data.Array;
import ghidra.program.model.data.BitFieldDataType;
import ghidra.program.model.data.CategoryPath;
import ghidra.program.model.data.Composite;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.DataTypeComponent;
import ghidra.program.model.data.DataTypeConflictHandler;
import ghidra.program.model.data.DataTypeInstance;
import ghidra.program.model.data.DataTypeManager;
import ghidra.program.model.data.InvalidDataTypeException;
import ghidra.program.model.data.PackingType;
import ghidra.program.model.data.Pointer;
import ghidra.program.model.data.Structure;
import ghidra.program.model.data.StructureDataType;
import ghidra.program.model.lang.InsufficientBytesException;
import ghidra.util.Msg;
import ghidra.util.exception.CancelledException;
import ghidra.util.exception.DuplicateNameException;
import ghidra.util.exception.UsrException;
import ghidra.util.task.TaskLauncher;
import ghidra.util.task.TaskMonitor;
import java.awt.Component;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.NoSuchElementException;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;

class StructureEditorModel
extends CompEditorModel {
    private static final long serialVersionUID = 1L;
    private static final int OFFSET = 0;
    private static final int LENGTH = 1;
    private static final int MNEMONIC = 2;
    private static final int DATATYPE = 3;
    private static final int FIELDNAME = 4;
    private static final int COMMENT = 5;
    private static final int ORDINAL = 6;
    private List<TableColumn> hiddenColumns;

    StructureEditorModel(StructureEditorProvider provider, boolean showHexNumbers) {
        super(provider);
        this.headers = new String[]{"Offset", "Length", "Mnemonic", "DataType", "Name", "Comment"};
        this.columnWidths = new int[]{75, 75, 100, 100, 100, 150};
        this.columnOffsets = new int[this.headers.length];
        this.adjustOffsets();
        this.showHexNumbers = showHexNumbers;
        ArrayList<TableColumn> additionalColumns = new ArrayList<TableColumn>();
        TableColumn ordinalColumn = new TableColumn(6, 75);
        ordinalColumn.setHeaderRenderer((TableCellRenderer)new GTableHeaderRenderer());
        ordinalColumn.setHeaderValue("Ordinal");
        additionalColumns.add(ordinalColumn);
        this.hiddenColumns = Collections.unmodifiableList(additionalColumns);
    }

    @Override
    protected List<TableColumn> getHiddenColumns() {
        return this.hiddenColumns;
    }

    @Override
    public int getOffsetColumn() {
        return 0;
    }

    @Override
    public int getLengthColumn() {
        return 1;
    }

    @Override
    public int getMnemonicColumn() {
        return 2;
    }

    @Override
    public int getDataTypeColumn() {
        return 3;
    }

    @Override
    public int getNameColumn() {
        return 4;
    }

    @Override
    public int getCommentColumn() {
        return 5;
    }

    @Override
    public void load(Composite dataType) {
        super.load(dataType);
    }

    @Override
    public int getRowCount() {
        int componentCount = this.getNumComponents();
        int rowCount = componentCount + 1;
        return rowCount;
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        if (this.viewComposite == null || rowIndex < 0 || columnIndex < 0) {
            return "";
        }
        DataTypeComponent dtc = this.getComponent(rowIndex);
        if (dtc == null) {
            if (columnIndex == this.getDataTypeColumn()) {
                return null;
            }
            return "";
        }
        Object value = null;
        if (columnIndex == this.getOffsetColumn()) {
            int offset = dtc.getOffset();
            value = this.showHexNumbers ? StructureEditorModel.getHexString(offset, true) : Integer.toString(offset);
        } else if (columnIndex == this.getLengthColumn()) {
            int compLen = dtc.getLength();
            value = this.showHexNumbers ? StructureEditorModel.getHexString(compLen, true) : Integer.toString(compLen);
        } else if (columnIndex == this.getMnemonicColumn()) {
            int dtLen;
            DataType dt = dtc.getDataType();
            value = dt.getMnemonic(dtc.getDefaultSettings());
            int compLen = dtc.getLength();
            int n = dtLen = dt.isZeroLength() ? 0 : dt.getLength();
            if (dtLen > compLen) {
                value = "TooBig: " + (String)value + " needs " + dtLen + " has " + compLen;
            }
        } else {
            if (columnIndex == this.getDataTypeColumn()) {
                DataType dt;
                int dtLen = (dt = dtc.getDataType()).getLength();
                return DataTypeInstance.getDataTypeInstance((DataType)dt, (int)(dtLen > 0 ? dtLen : dtc.getLength()));
            }
            if (columnIndex == this.getNameColumn()) {
                value = dtc.getFieldName();
            } else if (columnIndex == this.getCommentColumn()) {
                value = dtc.getComment();
            } else if (columnIndex == 6) {
                int ordinal = dtc.getOrdinal();
                value = this.showHexNumbers ? StructureEditorModel.getHexString(ordinal, true) : Integer.toString(ordinal);
            }
        }
        return value == null ? "" : value;
    }

    @Override
    public DataTypeComponent getComponent(int rowIndex) {
        int numComponents = this.getNumComponents();
        if (rowIndex < 0 || rowIndex == numComponents) {
            return null;
        }
        Structure viewStruct = (Structure)this.viewComposite;
        if (rowIndex > numComponents) {
            return null;
        }
        if (this.isShowingUndefinedBytes()) {
            return this.viewComposite.getComponent(rowIndex);
        }
        DataTypeComponent[] definedComponents = viewStruct.getDefinedComponents();
        return definedComponents[rowIndex];
    }

    @Override
    public int getNumComponents() {
        return this.viewComposite == null ? 0 : this.viewComposite.getNumComponents();
    }

    @Override
    protected boolean isSizeEditable() {
        return !this.isPackingEnabled();
    }

    void setStructureSize(int size) {
        int currentLength;
        if (this.viewComposite == null || this.viewComposite.isPackingEnabled()) {
            return;
        }
        int n = currentLength = this.viewComposite.isZeroLength() ? 0 : this.viewComposite.getLength();
        if (currentLength == size) {
            return;
        }
        Structure structure = (Structure)this.viewComposite;
        if (currentLength > size) {
            int numComponents = structure.getNumComponents();
            DataTypeComponent dtc = structure.getComponentContaining(size);
            int ordinal = dtc.getOrdinal();
            while (dtc.getOffset() == size && dtc.getLength() == 0 && ordinal + 1 < numComponents) {
                dtc = structure.getComponent(++ordinal);
            }
            for (int index = numComponents - 1; index >= ordinal; --index) {
                structure.delete(index);
                int bitFieldResidualBytes = structure.getNumComponents() - index;
                for (int i = 0; i < bitFieldResidualBytes; ++i) {
                    structure.delete(index);
                }
            }
            int n2 = currentLength = this.viewComposite.isZeroLength() ? 0 : this.viewComposite.getLength();
        }
        if (currentLength < size) {
            structure.growStructure(size - currentLength);
        }
        this.updateAndCheckChangeState();
        this.fireTableDataChanged();
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        if (this.getNumSelectedRows() != 1) {
            return false;
        }
        if (rowIndex < 0 || rowIndex >= this.getRowCount()) {
            return false;
        }
        switch (columnIndex) {
            case 3: {
                return true;
            }
            case 4: 
            case 5: {
                DataTypeComponent dtc = this.getComponent(rowIndex);
                if (dtc == null) {
                    return false;
                }
                DataType dt = dtc.getDataType();
                return dt != DataType.DEFAULT;
            }
        }
        return false;
    }

    @Override
    public void clearSelectedComponents() throws UsrException {
        if (!this.isClearAllowed()) {
            throw new UsrException("Clearing is not allowed.");
        }
        if (this.getNumSelectedComponentRows() <= 0) {
            throw new UsrException("Only selections can be cleared.");
        }
        this.clearComponents(this.getSelectedComponentRows());
    }

    @Override
    public void clearComponent(int ordinal) {
        ((Structure)this.viewComposite).clearComponent(ordinal);
    }

    @Override
    public void clearComponents(int[] indices) {
        if (this.isEditingField()) {
            this.endFieldEditing();
        }
        Arrays.sort(indices);
        for (int i = indices.length - 1; i >= 0; --i) {
            DataTypeComponent comp = this.getComponent(indices[i]);
            if (comp == null) continue;
            boolean isSelected = this.selection.containsEntirely(BigInteger.valueOf(indices[i]));
            int numBytes = comp.getLength();
            ((Structure)this.viewComposite).clearComponent(indices[i]);
            this.adjustSelection(indices[i] + 1, numBytes - 1);
            if (isSelected && numBytes > 1) {
                this.selection.addRange(indices[i] + 1, indices[i] + numBytes);
            }
            if (indices[i] <= 0) continue;
            this.consumeByComponent(indices[i] - 1);
        }
        this.componentEdited();
    }

    @Override
    protected void deleteComponents(int[] rows) {
        if (this.isShowingUndefinedBytes()) {
            super.deleteComponents(rows);
            return;
        }
        int[] ordinals = this.convertRowsToOrdinals(rows);
        for (int i = ordinals.length - 1; i >= 0; --i) {
            this.viewComposite.delete(ordinals[i]);
        }
        this.notifyCompositeChanged();
    }

    private int[] convertRowsToOrdinals(int[] rows) {
        int[] ordinals = new int[rows.length];
        DataTypeComponent[] definedComponents = ((Structure)this.viewComposite).getDefinedComponents();
        for (int i = rows.length - 1; i >= 0; --i) {
            ordinals[i] = definedComponents[rows[i]].getOrdinal();
        }
        return ordinals;
    }

    @Override
    protected int convertRowToOrdinal(int rowIndex) {
        int numRowComponents = this.getNumComponents();
        if (rowIndex < 0 || rowIndex > numRowComponents) {
            return -1;
        }
        if (rowIndex == numRowComponents) {
            return this.viewComposite.getNumComponents();
        }
        if (this.isShowingUndefinedBytes()) {
            return rowIndex;
        }
        DataTypeComponent[] definedComponents = ((Structure)this.viewComposite).getDefinedComponents();
        return definedComponents[rowIndex].getOrdinal();
    }

    @Override
    public void duplicateMultiple(int index, int multiple, TaskMonitor monitor) throws UsrException {
        DataTypeComponent originalComp;
        if (this.isEditingField()) {
            this.endFieldEditing();
        }
        if ((originalComp = this.getComponent(index)) == null) {
            throw new IllegalArgumentException("Invalid component index specified");
        }
        DataType dt = originalComp.getDataType();
        int dtLen = dt.getLength();
        this.checkIsAllowableDataType(dt);
        int startIndex = index + 1;
        if (this.isShowingUndefinedBytes() && dt != DataType.DEFAULT) {
            int endIndex = startIndex + dtLen * multiple - 1;
            if (startIndex < this.getNumComponents()) {
                this.deleteComponentRange(startIndex, endIndex, monitor);
            }
        }
        this.insertComponentMultiple(startIndex, dt, originalComp.getLength(), multiple, monitor);
        this.setSelection(new int[]{index + multiple});
        this.componentEdited();
        this.lastNumDuplicates = multiple;
    }

    private boolean shiftComponentsUp(int startIndex, int endIndex) {
        int numComps = this.getNumComponents();
        if (startIndex > endIndex || startIndex <= 0 || startIndex >= numComps || endIndex <= 0 || endIndex >= numComps) {
            return false;
        }
        int len = this.getLength();
        DataTypeComponent comp = this.deleteComponentAndResidual(startIndex - 1);
        try {
            if (!this.isPackingEnabled() && comp.isBitFieldComponent()) {
                int lenChange = len - this.getLength();
                this.insert(endIndex, DataType.DEFAULT, 1, lenChange, TaskMonitor.DUMMY);
            }
            this.insert(endIndex, comp.getDataType(), comp.getLength(), comp.getFieldName(), comp.getComment());
        }
        catch (CancelledException lenChange) {
        }
        catch (InvalidDataTypeException e) {
            return false;
        }
        return true;
    }

    private boolean shiftComponentsDown(int startIndex, int endIndex) {
        int numComponents = this.getNumComponents();
        if (startIndex > endIndex || startIndex < 0 || startIndex >= numComponents - 1 || endIndex < 0 || endIndex >= numComponents - 1) {
            return false;
        }
        int len = this.getLength();
        DataTypeComponent comp = this.deleteComponentAndResidual(endIndex + 1);
        try {
            if (!this.isPackingEnabled() && comp.isBitFieldComponent()) {
                int lenChange = len - this.getLength();
                this.insert(startIndex, DataType.DEFAULT, 1, lenChange, TaskMonitor.DUMMY);
            }
            this.insert(startIndex, comp.getDataType(), comp.getLength(), comp.getFieldName(), comp.getComment());
        }
        catch (CancelledException lenChange) {
        }
        catch (InvalidDataTypeException e) {
            return false;
        }
        return true;
    }

    private DataTypeComponent deleteComponentAndResidual(int index) {
        DataTypeComponent comp = this.getComponent(index);
        this.deleteComponent(index);
        if (this.isPackingEnabled() || !comp.isBitFieldComponent() || index >= this.getNumComponents()) {
            return comp;
        }
        int startOffset = comp.getOffset();
        for (int i = index + comp.getLength() - 1; i >= index; --i) {
            DataTypeComponent dtc = this.getComponent(i);
            if (dtc == null || dtc.getDataType() != DataType.DEFAULT || dtc.getOffset() < startOffset) continue;
            this.deleteComponent(i);
        }
        return comp;
    }

    @Override
    public boolean moveUp() throws NoSuchElementException {
        if (this.selection.getNumRanges() != 1) {
            return false;
        }
        if (this.isEditingField()) {
            this.endFieldEditing();
        }
        FieldRange range = this.selection.getFieldRange(0);
        int startRowIndex = range.getStart().getIndex().intValue();
        int endRowIndex = range.getEnd().getIndex().intValue() - 1;
        int numSelected = endRowIndex - startRowIndex + 1;
        boolean moved = false;
        int newIndex = startRowIndex - 1;
        moved = this.shiftComponentsUp(startRowIndex, endRowIndex);
        if (moved) {
            this.componentEdited();
            FieldSelection tmpFieldSelection = new FieldSelection();
            tmpFieldSelection.addRange(newIndex, newIndex + numSelected);
            this.setSelection(tmpFieldSelection);
        }
        return moved;
    }

    @Override
    public boolean moveDown() throws NoSuchElementException {
        if (this.selection.getNumRanges() != 1) {
            return false;
        }
        if (this.isEditingField()) {
            this.endFieldEditing();
        }
        FieldRange range = this.selection.getFieldRange(0);
        int startIndex = range.getStart().getIndex().intValue();
        int endIndex = range.getEnd().getIndex().intValue() - 1;
        int numSelected = endIndex - startIndex + 1;
        boolean moved = false;
        int newIndex = startIndex + 1;
        moved = this.shiftComponentsDown(startIndex, endIndex);
        if (moved) {
            this.componentEdited();
            FieldSelection tmpFieldSelection = new FieldSelection();
            tmpFieldSelection.addRange(newIndex, newIndex + numSelected);
            this.setSelection(tmpFieldSelection);
        }
        return moved;
    }

    @Override
    public boolean isBitFieldAllowed() {
        return this.isSingleRowSelection();
    }

    @Override
    public boolean isArrayAllowed() {
        boolean allowed = false;
        if (!this.isContiguousSelection()) {
            return false;
        }
        FieldRange range = this.selection.getFieldRange(0);
        DataTypeComponent comp = this.getComponent(range.getStart().getIndex().intValue());
        if (comp == null || comp.isBitFieldComponent()) {
            return false;
        }
        DataType dt = comp.getDataType();
        int dtLen = dt.getLength();
        if (dtLen < 0 || dtLen == comp.getLength()) {
            allowed = true;
        }
        return allowed;
    }

    @Override
    public boolean isClearAllowed() {
        return this.hasComponentSelection() && this.isShowingUndefinedBytes();
    }

    @Override
    public boolean isDeleteAllowed() {
        if (!this.hasSelection()) {
            return false;
        }
        int rowIndex = this.selection.getFieldRange(0).getStart().getIndex().intValue();
        return this.getComponent(rowIndex) != null;
    }

    @Override
    public boolean isDuplicateAllowed() {
        int undefSize;
        if (!this.isSingleRowSelection() || this.getNumSelectedComponentRows() != 1) {
            return false;
        }
        int rowIndex = this.getRow();
        DataTypeComponent comp = this.getComponent(rowIndex);
        if (comp == null) {
            return false;
        }
        DataType dt = comp.getDataType();
        if (this.viewComposite.isPackingEnabled()) {
            return true;
        }
        if (dt.equals(DataType.DEFAULT)) {
            return true;
        }
        if (comp.isBitFieldComponent()) {
            return false;
        }
        if (this.isAtEnd(rowIndex) || this.onlyUndefinedsUntilEnd(rowIndex + 1)) {
            return true;
        }
        int dtSize = dt.getLength();
        if (dtSize <= 0) {
            dtSize = comp.getLength();
        }
        return dtSize <= (undefSize = this.getNumUndefinedBytesAt(rowIndex + 1));
    }

    @Override
    public boolean isUnpackageAllowed() {
        boolean unpackageAllowed = false;
        if (this.getNumSelectedComponentRows() != 1) {
            return false;
        }
        int currentIndex = this.selection.getFieldRange(0).getStart().getIndex().intValue();
        FieldRange range = this.getSelectedRangeContaining(currentIndex);
        boolean notInMultiLineSelection = true;
        if (range != null && range.getEnd().getIndex().intValue() - range.getStart().getIndex().intValue() > 1) {
            notInMultiLineSelection = false;
        }
        if (notInMultiLineSelection && currentIndex < this.getNumComponents()) {
            DataTypeComponent comp = this.getComponent(currentIndex);
            DataType dt = comp.getDataType();
            if (comp.getLength() == dt.getLength() && (dt instanceof Array || dt instanceof Structure)) {
                unpackageAllowed = true;
            }
        }
        return unpackageAllowed;
    }

    @Override
    public boolean isAddAllowed(int currentIndex, DataType datatype) {
        boolean isOneComponent;
        DataType compDt;
        DataTypeComponent comp;
        if (currentIndex < 0 || currentIndex > this.getRowCount()) {
            return false;
        }
        if (datatype instanceof Array && (comp = this.getComponent(currentIndex)) != null && ((compDt = comp.getDataType()) instanceof Array || compDt instanceof Pointer)) {
            return false;
        }
        FieldRange currentRange = this.getSelectedRangeContaining(currentIndex);
        boolean bl = isOneComponent = currentRange == null || currentRange.getStart().getIndex().intValue() + 1 == currentRange.getEnd().getIndex().intValue();
        if (isOneComponent) {
            if (!this.isShowingUndefinedBytes() || this.isAtEnd(currentIndex) || this.onlyUndefinedsUntilEnd(currentIndex + 1)) {
                return true;
            }
            DataTypeComponent comp2 = this.getComponent(currentIndex);
            if (comp2 != null) {
                DataType compDt2 = comp2.getDataType();
                int numCompBytes = comp2.getLength();
                int numFollowing = this.getNumUndefinedBytesAt(currentIndex + 1);
                int numAvailable = numCompBytes + numFollowing;
                if (compDt2 instanceof Pointer || DataTypeHelper.getBaseType(compDt2) instanceof Pointer) {
                    return !datatype.equals(DataType.DEFAULT);
                }
                return datatype.getLength() <= numAvailable;
            }
            return true;
        }
        int numComps = this.getNumComponents();
        int firstIndex = currentRange.getStart().getIndex().intValue();
        int lastIndex = currentRange.getEnd().getIndex().intValue() - 1;
        if (firstIndex >= numComps || lastIndex >= numComps) {
            return false;
        }
        DataTypeComponent startComp = this.getComponent(firstIndex);
        DataTypeComponent endComp = this.getComponent(lastIndex);
        int numAvailable = endComp.getOffset() + endComp.getLength() - startComp.getOffset();
        return datatype.getLength() <= numAvailable;
    }

    @Override
    public boolean isInsertAllowed(int currentIndex, DataType datatype) {
        return currentIndex <= this.getNumComponents();
    }

    @Override
    public boolean isReplaceAllowed(int rowIndex, DataType dataType) {
        DataTypeComponent dtc = this.getComponent(rowIndex);
        if (dtc == null) {
            return false;
        }
        try {
            this.checkIsAllowableDataType(dataType);
        }
        catch (InvalidDataTypeException e) {
            return false;
        }
        if (this.isShowingUndefinedBytes()) {
            if (this.isAtEnd(rowIndex)) {
                return true;
            }
            int maxBytes = dtc.getLength() + this.getNumUndefinedBytesAt(rowIndex + 1);
            if (dataType.getLength() > maxBytes) {
                return false;
            }
        }
        return true;
    }

    @Override
    public int getMaxAddLength(int rowIndex) {
        boolean isOneComponent;
        int maxLength = Integer.MAX_VALUE;
        if (rowIndex >= this.getNumComponents() - 1) {
            return maxLength;
        }
        DataTypeComponent comp = this.getComponent(rowIndex);
        FieldRange currentRange = this.getSelectedRangeContaining(rowIndex);
        boolean bl = isOneComponent = currentRange == null || currentRange.getStart().getIndex().intValue() + 1 == currentRange.getEnd().getIndex().intValue();
        if (isOneComponent) {
            if (!this.isShowingUndefinedBytes()) {
                return maxLength;
            }
            int numAvailable = comp.getLength() + this.getNumUndefinedBytesAt(rowIndex + 1);
            return maxLength == -1 ? numAvailable : Math.min(maxLength, numAvailable);
        }
        DataTypeComponent startComp = this.getComponent(currentRange.getStart().getIndex().intValue());
        DataTypeComponent endComp = this.getComponent(currentRange.getEnd().getIndex().intValue() - 1);
        int numAvailable = endComp.getOffset() + endComp.getLength() - startComp.getOffset();
        return maxLength == -1 ? numAvailable : Math.min(maxLength, numAvailable);
    }

    @Override
    public int getMaxReplaceLength(int currentIndex) {
        if (!this.isShowingUndefinedBytes()) {
            return Integer.MAX_VALUE;
        }
        DataTypeComponent comp = this.getComponent(currentIndex);
        int numComponents = this.getNumComponents();
        if (currentIndex >= numComponents - 1 && currentIndex <= numComponents) {
            return Integer.MAX_VALUE;
        }
        if (comp == null) {
            return 0;
        }
        FieldRange range = this.getSelectedRangeContaining(currentIndex);
        if (range == null || range.getStart().getIndex().intValue() == range.getEnd().getIndex().intValue() - 1) {
            return comp.getLength() + this.getNumUndefinedBytesAt(currentIndex + 1);
        }
        return this.getNumBytesInRange(range);
    }

    @Override
    protected int getNumBytesInRange(FieldRange range) {
        int numBytesInRange = 0;
        if (range != null) {
            int startIndex = range.getStart().getIndex().intValue();
            int endIndex = range.getEnd().getIndex().intValue() - 1;
            DataTypeComponent startComp = this.getComponent(startIndex);
            DataTypeComponent endComp = this.getComponent(endIndex);
            numBytesInRange = endComp.getOffset() + endComp.getLength();
            numBytesInRange -= startComp.getOffset();
        }
        return numBytesInRange;
    }

    @Override
    protected DataTypeComponent insert(int rowIndex, DataType dataType, int length, String name, String comment) throws InvalidDataTypeException {
        this.checkIsAllowableDataType(dataType);
        try {
            DataTypeComponent dtc;
            if (this.isPackingEnabled() || !(dataType instanceof BitFieldDataType)) {
                dtc = ((Structure)this.viewComposite).insert(rowIndex, dataType, length, name, comment);
            } else {
                BitFieldDataType bitfield = (BitFieldDataType)dataType;
                dtc = ((Structure)this.viewComposite).insertBitField(rowIndex, length, bitfield.getBitOffset(), bitfield.getBaseDataType(), bitfield.getDeclaredBitSize(), name, comment);
            }
            if (rowIndex <= this.row) {
                ++this.row;
            }
            this.adjustSelection(rowIndex, 1);
            this.consumeByComponent(rowIndex - 1);
            return dtc;
        }
        catch (IllegalArgumentException exc) {
            throw new InvalidDataTypeException(exc.getMessage());
        }
    }

    @Override
    protected void insert(int rowIndex, DataType dataType, int length, int numCopies, TaskMonitor monitor) throws InvalidDataTypeException, CancelledException {
        this.checkIsAllowableDataType(dataType);
        int componentOrdinal = this.convertRowToOrdinal(rowIndex);
        monitor.initialize((long)numCopies);
        try {
            for (int i = 0; i < numCopies; ++i) {
                monitor.checkCanceled();
                monitor.setMessage("Inserting " + (i + 1) + " of " + numCopies);
                this.viewComposite.insert(componentOrdinal, dataType, length);
                monitor.incrementProgress(1L);
            }
            if (rowIndex <= this.row) {
                this.row += numCopies;
            }
            this.adjustSelection(componentOrdinal, numCopies);
            this.consumeByComponent(componentOrdinal - numCopies);
        }
        catch (IllegalArgumentException exc) {
            throw new InvalidDataTypeException(exc.getMessage());
        }
    }

    @Override
    protected DataTypeComponent replace(int rowIndex, DataType dataType, int length, String name, String comment) throws InvalidDataTypeException {
        this.checkIsAllowableDataType(dataType);
        try {
            DataTypeComponent dtc = null;
            boolean isSelected = this.selection.containsEntirely(BigInteger.valueOf(rowIndex));
            int diffLen = 0;
            int componentOrdinal = this.convertRowToOrdinal(rowIndex);
            if (this.isShowingUndefinedBytes() && !this.isAtEnd(rowIndex)) {
                int origLen = this.getComponent(rowIndex).getLength();
                dtc = ((Structure)this.viewComposite).replace(componentOrdinal, dataType, length, name, comment);
                diffLen = origLen - dtc.getLength();
                int nextRowIndex = rowIndex + 1;
                if (diffLen < 0) {
                    this.selection.removeRange(nextRowIndex, nextRowIndex - diffLen);
                    this.adjustSelection(nextRowIndex, diffLen);
                } else if (diffLen > 0) {
                    this.adjustSelection(nextRowIndex, diffLen);
                    if (isSelected) {
                        this.selection.addRange(nextRowIndex, nextRowIndex + diffLen);
                    }
                }
                if (rowIndex < this.row) {
                    this.row += diffLen;
                }
            } else {
                ((Structure)this.viewComposite).delete(componentOrdinal);
                dtc = ((Structure)this.viewComposite).insert(componentOrdinal, dataType, length, name, comment);
            }
            return dtc;
        }
        catch (IllegalArgumentException exc) {
            throw new InvalidDataTypeException(exc.getMessage());
        }
    }

    @Override
    protected boolean replaceRange(int startRowIndex, int endRowIndex, DataType datatype, int length, TaskMonitor monitor) throws InvalidDataTypeException, InsufficientBytesException, CancelledException {
        if (startRowIndex > endRowIndex) {
            return false;
        }
        DataTypeComponent startComp = this.getComponent(startRowIndex);
        DataTypeComponent endComp = this.getComponent(endRowIndex);
        int numBytesInRange = endComp.getOffset() + endComp.getLength();
        if (length > (numBytesInRange -= startComp.getOffset())) {
            throw new InsufficientBytesException("\"" + datatype.getDisplayName() + "\" does not fit in selection.");
        }
        int numComps = numBytesInRange / length;
        String fieldName = startComp.getFieldName();
        String comment = startComp.getComment();
        FieldSelection overlap = new FieldSelection();
        overlap.addRange(startRowIndex, endRowIndex + 1);
        overlap.intersect(this.selection);
        boolean replacedSelected = overlap.getNumRanges() > 0;
        this.deleteComponentRange(startRowIndex, endRowIndex, monitor);
        int beginUndefs = startRowIndex + numComps;
        this.insertMultiple(startRowIndex, datatype, length, numComps, monitor);
        int indexAfterMultiple = startRowIndex + numComps;
        if (replacedSelected) {
            this.selection.addRange(startRowIndex, indexAfterMultiple);
            this.fixSelection();
        }
        DataTypeComponent comp = this.getComponent(startRowIndex);
        try {
            comp.setFieldName(fieldName);
        }
        catch (DuplicateNameException exc) {
            Msg.showError((Object)this, null, null, null);
        }
        comp.setComment(comment);
        int remainingLength = numBytesInRange - numComps * length;
        if (remainingLength > 0 && this.isShowingUndefinedBytes()) {
            try {
                this.insertComponentMultiple(beginUndefs, DataType.DEFAULT, DataType.DEFAULT.getLength(), remainingLength, monitor);
                if (replacedSelected) {
                    this.selection.addRange(indexAfterMultiple, indexAfterMultiple + remainingLength);
                }
            }
            catch (InvalidDataTypeException idte) {
                Msg.showError((Object)this, null, (String)"Structure Editor Error", (Object)idte.getMessage());
            }
        } else if (remainingLength < 0) {
            return false;
        }
        return true;
    }

    @Override
    protected void replaceOriginalComponents() {
        Structure dt = (Structure)this.getOriginalComposite();
        if (dt == null) {
            throw new RuntimeException("ERROR: Couldn't replace structure components in " + this.getOriginalDataTypeName() + ".");
        }
        dt.replaceWith((DataType)this.viewComposite);
    }

    @Override
    void removeDtFromComponents(Composite comp) {
        DataType newDt = this.viewDTM.getDataType(comp.getDataTypePath());
        if (newDt == null) {
            return;
        }
        int num = this.getNumComponents();
        for (int i = num - 1; i >= 0; --i) {
            Composite dtcComp;
            DataTypeComponent dtc = this.getComponent(i);
            DataType dt = dtc.getDataType();
            if (!(dt instanceof Composite) || !(dtcComp = (Composite)dt).isPartOf(newDt)) continue;
            this.clearComponents(new int[]{i});
            String msg = "Components containing " + comp.getDisplayName() + " were cleared.";
            this.setStatus(msg, true);
        }
    }

    @Override
    public boolean isShowingUndefinedBytes() {
        return !this.viewComposite.isPackingEnabled();
    }

    void createInternalStructure() throws UsrException {
        int choice;
        if (this.selection.getNumRanges() != 1) {
            throw new UsrException("Can only create structure on a contiguous selection.");
        }
        FieldRange fieldRange = this.selection.getFieldRange(0);
        int minRow = fieldRange.getStart().getIndex().intValue();
        int maxRow = fieldRange.getEnd().getIndex().intValue();
        int selectedRowCount = maxRow - minRow;
        if (selectedRowCount == 1 && (choice = OptionDialog.showYesNoDialog((Component)this.provider.getComponent(), (String)"Create Structure From Selected Components", (String)"You only have a single component selected.\nAre you sure you want to create a structure from the selection?")) == 2) {
            return;
        }
        if (this.isEditingField()) {
            this.endFieldEditing();
        }
        DataTypeManager originalDtm = this.getOriginalDataTypeManager();
        String baseName = "struct";
        CategoryPath originalCategoryPath = this.getOriginalCategoryPath();
        String uniqueName = this.viewDTM.getUniqueName(originalCategoryPath, baseName);
        DataType conflictingDt = originalDtm.getDataType(originalCategoryPath, uniqueName);
        while (conflictingDt != null) {
            this.viewDTM.resolve(conflictingDt, DataTypeConflictHandler.DEFAULT_HANDLER);
            uniqueName = this.viewDTM.getUniqueName(originalCategoryPath, baseName);
            conflictingDt = originalDtm.getDataType(originalCategoryPath, uniqueName);
        }
        String specifiedName = this.showNameDialog(uniqueName, originalCategoryPath, this.viewComposite.getName(), originalDtm);
        if (specifiedName == null) {
            return;
        }
        TaskLauncher.launchModal((String)"Create Structure", monitor -> {
            try {
                this.doCreateInternalStructure(originalDtm, originalCategoryPath, specifiedName, monitor);
            }
            catch (UsrException e) {
                this.setStatus(e.getMessage(), true);
            }
        });
    }

    private void doCreateInternalStructure(DataTypeManager dtm, CategoryPath categoryPath, String name, TaskMonitor monitor) throws InvalidDataTypeException, UsrException {
        int length = 0;
        StructureDataType structureDataType = new StructureDataType(categoryPath, name, length, dtm);
        structureDataType.setPackingEnabled(this.isPackingEnabled());
        if (this.getPackingType() == PackingType.EXPLICIT) {
            structureDataType.setExplicitPackingValue(this.getExplicitPackingValue());
        }
        FieldRange fieldRange = this.selection.getFieldRange(0);
        int minRow = fieldRange.getStart().getIndex().intValue();
        int maxRow = fieldRange.getEnd().getIndex().intValue();
        DataTypeComponent firstDtc = null;
        DataTypeComponent lastDtc = null;
        for (int rowIndex = minRow; rowIndex < maxRow; ++rowIndex) {
            DataTypeComponent component = this.getComponent(rowIndex);
            if (rowIndex == minRow) {
                firstDtc = component;
            }
            if (component == null) {
                lastDtc = component;
                continue;
            }
            DataType dt = component.getDataType();
            int compLength = component.getLength();
            length += compLength;
            if (!structureDataType.isPackingEnabled() && component.isBitFieldComponent()) {
                BitFieldDataType bitfield = (BitFieldDataType)dt;
                structureDataType.insertBitFieldAt(component.getOffset() - firstDtc.getOffset(), compLength, bitfield.getBitOffset(), bitfield.getBaseDataType(), bitfield.getDeclaredBitSize(), component.getFieldName(), component.getComment());
            } else {
                structureDataType.add(dt, compLength, component.getFieldName(), component.getComment());
            }
            lastDtc = component;
        }
        DataType addedDataType = this.createDataTypeInOriginalDTM(structureDataType);
        if (this.viewComposite.isPackingEnabled()) {
            this.deleteSelectedComponents();
            this.insert(minRow, addedDataType, addedDataType.getLength());
        } else {
            DataTypeComponent dtc;
            int adjustmentBytes = 0;
            if (firstDtc != null && firstDtc.isBitFieldComponent() && minRow > 0 && (dtc = this.getComponent(minRow - 1)).getEndOffset() == firstDtc.getOffset()) {
                ++adjustmentBytes;
            }
            if (lastDtc != null && lastDtc.isBitFieldComponent() && maxRow < this.getNumComponents() && (dtc = this.getComponent(maxRow)).getOffset() == lastDtc.getEndOffset()) {
                ++adjustmentBytes;
            }
            this.clearSelectedComponents();
            this.insertMultiple(minRow, DataType.DEFAULT, 1, adjustmentBytes, monitor);
            this.replace(minRow, addedDataType, addedDataType.getLength());
        }
    }

    private String showNameDialog(String defaultName, CategoryPath catPath, String parentStructureName, DataTypeManager applyDTM) {
        InputDialogListener listener = dialog -> {
            String name = dialog.getValue();
            if (name == null || name.length() == 0) {
                dialog.setStatusText("A name must be specified.");
                return false;
            }
            if (name.equals(parentStructureName)) {
                dialog.setStatusText("The name cannot match the external structure name.");
                return false;
            }
            DataTypeManager originalDTM = this.getOriginalDataTypeManager();
            DataType conflictingDt = originalDTM.getDataType(this.getOriginalCategoryPath(), name);
            if (conflictingDt != null) {
                dialog.setStatusText("A data type named \"" + name + "\" already exists.");
                return false;
            }
            return true;
        };
        String title = "Specify the Structure's Name";
        InputDialog nameStructureDialog = new InputDialog(title, new String[]{"New Structure's Name: "}, new String[]{defaultName}, listener);
        this.provider.getPlugin().getTool().showDialog((DialogComponentProvider)nameStructureDialog);
        if (nameStructureDialog.isCanceled()) {
            return null;
        }
        return nameStructureDialog.getValue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DataType createDataTypeInOriginalDTM(StructureDataType structureDataType) {
        boolean commit = false;
        DataTypeManager originalDTM = this.getOriginalDataTypeManager();
        int transactionID = originalDTM.startTransaction("Creating " + structureDataType.getName());
        try {
            DataType addedDataType = originalDTM.addDataType((DataType)structureDataType, DataTypeConflictHandler.DEFAULT_HANDLER);
            commit = true;
            DataType dataType = addedDataType;
            return dataType;
        }
        finally {
            originalDTM.endTransaction(transactionID, commit);
        }
    }

    public void unpackage(int rowIndex, TaskMonitor monitor) throws UsrException {
        Structure struct;
        int componentOrdinal = this.convertRowToOrdinal(rowIndex);
        DataTypeComponent currentComp = this.viewComposite.getComponent(componentOrdinal);
        if (currentComp == null) {
            throw new UsrException("Can only unpackage an array or structure.");
        }
        DataType currentDataType = currentComp.getDataType();
        if (!(currentDataType instanceof Array) && !(currentDataType instanceof Structure)) {
            throw new UsrException("Can only unpackage an array or structure.");
        }
        if (this.isEditingField()) {
            this.endFieldEditing();
        }
        Structure viewStruct = (Structure)this.viewComposite;
        String fieldName = currentComp.getFieldName();
        String comment = currentComp.getComment();
        int numComps = 0;
        if (currentDataType instanceof Array) {
            Array array = (Array)currentDataType;
            int elementLen = array.getElementLength();
            numComps = array.getNumElements();
            this.delete(componentOrdinal);
            if (numComps > 0) {
                try {
                    DataType dt = array.getDataType();
                    this.insertMultiple(rowIndex, dt, elementLen, numComps, monitor);
                }
                catch (InvalidDataTypeException dt) {
                }
                catch (OutOfMemoryError memExc) {
                    throw memExc;
                }
            }
        } else if (currentDataType instanceof Structure && (numComps = (struct = (Structure)currentDataType).getNumComponents()) > 0) {
            int currentOffset = currentComp.getOffset();
            this.deleteComponent(rowIndex);
            for (int i = 0; i < numComps; ++i) {
                DataTypeComponent dtc = struct.getComponent(i);
                DataType dt = dtc.getDataType();
                int compLength = dtc.getLength();
                if (!this.isPackingEnabled()) {
                    if (dtc.isBitFieldComponent()) {
                        BitFieldDataType bitfield = (BitFieldDataType)dt;
                        viewStruct.insertBitFieldAt(currentOffset + dtc.getOffset(), compLength, bitfield.getBitOffset(), bitfield.getBaseDataType(), bitfield.getDeclaredBitSize(), dtc.getFieldName(), dtc.getComment());
                        continue;
                    }
                    viewStruct.insertAtOffset(currentOffset + dtc.getOffset(), dt, compLength, dtc.getFieldName(), dtc.getComment());
                    continue;
                }
                this.insert(rowIndex + i, dt, compLength, dtc.getFieldName(), dtc.getComment());
            }
        }
        this.selection.clear();
        this.selection.addRange(rowIndex, rowIndex + numComps);
        DataTypeComponent comp = this.getComponent(rowIndex);
        try {
            if (comp.getFieldName() == null) {
                comp.setFieldName(fieldName);
            }
        }
        catch (DuplicateNameException exc) {
            Msg.showError((Object)this, null, null, null);
        }
        comp.setComment(comment);
        this.fixSelection();
        this.componentEdited();
        this.selectionChanged();
    }
}

