/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.compositeeditor;

import docking.action.DockingAction;
import docking.action.KeyBindingType;
import docking.action.MenuData;
import docking.action.ToolBarData;
import ghidra.app.plugin.core.compositeeditor.CompositeEditorModel;
import ghidra.app.plugin.core.compositeeditor.CompositeEditorPanel;
import ghidra.app.plugin.core.compositeeditor.CompositeEditorProvider;
import ghidra.app.plugin.core.compositeeditor.EditorAction;
import ghidra.framework.plugintool.Plugin;
import ghidra.framework.plugintool.PluginTool;
import ghidra.util.HelpLocation;
import java.awt.event.ActionListener;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JTable;
import javax.swing.KeyStroke;

public abstract class CompositeEditorTableAction
extends DockingAction
implements EditorAction {
    protected CompositeEditorProvider provider;
    protected CompositeEditorModel model;
    protected String tooltip;
    protected ImageIcon icon;
    protected ActionListener listener;
    protected String displayString;
    protected String actionCommand;
    protected JButton button;
    protected KeyStroke keystroke;
    protected Plugin plugin;
    protected PluginTool tool;
    public static final String EDIT_ACTION_PREFIX = "Editor: ";

    public CompositeEditorTableAction(CompositeEditorProvider provider, String name, String group, String[] popupPath, String[] menuPath, Icon icon) {
        super(name, provider.plugin.getName(), KeyBindingType.SHARED);
        this.provider = provider;
        this.model = provider.getModel();
        if (menuPath != null) {
            this.setMenuBarData(new MenuData(menuPath, icon, group));
        }
        if (popupPath != null) {
            this.setPopupMenuData(new MenuData(popupPath, icon, group));
        }
        if (icon != null) {
            this.setToolBarData(new ToolBarData(icon, group));
        }
        this.plugin = provider.plugin;
        this.tool = this.plugin.getTool();
        this.model.addCompositeEditorModelListener(this);
        String helpAnchor = provider.getHelpName() + "_" + this.getHelpName();
        this.setHelpLocation(new HelpLocation(provider.getHelpTopic(), helpAnchor));
    }

    public void dispose() {
        this.model.removeCompositeEditorModelListener(this);
        super.dispose();
        this.provider = null;
        this.model = null;
        this.plugin = null;
        this.tool = null;
    }

    protected void requestTableFocus() {
        if (this.provider == null) {
            return;
        }
        JTable table = ((CompositeEditorPanel)this.provider.getComponent()).getTable();
        if (table.isEditing()) {
            table.getEditorComponent().requestFocus();
        } else {
            table.requestFocus();
        }
    }

    @Override
    public abstract void adjustEnablement();

    public String getHelpName() {
        String actionName = this.getName();
        if (actionName.startsWith(EDIT_ACTION_PREFIX)) {
            actionName = actionName.substring(EDIT_ACTION_PREFIX.length());
        }
        return actionName;
    }

    @Override
    public void selectionChanged() {
        this.adjustEnablement();
    }

    public void editStateChanged(int i) {
        this.adjustEnablement();
    }

    @Override
    public void compositeEditStateChanged(int type) {
        this.adjustEnablement();
    }

    @Override
    public void endFieldEditing() {
        this.adjustEnablement();
    }

    @Override
    public void componentDataChanged() {
        this.adjustEnablement();
    }

    @Override
    public void compositeInfoChanged() {
        this.adjustEnablement();
    }

    @Override
    public void statusChanged(String message, boolean beep) {
    }

    @Override
    public void showUndefinedStateChanged(boolean showUndefinedBytes) {
        this.adjustEnablement();
    }
}

