/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.compositeeditor;

import docking.widgets.OptionDialog;
import docking.widgets.button.GRadioButton;
import docking.widgets.fieldpanel.support.FieldSelection;
import docking.widgets.label.GDLabel;
import ghidra.app.plugin.core.compositeeditor.BitFieldPlacementComponent;
import ghidra.app.plugin.core.compositeeditor.CompEditorModel;
import ghidra.app.plugin.core.compositeeditor.CompositeEditorModelAdapter;
import ghidra.app.plugin.core.compositeeditor.CompositeEditorPanel;
import ghidra.app.plugin.core.compositeeditor.CompositeEditorProvider;
import ghidra.app.plugin.core.compositeeditor.CompositeViewerModel;
import ghidra.app.plugin.core.compositeeditor.StructureEditorModel;
import ghidra.program.model.data.AlignmentType;
import ghidra.program.model.data.Category;
import ghidra.program.model.data.Composite;
import ghidra.program.model.data.DataOrganization;
import ghidra.program.model.data.DataTypeComponent;
import ghidra.program.model.data.DataUtilities;
import ghidra.program.model.data.PackingType;
import ghidra.util.HelpLocation;
import ghidra.util.InvalidNameException;
import ghidra.util.exception.DuplicateNameException;
import ghidra.util.layout.PairLayout;
import ghidra.util.layout.VerticalLayout;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.border.TitledBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.Document;

public class CompEditorPanel
extends CompositeEditorPanel {
    protected static final Insets LEFT_INSETS = new Insets(2, 3, 1, 0);
    protected static final Insets VERTICAL_INSETS = new Insets(2, 0, 1, 0);
    private GridBagLayout gridBagLayout;
    private JPanel infoPanel;
    private JLabel nameLabel;
    protected JTextField nameTextField;
    private JLabel descriptionLabel;
    private JTextField descriptionTextField;
    private JLabel categoryLabel;
    private JTextField categoryStatusTextField;
    private JLabel sizeLabel;
    private JTextField sizeTextField;
    private JPanel alignPanel;
    private JRadioButton defaultAlignButton;
    private JRadioButton machineAlignButton;
    private JRadioButton explicitAlignButton;
    private JTextField explicitAlignTextField;
    private JPanel packingPanel;
    private JCheckBox packingEnablementButton;
    private JRadioButton defaultPackingButton;
    private JRadioButton explicitPackingButton;
    private JTextField explicitPackingTextField;
    private JLabel actualAlignmentLabel;
    private JTextField actualAlignmentValueTextField;
    private BitFieldPlacementComponent bitViewComponent;
    private DocumentListener fieldDocListener;
    private ActionListener fieldActionListener;
    private FocusListener fieldFocusListener;
    private boolean updatingSize;

    public CompEditorPanel(CompEditorModel model, CompositeEditorProvider provider) {
        super(model, provider);
    }

    @Override
    public void dispose() {
        this.removeFieldListeners();
        super.dispose();
    }

    @Override
    public void componentDataChanged() {
        this.refreshGUIPackingValue();
        this.refreshGUIMinimumAlignmentValue();
        this.refreshGUIActualAlignmentValue();
        this.setCompositeSize(this.model.getLength());
    }

    @Override
    public void compositeInfoChanged() {
        this.adjustCompositeInfo();
        if (this.bitViewComponent != null && this.model.showHexNumbers != this.bitViewComponent.isShowOffsetsInHex()) {
            this.bitViewComponent.setShowOffsetsInHex(this.model.showHexNumbers);
        }
    }

    @Override
    protected void adjustCompositeInfo() {
        this.setCompositeName(this.model.getCompositeName());
        this.setDescription(this.model.getDescription());
        Category c = this.model.getOriginalCategory();
        if (c != null) {
            this.setCategoryName(c.toString());
        }
        this.componentDataChanged();
    }

    @Override
    protected JPanel createBitViewerPanel() {
        this.bitViewComponent = new BitFieldPlacementComponent(this.model.viewComposite, false);
        this.bitViewComponent.setShowOffsetsInHex(this.model.showHexNumbers);
        this.model.addCompositeViewerModelListener(new CompositeEditorModelAdapter(){

            @Override
            public void selectionChanged() {
                this.update(false);
            }

            @Override
            public void componentDataChanged() {
                this.update(true);
            }

            private void update(boolean dataChanged) {
                Rectangle selectedRectangle;
                int length;
                if (!CompEditorPanel.this.model.isLoaded()) {
                    CompEditorPanel.this.bitViewComponent.setComposite(null);
                    return;
                }
                if (CompEditorPanel.this.bitViewComponent.getComposite() != CompEditorPanel.this.model.viewComposite) {
                    CompEditorPanel.this.bitViewComponent.setComposite(CompEditorPanel.this.model.viewComposite);
                }
                if ((length = CompEditorPanel.this.model.viewComposite.getLength()) != CompEditorPanel.this.bitViewComponent.getAllocationByteSize()) {
                    CompEditorPanel.this.bitViewComponent.updateAllocation(length, 0);
                }
                DataTypeComponent dtc = null;
                if (CompEditorPanel.this.model.isSingleComponentRowSelection()) {
                    dtc = CompEditorPanel.this.model.getComponent(CompEditorPanel.this.model.getSelectedRows()[0]);
                }
                if ((selectedRectangle = CompEditorPanel.this.bitViewComponent.getComponentRectangle(dtc)) != null) {
                    CompEditorPanel.this.bitViewComponent.scrollRectToVisible(selectedRectangle);
                    CompEditorPanel.this.validate();
                }
                if (dtc != null && dtc.getOffset() >= length) {
                    CompEditorPanel.this.bitViewComponent.init(null);
                } else {
                    CompEditorPanel.this.bitViewComponent.init(dtc);
                }
            }
        });
        this.bitViewComponent.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                Point p = e.getPoint();
                BitFieldPlacementComponent.BitAttributes attrs = CompEditorPanel.this.bitViewComponent.getBitAttributes(p);
                if (attrs == null) {
                    return;
                }
                DataTypeComponent dtc = attrs.getDataTypeComponent(false);
                if (dtc != null) {
                    CompEditorPanel.this.model.setSelection(new int[]{dtc.getOrdinal()});
                    CompEditorPanel.this.table.scrollToSelectedRow();
                } else {
                    CompEditorPanel.this.model.setSelection(new FieldSelection());
                }
            }
        });
        JPanel bitViewPanel = new JPanel((LayoutManager)new PairLayout(0, 5));
        JPanel labelPanel = new JPanel((LayoutManager)new VerticalLayout(7));
        labelPanel.setBorder(BorderFactory.createEmptyBorder(7, 5, 0, 0));
        JLabel byteOffsetLabel = new JLabel("Byte Offset:", 4);
        labelPanel.add(byteOffsetLabel);
        labelPanel.add(new JLabel("Component Bits:", 4));
        bitViewPanel.add(labelPanel);
        JScrollPane bitViewScrollPane = new JScrollPane(this.bitViewComponent, 21, 30);
        bitViewScrollPane.getViewport().setBackground(this.getBackground());
        bitViewScrollPane.setBorder(null);
        Dimension bitViewerDefaultSize = new Dimension(800, this.bitViewComponent.getPreferredHeight());
        bitViewScrollPane.setPreferredSize(bitViewerDefaultSize);
        bitViewPanel.add(bitViewScrollPane);
        return bitViewPanel;
    }

    @Override
    protected JPanel createInfoPanel() {
        this.gridBagLayout = new GridBagLayout();
        this.infoPanel = new JPanel(this.gridBagLayout);
        this.setBorder(BEVELED_BORDER);
        this.setupName();
        this.setupDescription();
        this.setupCategory();
        this.setupSize();
        this.setupActualAlignment();
        this.setupMinimumAlignment();
        this.setupPacking();
        this.addFieldListeners();
        this.infoPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 0, 5));
        return this.infoPanel;
    }

    private void setupName() {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        this.nameLabel = new GDLabel("Name:");
        gridBagConstraints.insets = LEFT_INSETS;
        gridBagConstraints.anchor = 22;
        gridBagConstraints.fill = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        this.infoPanel.add((Component)this.nameLabel, gridBagConstraints);
        this.nameTextField = new JTextField("");
        this.nameTextField.setToolTipText("Structure Name");
        this.nameTextField.setEditable(true);
        gridBagConstraints.insets = VERTICAL_INSETS;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 4;
        this.infoPanel.add((Component)this.nameTextField, gridBagConstraints);
        if (helpManager != null) {
            helpManager.registerHelp((Object)this.nameTextField, new HelpLocation(this.provider.getHelpTopic(), this.provider.getHelpName() + "_Name"));
        }
    }

    private void setupDescription() {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        this.descriptionLabel = new GDLabel("Description:");
        gridBagConstraints.insets = LEFT_INSETS;
        gridBagConstraints.anchor = 22;
        gridBagConstraints.fill = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        this.infoPanel.add((Component)this.descriptionLabel, gridBagConstraints);
        this.descriptionTextField = new JTextField("");
        this.descriptionTextField.setToolTipText("Structure Description");
        this.descriptionTextField.setEditable(true);
        gridBagConstraints.insets = VERTICAL_INSETS;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 4;
        this.infoPanel.add((Component)this.descriptionTextField, gridBagConstraints);
        if (helpManager != null) {
            helpManager.registerHelp((Object)this.descriptionTextField, new HelpLocation(this.provider.getHelpTopic(), this.provider.getHelpName() + "_Description"));
        }
    }

    private void setupCategory() {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        this.categoryLabel = new GDLabel("Category:");
        gridBagConstraints.insets = LEFT_INSETS;
        gridBagConstraints.anchor = 22;
        gridBagConstraints.fill = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        this.infoPanel.add((Component)this.categoryLabel, gridBagConstraints);
        this.categoryStatusTextField = new JTextField(" ");
        this.categoryStatusTextField.setEditable(false);
        this.categoryStatusTextField.setToolTipText("Category of this composite data type.");
        gridBagConstraints.insets = VERTICAL_INSETS;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 4;
        this.infoPanel.add((Component)this.categoryStatusTextField, gridBagConstraints);
    }

    @Override
    public Dimension getPreferredSize() {
        Dimension preferredSize = super.getPreferredSize();
        if (this.alignPanel.isShowing()) {
            return preferredSize;
        }
        Dimension alignmentPanelPreferredSize = this.alignPanel.getPreferredSize();
        preferredSize.width += alignmentPanelPreferredSize.width;
        Dimension packingPanelPreferredSize = this.packingPanel.getPreferredSize();
        preferredSize.width += packingPanelPreferredSize.width;
        return preferredSize;
    }

    private void setupMinimumAlignment() {
        DataOrganization dataOrganization = ((CompEditorModel)this.model).viewComposite.getDataOrganization();
        int machineAlignment = dataOrganization.getMachineAlignment();
        this.defaultAlignButton = new GRadioButton("default           ");
        this.explicitAlignButton = new GRadioButton();
        this.explicitAlignTextField = new JTextField();
        this.machineAlignButton = new GRadioButton("machine: " + machineAlignment);
        this.setupDefaultMinAlignButton();
        this.setupExplicitAlignButton();
        this.setupMachineMinAlignButton();
        ButtonGroup minAlignGroup = new ButtonGroup();
        minAlignGroup.add(this.defaultAlignButton);
        minAlignGroup.add(this.explicitAlignButton);
        minAlignGroup.add(this.machineAlignButton);
        this.alignPanel = new JPanel(new GridBagLayout());
        TitledBorder border = BorderFactory.createTitledBorder("align (minimum)");
        this.alignPanel.setBorder(border);
        if (helpManager != null) {
            helpManager.registerHelp((Object)this.alignPanel, new HelpLocation(this.provider.getHelpTopic(), this.provider.getHelpName() + "_Align"));
        }
        String alignmentToolTip = "<HTML>The <B>align</B> control allows the overall minimum alignment of this<BR>data type to be specified.  The actual computed alignment<BR>may be any multiple of this value.   <font color=blue size=\"-2\">(&lt;F1&gt; for help)</HTML>";
        this.alignPanel.setToolTipText(alignmentToolTip);
        this.addMinimumAlignmentComponents();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.gridx = 5;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridheight = 4;
        this.infoPanel.add((Component)this.alignPanel, gridBagConstraints);
        this.infoPanel.invalidate();
        this.refreshGUIActualAlignmentValue();
    }

    private void addMinimumAlignmentComponents() {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 0;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        this.alignPanel.add((Component)this.defaultAlignButton, gridBagConstraints);
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 0;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 1;
        this.alignPanel.add((Component)this.explicitAlignButton, gridBagConstraints);
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 1;
        this.alignPanel.add((Component)this.explicitAlignTextField, gridBagConstraints);
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 0;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 2;
        this.alignPanel.add((Component)this.machineAlignButton, gridBagConstraints);
    }

    private void setupDefaultMinAlignButton() {
        this.defaultAlignButton.setName("Default Alignment");
        String alignmentToolTip = "<HTML>Sets this data type to use <B>default</B> alignment.<BR>If packing is disabled, the default will be 1 byte.  If packing<BR>is enabled, the alignment is computed based upon the pack<BR>setting and the alignment of each component data type.</HTML>";
        this.defaultAlignButton.addActionListener(e -> ((CompEditorModel)this.model).setAlignmentType(AlignmentType.DEFAULT, -1));
        this.defaultAlignButton.setToolTipText(alignmentToolTip);
        if (helpManager != null) {
            helpManager.registerHelp((Object)this.defaultAlignButton, new HelpLocation(this.provider.getHelpTopic(), this.provider.getHelpName() + "_Align"));
        }
    }

    private void setupMachineMinAlignButton() {
        this.machineAlignButton.setName("Machine Alignment");
        String alignmentToolTip = "<HTML>Sets this data type to use the <B>machine</B> alignment<BR>as specified by the compiler specification.  If packing is<BR>enabled, the computed alignment of this composite should be<BR>the machine alignment value.</HTML>";
        this.machineAlignButton.setToolTipText(alignmentToolTip);
        this.machineAlignButton.addActionListener(e -> ((CompEditorModel)this.model).setAlignmentType(AlignmentType.MACHINE, -1));
        if (helpManager != null) {
            helpManager.registerHelp((Object)this.machineAlignButton, new HelpLocation(this.provider.getHelpTopic(), this.provider.getHelpName() + "_Align"));
        }
    }

    private void setupExplicitAlignButton() {
        this.explicitAlignButton.setName("Explicit Alignment");
        String alignmentToolTip = "<HTML>Sets this data type to use the <B>explicit</B> alignment value<BR>specified.  If packing is enabled, the computed alignment of<BR>this composite may be any multiple of this value.</HTML>";
        this.explicitAlignButton.setToolTipText(alignmentToolTip);
        this.explicitAlignButton.addActionListener(e -> this.chooseExplicitAlign());
        if (helpManager != null) {
            helpManager.registerHelp((Object)this.explicitAlignButton, new HelpLocation(this.provider.getHelpTopic(), this.provider.getHelpName() + "_Align"));
        }
        this.explicitAlignTextField.setName("Explicit Alignment Value");
        this.explicitAlignTextField.setEditable(true);
        this.explicitAlignTextField.addActionListener(e -> this.adjustExplicitMinimumAlignmentValue());
        this.explicitAlignTextField.addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent e) {
                if (CompEditorPanel.this.explicitAlignButton.isSelected()) {
                    return;
                }
                CompEditorPanel.this.explicitAlignButton.setSelected(true);
                CompEditorPanel.this.chooseExplicitAlign();
            }

            @Override
            public void focusLost(FocusEvent e) {
                CompEditorPanel.this.adjustExplicitMinimumAlignmentValue();
            }
        });
        this.explicitAlignTextField.setToolTipText(alignmentToolTip);
        if (helpManager != null) {
            helpManager.registerHelp((Object)this.explicitAlignTextField, new HelpLocation(this.provider.getHelpTopic(), this.provider.getHelpName() + "_Align"));
        }
        this.refreshGUIMinimumAlignmentValue();
    }

    private void adjustExplicitMinimumAlignmentValue() {
        this.setStatus(null);
        String value = this.explicitAlignTextField.getText();
        try {
            int minAlignment = Integer.decode(value.trim());
            try {
                ((CompEditorModel)this.model).setAlignmentType(AlignmentType.EXPLICIT, minAlignment);
                this.adjustCompositeInfo();
            }
            catch (IllegalArgumentException e1) {
                this.refreshGUIMinimumAlignmentValue();
                String message = "\"" + value + "\" is not a valid alignment value.";
                this.setStatus(message);
            }
        }
        catch (NumberFormatException e1) {
            this.refreshGUIMinimumAlignmentValue();
            String message = "\"" + value + "\" is not a valid alignment value.";
            this.setStatus(message);
        }
    }

    private void setupActualAlignment() {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        String actualAlignmentToolTip = "<HTML>The actual alignment to be used for this data type.<BR>A combination of the pack and alignment settings made to this datatype<BR>combined with alignments of the individual components are used to<BR>to compute the actual alignment of this datatype.</HTML>";
        JPanel actualAlignmentPanel = new JPanel(new BorderLayout());
        this.actualAlignmentLabel = new GDLabel("Alignment:");
        gridBagConstraints.insets = new Insets(2, 7, 2, 2);
        gridBagConstraints.anchor = 13;
        gridBagConstraints.fill = 0;
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 3;
        this.actualAlignmentLabel.setToolTipText(actualAlignmentToolTip);
        actualAlignmentPanel.add((Component)this.actualAlignmentLabel, "East");
        this.infoPanel.add((Component)actualAlignmentPanel, gridBagConstraints);
        this.actualAlignmentValueTextField = new JTextField(8);
        this.actualAlignmentValueTextField.setText("" + ((CompEditorModel)this.model).getActualAlignment());
        this.actualAlignmentValueTextField.setToolTipText(actualAlignmentToolTip);
        this.actualAlignmentValueTextField.setEditable(false);
        if (helpManager != null) {
            helpManager.registerHelp((Object)this.actualAlignmentValueTextField, new HelpLocation(this.provider.getHelpTopic(), this.provider.getHelpName() + "_ActualAlignment"));
        }
        this.actualAlignmentValueTextField.setName("Actual Alignment Value");
        gridBagConstraints.insets = VERTICAL_INSETS;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.fill = 2;
        gridBagConstraints.ipadx = 50;
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 3;
        this.infoPanel.add((Component)this.actualAlignmentValueTextField, gridBagConstraints);
        this.actualAlignmentValueTextField.setBackground(new Color(this.getBackground().getRGB()));
    }

    private void setupPacking() {
        this.packingPanel = new JPanel((LayoutManager)new VerticalLayout(0));
        this.packingEnablementButton = new JCheckBox("pack");
        this.packingEnablementButton.setEnabled(true);
        this.packingEnablementButton.setFont(UIManager.getFont("TitledBorder.font"));
        this.packingEnablementButton.setForeground(UIManager.getColor("TitledBorder.titleColor"));
        this.packingPanel.add(this.packingEnablementButton);
        JPanel innerPanel = new JPanel(new GridBagLayout());
        innerPanel.setBorder(UIManager.getBorder("TitledBorder.border"));
        this.packingPanel.add(innerPanel);
        this.defaultPackingButton = new GRadioButton("default           ");
        this.explicitPackingButton = new GRadioButton();
        this.explicitPackingTextField = new JTextField();
        this.setupDefaultPackingButton();
        this.setupExplicitPackingButton();
        this.setupPackingEnablementButton();
        ButtonGroup packingGroup = new ButtonGroup();
        packingGroup.add(this.defaultPackingButton);
        packingGroup.add(this.explicitPackingButton);
        if (helpManager != null) {
            helpManager.registerHelp((Object)this.packingPanel, new HelpLocation(this.provider.getHelpTopic(), this.provider.getHelpName() + "_Pack"));
        }
        this.addPackingComponents(innerPanel);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.gridx = 7;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridheight = 4;
        this.infoPanel.add((Component)this.packingPanel, gridBagConstraints);
        this.refreshGUIPackingValue();
    }

    private void addPackingComponents(JPanel gridPanel) {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 0;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridPanel.add((Component)this.defaultPackingButton, gridBagConstraints);
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 0;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 1;
        gridPanel.add((Component)this.explicitPackingButton, gridBagConstraints);
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 1;
        gridPanel.add((Component)this.explicitPackingTextField, gridBagConstraints);
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 0;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 2;
    }

    private void setupPackingEnablementButton() {
        this.packingEnablementButton.setName("Packing Enablement");
        String packingToolTipText = "<HTML>Enable packing when details of all components are known (including sizing and alignment).<BR>Disable packing when Reverse Engineering composite.   <font color=blue size=\"-2\">(&lt;F1&gt; for help)</font></HTML>";
        this.packingEnablementButton.addActionListener(e -> ((CompEditorModel)this.model).setPackingType(this.packingEnablementButton.isSelected() ? PackingType.DEFAULT : PackingType.DISABLED, -1));
        this.packingEnablementButton.setToolTipText(packingToolTipText);
        if (helpManager != null) {
            helpManager.registerHelp((Object)this.packingEnablementButton, new HelpLocation(this.provider.getHelpTopic(), this.provider.getHelpName() + "_Pack"));
        }
    }

    private void setupDefaultPackingButton() {
        this.defaultPackingButton.setName("Default Packing");
        String packingToolTipText = "<HTML>Indicates <B>default</B> compiler packing rules should be applied.</HTML>";
        this.defaultPackingButton.addActionListener(e -> ((CompEditorModel)this.model).setPackingType(PackingType.DEFAULT, -1));
        this.defaultPackingButton.setToolTipText(packingToolTipText);
        if (helpManager != null) {
            helpManager.registerHelp((Object)this.defaultPackingButton, new HelpLocation(this.provider.getHelpTopic(), this.provider.getHelpName() + "_Pack"));
        }
    }

    private void setupExplicitPackingButton() {
        this.explicitPackingButton.setName("Explicit Packing");
        String packingToolTipText = "<HTML>Indicates an explicit pack size should be applied.</HTML>";
        this.explicitPackingButton.addActionListener(e -> this.chooseByValuePacking());
        this.explicitPackingButton.setToolTipText(packingToolTipText);
        if (helpManager != null) {
            helpManager.registerHelp((Object)this.explicitPackingButton, new HelpLocation(this.provider.getHelpTopic(), this.provider.getHelpName() + "_Pack"));
        }
        this.explicitPackingTextField.setName("Packing Value");
        this.explicitPackingTextField.setEditable(true);
        this.explicitPackingTextField.addActionListener(e -> this.adjustPackingValue());
        this.explicitPackingTextField.addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent e) {
                if (CompEditorPanel.this.explicitPackingButton.isSelected()) {
                    return;
                }
                CompEditorPanel.this.explicitPackingButton.setSelected(true);
                CompEditorPanel.this.chooseByValuePacking();
            }

            @Override
            public void focusLost(FocusEvent e) {
                CompEditorPanel.this.adjustPackingValue();
            }
        });
        this.explicitPackingTextField.setToolTipText(packingToolTipText);
        if (helpManager != null) {
            helpManager.registerHelp((Object)this.explicitPackingTextField, new HelpLocation(this.provider.getHelpTopic(), this.provider.getHelpName() + "_Pack"));
        }
    }

    private void chooseByValuePacking() {
        ((CompEditorModel)this.model).setPackingType(PackingType.EXPLICIT, 1);
        this.explicitPackingTextField.selectAll();
        this.explicitPackingTextField.requestFocus();
    }

    private void adjustPackingValue() {
        this.setStatus(null);
        String value = this.explicitPackingTextField.getText();
        try {
            int explicitPacking = Integer.decode(value.trim());
            ((CompEditorModel)this.model).setPackingType(PackingType.EXPLICIT, explicitPacking);
            this.adjustCompositeInfo();
        }
        catch (NumberFormatException e1) {
            this.refreshGUIPackingValue();
            this.setStatus(value + " is not a valid packing value.");
        }
    }

    public void refreshGUIPackingValue() {
        PackingType packingType = ((CompEditorModel)this.model).getPackingType();
        String packingString = "";
        boolean packingEnabled = packingType != PackingType.DISABLED;
        this.packingEnablementButton.setSelected(packingEnabled);
        this.defaultPackingButton.setEnabled(packingEnabled);
        this.explicitPackingButton.setEnabled(packingEnabled);
        this.explicitPackingTextField.setEnabled(packingEnabled);
        if (packingType == PackingType.DEFAULT) {
            this.defaultPackingButton.setSelected(true);
        } else if (packingType == PackingType.EXPLICIT) {
            int packValue = ((CompEditorModel)this.model).getExplicitPackingValue();
            packingString = this.model.showHexNumbers ? CompositeViewerModel.getHexString(packValue, true) : Integer.toString(packValue);
            this.explicitPackingButton.setSelected(true);
        }
        this.explicitPackingTextField.setText(packingString);
    }

    protected void setupSize() {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        this.sizeLabel = new GDLabel("Size:");
        this.sizeLabel.setToolTipText("The current size in bytes.");
        gridBagConstraints.anchor = 22;
        gridBagConstraints.fill = 0;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        this.infoPanel.add((Component)this.sizeLabel, gridBagConstraints);
        this.sizeTextField = new JTextField(10);
        this.sizeTextField.setName("Total Length");
        this.sizeTextField.setToolTipText("The current size in bytes.");
        this.setSizeEditable(false);
        gridBagConstraints.ipadx = 60;
        gridBagConstraints.fill = 2;
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        this.infoPanel.add((Component)this.sizeTextField, gridBagConstraints);
        this.sizeTextField.addActionListener(e -> this.updatedStructureSize());
        this.sizeTextField.addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent e) {
            }

            @Override
            public void focusLost(FocusEvent e) {
                if (CompEditorPanel.this.sizeTextField.isEditable()) {
                    CompEditorPanel.this.updatedStructureSize();
                }
            }
        });
    }

    protected void setSizeEditable(boolean editable) {
        this.sizeTextField.setEditable(editable);
        if (editable) {
            this.sizeTextField.setBackground(this.descriptionTextField.getBackground());
        } else {
            this.sizeTextField.setBackground(new Color(this.getBackground().getRGB()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updatedStructureSize() {
        if (this.updatingSize) {
            return;
        }
        if (!this.sizeTextField.isShowing()) {
            return;
        }
        if (!((CompEditorModel)this.model).isSizeEditable()) {
            return;
        }
        String valueStr = this.sizeTextField.getText();
        try {
            this.updatingSize = true;
            Integer value = Integer.decode(valueStr);
            int structureSize = value;
            if (structureSize < 0) {
                this.model.setStatus("Structure size cannot be negative.", true);
            } else {
                if (structureSize < this.model.getLength()) {
                    String question = "The size field was changed to " + structureSize + " bytes.\nDo you really want to truncate " + this.model.getCompositeName() + "?";
                    String title = "Truncate " + this.model.getTypeName() + " In Editor?";
                    int response = OptionDialog.showYesNoDialogWithNoAsDefaultButton((Component)this, (String)title, (String)question);
                    if (response != 1) {
                        this.compositeInfoChanged();
                        return;
                    }
                }
                ((StructureEditorModel)this.model).setStructureSize(structureSize);
                this.model.setStatus(null);
            }
        }
        catch (NumberFormatException e1) {
            this.model.setStatus("Invalid structure size \"" + valueStr + "\".", true);
        }
        finally {
            this.updatingSize = false;
        }
        this.compositeInfoChanged();
    }

    private void addFieldListeners() {
        this.fieldDocListener = new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                this.changed(e);
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                this.changed(e);
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                this.changed(e);
            }

            private void changed(DocumentEvent e) {
                Document doc = e.getDocument();
                if (doc.equals(CompEditorPanel.this.nameTextField.getDocument())) {
                    CompEditorPanel.this.model.clearStatus();
                    String name = CompEditorPanel.this.nameTextField.getText().trim();
                    if (name.length() == 0) {
                        return;
                    }
                    try {
                        CompEditorPanel.this.model.setName(name);
                    }
                    catch (DuplicateNameException dne) {
                        CompEditorPanel.this.model.setStatus("A data type named " + name + " already exists.");
                    }
                    catch (InvalidNameException ine) {
                        CompEditorPanel.this.model.setStatus(name + " is not a valid name.");
                    }
                } else if (doc.equals(CompEditorPanel.this.descriptionTextField.getDocument())) {
                    CompEditorPanel.this.model.clearStatus();
                    CompEditorPanel.this.model.setDescription(CompEditorPanel.this.descriptionTextField.getText().trim());
                }
            }
        };
        this.nameTextField.getDocument().addDocumentListener(this.fieldDocListener);
        this.descriptionTextField.getDocument().addDocumentListener(this.fieldDocListener);
        this.fieldActionListener = e -> {
            Object source = e.getSource();
            if (source == this.nameTextField) {
                this.updatedName();
            } else if (source == this.descriptionTextField) {
                this.updatedDescription();
            }
        };
        this.nameTextField.addActionListener(this.fieldActionListener);
        this.descriptionTextField.addActionListener(this.fieldActionListener);
        this.fieldFocusListener = new FocusListener(){

            @Override
            public void focusGained(FocusEvent e) {
            }

            @Override
            public void focusLost(FocusEvent e) {
                Object source = e.getSource();
                if (source == CompEditorPanel.this.nameTextField) {
                    CompEditorPanel.this.updatedName();
                } else if (source == CompEditorPanel.this.descriptionTextField) {
                    CompEditorPanel.this.updatedDescription();
                }
            }
        };
        this.nameTextField.addFocusListener(this.fieldFocusListener);
        this.descriptionTextField.addFocusListener(this.fieldFocusListener);
    }

    private void chooseExplicitAlign() {
        if (((CompEditorModel)this.model).getAlignmentType() != AlignmentType.EXPLICIT) {
            Composite viewComposite = ((CompEditorModel)this.model).viewComposite;
            int defaultValue = 1;
            if (viewComposite.isPackingEnabled()) {
                defaultValue = viewComposite.getDataOrganization().getMachineAlignment();
            }
            ((CompEditorModel)this.model).setAlignmentType(AlignmentType.EXPLICIT, defaultValue);
        }
        this.explicitAlignTextField.selectAll();
        this.explicitAlignTextField.requestFocus();
    }

    private void removeFieldListeners() {
        this.nameTextField.getDocument().removeDocumentListener(this.fieldDocListener);
        this.nameTextField.removeActionListener(this.fieldActionListener);
        this.nameTextField.removeFocusListener(this.fieldFocusListener);
        this.descriptionTextField.getDocument().removeDocumentListener(this.fieldDocListener);
        this.descriptionTextField.removeActionListener(this.fieldActionListener);
        this.descriptionTextField.removeFocusListener(this.fieldFocusListener);
        this.defaultAlignButton.addActionListener(this.fieldActionListener);
        this.machineAlignButton.addActionListener(this.fieldActionListener);
        this.explicitAlignButton.addActionListener(this.fieldActionListener);
        this.explicitAlignTextField.addActionListener(this.fieldActionListener);
        this.explicitAlignTextField.removeFocusListener(this.fieldFocusListener);
    }

    protected void updatedName() {
        if (!this.nameTextField.isShowing()) {
            return;
        }
        String nameText = this.nameTextField.getText();
        String newName = nameText.trim();
        if (!DataUtilities.isValidDataTypeName((String)newName)) {
            if (newName.length() == 0) {
                this.model.setStatus("Name is required.");
            } else {
                this.model.setStatus(newName + " is not a valid name.");
            }
            return;
        }
        String originalDtName = this.model.getOriginalDataTypeName();
        if (!newName.equals(originalDtName) && newName.length() == 0) {
            this.nameTextField.setText(originalDtName);
            this.model.setStatus("Name is required. So original name has been restored.");
            return;
        }
        if (!newName.equals(nameText)) {
            this.nameTextField.setText(newName);
        }
        if (!newName.equals(this.model.getCompositeName())) {
            try {
                this.model.setName(newName);
            }
            catch (DuplicateNameException e) {
                this.model.setStatus("Can't duplicate name \"" + newName + "\".");
            }
            catch (InvalidNameException e) {
                this.model.setStatus("\"" + newName + "\" isn't a valid name.");
            }
        }
    }

    protected void updatedDescription() {
        if (!this.descriptionTextField.isShowing()) {
            return;
        }
        String newValue = this.descriptionTextField.getText().trim();
        if (!newValue.equals(this.model.getDescription())) {
            this.model.setDescription(newValue);
        }
    }

    public String getCategoryName() {
        return this.categoryStatusTextField.getText();
    }

    public void setCategoryName(String name) {
        this.categoryStatusTextField.setText(name);
    }

    public String getCompositeName() {
        return this.nameTextField.getText().trim();
    }

    public void setCompositeName(String name) {
        String original = this.getCompositeName();
        if (name.equals(original)) {
            return;
        }
        Document doc = this.nameTextField.getDocument();
        doc.removeDocumentListener(this.fieldDocListener);
        this.nameTextField.setText(name);
        doc.addDocumentListener(this.fieldDocListener);
    }

    public String getDescription() {
        return this.descriptionTextField.getText().trim();
    }

    public void setDescription(String description) {
        this.descriptionTextField.setText(description);
    }

    public void refreshGUIMinimumAlignmentValue() {
        AlignmentType alignmentType = ((CompEditorModel)this.model).getAlignmentType();
        String minimumAlignmentStr = "";
        if (alignmentType == AlignmentType.DEFAULT) {
            this.defaultAlignButton.setSelected(true);
        } else if (alignmentType == AlignmentType.MACHINE) {
            this.machineAlignButton.setSelected(true);
        } else {
            this.explicitAlignButton.setSelected(true);
            int minimumAlignment = ((CompEditorModel)this.model).getExplicitMinimumAlignment();
            minimumAlignmentStr = this.model.showHexNumbers ? CompositeViewerModel.getHexString(minimumAlignment, true) : Integer.toString(minimumAlignment);
        }
        this.explicitAlignTextField.setText(minimumAlignmentStr);
    }

    public void refreshGUIActualAlignmentValue() {
        int actualAlignment = ((CompEditorModel)this.model).getActualAlignment();
        String alignmentStr = this.model.showHexNumbers ? CompositeViewerModel.getHexString(actualAlignment, true) : Integer.toString(actualAlignment);
        this.actualAlignmentValueTextField.setText(alignmentStr);
    }

    public int getCompositeSize() {
        return Integer.decode(this.sizeTextField.getText());
    }

    public void setCompositeSize(int size) {
        boolean sizeIsEditable = ((CompEditorModel)this.model).isSizeEditable();
        if (this.sizeTextField.isEditable() != sizeIsEditable) {
            this.setSizeEditable(sizeIsEditable);
        }
        String sizeStr = this.model.showHexNumbers ? CompositeViewerModel.getHexString(size, true) : Integer.toString(size);
        this.sizeTextField.setText(sizeStr);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void dragUnderFeedback(boolean ok, DropTargetDragEvent e) {
        CompositeEditorPanel.CompositeTable compositeTable = this.table;
        synchronized (compositeTable) {
            int dropAction = e.getDropAction();
            boolean actionChanged = false;
            if (dropAction != this.lastDndAction) {
                actionChanged = true;
                this.lastDndAction = dropAction;
            }
            if (this.table.isEditing()) {
                this.table.editingCanceled(null);
            }
            boolean inserting = false;
            if (dropAction == 1) {
                inserting = true;
            }
            this.dndTableCellRenderer.selectRange(inserting);
            this.dndDtiCellRenderer.selectRange(inserting);
            Point p = e.getLocation();
            int row = this.table.rowAtPoint(p);
            boolean setRow = this.dndTableCellRenderer.setRowForFeedback(row);
            boolean setDtiRow = this.dndDtiCellRenderer.setRowForFeedback(row);
            if (actionChanged || setRow || setDtiRow) {
                this.table.repaint();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void undoDragUnderFeedback() {
        CompositeEditorPanel.CompositeTable compositeTable = this.table;
        synchronized (compositeTable) {
            this.dndTableCellRenderer.setRowForFeedback(-1);
            this.dndDtiCellRenderer.setRowForFeedback(-1);
            this.table.repaint();
        }
    }

    @Override
    public void showUndefinedStateChanged(boolean showUndefinedBytes) {
    }
}

