/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.cmd.module;

import ghidra.framework.cmd.Command;
import ghidra.framework.model.DomainObject;
import ghidra.program.model.listing.Listing;
import ghidra.program.model.listing.Program;
import ghidra.program.model.listing.ProgramFragment;
import ghidra.program.model.listing.ProgramModule;
import ghidra.util.exception.DuplicateNameException;

public class RenameCmd
implements Command {
    private String oldName;
    private String newName;
    private boolean isModule;
    private String cmdName;
    private String statusMsg;
    private String treeName;
    private boolean ignoreDuplicateName;

    public RenameCmd(String treeName, boolean isModule, String oldName, String newName, boolean ignoreDuplicateName) {
        this.treeName = treeName;
        this.isModule = isModule;
        this.oldName = oldName;
        this.newName = newName;
        this.ignoreDuplicateName = ignoreDuplicateName;
        this.cmdName = isModule ? "Rename Folder" : "Rename Fragment";
    }

    public RenameCmd(String treeName, boolean isModule, String oldName, String newName) {
        this(treeName, isModule, oldName, newName, false);
    }

    public boolean applyTo(DomainObject obj) {
        Program program = (Program)obj;
        return this.setName(program, this.oldName, this.newName);
    }

    public String getStatusMsg() {
        return this.statusMsg;
    }

    public String getName() {
        return this.cmdName;
    }

    private boolean setName(Program program, String oldN, String newN) {
        Listing listing = program.getListing();
        try {
            if (this.isModule) {
                ProgramModule m = listing.getModule(this.treeName, oldN);
                m.setName(newN);
            } else {
                ProgramFragment f = listing.getFragment(this.treeName, oldN);
                f.setName(newN);
            }
            return true;
        }
        catch (DuplicateNameException e) {
            if (this.ignoreDuplicateName) {
                this.newName = this.oldName;
                return true;
            }
            this.statusMsg = "Name already exists for " + newN;
            return false;
        }
    }
}

