/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.cmd.equate;

import ghidra.framework.cmd.Command;
import ghidra.framework.model.DomainObject;
import ghidra.program.model.address.Address;
import ghidra.program.model.listing.Program;
import ghidra.program.model.symbol.Equate;
import ghidra.program.model.symbol.EquateTable;
import ghidra.util.exception.DuplicateNameException;
import ghidra.util.exception.InvalidInputException;

public class SetEquateCmd
implements Command {
    private String equateName;
    private Address addr;
    private int opIndex;
    private long equateValue;
    private Equate equate;
    private String msg;

    public SetEquateCmd(String equateName, Address addr, int opIndex, long equateValue) {
        this.equateName = equateName;
        this.addr = addr;
        this.opIndex = opIndex;
        this.equateValue = equateValue;
    }

    public String getName() {
        return "Set Equate";
    }

    public boolean applyTo(DomainObject obj) {
        EquateTable equateTable = ((Program)obj).getEquateTable();
        this.equate = equateTable.getEquate(this.equateName);
        if (this.existsWithDifferentValue(this.equate)) {
            this.msg = "Equate named " + this.equateName + " already exists with value of " + this.equate.getValue() + ".";
            return false;
        }
        if (this.equate == null) {
            try {
                this.equate = equateTable.createEquate(this.equateName, this.equateValue);
            }
            catch (DuplicateNameException e) {
                this.msg = "Equate named " + this.equateName + " already exists";
                return false;
            }
            catch (InvalidInputException e) {
                this.msg = "Invalid equate name: " + this.equateName;
                return false;
            }
        }
        this.equate.addReference(this.addr, this.opIndex);
        return true;
    }

    private boolean existsWithDifferentValue(Equate e) {
        return e != null && e.getValue() != this.equateValue;
    }

    public Equate getEquate() {
        return this.equate;
    }

    public String getStatusMsg() {
        return this.msg;
    }
}

