/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.demangler.gnu;

import ghidra.app.util.demangler.DemanglerOptions;
import ghidra.app.util.demangler.gnu.GnuDemanglerFormat;

public class GnuDemanglerOptions
extends DemanglerOptions {
    public static final String GNU_DEMANGLER_V2_24 = "demangler_gnu_v2_24";
    public static final String GNU_DEMANGLER_V2_33_1 = "demangler_gnu_v2_33_1";
    public static final String GNU_DEMANGLER_DEFAULT = "demangler_gnu_v2_33_1";
    private final GnuDemanglerFormat format;
    private final boolean isDeprecated;

    public GnuDemanglerOptions() {
        this(GnuDemanglerFormat.AUTO);
    }

    public GnuDemanglerOptions(GnuDemanglerFormat format) {
        this(format, !format.isModernFormat());
    }

    public GnuDemanglerOptions(GnuDemanglerFormat format, boolean isDeprecated) {
        this.format = format;
        this.isDeprecated = isDeprecated;
        if (!format.isAvailable(isDeprecated)) {
            throw new IllegalArgumentException(format.name() + " is not available in the " + this.getDemanglerName());
        }
    }

    public GnuDemanglerOptions(DemanglerOptions copy) {
        super(copy);
        if (copy instanceof GnuDemanglerOptions) {
            GnuDemanglerOptions gCopy = (GnuDemanglerOptions)copy;
            this.format = gCopy.format;
            this.isDeprecated = gCopy.isDeprecated;
        } else {
            this.format = GnuDemanglerFormat.AUTO;
            this.isDeprecated = false;
        }
    }

    private GnuDemanglerOptions(GnuDemanglerOptions copy, GnuDemanglerFormat format, boolean deprecated) {
        super((DemanglerOptions)copy);
        this.format = format;
        this.isDeprecated = deprecated;
    }

    public String getDemanglerName() {
        return this.isDeprecated ? GNU_DEMANGLER_V2_24 : "demangler_gnu_v2_33_1";
    }

    public GnuDemanglerOptions withDemanglerFormat(GnuDemanglerFormat demanglerFormat, boolean useDeprecated) throws IllegalArgumentException {
        if (this.format == demanglerFormat && this.isDeprecated == useDeprecated) {
            return this;
        }
        if (demanglerFormat.isAvailable(useDeprecated)) {
            return new GnuDemanglerOptions(this, demanglerFormat, useDeprecated);
        }
        throw new IllegalArgumentException(demanglerFormat.name() + " is not available in the " + this.getDemanglerName());
    }

    public String getDemanglerApplicationArguments() {
        if (this.format == GnuDemanglerFormat.AUTO) {
            return "";
        }
        return "-s " + this.format.getFormat();
    }

    public GnuDemanglerFormat getDemanglerFormat() {
        return this.format;
    }

    public String toString() {
        return "{\n\tdoDisassembly: " + this.doDisassembly() + ",\n\tapplySignature: " + this.applySignature() + ",\n\tdemangleOnlyKnownPatterns: " + this.demangleOnlyKnownPatterns() + ",\n\tdemanglerName: " + this.getDemanglerName() + ",\n\tdemanglerApplicationArguments: " + this.getDemanglerApplicationArguments() + ",\n}";
    }
}

