/*
 * Decompiled with CFR 0.152.
 */
package org.jungrapht.visualization.transform;

import java.awt.geom.Point2D;
import org.jungrapht.visualization.MultiLayerTransformer;
import org.jungrapht.visualization.VisualizationViewer;
import org.jungrapht.visualization.control.GraphElementAccessor;
import org.jungrapht.visualization.control.LensGraphMouse;
import org.jungrapht.visualization.control.LensTransformSupport;
import org.jungrapht.visualization.control.TransformSupport;
import org.jungrapht.visualization.transform.AbstractLensSupport;
import org.jungrapht.visualization.transform.LensSupport;
import org.jungrapht.visualization.transform.LensTransformer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LayoutLensSupport<V, E, M extends LensGraphMouse>
extends AbstractLensSupport<V, E, M>
implements LensSupport<M> {
    private static final Logger log = LoggerFactory.getLogger(LayoutLensSupport.class);
    protected GraphElementAccessor<V, E> pickSupport;

    public static <V, E, M extends LensGraphMouse> Builder<V, E, M, ?, ?> builder(VisualizationViewer<V, E> vv) {
        return new Builder(vv);
    }

    protected LayoutLensSupport(Builder<V, E, M, ?, ?> builder) {
        super(builder);
        this.lensTransformer = builder.lensTransformer;
        this.pickSupport = this.vv.getPickSupport();
    }

    protected LayoutLensSupport(VisualizationViewer<V, E> vv, LensTransformer lensTransformer, M lensGraphMouse) {
        super(vv, lensGraphMouse);
        this.lensTransformer = lensTransformer;
        this.pickSupport = vv.getPickSupport();
    }

    @Override
    public void activate() {
        super.activate();
        if (this.allowed()) {
            if (this.lensPaintable == null) {
                this.lensPaintable = new AbstractLensSupport.LensPaintable(this.lensTransformer, this.useGradient);
            }
            if (this.lensControls == null) {
                this.lensControls = new AbstractLensSupport.LensControls(this.lensTransformer);
            }
            Point2D viewCenter = this.vv.getCenter();
            MultiLayerTransformer multiLayerTransformer = this.vv.getRenderContext().getMultiLayerTransformer();
            this.lensTransformer.getLens().setCenter(multiLayerTransformer.getTransformer(MultiLayerTransformer.Layer.VIEW).inverseTransform(viewCenter));
            double scale = multiLayerTransformer.getTransformer(MultiLayerTransformer.Layer.VIEW).getScale();
            log.trace("view scale is {}", (Object)scale);
            this.lensTransformer.getLens().setRadius((double)Math.min(this.vv.getWidth(), this.vv.getHeight()) / scale / 3.0);
            this.vv.getRenderContext().getMultiLayerTransformer().setTransformer(MultiLayerTransformer.Layer.LAYOUT, this.lensTransformer);
            this.vv.prependPreRenderPaintable(this.lensPaintable);
            this.vv.addPostRenderPaintable(this.lensControls);
            this.vv.setGraphMouse(this.lensGraphMouse);
            this.vv.setToolTipText("<html><center>Mouse-Drag the Lens center to move it<p>Mouse-Drag the Lens edge or handles to resize it<p>MouseWheel inside lens changes magnification</center></html>");
            this.vv.setTransformSupport(new LensTransformSupport());
            this.vv.repaint();
        }
    }

    @Override
    public void deactivate() {
        super.deactivate();
        if (this.lensTransformer != null) {
            this.vv.removePreRenderPaintable(this.lensPaintable);
            this.vv.removePostRenderPaintable(this.lensControls);
            this.vv.getRenderContext().getMultiLayerTransformer().setTransformer(MultiLayerTransformer.Layer.LAYOUT, this.lensTransformer.getDelegate());
        }
        this.vv.setToolTipText(this.defaultToolTipText);
        this.vv.setTransformSupport(new TransformSupport());
        this.vv.repaint();
    }

    public static class Builder<V, E, M extends LensGraphMouse, T extends LayoutLensSupport<V, E, M>, B extends Builder<V, E, M, T, B>>
    extends AbstractLensSupport.Builder<V, E, M, T, B> {
        protected GraphElementAccessor<V, E> pickSupport;

        protected Builder(VisualizationViewer<V, E> vv) {
            super(vv);
        }

        @Override
        public T build() {
            return (T)new LayoutLensSupport(this);
        }
    }
}

