/*
 * Decompiled with CFR 0.152.
 */
package org.jungrapht.visualization.spatial;

import java.awt.Shape;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import javax.swing.SwingUtilities;
import org.jungrapht.visualization.layout.event.LayoutStateChange;
import org.jungrapht.visualization.layout.event.LayoutVertexPositionChange;
import org.jungrapht.visualization.layout.model.LayoutModel;
import org.jungrapht.visualization.layout.model.Point;
import org.jungrapht.visualization.spatial.Spatial;
import org.jungrapht.visualization.spatial.rtree.TreeNode;

public class SwingThreadSpatial<T, NT>
implements Spatial<T, NT> {
    protected Spatial<T, NT> spatial;
    protected Runnable after = () -> {};

    public static <T, NT> SwingThreadSpatial<T, NT> of(Spatial<T, NT> delegate) {
        return new SwingThreadSpatial<T, NT>(delegate);
    }

    protected SwingThreadSpatial(Spatial<T, NT> delegate) {
        this.spatial = delegate;
    }

    public Spatial<T, NT> getSpatial() {
        return this.spatial;
    }

    public void layoutStateChanged(LayoutStateChange.Event evt) {
        this.setActive(!evt.active);
        if (!evt.active) {
            this.recalculate();
            this.getLayoutModel().getModelChangeSupport().fireModelChanged();
        }
    }

    public Spatial<T, NT> after(Runnable after) {
        this.after = after;
        return this;
    }

    @Override
    public void setActive(boolean active) {
        this.spatial.setActive(active);
    }

    @Override
    public boolean isActive() {
        return this.spatial.isActive();
    }

    @Override
    public List<Shape> getGrid() {
        return this.spatial.getGrid();
    }

    @Override
    public Collection<Shape> getPickShapes() {
        return this.spatial.getPickShapes();
    }

    @Override
    public void clear() {
        SwingUtilities.invokeLater(() -> {
            this.spatial.clear();
            this.after.run();
        });
    }

    @Override
    public void recalculate() {
        SwingUtilities.invokeLater(() -> {
            this.spatial.recalculate();
            this.after.run();
        });
    }

    @Override
    public Rectangle2D getLayoutArea() {
        return this.spatial.getLayoutArea();
    }

    @Override
    public void setBounds(Rectangle2D bounds) {
        this.spatial.setBounds(bounds);
    }

    @Override
    public Rectangle2D getUnion(Rectangle2D rect, Point2D p) {
        return this.spatial.getUnion(rect, p);
    }

    @Override
    public Rectangle2D getUnion(Rectangle2D rect, double x, double y) {
        return this.spatial.getUnion(rect, x, y);
    }

    @Override
    public void update(T element, Point location) {
        this.spatial.update(element, location);
    }

    @Override
    public Set<? extends TreeNode> getContainingLeafs(Point2D p) {
        return this.spatial.getContainingLeafs(p);
    }

    @Override
    public Set<? extends TreeNode> getContainingLeafs(double x, double y) {
        return this.spatial.getContainingLeafs(x, y);
    }

    @Override
    public TreeNode getContainingLeaf(Object element) {
        return this.spatial.getContainingLeaf(element);
    }

    @Override
    public Set<T> getVisibleElements(Shape shape) {
        return this.spatial.getVisibleElements(shape);
    }

    @Override
    public T getClosestElement(Point2D p) {
        return this.spatial.getClosestElement(p);
    }

    @Override
    public T getClosestElement(double x, double y) {
        return this.spatial.getClosestElement(x, y);
    }

    @Override
    public LayoutModel getLayoutModel() {
        return this.spatial.getLayoutModel();
    }

    public void layoutVertexPositionChanged(LayoutVertexPositionChange.Event<NT> evt) {
        SwingUtilities.invokeLater(() -> this.spatial.layoutVertexPositionChanged(evt));
    }

    public void layoutVertexPositionChanged(LayoutVertexPositionChange.GraphEvent<NT> evt) {
        SwingUtilities.invokeLater(() -> this.spatial.layoutVertexPositionChanged(evt));
    }
}

