/*
 * Decompiled with CFR 0.152.
 */
package docking.wizard;

import docking.wizard.IllegalPanelStateException;
import docking.wizard.MagePanel;
import docking.wizard.PanelManager;
import docking.wizard.WizardManager;
import docking.wizard.WizardPanel;
import docking.wizard.WizardPanelDisplayability;
import docking.wizard.WizardState;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.KeyboardFocusManager;
import java.awt.Window;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Stack;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JRootPane;
import javax.swing.JScrollBar;
import javax.swing.JWindow;

public abstract class AbstractMagePanelManager<T>
implements PanelManager {
    private List<MagePanel<T>> panels;
    private Stack<Integer> panelPath = new Stack();
    private int currentIndex;
    private WizardState<T> state;
    private WizardManager wizardManager;
    private String statusMessage;

    protected AbstractMagePanelManager(WizardState<T> initialState) {
        this.state = initialState;
    }

    protected abstract Collection<? extends MagePanel<T>> createPanels();

    protected WizardState<T> getState() {
        return this.state;
    }

    @Override
    public void cancel() {
    }

    @Override
    public final WizardManager getWizardManager() {
        return this.wizardManager;
    }

    @Override
    public final void setWizardManager(WizardManager wm) {
        this.wizardManager = wm;
    }

    @Override
    public Dimension getPanelSize() {
        int minWidth = -1;
        int minHeight = -1;
        for (MagePanel<T> panel : this.getPanels()) {
            JComponent component = (JComponent)((Object)panel);
            Dimension preferredSize = component.getPreferredSize();
            if (preferredSize.width > minWidth) {
                minWidth = preferredSize.width;
            }
            if (preferredSize.height <= minHeight) continue;
            minHeight = preferredSize.height;
        }
        Dimension dimension = new Dimension(minWidth, minHeight);
        JScrollBar scrollBar = new JScrollBar(1);
        Dimension scrollBarSize = scrollBar.getMinimumSize();
        dimension.width += scrollBarSize.width * 2;
        return dimension;
    }

    @Override
    public final String getStatusMessage() {
        String tmp = this.statusMessage;
        this.statusMessage = null;
        return tmp;
    }

    protected final void setStatusMessage(String msg) {
        this.statusMessage = msg;
        this.wizardManager.setStatusMessage(msg);
    }

    protected void initializeHook() {
    }

    @Override
    public final void initialize() {
        for (MagePanel<T> panel : this.getPanels()) {
            panel.initialize();
        }
        this.setCurrentIndex(-1);
        this.panelPath.clear();
        this.statusMessage = null;
        this.initializeHook();
    }

    protected final MagePanel<T> getCurrentPanel() {
        int index = this.getCurrentIndex();
        List<MagePanel<T>> panelList = this.getPanels();
        if (index < 0 || index >= panelList.size()) {
            return null;
        }
        return panelList.get(index);
    }

    @Override
    public final boolean hasNextPanel() {
        MagePanel<T> currentPanel = this.getCurrentPanel();
        WizardState pretendState = (WizardState)this.state.clone();
        if (currentPanel != null) {
            currentPanel.updateStateObjectWithPanelInfo(pretendState);
        }
        MagePanel<T> panel = null;
        for (int index = this.getCurrentIndex() + 1; index < this.getPanels().size(); ++index) {
            panel = this.getPanels().get(index);
            WizardPanelDisplayability displayability = panel.getPanelDisplayabilityAndUpdateState(pretendState);
            if (displayability != WizardPanelDisplayability.MUST_BE_DISPLAYED && displayability != WizardPanelDisplayability.CAN_BE_DISPLAYED) continue;
            return true;
        }
        return false;
    }

    @Override
    public final boolean hasPreviousPanel() {
        return this.panelPath.size() > 0;
    }

    @Override
    public final boolean canFinish() {
        MagePanel<T> currentPanel = this.getCurrentPanel();
        WizardState pretendState = (WizardState)this.state.clone();
        if (currentPanel != null) {
            currentPanel.updateStateObjectWithPanelInfo(pretendState);
        }
        MagePanel<T> panel = null;
        for (int index = this.getCurrentIndex() + 1; index < this.getPanels().size(); ++index) {
            panel = this.getPanels().get(index);
            WizardPanelDisplayability displayability = panel.getPanelDisplayabilityAndUpdateState(pretendState);
            if (displayability != WizardPanelDisplayability.MUST_BE_DISPLAYED) continue;
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final WizardPanel getNextPanel() throws IllegalPanelStateException {
        Window window = this.getWindow();
        Cursor originalCursor = this.getCursor(window);
        try {
            this.setCursor(window, Cursor.getPredefinedCursor(3));
            WizardPanel wizardPanel = this.doGetNextPanel();
            return wizardPanel;
        }
        finally {
            this.setCursor(window, originalCursor);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public WizardPanel getInitialPanel() throws IllegalPanelStateException {
        Window window = this.getWindow();
        Cursor originalCursor = this.getCursor(window);
        try {
            this.setCursor(window, Cursor.getPredefinedCursor(3));
            this.panelPath.clear();
            MagePanel<T> panel = this.panels.get(0);
            panel.getPanelDisplayabilityAndUpdateState(this.state);
            panel.enterPanel(this.state);
            this.setCurrentIndex(0);
            MagePanel<T> magePanel = panel;
            return magePanel;
        }
        finally {
            this.setCursor(window, originalCursor);
        }
    }

    private WizardPanel doGetNextPanel() throws IllegalPanelStateException {
        MagePanel<T> currentPanel = this.getCurrentPanel();
        if (currentPanel != null) {
            currentPanel.leavePanel(this.state);
            this.panelPath.push(this.getCurrentIndex());
        }
        MagePanel<T> panel = null;
        for (int index = this.getCurrentIndex() + 1; index < this.getPanels().size(); ++index) {
            panel = this.getPanels().get(index);
            WizardPanelDisplayability displayability = panel.getPanelDisplayabilityAndUpdateState(this.state);
            if (displayability != WizardPanelDisplayability.MUST_BE_DISPLAYED && displayability != WizardPanelDisplayability.CAN_BE_DISPLAYED) continue;
            panel.enterPanel(this.state);
            this.setCurrentIndex(index);
            return panel;
        }
        return null;
    }

    private void setCursor(Window window, Cursor cursor) {
        if (window == null) {
            return;
        }
        window.setCursor(cursor);
        if (window instanceof JWindow) {
            JRootPane rootPane = ((JWindow)window).getRootPane();
            rootPane.paintImmediately(rootPane.getBounds());
        } else if (window instanceof JDialog) {
            JRootPane rootPane = ((JDialog)window).getRootPane();
            rootPane.paintImmediately(rootPane.getBounds());
        } else if (window instanceof JFrame) {
            JRootPane rootPane = ((JFrame)window).getRootPane();
            rootPane.paintImmediately(rootPane.getBounds());
        }
    }

    private Cursor getCursor(Window window) {
        if (window == null) {
            return null;
        }
        return window.getCursor();
    }

    private Window getWindow() {
        KeyboardFocusManager focusManager = KeyboardFocusManager.getCurrentKeyboardFocusManager();
        return focusManager.getActiveWindow();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final WizardPanel getPreviousPanel() throws IllegalPanelStateException {
        Window window = this.getWindow();
        Cursor originalCursor = this.getCursor(window);
        try {
            this.setCursor(window, Cursor.getPredefinedCursor(3));
            WizardPanel wizardPanel = this.doGetPreviousPanel();
            return wizardPanel;
        }
        finally {
            this.setCursor(window, originalCursor);
        }
    }

    private WizardPanel doGetPreviousPanel() throws IllegalPanelStateException {
        if (this.hasPreviousPanel()) {
            MagePanel<T> currentPanel = this.getCurrentPanel();
            if (currentPanel != null) {
                currentPanel.leavePanel(this.state);
            }
            int previousIndex = this.panelPath.pop();
            MagePanel<T> panel = this.getPanels().get(previousIndex);
            panel.enterPanel(this.state);
            this.setCurrentIndex(previousIndex);
            return panel;
        }
        return null;
    }

    protected abstract void doFinish() throws IllegalPanelStateException;

    @Override
    public final void finish() throws IllegalPanelStateException {
        this.getWizardManager().disableNavigation();
        MagePanel<T> currentPanel = this.getCurrentPanel();
        if (currentPanel != null) {
            currentPanel.leavePanel(this.state);
        }
        MagePanel<T> panel = null;
        for (int index = this.getCurrentIndex() + 1; index < this.getPanels().size(); ++index) {
            panel = this.getPanels().get(index);
            panel.getPanelDisplayabilityAndUpdateState(this.state);
        }
        this.doFinish();
        this.initialize();
        this.wizardManager.enableNavigation();
    }

    protected final List<MagePanel<T>> getPanels() {
        if (this.panels == null) {
            this.panels = Collections.unmodifiableList(new ArrayList<MagePanel<T>>(this.createPanels()));
            for (MagePanel<T> magePanel : this.panels) {
                magePanel.addDependencies(this.state);
            }
        }
        return this.panels;
    }

    private int getCurrentIndex() {
        return this.currentIndex;
    }

    private void setCurrentIndex(int currentIndex) {
        this.currentIndex = currentIndex;
    }
}

