/*
 * Decompiled with CFR 0.152.
 */
package docking.widgets.table.constrainteditor;

import docking.DockingUtils;
import docking.widgets.label.GDHtmlLabel;
import docking.widgets.table.constraint.ColumnConstraint;
import docking.widgets.table.constraint.StringColumnConstraint;
import docking.widgets.table.constrainteditor.AbstractColumnConstraintEditor;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class StringConstraintEditor
extends AbstractColumnConstraintEditor<String> {
    protected JTextField textField;
    private String errorMessage;
    private JLabel infoLabel;

    public StringConstraintEditor(StringColumnConstraint constraint, String errorMessage) {
        super(constraint);
        this.errorMessage = errorMessage;
    }

    @Override
    protected Component buildInlineEditorComponent() {
        JPanel panel = new JPanel(new BorderLayout());
        this.textField = new JTextField();
        this.textField.getDocument().addUndoableEditListener(e -> this.valueChanged());
        DockingUtils.installUndoRedo(this.textField);
        panel.add((Component)this.textField, "Center");
        this.infoLabel = new GDHtmlLabel("abc");
        this.infoLabel.setForeground(Color.RED);
        this.infoLabel.setHorizontalAlignment(0);
        panel.add((Component)this.infoLabel, "South");
        return panel;
    }

    @Override
    protected ColumnConstraint<String> getValueFromComponent() {
        String newPatternString = this.textField.getText().trim();
        return this.getConstraint().copy(newPatternString);
    }

    @Override
    public void reset() {
        this.setValue(this.getConstraint().copy(""));
    }

    @Override
    protected boolean checkEditorValueValidity() {
        return this.getConstraint().isValidPatternString(this.textField.getText().trim());
    }

    @Override
    protected void updateInfoMessage(boolean isValid) {
        String status = StringConstraintEditor.formatStatus(isValid ? "&nbsp;" : this.errorMessage, true);
        this.infoLabel.setText(status);
    }

    @Override
    public String getErrorMessage() {
        if (this.hasValidValue()) {
            return "";
        }
        return "Please enter a pattern to match (You may use * and ? globbing characters)";
    }

    @Override
    protected void updateEditorComponent() {
        if (this.hasEditorComponents()) {
            this.textField.setText(this.getConstraint().getPatternString());
            this.textField.setCaretPosition(0);
        }
    }

    private StringColumnConstraint getConstraint() {
        return (StringColumnConstraint)this.currentConstraint;
    }
}

