/*
 * Decompiled with CFR 0.152.
 */
package docking.options.editor;

import docking.options.editor.SwatchPanel;
import java.awt.Color;
import java.awt.Dimension;
import java.util.List;
import javax.swing.UIManager;

class HistorySwatchPanel
extends SwatchPanel {
    private List<Color> recentColors;

    HistorySwatchPanel(List<Color> recentColors) {
        this.setRecentColors(recentColors);
    }

    void setRecentColors(List<Color> recentColors) {
        this.recentColors = recentColors;
        this.initColors();
    }

    @Override
    protected void initValues() {
        this.swatchSize = UIManager.getDimension("ColorChooser.swatchesRecentSwatchSize");
        this.numSwatches = new Dimension(5, 7);
        this.gap = new Dimension(1, 1);
    }

    @Override
    protected void initColors() {
        Color defaultRecentColor = UIManager.getColor("ColorChooser.swatchesDefaultRecentColor");
        int numColors = this.numSwatches.width * this.numSwatches.height;
        this.colors = new Color[numColors];
        for (int i = 0; i < numColors; ++i) {
            this.colors[i] = defaultRecentColor;
        }
        if (this.recentColors != null && this.recentColors.size() > 0) {
            int recentColorCount = this.recentColors.size();
            for (int i = 0; i < recentColorCount; ++i) {
                this.colors[i] = this.recentColors.get(i);
            }
            return;
        }
    }
}

