/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.model.lang;

import ghidra.app.plugin.processors.sleigh.FixedHandle;
import ghidra.app.plugin.processors.sleigh.ParserWalker;
import ghidra.app.plugin.processors.sleigh.PcodeEmit;
import ghidra.app.plugin.processors.sleigh.PcodeEmitObjects;
import ghidra.app.plugin.processors.sleigh.SleighException;
import ghidra.app.plugin.processors.sleigh.SleighLanguage;
import ghidra.app.plugin.processors.sleigh.SleighParserContext;
import ghidra.app.plugin.processors.sleigh.template.ConstTpl;
import ghidra.app.plugin.processors.sleigh.template.ConstructTpl;
import ghidra.app.plugin.processors.sleigh.template.OpTpl;
import ghidra.app.plugin.processors.sleigh.template.VarnodeTpl;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressFactory;
import ghidra.program.model.lang.InjectContext;
import ghidra.program.model.lang.InjectPayload;
import ghidra.program.model.lang.UnknownInstructionException;
import ghidra.program.model.listing.Program;
import ghidra.program.model.pcode.AttributeId;
import ghidra.program.model.pcode.ElementId;
import ghidra.program.model.pcode.Encoder;
import ghidra.program.model.pcode.PcodeOp;
import ghidra.program.model.pcode.Varnode;
import ghidra.util.xml.SpecXmlUtils;
import ghidra.xml.XmlElement;
import ghidra.xml.XmlParseException;
import ghidra.xml.XmlPullParser;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class InjectPayloadSleigh
implements InjectPayload {
    private ConstructTpl pcodeTemplate;
    private int paramShift;
    private boolean isfallthru;
    private boolean incidentalCopy;
    private InjectPayload.InjectParameter[] inputlist;
    private InjectPayload.InjectParameter[] output;
    private int subType;
    protected String name;
    protected int type;
    protected String source;
    private String parseString;

    protected InjectPayloadSleigh(ConstructTpl pcode, InjectPayloadSleigh failedPayload) {
        this.pcodeTemplate = pcode;
        this.paramShift = failedPayload.paramShift;
        this.incidentalCopy = failedPayload.incidentalCopy;
        this.inputlist = failedPayload.inputlist;
        this.output = failedPayload.output;
        this.subType = failedPayload.subType;
        this.name = failedPayload.name;
        this.type = failedPayload.type;
        this.source = failedPayload.source + "_FAILED";
        this.parseString = null;
        this.isfallthru = this.computeFallThru();
    }

    protected InjectPayloadSleigh(ConstructTpl pcode, int tp, String nm) {
        this.pcodeTemplate = pcode;
        this.paramShift = 0;
        this.incidentalCopy = false;
        this.inputlist = new InjectPayload.InjectParameter[0];
        this.output = new InjectPayload.InjectParameter[0];
        this.subType = -1;
        this.name = nm;
        this.type = tp;
        this.source = "FAILED";
        this.parseString = null;
        this.isfallthru = this.computeFallThru();
    }

    protected InjectPayloadSleigh(String sourceName) {
        this.name = null;
        this.type = -1;
        this.subType = -1;
        this.incidentalCopy = false;
        this.inputlist = null;
        this.output = null;
        this.source = sourceName;
    }

    public InjectPayloadSleigh(String nm, int tp, String sourceName) {
        this.name = nm;
        this.type = tp;
        this.subType = -1;
        this.inputlist = null;
        this.output = null;
        this.source = sourceName;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public int getType() {
        return this.type;
    }

    @Override
    public String getSource() {
        return this.source;
    }

    @Override
    public int getParamShift() {
        return this.paramShift;
    }

    protected void setInputParameters(List<InjectPayload.InjectParameter> in) {
        this.inputlist = new InjectPayload.InjectParameter[in.size()];
        in.toArray(this.inputlist);
    }

    protected void setOutputParameters(List<InjectPayload.InjectParameter> out) {
        this.output = new InjectPayload.InjectParameter[out.size()];
        out.toArray(this.output);
    }

    @Override
    public InjectPayload.InjectParameter[] getInput() {
        return this.inputlist;
    }

    @Override
    public InjectPayload.InjectParameter[] getOutput() {
        return this.output;
    }

    @Override
    public boolean isErrorPlaceholder() {
        return false;
    }

    @Override
    public void inject(InjectContext context, PcodeEmit emit) {
        ParserWalker walker = emit.getWalker();
        try {
            walker.snippetState();
            this.setupParameters(context, walker);
            emit.build(this.pcodeTemplate, -1);
        }
        catch (Exception e) {
            e.printStackTrace();
            return;
        }
        emit.resolveRelatives();
    }

    @Override
    public PcodeOp[] getPcode(Program program, InjectContext con) {
        SleighParserContext protoContext = new SleighParserContext(con.baseAddr, con.nextAddr, con.refAddr, con.callAddr);
        ParserWalker walker = new ParserWalker(protoContext);
        PcodeEmitObjects emit = new PcodeEmitObjects(walker);
        this.inject(con, emit);
        return emit.getPcodeOp();
    }

    @Override
    public boolean isFallThru() {
        return this.isfallthru;
    }

    @Override
    public boolean isIncidentalCopy() {
        return this.incidentalCopy;
    }

    private boolean computeFallThru() {
        OpTpl[] opVec = this.pcodeTemplate.getOpVec();
        if (opVec.length <= 0) {
            return true;
        }
        switch (opVec[opVec.length - 1].getOpcode()) {
            case 4: 
            case 6: 
            case 10: {
                return false;
            }
        }
        return true;
    }

    protected void orderParameters() {
        int id = 0;
        for (InjectPayload.InjectParameter element : this.inputlist) {
            element.setIndex(id);
            ++id;
        }
        for (InjectPayload.InjectParameter element : this.output) {
            element.setIndex(id);
            ++id;
        }
    }

    @Override
    public void encode(Encoder encoder) throws IOException {
        encoder.openElement(ElementId.ELEM_PCODE);
        if (this.type == 3 && this.subType >= 0) {
            encoder.writeString(AttributeId.ATTRIB_INJECT, this.subType == 0 ? "uponentry" : "uponreturn");
        }
        if (this.paramShift != 0) {
            encoder.writeSignedInteger(AttributeId.ATTRIB_PARAMSHIFT, this.paramShift);
        }
        if (this.pcodeTemplate == null) {
            encoder.writeBool(AttributeId.ATTRIB_DYNAMIC, true);
        }
        if (this.incidentalCopy) {
            encoder.writeBool(AttributeId.ATTRIB_INCIDENTALCOPY, this.incidentalCopy);
        }
        for (InjectPayload.InjectParameter param : this.inputlist) {
            encoder.openElement(ElementId.ELEM_INPUT);
            encoder.writeString(AttributeId.ATTRIB_NAME, param.getName());
            encoder.writeSignedInteger(AttributeId.ATTRIB_SIZE, param.getSize());
            encoder.closeElement(ElementId.ELEM_INPUT);
        }
        for (InjectPayload.InjectParameter param : this.output) {
            encoder.openElement(ElementId.ELEM_OUTPUT);
            encoder.writeString(AttributeId.ATTRIB_NAME, param.getName());
            encoder.writeSignedInteger(AttributeId.ATTRIB_SIZE, param.getSize());
            encoder.closeElement(ElementId.ELEM_OUTPUT);
        }
        if (this.pcodeTemplate != null) {
            encoder.openElement(ElementId.ELEM_BODY);
            encoder.writeString(AttributeId.ATTRIB_CONTENT, " local tmp:1 = 0; ");
            encoder.closeElement(ElementId.ELEM_BODY);
        }
        encoder.closeElement(ElementId.ELEM_PCODE);
    }

    @Override
    public void restoreXml(XmlPullParser parser, SleighLanguage language) throws XmlParseException {
        ArrayList<InjectPayload.InjectParameter> inlist = new ArrayList<InjectPayload.InjectParameter>();
        ArrayList<InjectPayload.InjectParameter> outlist = new ArrayList<InjectPayload.InjectParameter>();
        XmlElement el = parser.start(new String[0]);
        String injectstr = el.getAttribute("inject");
        if (injectstr != null) {
            if (injectstr.equals("uponentry")) {
                this.subType = 0;
            } else if (injectstr.equals("uponreturn")) {
                this.subType = 1;
            } else {
                throw new XmlParseException("Unknown \"inject\" attribute value: " + injectstr);
            }
        }
        String pshiftstr = el.getAttribute("paramshift");
        this.paramShift = SpecXmlUtils.decodeInt((String)pshiftstr);
        boolean isDynamic = SpecXmlUtils.decodeBoolean((String)el.getAttribute("dynamic"));
        this.incidentalCopy = SpecXmlUtils.decodeBoolean((String)el.getAttribute("incidentalcopy"));
        XmlElement subel = parser.peek();
        while (subel.isStart()) {
            subel = parser.start(new String[0]);
            if (subel.getName().equals("body")) {
                this.parseString = parser.end(subel).getText();
                break;
            }
            String paramName = subel.getAttribute("name");
            int size = SpecXmlUtils.decodeInt((String)subel.getAttribute("size"));
            InjectPayload.InjectParameter param = new InjectPayload.InjectParameter(paramName, size);
            if (subel.getName().equals("input")) {
                inlist.add(param);
            } else {
                outlist.add(param);
            }
            parser.end(subel);
            subel = parser.peek();
        }
        parser.end(el);
        if (this.parseString != null) {
            this.parseString = this.parseString.trim();
            if (this.parseString.length() == 0) {
                this.parseString = null;
            }
        }
        if (this.parseString == null && !isDynamic) {
            throw new XmlParseException("Missing pcode <body> in injection: " + this.source);
        }
        this.setInputParameters(inlist);
        this.setOutputParameters(outlist);
        this.orderParameters();
    }

    String releaseParseString() {
        String res = this.parseString;
        this.parseString = null;
        return res;
    }

    protected void setTemplate(ConstructTpl ctl) {
        this.pcodeTemplate = ctl;
        this.isfallthru = this.computeFallThru();
    }

    private void checkParameterRestrictions(InjectContext con, Address addr) {
        int outsize;
        int insize;
        int n = insize = con.inputlist == null ? 0 : con.inputlist.size();
        if (this.inputlist.length != insize) {
            throw new SleighException("Input parameters do not match injection specification: " + this.source);
        }
        for (int i = 0; i < this.inputlist.length; ++i) {
            int sz = this.inputlist[i].getSize();
            if (sz == 0 || sz == con.inputlist.get(i).getSize()) continue;
            throw new SleighException("Input parameter size does not match injection specification: " + this.source);
        }
        int n2 = outsize = con.output == null ? 0 : con.output.size();
        if (this.output.length != outsize) {
            throw new SleighException("Output does not match injection specification: " + this.source);
        }
        for (int i = 0; i < this.output.length; ++i) {
            int sz = this.output[i].getSize();
            if (sz == 0 || sz == con.output.get(i).getSize()) continue;
            throw new SleighException("Output size does not match injection specification: " + this.source);
        }
    }

    private void setupParameters(InjectContext con, ParserWalker walker) throws UnknownInstructionException {
        FixedHandle hand;
        Varnode vn;
        int i;
        this.checkParameterRestrictions(con, walker.getAddr());
        for (i = 0; i < this.inputlist.length; ++i) {
            walker.allocateOperand();
            vn = con.inputlist.get(i);
            hand = walker.getParentHandle();
            hand.space = vn.getAddress().getAddressSpace();
            hand.offset_offset = vn.getOffset();
            hand.size = vn.getSize();
            hand.offset_space = null;
            walker.popOperand();
        }
        for (i = 0; i < this.output.length; ++i) {
            walker.allocateOperand();
            vn = con.output.get(i);
            hand = walker.getParentHandle();
            hand.space = vn.getAddress().getAddressSpace();
            hand.offset_offset = vn.getOffset();
            hand.size = vn.getSize();
            hand.offset_space = null;
            walker.popOperand();
        }
    }

    @Override
    public boolean isEquivalent(InjectPayload obj) {
        int i;
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        InjectPayloadSleigh op2 = (InjectPayloadSleigh)obj;
        if (!this.name.equals(op2.name)) {
            return false;
        }
        if (this.inputlist.length != op2.inputlist.length) {
            return false;
        }
        for (i = 0; i < this.inputlist.length; ++i) {
            if (this.inputlist[i].isEquivalent(op2.inputlist[i])) continue;
            return false;
        }
        if (this.output.length != op2.output.length) {
            return false;
        }
        for (i = 0; i < this.output.length; ++i) {
            if (this.output[i].isEquivalent(op2.output[i])) continue;
            return false;
        }
        if (this.incidentalCopy != op2.incidentalCopy) {
            return false;
        }
        if (this.paramShift != op2.paramShift) {
            return false;
        }
        return this.type == op2.type && this.subType == op2.subType;
    }

    public static ConstructTpl getDummyPcode(AddressFactory addrFactory) {
        ConstTpl uniqueSpace = new ConstTpl(addrFactory.getUniqueSpace());
        ConstTpl constSpace = new ConstTpl(addrFactory.getConstantSpace());
        ConstTpl tmpOffset = new ConstTpl(0, 256L);
        ConstTpl constZero = new ConstTpl(0, 0L);
        ConstTpl size = new ConstTpl(0, 4L);
        VarnodeTpl temp = new VarnodeTpl(uniqueSpace, tmpOffset, size);
        VarnodeTpl zero = new VarnodeTpl(constSpace, constZero, size);
        VarnodeTpl[] inputs = new VarnodeTpl[]{temp, zero};
        OpTpl[] ops = new OpTpl[]{new OpTpl(19, temp, inputs)};
        ConstructTpl pcode = new ConstructTpl(ops);
        return pcode;
    }
}

