/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.model.data;

import ghidra.docking.settings.Settings;
import ghidra.docking.settings.SettingsDefinition;
import ghidra.program.model.data.AbstractDataType;
import ghidra.program.model.data.AbstractIntegerDataType;
import ghidra.program.model.data.CategoryPath;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.DataTypeManager;
import ghidra.program.model.data.EndianSettingsDefinition;
import ghidra.program.model.data.Enum;
import ghidra.program.model.data.InvalidDataTypeException;
import ghidra.program.model.data.StringDataInstance;
import ghidra.program.model.data.TypeDef;
import ghidra.program.model.mem.MemBuffer;
import ghidra.program.model.scalar.Scalar;
import ghidra.util.DataConverter;
import ghidra.util.exception.AssertException;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;

public class BitFieldDataType
extends AbstractDataType {
    private static final int MAX_BIT_LENGTH = 255;
    private final DataType baseDataType;
    private final int bitSize;
    private final int effectiveBitSize;
    private final int bitOffset;
    private final int storageSize;
    protected Settings defaultSettings;

    protected BitFieldDataType(DataType baseDataType, int bitSize, int bitOffset) throws InvalidDataTypeException {
        super(CategoryPath.ROOT, baseDataType.getName() + ":" + bitSize, baseDataType.getDataTypeManager());
        BitFieldDataType.checkBaseDataType(baseDataType);
        if (bitSize < 0 || bitSize > 255) {
            throw new InvalidDataTypeException("unsupported bit size: " + bitSize);
        }
        if (bitOffset < 0 || bitOffset > 7) {
            throw new InvalidDataTypeException("unsupported minimal bit offset: " + bitOffset);
        }
        this.baseDataType = baseDataType;
        this.bitSize = bitSize;
        this.bitOffset = bitOffset;
        this.effectiveBitSize = BitFieldDataType.getEffectiveBitSize(bitSize, this.baseDataType.getLength());
        this.storageSize = BitFieldDataType.getMinimumStorageSize(this.effectiveBitSize, bitOffset);
        this.defaultSettings = this.baseDataType.getDefaultSettings();
    }

    protected BitFieldDataType(DataType baseDataType, int bitSize) throws InvalidDataTypeException {
        this(baseDataType, bitSize, 0);
    }

    @Override
    public boolean isZeroLength() {
        return this.bitSize == 0;
    }

    public static int getEffectiveBitSize(int declaredBitSize, int baseTypeByteSize) {
        return Math.min(8 * baseTypeByteSize, declaredBitSize);
    }

    public static int getMinimumStorageSize(int bitSize) {
        return BitFieldDataType.getMinimumStorageSize(bitSize, 0);
    }

    public static int getMinimumStorageSize(int bitSize, int bitOffset) {
        if (bitSize == 0) {
            return 1;
        }
        return (bitSize + bitOffset % 8 + 7) / 8;
    }

    public static void checkBaseDataType(DataType baseDataType) throws InvalidDataTypeException {
        if (!BitFieldDataType.isValidBaseDataType(baseDataType)) {
            throw new InvalidDataTypeException("Unsupported base data type for bitfield: " + baseDataType.getName());
        }
    }

    public static boolean isValidBaseDataType(DataType baseDataType) {
        if (baseDataType instanceof TypeDef) {
            baseDataType = ((TypeDef)baseDataType).getBaseDataType();
        }
        if (baseDataType instanceof Enum) {
            return true;
        }
        return baseDataType instanceof AbstractIntegerDataType;
    }

    @Override
    public void addParent(DataType dt) {
        if (this.baseDataType instanceof TypeDef || this.baseDataType instanceof Enum) {
            this.baseDataType.addParent(dt);
        }
    }

    public int getBaseTypeSize() {
        return this.baseDataType.getLength();
    }

    public int getStorageSize() {
        return this.storageSize;
    }

    public int getBitSize() {
        return this.effectiveBitSize;
    }

    public int getDeclaredBitSize() {
        return this.bitSize;
    }

    public int getBitOffset() {
        return this.bitOffset;
    }

    public DataType getBaseDataType() {
        return this.baseDataType;
    }

    public AbstractIntegerDataType getPrimitiveBaseDataType() {
        DataType dt = this.baseDataType;
        if (this.baseDataType instanceof TypeDef) {
            dt = ((TypeDef)this.baseDataType).getBaseDataType();
        }
        if (dt instanceof Enum) {
            dt = AbstractIntegerDataType.getUnsignedDataType(((Enum)dt).getLength(), this.dataMgr);
        }
        return (AbstractIntegerDataType)dt;
    }

    @Override
    public final SettingsDefinition[] getSettingsDefinitions() {
        ArrayList<SettingsDefinition> baseDTSettings = new ArrayList<SettingsDefinition>(Arrays.asList(this.baseDataType.getSettingsDefinitions()));
        baseDTSettings.remove(EndianSettingsDefinition.DEF);
        return (SettingsDefinition[])baseDTSettings.toArray(SettingsDefinition[]::new);
    }

    @Override
    public final boolean isEquivalent(DataType dt) {
        if (dt == this) {
            return true;
        }
        if (dt == null) {
            return false;
        }
        if (!(dt instanceof BitFieldDataType)) {
            return false;
        }
        BitFieldDataType otherBitField = (BitFieldDataType)dt;
        return otherBitField.bitSize == this.bitSize && this.baseDataType.isEquivalent(otherBitField.baseDataType);
    }

    public final int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.baseDataType.hashCode();
        result = 31 * result + this.bitOffset;
        result = 31 * result + this.bitSize;
        return result;
    }

    public final boolean equals(Object obj) {
        if (!(obj instanceof BitFieldDataType)) {
            return false;
        }
        BitFieldDataType otherDt = (BitFieldDataType)obj;
        return otherDt.getDataTypeManager() == this.getDataTypeManager() && this.isEquivalent(otherDt) && this.bitOffset == otherDt.bitOffset && this.storageSize == otherDt.storageSize && this.baseDataType.equals(otherDt.baseDataType);
    }

    @Override
    public Settings getDefaultSettings() {
        return this.defaultSettings;
    }

    @Override
    public final DataType copy(DataTypeManager dtm) {
        return this.clone(dtm);
    }

    @Override
    public BitFieldDataType clone(DataTypeManager dtm) {
        if (dtm == this.dataMgr) {
            return this;
        }
        try {
            return new BitFieldDataType(this.baseDataType.clone(dtm), this.bitSize, this.bitOffset);
        }
        catch (InvalidDataTypeException e) {
            throw new AssertException("unexpected", (Throwable)((Object)e));
        }
    }

    @Override
    public int getLength() {
        return this.storageSize;
    }

    @Override
    public String getDescription() {
        StringBuffer sbuf = new StringBuffer();
        sbuf.append(Integer.toString(this.effectiveBitSize));
        sbuf.append("-bit ");
        DataType dt = this.getBaseDataType();
        sbuf.append(dt.getDisplayName());
        sbuf.append(" bitfield");
        if (this.effectiveBitSize != this.bitSize) {
            sbuf.append(" (declared as ");
            sbuf.append(Integer.toString(this.bitSize));
            sbuf.append("-bits)");
        }
        return sbuf.toString();
    }

    @Override
    public Object getValue(MemBuffer buf, Settings settings, int length) {
        if (this.effectiveBitSize == 0) {
            return new Scalar(0, 0L);
        }
        AbstractIntegerDataType primitiveBaseDataType = this.getPrimitiveBaseDataType();
        boolean isSigned = primitiveBaseDataType.isSigned();
        BigInteger big = this.getBigIntegerValue(buf, isSigned, settings);
        if (big == null) {
            return null;
        }
        if (this.effectiveBitSize <= 64) {
            return new Scalar(this.effectiveBitSize, big.longValue(), isSigned);
        }
        return big;
    }

    private BigInteger getBigIntegerValue(MemBuffer buf, boolean isSigned, Settings settings) {
        if (this.effectiveBitSize == 0) {
            return BigInteger.ZERO;
        }
        try {
            BigInteger big = buf.getBigInteger(0, this.storageSize, false);
            BigInteger pow = BigInteger.valueOf(2L).pow(this.effectiveBitSize);
            BigInteger mask = pow.subtract(BigInteger.ONE);
            big = big.shiftRight(this.bitOffset).and(mask);
            if (isSigned && big.testBit(this.effectiveBitSize - 1)) {
                big = big.subtract(pow);
            }
            return big;
        }
        catch (Exception exception) {
            return null;
        }
    }

    @Override
    public Class<?> getValueClass(Settings settings) {
        return this.baseDataType.getValueClass(settings);
    }

    @Override
    public String getRepresentation(MemBuffer buf, Settings settings, int length) {
        if (this.bitSize == 0) {
            return "";
        }
        AbstractIntegerDataType primitiveBaseDataType = this.getPrimitiveBaseDataType();
        boolean isSigned = primitiveBaseDataType.isSigned();
        BigInteger big = this.getBigIntegerValue(buf, isSigned, settings);
        if (big == null) {
            return "??";
        }
        DataType dt = this.baseDataType;
        if (dt instanceof TypeDef) {
            dt = ((TypeDef)dt).getBaseDataType();
        }
        if (dt instanceof Enum) {
            return ((Enum)dt).getRepresentation(big, settings, this.effectiveBitSize);
        }
        AbstractIntegerDataType intDT = (AbstractIntegerDataType)dt;
        if (intDT.getFormatSettingsDefinition().getFormat(settings) == 4) {
            if (big.signum() < 0) {
                big = big.add(BigInteger.valueOf(2L).pow(this.effectiveBitSize));
            }
            int bytesLen = BitFieldDataType.getMinimumStorageSize(this.effectiveBitSize);
            byte[] bytes = DataConverter.getInstance((boolean)buf.isBigEndian()).getBytes(big, bytesLen);
            return StringDataInstance.getCharRepresentation(this, bytes, settings);
        }
        return intDT.getRepresentation(big, settings, this.effectiveBitSize);
    }

    @Override
    public int getAlignment() {
        return this.baseDataType.getAlignment();
    }

    @Override
    public String toString() {
        return this.getDisplayName() + "(storage:" + this.storageSize + ",bitOffset:" + this.bitOffset + ")";
    }
}

