/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.model.address;

import ghidra.program.model.address.AbstractAddressSpace;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressFactory;
import ghidra.program.model.address.AddressFormatException;
import ghidra.program.model.address.AddressOutOfBoundsException;
import ghidra.program.model.address.AddressRange;
import ghidra.program.model.address.AddressRangeIterator;
import ghidra.program.model.address.AddressSet;
import ghidra.program.model.address.AddressSpace;
import ghidra.program.model.address.OverlayAddressSpace;
import ghidra.util.datastruct.IntObjectHashtable;
import ghidra.util.exception.DuplicateNameException;
import java.util.ArrayList;
import java.util.HashMap;

public class DefaultAddressFactory
implements AddressFactory {
    private AddressSpace defaultSpace;
    private AddressSpace constantSpace;
    private AddressSpace uniqueSpace;
    private IntObjectHashtable<AddressSpace> spaceLookup;
    private AddressSet memoryAddressSet = new AddressSet();
    private AddressSpace registerSpace;
    private HashMap<String, AddressSpace> spaceNameTable;
    private ArrayList<AddressSpace> spaces;

    DefaultAddressFactory() {
        this(new AddressSpace[0], null);
    }

    public DefaultAddressFactory(AddressSpace[] addrSpaces) {
        this(addrSpaces, null);
    }

    public DefaultAddressFactory(AddressSpace[] addrSpaces, AddressSpace defaultSpace) {
        this.spaces = new ArrayList(addrSpaces.length);
        this.spaceLookup = new IntObjectHashtable();
        this.spaceNameTable = new HashMap();
        for (AddressSpace space : addrSpaces) {
            this.checkReservedSpace(space);
            this.spaces.add(space);
            if (space.equals(defaultSpace)) {
                this.defaultSpace = space;
            }
            this.spaceNameTable.put(space.getName(), space);
            this.spaceLookup.put(space.getSpaceID(), (Object)space);
            if (space.getType() == 0) {
                this.constantSpace = space;
            } else if (space.getType() == 3) {
                this.uniqueSpace = space;
            } else if (space.getType() == 4) {
                if (this.registerSpace != null || !space.getName().equalsIgnoreCase("register")) {
                    throw new IllegalArgumentException("Ghidra can only support a single Register space named 'register'");
                }
                this.registerSpace = space;
            }
            if (!space.isMemorySpace()) continue;
            this.memoryAddressSet.addRange(space.getMinAddress(), space.getMaxAddress());
        }
        if (this.hasMultipleMemorySpaces()) {
            AddressSpace[] physSpaces;
            for (AddressSpace sp : physSpaces = this.getPhysicalSpaces()) {
                if (!(sp instanceof AbstractAddressSpace)) continue;
                ((AbstractAddressSpace)sp).setShowSpaceName(true);
            }
        }
        if (this.defaultSpace == null) {
            if (defaultSpace != null) {
                throw new IllegalArgumentException("Specified default space not in array");
            }
            this.defaultSpace = this.spaces.get(0);
        }
        if (this.registerSpace == null) {
            this.registerSpace = AddressSpace.DEFAULT_REGISTER_SPACE;
        }
    }

    private void checkReservedSpace(AddressSpace space) {
        this.checkReservedVariable(space);
        this.checkReservedJoin(space);
        this.checkReservedExternal(space);
        this.checkReservedStack(space);
    }

    private void checkReservedVariable(AddressSpace space) {
        if (space.getType() == 11 || space.getName().equalsIgnoreCase(AddressSpace.VARIABLE_SPACE.getName())) {
            throw new IllegalArgumentException("Variable space should not be specified");
        }
    }

    private void checkReservedJoin(AddressSpace space) {
        if (space.getType() == 6 || space.getName().equals("join")) {
            throw new IllegalArgumentException("Join space should not be specified");
        }
    }

    private void checkReservedExternal(AddressSpace space) {
        if (space.getType() == 10 || space.getName().equalsIgnoreCase(AddressSpace.EXTERNAL_SPACE.getName())) {
            throw new IllegalArgumentException("External space should not be specified");
        }
    }

    private void checkReservedStack(AddressSpace space) {
        if (space.getType() == 5 || space.getName().equalsIgnoreCase("stack")) {
            throw new IllegalArgumentException("Stack space should not be specified");
        }
    }

    @Override
    public Address getAddress(String addrString) {
        try {
            Address addr = this.defaultSpace.getAddress(addrString);
            if (addr != null) {
                return addr;
            }
        }
        catch (AddressFormatException addressFormatException) {
            // empty catch block
        }
        for (AddressSpace space : this.spaces) {
            if (space == this.defaultSpace) continue;
            try {
                Address addr = space.getAddress(addrString);
                if (addr == null) continue;
                return addr;
            }
            catch (AddressFormatException addressFormatException) {
            }
        }
        return null;
    }

    @Override
    public Address[] getAllAddresses(String addrString) {
        return this.getAllAddresses(addrString, true);
    }

    @Override
    public Address[] getAllAddresses(String addrString, boolean caseSensitive) {
        ArrayList<Address> loadedMemoryList = new ArrayList<Address>();
        ArrayList<Address> otherList = new ArrayList<Address>();
        for (AddressSpace space : this.spaces) {
            if (!space.isMemorySpace()) continue;
            try {
                Address addr = space.getAddress(addrString, caseSensitive);
                if (addr == null || space.isOverlaySpace() && addr.getAddressSpace() != space) continue;
                if (space.isNonLoadedMemorySpace()) {
                    otherList.add(addr);
                    continue;
                }
                if (space == this.defaultSpace) {
                    loadedMemoryList.add(0, addr);
                    continue;
                }
                loadedMemoryList.add(addr);
            }
            catch (AddressFormatException addressFormatException) {}
        }
        if (loadedMemoryList.isEmpty() && otherList.size() == 1) {
            return new Address[]{(Address)otherList.get(0)};
        }
        Address[] addrs = new Address[loadedMemoryList.size()];
        return loadedMemoryList.toArray(addrs);
    }

    @Override
    public AddressSpace getDefaultAddressSpace() {
        return this.defaultSpace;
    }

    @Override
    public AddressSpace[] getAddressSpaces() {
        return this.getPhysicalSpaces();
    }

    @Override
    public AddressSpace[] getAllAddressSpaces() {
        AddressSpace[] allSpaces = new AddressSpace[this.spaces.size()];
        this.spaces.toArray(allSpaces);
        return allSpaces;
    }

    @Override
    public AddressSpace getAddressSpace(String name) {
        return this.spaceNameTable.get(name);
    }

    @Override
    public AddressSpace getAddressSpace(int spaceID) {
        return (AddressSpace)this.spaceLookup.get(spaceID);
    }

    @Override
    public int getNumAddressSpaces() {
        return this.getPhysicalSpaces().length;
    }

    @Override
    public boolean isValidAddress(Address addr) {
        return this.spaces.contains(addr.getAddressSpace());
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof DefaultAddressFactory)) {
            return false;
        }
        DefaultAddressFactory factory = (DefaultAddressFactory)o;
        if (this.spaces.size() != factory.spaces.size()) {
            return false;
        }
        for (AddressSpace space : this.spaces) {
            if (factory.spaces.contains(space)) continue;
            return false;
        }
        return true;
    }

    @Override
    public long getIndex(Address addr) {
        AddressSpace space = addr.getAddressSpace();
        int id = space.getSpaceID();
        if (this.spaceLookup.get(id) == null) {
            this.spaceLookup.put(id, (Object)space);
        }
        long value = (long)id << 48;
        return value += addr.getOffset();
    }

    @Override
    public AddressSpace getPhysicalSpace(AddressSpace space) {
        return space.getPhysicalSpace();
    }

    @Override
    public AddressSpace[] getPhysicalSpaces() {
        ArrayList<AddressSpace> physicalSpaces = new ArrayList<AddressSpace>();
        for (AddressSpace space : this.spaces) {
            if (!space.isMemorySpace()) continue;
            physicalSpaces.add(space);
        }
        AddressSpace[] ret = new AddressSpace[physicalSpaces.size()];
        physicalSpaces.toArray(ret);
        return ret;
    }

    @Override
    public Address getAddress(int spaceID, long offset) {
        AddressSpace space = this.getAddressSpace(spaceID);
        if (space == null) {
            return null;
        }
        return space.getAddress(offset);
    }

    @Override
    public AddressSpace getConstantSpace() {
        return this.constantSpace;
    }

    @Override
    public AddressSpace getUniqueSpace() {
        return this.uniqueSpace;
    }

    @Override
    public AddressSpace getStackSpace() {
        throw new UnsupportedOperationException("Use program's address factory to obtain compiler specified stack space");
    }

    @Override
    public AddressSpace getRegisterSpace() {
        return this.registerSpace;
    }

    @Override
    public Address getConstantAddress(long offset) {
        return this.constantSpace.getAddress(offset);
    }

    @Override
    public AddressSet getAddressSet(Address min, Address max) {
        if (min.getAddressSpace() == max.getAddressSpace()) {
            return new AddressSet(min, max);
        }
        AddressSet set = new AddressSet();
        AddressRangeIterator it = this.memoryAddressSet.getAddressRanges();
        while (it.hasNext()) {
            AddressRange r = (AddressRange)it.next();
            AddressRange result = r.intersectRange(min, max);
            if (result == null) continue;
            set.add(result);
        }
        return set;
    }

    @Override
    public AddressSet getAddressSet() {
        return new AddressSet(this.memoryAddressSet);
    }

    @Override
    public Address oldGetAddressFromLong(long value) {
        int spaceId = (int)(value >> 48);
        long offset = value & 0xFFFFFFFFL;
        AddressSpace space = (AddressSpace)this.spaceLookup.get(spaceId);
        if (space == null) {
            throw new AddressOutOfBoundsException("Unable to decode old address - space not found (spaceId=" + spaceId + ")");
        }
        return space.getAddress(offset);
    }

    protected void addAddressSpace(AddressSpace space) throws DuplicateNameException {
        if (this.spaceNameTable.containsKey(space.getName())) {
            throw new DuplicateNameException("Space named " + space.getName() + " already exists!");
        }
        if (space.getType() == 11) {
            this.spaceNameTable.put("join", space);
            return;
        }
        this.spaces.add(space);
        this.spaceNameTable.put(space.getName(), space);
        this.spaceLookup.put(space.getSpaceID(), (Object)space);
        if (space.isMemorySpace()) {
            this.memoryAddressSet.addRange(space.getMinAddress(), space.getMaxAddress());
        }
    }

    protected String renameOverlaySpace(String oldOverlaySpaceName, String newName) throws DuplicateNameException {
        if (this.getAddressSpace(newName) != null) {
            throw new DuplicateNameException("AddressSpace named " + newName + " already exists!");
        }
        AddressSpace space = this.getAddressSpace(oldOverlaySpaceName);
        if (space != null && space.isOverlaySpace()) {
            ((OverlayAddressSpace)space).setName(newName);
            this.spaceNameTable.remove(oldOverlaySpaceName);
            this.spaceNameTable.put(space.getName(), space);
            return newName;
        }
        throw new IllegalArgumentException("No such overlay space: " + oldOverlaySpaceName);
    }

    protected void removeAddressSpace(String spaceName) {
        AddressSpace deletedSpace = this.spaceNameTable.get(spaceName);
        if (deletedSpace != null) {
            this.spaces.remove(deletedSpace);
            this.spaceNameTable.remove(deletedSpace.getName());
            this.spaceLookup.remove(deletedSpace.getSpaceID());
            if (deletedSpace.getType() == 1 || deletedSpace.getType() == 2) {
                this.memoryAddressSet.deleteRange(deletedSpace.getMinAddress(), deletedSpace.getMaxAddress());
            }
        }
    }

    @Override
    public boolean hasMultipleMemorySpaces() {
        return this.getPhysicalSpaces().length > 1;
    }
}

