/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.database.util;

import db.DBHandle;
import db.DBListener;
import db.DBRecord;
import db.Field;
import db.LongField;
import db.RecordIterator;
import db.Schema;
import db.Table;
import db.util.ErrorHandler;
import ghidra.program.database.map.AddressKeyRecordIterator;
import ghidra.program.database.map.AddressMap;
import ghidra.program.database.util.AddressRangeMapIterator;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressRange;
import ghidra.program.model.address.AddressRangeImpl;
import ghidra.program.model.address.AddressRangeIterator;
import ghidra.program.model.address.AddressSet;
import ghidra.program.model.address.AddressSpace;
import ghidra.program.model.address.EmptyAddressRangeIterator;
import ghidra.util.Lock;
import ghidra.util.Msg;
import ghidra.util.exception.AssertException;
import ghidra.util.exception.CancelledException;
import ghidra.util.exception.DuplicateNameException;
import ghidra.util.task.TaskMonitor;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class AddressRangeMapDB
implements DBListener {
    public static final String RANGE_MAP_TABLE_PREFIX = "Range Map - ";
    static final int TO_COL = 0;
    static final int VALUE_COL = 1;
    private static final String[] COLUMN_NAMES = new String[]{"To", "Value"};
    private static final int[] INDEXED_COLUMNS = new int[]{1};
    private final DBHandle dbHandle;
    private final AddressMap addressMap;
    private final ErrorHandler errHandler;
    private final Field valueField;
    private final boolean indexed;
    private final Lock lock;
    private String tableName;
    private Schema rangeMapSchema;
    private Table rangeMapTable;
    private Field lastValue;
    private AddressRange lastRange;
    private int modCount;
    private boolean alreadyCheckedForWrappingRecord = false;

    public AddressRangeMapDB(DBHandle dbHandle, AddressMap addressMap, Lock lock, String name, ErrorHandler errHandler, Field valueField, boolean indexed) {
        this.dbHandle = dbHandle;
        this.addressMap = addressMap;
        this.lock = lock;
        this.errHandler = errHandler;
        this.valueField = valueField;
        this.indexed = indexed;
        this.tableName = RANGE_MAP_TABLE_PREFIX + name;
        this.findTable();
        dbHandle.addListener((DBListener)this);
    }

    public static boolean exists(DBHandle dbHandle, String name) {
        return dbHandle.getTable(RANGE_MAP_TABLE_PREFIX + name) != null;
    }

    public boolean setName(String newName) throws DuplicateNameException {
        String newTableName = RANGE_MAP_TABLE_PREFIX + newName;
        if (this.rangeMapTable == null || this.rangeMapTable.setName(newTableName)) {
            this.tableName = newTableName;
            return true;
        }
        return false;
    }

    public boolean isEmpty() {
        this.lock.acquire();
        try {
            boolean bl = this.rangeMapTable == null || this.rangeMapTable.getRecordCount() == 0;
            return bl;
        }
        finally {
            this.lock.release();
        }
    }

    public int getRecordCount() {
        return this.rangeMapTable != null ? this.rangeMapTable.getRecordCount() : 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Field getValue(Address address) {
        this.lock.acquire();
        try {
            if (this.rangeMapTable == null) {
                Field field = null;
                return field;
            }
            if (this.lastRange != null && this.lastRange.contains(address)) {
                Field field = this.lastValue;
                return field;
            }
            DBRecord record = this.findRecordContaining(address);
            List<AddressRange> ranges = this.getRangesForRecord(record);
            for (AddressRange range : ranges) {
                if (!range.contains(address)) continue;
                this.lastRange = range;
                Field field = this.lastValue = record.getFieldValue(1);
                return field;
            }
        }
        catch (IOException e) {
            this.errHandler.dbError(e);
        }
        finally {
            this.lock.release();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void paintRange(Address startAddress, Address endAddress, Field value) {
        if (!startAddress.hasSameAddressSpace(endAddress)) {
            throw new IllegalArgumentException("Addresses must be in the same space!");
        }
        if (startAddress.compareTo(endAddress) > 0) {
            throw new IllegalArgumentException("Start address must be <= end address!");
        }
        this.lock.acquire();
        try {
            this.clearCache();
            ++this.modCount;
            if (this.rangeMapTable == null) {
                if (value == null) {
                    return;
                }
                this.createTable();
            }
            this.doPaintRange(startAddress, endAddress, value);
        }
        catch (IOException e) {
            this.errHandler.dbError(e);
        }
        finally {
            this.lock.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void moveAddressRange(Address fromAddr, Address toAddr, long length, TaskMonitor monitor) throws CancelledException {
        if (length <= 0L || this.rangeMapTable == null) {
            return;
        }
        DBHandle tmpDb = null;
        AddressRangeMapDB tmpMap = null;
        this.lock.acquire();
        try {
            tmpDb = this.dbHandle.getScratchPad();
            tmpMap = new AddressRangeMapDB(tmpDb, this.addressMap, this.lock, "TEMP", this.errHandler, this.valueField, this.indexed);
            Address fromEndAddr = fromAddr.add(length - 1L);
            for (AddressRange range : this.getAddressRanges(fromAddr, fromEndAddr)) {
                monitor.checkCanceled();
                Address minAddr = range.getMinAddress();
                Field value = this.getValue(minAddr);
                long offset = minAddr.subtract(fromAddr);
                minAddr = toAddr.add(offset);
                Address maxAddr = range.getMaxAddress();
                offset = maxAddr.subtract(fromAddr);
                maxAddr = toAddr.add(offset);
                tmpMap.paintRange(minAddr, maxAddr, value);
            }
            this.clearRange(fromAddr, fromEndAddr);
            for (AddressRange range : tmpMap.getAddressRanges()) {
                monitor.checkCanceled();
                Field value = tmpMap.getValue(range.getMinAddress());
                this.paintRange(range.getMinAddress(), range.getMaxAddress(), value);
            }
        }
        catch (IOException e) {
            this.errHandler.dbError(e);
        }
        finally {
            if (tmpMap != null) {
                try {
                    tmpDb.deleteTable(tmpMap.tableName);
                }
                catch (IOException iOException) {}
            }
            this.lock.release();
        }
    }

    public void clearRange(Address startAddr, Address endAddr) {
        this.paintRange(startAddr, endAddr, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AddressSet getAddressSet() {
        this.lock.acquire();
        try {
            AddressSet set = new AddressSet();
            AddressRangeIterator addressRanges = this.getAddressRanges();
            for (AddressRange addressRange : addressRanges) {
                set.add(addressRange);
            }
            AddressSet addressSet = set;
            return addressSet;
        }
        finally {
            this.lock.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AddressSet getAddressSet(Field value) {
        AddressSet set = new AddressSet();
        if (this.rangeMapTable == null) {
            return set;
        }
        this.lock.acquire();
        try {
            RecordIterator it = this.rangeMapTable.indexIterator(1, value, value, true);
            while (it.hasNext()) {
                DBRecord record = it.next();
                List<AddressRange> rangesForRecord = this.getRangesForRecord(record);
                rangesForRecord.forEach(r -> set.addRange(r.getMinAddress(), r.getMaxAddress()));
            }
        }
        catch (IOException e) {
            this.dbError(e);
        }
        finally {
            this.lock.release();
        }
        return set;
    }

    public AddressRangeIterator getAddressRanges() {
        if (this.rangeMapTable == null) {
            return new EmptyAddressRangeIterator();
        }
        try {
            return new AddressRangeMapIterator(this);
        }
        catch (IOException e) {
            this.dbError(e);
            return null;
        }
    }

    public AddressRangeIterator getAddressRanges(Address startAddress) {
        if (this.rangeMapTable == null) {
            return new EmptyAddressRangeIterator();
        }
        try {
            return new AddressRangeMapIterator(this, startAddress);
        }
        catch (IOException e) {
            this.dbError(e);
            return null;
        }
    }

    public AddressRangeIterator getAddressRanges(Address startAddress, Address endAddr) {
        if (this.rangeMapTable == null) {
            return new EmptyAddressRangeIterator();
        }
        try {
            return new AddressRangeMapIterator(this, startAddress, endAddr);
        }
        catch (IOException e) {
            this.dbError(e);
            return null;
        }
    }

    public void dbRestored(DBHandle dbh) {
        this.lock.acquire();
        try {
            this.clearCache();
            this.findTable();
        }
        finally {
            this.lock.release();
        }
    }

    public void dbClosed(DBHandle dbh) {
    }

    public void tableDeleted(DBHandle dbh, Table table) {
        if (table == this.rangeMapTable) {
            this.lock.acquire();
            try {
                this.clearCache();
                this.rangeMapTable = null;
            }
            finally {
                this.lock.release();
            }
        }
    }

    public void tableAdded(DBHandle dbh, Table table) {
        if (this.tableName.equals(table.getName())) {
            this.rangeMapTable = table;
        }
    }

    public void dispose() {
        block5: {
            this.lock.acquire();
            try {
                if (this.rangeMapTable == null) break block5;
                try {
                    this.dbHandle.deleteTable(this.tableName);
                }
                catch (IOException e) {
                    this.errHandler.dbError(e);
                }
                this.clearCache();
                this.rangeMapTable = null;
            }
            finally {
                this.lock.release();
            }
        }
    }

    public void invalidate() {
        this.lock.acquire();
        try {
            this.clearCache();
            this.alreadyCheckedForWrappingRecord = false;
        }
        finally {
            this.lock.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AddressRange getAddressRangeContaining(Address address) {
        this.lock.acquire();
        try {
            if (this.lastRange != null && this.lastRange.contains(address)) {
                AddressRange addressRange = this.lastRange;
                return addressRange;
            }
            AddressRange range = this.findValueRangeContainingAddress(address);
            if (range == null) {
                range = this.findGapRange(address);
            }
            AddressRange addressRange = range;
            return addressRange;
        }
        catch (IOException e) {
            this.dbError(e);
            AddressRange addressRange = null;
            return addressRange;
        }
        finally {
            this.lock.release();
        }
    }

    private AddressRange findValueRangeContainingAddress(Address address) throws IOException {
        DBRecord record = this.findRecordContaining(address);
        List<AddressRange> rangesForRecord = this.getRangesForRecord(record);
        for (AddressRange range : rangesForRecord) {
            if (!range.contains(address)) continue;
            this.lastRange = range;
            this.lastValue = record.getFieldValue(1);
            return range;
        }
        return null;
    }

    private AddressRange findGapRange(Address address) throws IOException {
        Address startAddress;
        Address endAddress;
        DBRecord record;
        DBRecord wrappingRecord;
        Address gapStart = address.getAddressSpace().getMinAddress();
        Address gapEnd = address.getAddressSpace().getMaxAddress();
        if (address.hasSameAddressSpace(this.addressMap.getImageBase()) && (wrappingRecord = this.getAddressWrappingRecord()) != null) {
            gapStart = this.getEndAddress(wrappingRecord).add(1L);
            gapEnd = this.getStartAddress(wrappingRecord).subtract(1L);
        }
        if ((record = this.getRecordAtOrBefore(address)) != null && (endAddress = this.getEndAddress(record)).hasSameAddressSpace(address) && endAddress.compareTo(address) < 0) {
            gapStart = endAddress.add(1L);
        }
        if ((record = this.getRecordAfter(address)) != null && (startAddress = this.getStartAddress(record)).hasSameAddressSpace(address) && startAddress.compareTo(address) > 0) {
            gapEnd = startAddress.subtract(1L);
        }
        return new AddressRangeImpl(gapStart, gapEnd);
    }

    List<AddressRange> getRangesForRecord(DBRecord record) {
        Address end;
        ArrayList<AddressRange> ranges = new ArrayList<AddressRange>(2);
        if (record == null) {
            return ranges;
        }
        Address start = this.addressMap.decodeAddress(record.getKey());
        if (start.compareTo(end = this.addressMap.decodeAddress(record.getLongValue(0))) <= 0) {
            ranges.add(new AddressRangeImpl(start, end));
        } else {
            AddressSpace space = start.getAddressSpace();
            ranges.add(new AddressRangeImpl(space.getMinAddress(), end));
            ranges.add(new AddressRangeImpl(start, space.getMaxAddress()));
        }
        return ranges;
    }

    private void doPaintRange(Address paintStart, Address paintEnd, Field value) throws IOException {
        this.splitAddressWrappingRecordIfExists();
        paintStart = this.checkRecordBeforeRange(paintStart, paintEnd, value);
        if (paintStart == null) {
            return;
        }
        paintEnd = this.fixupIntersectingRecords(paintStart, paintEnd, value);
        paintEnd = this.possiblyMergeWithNextRecord(paintEnd, value);
        if (value != null) {
            this.createRecord(paintStart, paintEnd, value);
        }
        if (this.rangeMapTable.getRecordCount() == 0) {
            this.dbHandle.deleteTable(this.tableName);
            this.rangeMapTable = null;
        }
    }

    private void splitAddressWrappingRecordIfExists() throws IOException {
        if (this.alreadyCheckedForWrappingRecord) {
            return;
        }
        this.alreadyCheckedForWrappingRecord = true;
        DBRecord wrappingRecord = this.getAddressWrappingRecord();
        if (wrappingRecord == null) {
            return;
        }
        List<AddressRange> ranges = this.getRangesForRecord(wrappingRecord);
        if (ranges.size() != 2) {
            throw new AssertException("wrapping records should have two ranges!");
        }
        Field value = this.getValue(wrappingRecord);
        this.rangeMapTable.deleteRecord(wrappingRecord.getKey());
        this.createRecord(ranges.get(0), value);
        this.createRecord(ranges.get(1), value);
    }

    private Address checkRecordBeforeRange(Address paintStart, Address paintEnd, Field value) throws IOException {
        DBRecord record = this.getRecordBefore(paintStart);
        if (record == null) {
            return paintStart;
        }
        Address recordStart = this.getStartAddress(record);
        Address recordEnd = this.getEndAddress(record);
        Field recordValue = this.getValue(record);
        if (!recordEnd.hasSameAddressSpace(paintStart)) {
            return paintStart;
        }
        if (recordValue.equals((Object)value)) {
            if (recordEnd.compareTo(paintEnd) >= 0) {
                return null;
            }
            if (recordEnd.isSuccessor(paintStart) || paintStart.compareTo(recordEnd) <= 0) {
                this.rangeMapTable.deleteRecord(record.getKey());
                return recordStart;
            }
            return paintStart;
        }
        if (recordEnd.compareTo(paintStart) < 0) {
            return paintStart;
        }
        record.setLongValue(0, this.addressMap.getKey(paintStart.subtract(1L), true));
        this.rangeMapTable.putRecord(record);
        if (recordEnd.compareTo(paintEnd) > 0) {
            this.createRecord(paintEnd.add(1L), recordEnd, recordValue);
        }
        return paintStart;
    }

    private Address fixupIntersectingRecords(Address startAddr, Address endAddr, Field value) throws IOException {
        AddressKeyRecordIterator it = new AddressKeyRecordIterator(this.rangeMapTable, this.addressMap, startAddr, endAddr, startAddr, true);
        while (it.hasNext()) {
            DBRecord record = it.next();
            it.delete();
            Address recordEndAddress = this.getEndAddress(record);
            if (recordEndAddress.compareTo(endAddr) <= 0) continue;
            Field recordValue = this.getValue(record);
            if (recordValue.equals((Object)value)) {
                return recordEndAddress;
            }
            this.createRecord(endAddr.add(1L), recordEndAddress, recordValue);
        }
        return endAddr;
    }

    private Address possiblyMergeWithNextRecord(Address endAddr, Field value) throws IOException {
        if (endAddr.equals(endAddr.getAddressSpace().getMaxAddress())) {
            return endAddr;
        }
        Address next = endAddr.add(1L);
        DBRecord record = this.rangeMapTable.getRecord(this.addressMap.getKey(next, false));
        if (record != null && this.getValue(record).equals((Object)value)) {
            this.rangeMapTable.deleteRecord(record.getKey());
            return this.getEndAddress(record);
        }
        return endAddr;
    }

    private void clearCache() {
        this.lock.acquire();
        try {
            this.lastRange = null;
            this.lastValue = null;
        }
        finally {
            this.lock.release();
        }
    }

    DBRecord getAddressWrappingRecord() throws IOException {
        Address end;
        Address maxAddress = this.addressMap.getImageBase().getAddressSpace().getMaxAddress();
        DBRecord record = this.getRecordAtOrBefore(maxAddress);
        if (record == null) {
            return null;
        }
        Address start = this.getStartAddress(record);
        if (start.compareTo(end = this.getEndAddress(record)) > 0) {
            return record;
        }
        return null;
    }

    private Address getStartAddress(DBRecord record) {
        return this.addressMap.decodeAddress(record.getKey());
    }

    private Field getValue(DBRecord record) {
        return record.getFieldValue(1);
    }

    private Address getEndAddress(DBRecord record) {
        return this.addressMap.decodeAddress(record.getLongValue(0));
    }

    private void createRecord(AddressRange range, Field value) throws IOException {
        this.createRecord(range.getMinAddress(), range.getMaxAddress(), value);
    }

    private void createRecord(Address startAddr, Address endAddr, Field value) throws IOException {
        long start = this.addressMap.getKey(startAddr, true);
        long end = this.addressMap.getKey(endAddr, true);
        DBRecord rec = this.rangeMapSchema.createRecord(start);
        rec.setLongValue(0, end);
        rec.setField(1, value);
        this.rangeMapTable.putRecord(rec);
    }

    private DBRecord findRecordContaining(Address address) throws IOException {
        DBRecord record = this.getRecordAtOrBefore(address);
        if (this.recordContainsAddress(record, address)) {
            return record;
        }
        record = this.getAddressWrappingRecord();
        if (this.recordContainsAddress(record, address)) {
            return record;
        }
        return null;
    }

    private boolean recordContainsAddress(DBRecord record, Address address) {
        List<AddressRange> rangesForRecord = this.getRangesForRecord(record);
        for (AddressRange addressRange : rangesForRecord) {
            if (!addressRange.contains(address)) continue;
            return true;
        }
        return false;
    }

    private DBRecord getRecordAfter(Address address) throws IOException {
        if (this.rangeMapTable == null) {
            return null;
        }
        AddressKeyRecordIterator it = new AddressKeyRecordIterator(this.rangeMapTable, this.addressMap, address, true);
        if (it.hasNext()) {
            return it.next();
        }
        return null;
    }

    private DBRecord getRecordAtOrBefore(Address address) throws IOException {
        if (this.rangeMapTable == null) {
            return null;
        }
        AddressKeyRecordIterator it = new AddressKeyRecordIterator(this.rangeMapTable, this.addressMap, address, false);
        if (it.hasPrevious()) {
            return it.previous();
        }
        return null;
    }

    private DBRecord getRecordBefore(Address address) throws IOException {
        if (this.rangeMapTable == null) {
            return null;
        }
        AddressKeyRecordIterator it = new AddressKeyRecordIterator(this.rangeMapTable, this.addressMap, address, true);
        if (it.hasPrevious()) {
            return it.previous();
        }
        return null;
    }

    private void findTable() {
        this.rangeMapTable = this.dbHandle.getTable(this.tableName);
        if (this.rangeMapTable != null) {
            int[] indexedCols;
            this.rangeMapSchema = this.rangeMapTable.getSchema();
            Field[] fields = this.rangeMapSchema.getFields();
            if (fields.length != 2 || !fields[1].isSameType(this.valueField)) {
                this.errHandler.dbError(new IOException("Existing range map table has unexpected value class"));
            }
            if (this.indexed && ((indexedCols = this.rangeMapTable.getIndexedColumns()).length != 1 || indexedCols[0] != 1)) {
                this.errHandler.dbError(new IOException("Existing range map table is not indexed"));
            }
        }
    }

    private void createTable() throws IOException {
        this.rangeMapSchema = new Schema(0, "From", new Field[]{LongField.INSTANCE, this.valueField}, COLUMN_NAMES);
        this.rangeMapTable = this.indexed ? this.dbHandle.createTable(this.tableName, this.rangeMapSchema, INDEXED_COLUMNS) : this.dbHandle.createTable(this.tableName, this.rangeMapSchema);
    }

    AddressMap getAddressMap() {
        return this.addressMap;
    }

    Table getTable() {
        return this.rangeMapTable;
    }

    Lock getLock() {
        return this.lock;
    }

    int getModCount() {
        return this.modCount;
    }

    void dbError(IOException e) {
        Msg.error((Object)this, (Object)("Unexpected Exception: " + e.getMessage()), (Throwable)e);
        this.errHandler.dbError(e);
    }
}

