/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.database.reloc;

import db.BinaryCodedField;
import db.BinaryField;
import db.DBHandle;
import db.DBRecord;
import db.RecordIterator;
import ghidra.framework.options.Options;
import ghidra.program.database.ManagerDB;
import ghidra.program.database.ProgramDB;
import ghidra.program.database.map.AddressMap;
import ghidra.program.database.mem.AddressSourceInfo;
import ghidra.program.database.mem.FileBytes;
import ghidra.program.database.reloc.RelocationDBAdapter;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.mem.MemoryBlockSourceInfo;
import ghidra.program.model.reloc.Relocation;
import ghidra.program.model.reloc.RelocationTable;
import ghidra.util.Lock;
import ghidra.util.exception.CancelledException;
import ghidra.util.exception.VersionException;
import ghidra.util.task.TaskMonitor;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;

public class RelocationManager
implements RelocationTable,
ManagerDB {
    private ProgramDB program;
    private AddressMap addrMap;
    private RelocationDBAdapter adapter;
    private Boolean isRelocatable = null;
    private Lock lock;

    public RelocationManager(DBHandle handle, AddressMap addrMap, int openMode, Lock lock, TaskMonitor monitor) throws VersionException, IOException {
        this.addrMap = addrMap;
        this.lock = lock;
        this.initializeAdapters(handle, openMode, monitor);
    }

    private void initializeAdapters(DBHandle handle, int openMode, TaskMonitor monitor) throws VersionException, IOException {
        this.adapter = RelocationDBAdapter.getAdapter(handle, openMode, this.addrMap, monitor);
    }

    @Override
    public void invalidateCache(boolean all) {
    }

    @Override
    public void setProgram(ProgramDB p) {
        this.program = p;
    }

    @Override
    public void programReady(int openMode, int currentRevision, TaskMonitor monitor) throws IOException, CancelledException {
    }

    private byte[] getOriginalBytes(Address addr, byte[] bytes) throws IOException {
        if (bytes != null) {
            return bytes;
        }
        int byteCount = this.program.getDefaultPointerSize() > 4 ? 8 : 4;
        byte[] originalBytes = new byte[byteCount];
        AddressSourceInfo addressSourceInfo = this.program.getMemory().getAddressSourceInfo(addr);
        if (addressSourceInfo == null) {
            return null;
        }
        MemoryBlockSourceInfo memoryBlockSourceInfo = addressSourceInfo.getMemoryBlockSourceInfo();
        Optional<FileBytes> optional = memoryBlockSourceInfo.getFileBytes();
        if (!optional.isEmpty()) {
            FileBytes fileBytes = optional.get();
            long fileBytesOffset = addressSourceInfo.getFileOffset();
            long offsetIntoSourceRange = fileBytesOffset - memoryBlockSourceInfo.getFileBytesOffset();
            long available = memoryBlockSourceInfo.getLength() - offsetIntoSourceRange;
            int readSize = (int)Math.min(available, (long)byteCount);
            fileBytes.getOriginalBytes(fileBytesOffset, originalBytes, 0, readSize);
        }
        return originalBytes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Relocation add(Address addr, int type, long[] values, byte[] bytes, String symbolName) {
        this.lock.acquire();
        try {
            this.adapter.add(addr, type, values, bytes, symbolName);
            Relocation relocation = new Relocation(addr, type, values, this.getOriginalBytes(addr, bytes), symbolName);
            return relocation;
        }
        catch (IOException e) {
            this.program.dbError(e);
        }
        finally {
            this.lock.release();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean hasRelocation(Address addr) {
        this.lock.acquire();
        try {
            RecordIterator it = this.adapter.iterator(addr);
            if (!it.hasNext()) {
                boolean bl = false;
                return bl;
            }
            DBRecord r = it.next();
            Address a = this.addrMap.decodeAddress(r.getLongValue(0));
            boolean bl = addr.equals(a);
            return bl;
        }
        catch (IOException e) {
            this.program.dbError(e);
        }
        finally {
            this.lock.release();
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Relocation> getRelocations(Address addr) {
        this.lock.acquire();
        try {
            DBRecord rec;
            Address a;
            ArrayList<Relocation> list = null;
            RecordIterator it = this.adapter.iterator(addr);
            while (it.hasNext() && addr.equals(a = this.addrMap.decodeAddress((rec = it.next()).getLongValue(0)))) {
                if (list == null) {
                    list = new ArrayList<Relocation>();
                }
                list.add(this.getRelocation(rec));
            }
            List<Relocation> list2 = list == null ? List.of() : list;
            return list2;
        }
        catch (IOException e) {
            this.program.dbError(e);
        }
        finally {
            this.lock.release();
        }
        return null;
    }

    private Relocation getRelocation(DBRecord rec) throws IOException {
        Address addr = this.addrMap.decodeAddress(rec.getLongValue(0));
        BinaryCodedField valuesField = new BinaryCodedField((BinaryField)rec.getFieldValue(2));
        byte[] originalBytes = this.getOriginalBytes(addr, rec.getBinaryData(3));
        return new Relocation(addr, rec.getIntValue(1), valuesField.getLongArray(), originalBytes, rec.getString(4));
    }

    @Override
    public Iterator<Relocation> getRelocations() {
        RecordIterator ri = null;
        this.lock.acquire();
        try {
            ri = this.adapter.iterator();
        }
        catch (IOException e) {
            this.program.dbError(e);
        }
        finally {
            this.lock.release();
        }
        return new RelocationIterator(ri);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Address getRelocationAddressAfter(Address addr) {
        this.lock.acquire();
        try {
            RecordIterator it = this.adapter.iterator(addr);
            while (it.hasNext()) {
                DBRecord rec = it.next();
                Address a = this.addrMap.decodeAddress(rec.getLongValue(0));
                if (addr.equals(a)) continue;
                Address address = a;
                return address;
            }
        }
        catch (IOException e) {
            this.program.dbError(e);
        }
        finally {
            this.lock.release();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Iterator<Relocation> getRelocations(AddressSetView set) {
        RecordIterator it = null;
        this.lock.acquire();
        try {
            it = this.adapter.iterator(set);
        }
        catch (IOException e) {
            this.program.dbError(e);
        }
        finally {
            this.lock.release();
        }
        return new RelocationIterator(it);
    }

    @Override
    public int getSize() {
        return this.adapter.getRecordCount();
    }

    @Override
    public boolean isRelocatable() {
        if (this.isRelocatable == null) {
            Options propList = this.program.getOptions("Program Information");
            this.isRelocatable = propList.contains("Relocatable") ? Boolean.valueOf(propList.getBoolean("Relocatable", false)) : Boolean.valueOf(this.getSize() > 0);
        }
        return this.isRelocatable;
    }

    @Override
    public void deleteAddressRange(Address startAddr, Address endAddr, TaskMonitor monitor) {
    }

    @Override
    public void moveAddressRange(Address fromAddr, Address toAddr, long length, TaskMonitor monitor) {
    }

    private class RelocationIterator
    implements Iterator<Relocation> {
        private RecordIterator it;

        RelocationIterator(RecordIterator ri) {
            this.it = ri;
        }

        @Override
        public boolean hasNext() {
            if (this.it == null) {
                return false;
            }
            RelocationManager.this.lock.acquire();
            try {
                boolean bl = this.it.hasNext();
                return bl;
            }
            catch (IOException e) {
                RelocationManager.this.program.dbError(e);
            }
            finally {
                RelocationManager.this.lock.release();
            }
            return false;
        }

        @Override
        public Relocation next() {
            if (this.it == null) {
                return null;
            }
            RelocationManager.this.lock.acquire();
            try {
                DBRecord r = this.it.next();
                Relocation relocation = RelocationManager.this.getRelocation(r);
                return relocation;
            }
            catch (IOException e) {
                RelocationManager.this.program.dbError(e);
            }
            finally {
                RelocationManager.this.lock.release();
            }
            return null;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("Cannot remove from relocation table inside iterator!");
        }
    }
}

