/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.database.function;

import db.DBRecord;
import ghidra.program.database.DBObjectCache;
import ghidra.program.database.DatabaseObject;
import ghidra.program.database.ProgramDB;
import ghidra.program.database.data.ProgramDataTypeManager;
import ghidra.program.database.external.ExternalManagerDB;
import ghidra.program.database.function.FunctionAdapter;
import ghidra.program.database.function.FunctionManagerDB;
import ghidra.program.database.function.FunctionStackFrame;
import ghidra.program.database.function.FunctionTagManagerDB;
import ghidra.program.database.function.LocalVariableDB;
import ghidra.program.database.function.OverlappingFunctionException;
import ghidra.program.database.function.ParameterDB;
import ghidra.program.database.function.ReturnParameterDB;
import ghidra.program.database.function.VariableDB;
import ghidra.program.database.map.AddressMap;
import ghidra.program.database.references.ReferenceDBManager;
import ghidra.program.database.symbol.SymbolDB;
import ghidra.program.database.symbol.SymbolManager;
import ghidra.program.database.symbol.VariableSymbolDB;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressIterator;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.FunctionDefinitionDataType;
import ghidra.program.model.data.GenericCallingConvention;
import ghidra.program.model.data.Pointer;
import ghidra.program.model.data.Structure;
import ghidra.program.model.data.TypeDef;
import ghidra.program.model.data.Undefined;
import ghidra.program.model.data.VoidDataType;
import ghidra.program.model.lang.CompilerSpec;
import ghidra.program.model.lang.PrototypeModel;
import ghidra.program.model.listing.AutoParameterImpl;
import ghidra.program.model.listing.AutoParameterType;
import ghidra.program.model.listing.CircularDependencyException;
import ghidra.program.model.listing.Function;
import ghidra.program.model.listing.FunctionSignature;
import ghidra.program.model.listing.FunctionTag;
import ghidra.program.model.listing.GhidraClass;
import ghidra.program.model.listing.LocalVariableImpl;
import ghidra.program.model.listing.Parameter;
import ghidra.program.model.listing.ParameterImpl;
import ghidra.program.model.listing.Program;
import ghidra.program.model.listing.StackFrame;
import ghidra.program.model.listing.Variable;
import ghidra.program.model.listing.VariableFilter;
import ghidra.program.model.listing.VariableSizeException;
import ghidra.program.model.listing.VariableStorage;
import ghidra.program.model.listing.VariableUtilities;
import ghidra.program.model.symbol.ExternalLocation;
import ghidra.program.model.symbol.Namespace;
import ghidra.program.model.symbol.Reference;
import ghidra.program.model.symbol.ReferenceIterator;
import ghidra.program.model.symbol.SourceType;
import ghidra.program.model.symbol.Symbol;
import ghidra.program.model.symbol.SymbolIterator;
import ghidra.program.model.symbol.SymbolType;
import ghidra.program.model.symbol.SymbolUtilities;
import ghidra.program.model.util.StringPropertyMap;
import ghidra.util.Msg;
import ghidra.util.StringUtilities;
import ghidra.util.SystemUtilities;
import ghidra.util.exception.AssertException;
import ghidra.util.exception.DuplicateNameException;
import ghidra.util.exception.InvalidInputException;
import ghidra.util.task.TaskMonitor;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class FunctionDB
extends DatabaseObject
implements Function {
    final FunctionManagerDB manager;
    private FunctionDB thunkedFunction;
    private ProgramDB program;
    private Address entryPoint;
    private Symbol functionSymbol;
    private DBRecord rec;
    private FunctionStackFrame frame;
    private Map<SymbolDB, VariableDB> symbolMap;
    private ReturnParameterDB returnParam;
    private List<AutoParameterImpl> autoParams;
    private List<ParameterDB> params;
    private List<VariableDB> locals;
    private Set<FunctionTag> tags;
    private boolean foundBadVariables = false;
    private boolean validateEnabled = true;
    private int updateInProgressCount = 0;
    private boolean updateRefreshRequired = false;

    FunctionDB(FunctionManagerDB manager, DBObjectCache<FunctionDB> cache, AddressMap addrMap, DBRecord rec) {
        super(cache, rec.getKey());
        this.manager = manager;
        this.program = manager.getProgram();
        this.rec = rec;
        this.init();
        this.frame = new FunctionStackFrame(this);
    }

    @Override
    public boolean isDeleted() {
        return this.isDeleted(this.manager.lock);
    }

    public void setValidationEnabled(boolean state) {
        this.validateEnabled = state;
    }

    private void init() {
        this.thunkedFunction = this.manager.getThunkedFunction(this);
        this.functionSymbol = this.program.getSymbolTable().getSymbol(this.key);
        this.entryPoint = this.functionSymbol.getAddress();
    }

    @Override
    protected void checkDeleted() {
        super.checkDeleted();
    }

    @Override
    public boolean isThunk() {
        this.manager.lock.acquire();
        try {
            this.checkIsValid();
            boolean bl = this.thunkedFunction != null;
            return bl;
        }
        finally {
            this.manager.lock.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Function getThunkedFunction(boolean recursive) {
        this.manager.lock.acquire();
        try {
            this.checkIsValid();
            if (!recursive || this.thunkedFunction == null) {
                FunctionDB functionDB = this.thunkedFunction;
                return functionDB;
            }
            FunctionDB endFunction = this.thunkedFunction;
            while (endFunction.thunkedFunction != null) {
                endFunction = endFunction.thunkedFunction;
            }
            FunctionDB functionDB = endFunction;
            return functionDB;
        }
        finally {
            this.manager.lock.release();
        }
    }

    @Override
    public void setThunkedFunction(Function referencedFunction) {
        if (referencedFunction != null && !(referencedFunction instanceof FunctionDB)) {
            throw new IllegalArgumentException("FunctionDB expected for referenced function");
        }
        this.manager.lock.acquire();
        try {
            this.startUpdate();
            this.checkDeleted();
            this.manager.setThunkedFunction(this, (FunctionDB)referencedFunction);
        }
        finally {
            this.endUpdate();
            this.manager.lock.release();
        }
    }

    private List<Address> getFunctionThunkAddresses(long functionId, boolean recursive) {
        List<Long> functionIds = this.manager.getThunkFunctionIds(functionId);
        if (functionIds == null) {
            return null;
        }
        SymbolManager symMgr = this.program.getSymbolTable();
        ArrayList<Address> thunkAddrList = new ArrayList<Address>();
        for (long id : functionIds) {
            List<Address> thunkAddrs;
            Symbol s = symMgr.getSymbol(id);
            thunkAddrList.add(s.getAddress());
            if (!recursive || (thunkAddrs = this.getFunctionThunkAddresses(id, true)) == null) continue;
            thunkAddrList.addAll(thunkAddrs);
        }
        return thunkAddrList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Address[] getFunctionThunkAddresses(boolean recursive) {
        this.manager.lock.acquire();
        try {
            this.checkIsValid();
            List<Address> thunkAddrList = this.getFunctionThunkAddresses(this.key, recursive);
            if (thunkAddrList == null) {
                Address[] addressArray = null;
                return addressArray;
            }
            Address[] addressArray = thunkAddrList.toArray(new Address[thunkAddrList.size()]);
            return addressArray;
        }
        finally {
            this.manager.lock.release();
        }
    }

    @Override
    public boolean isExternal() {
        return this.entryPoint.isExternalAddress();
    }

    @Override
    public ExternalLocation getExternalLocation() {
        if (this.isExternal()) {
            ExternalManagerDB extMgr = this.program.getExternalManager();
            return extMgr.getExternalLocation(this.getSymbol());
        }
        return null;
    }

    public boolean equals(Object obj) {
        return super.equals(obj);
    }

    public int hashCode() {
        return super.hashCode();
    }

    public String toString() {
        return this.getName(true);
    }

    @Override
    public String getName() {
        this.manager.lock.acquire();
        try {
            this.checkIsValid();
            String string = this.functionSymbol.getName();
            return string;
        }
        finally {
            this.manager.lock.release();
        }
    }

    @Override
    public void setName(String name, SourceType source) throws DuplicateNameException, InvalidInputException {
        this.manager.lock.acquire();
        try {
            this.startUpdate();
            this.checkDeleted();
            this.functionSymbol.setName(name, source);
        }
        finally {
            this.endUpdate();
            this.manager.lock.release();
        }
    }

    @Override
    public Program getProgram() {
        return this.manager.getProgram();
    }

    @Override
    public String getComment() {
        this.manager.lock.acquire();
        try {
            this.checkIsValid();
            String string = this.manager.getCodeManager().getComment(3, this.getEntryPoint());
            return string;
        }
        finally {
            this.manager.lock.release();
        }
    }

    @Override
    public String[] getCommentAsArray() {
        return StringUtilities.toLines((String)this.getComment());
    }

    @Override
    public void setComment(String comment) {
        this.manager.lock.acquire();
        try {
            this.startUpdate();
            this.checkDeleted();
            this.manager.getCodeManager().setComment(this.getEntryPoint(), 3, comment);
        }
        finally {
            this.endUpdate();
            this.manager.lock.release();
        }
    }

    @Override
    public String getRepeatableComment() {
        this.manager.lock.acquire();
        try {
            this.checkIsValid();
            String string = this.manager.getCodeManager().getComment(4, this.getEntryPoint());
            return string;
        }
        finally {
            this.manager.lock.release();
        }
    }

    @Override
    public String[] getRepeatableCommentAsArray() {
        return StringUtilities.toLines((String)this.getRepeatableComment());
    }

    @Override
    public void setRepeatableComment(String comment) {
        this.manager.lock.acquire();
        try {
            this.checkDeleted();
            this.manager.getCodeManager().setComment(this.getEntryPoint(), 4, comment);
        }
        finally {
            this.manager.lock.release();
        }
    }

    @Override
    public Address getEntryPoint() {
        this.manager.lock.acquire();
        try {
            this.checkIsValid();
            Address address = this.entryPoint;
            return address;
        }
        finally {
            this.manager.lock.release();
        }
    }

    @Override
    public AddressSetView getBody() {
        return this.program.getNamespaceManager().getAddressSet(this);
    }

    @Override
    public void setBody(AddressSetView set) throws OverlappingFunctionException {
        this.manager.lock.acquire();
        try {
            this.startUpdate();
            this.checkDeleted();
            this.manager.setFunctionBody(this, set);
        }
        finally {
            this.endUpdate();
            this.manager.lock.release();
        }
    }

    @Override
    public DataType getReturnType() {
        return this.getReturn().getDataType();
    }

    @Override
    public ReturnParameterDB getReturn() {
        this.manager.lock.acquire();
        try {
            this.checkIsValid();
            if (this.thunkedFunction != null) {
                ReturnParameterDB returnParameterDB = this.thunkedFunction.getReturn();
                return returnParameterDB;
            }
            this.loadVariables();
            ReturnParameterDB returnParameterDB = this.returnParam;
            return returnParameterDB;
        }
        finally {
            this.manager.lock.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setReturn(DataType type, VariableStorage storage, SourceType source) throws InvalidInputException {
        this.manager.lock.acquire();
        try {
            this.startUpdate();
            this.checkDeleted();
            if (this.thunkedFunction != null) {
                this.thunkedFunction.setReturn(type, storage, source);
                return;
            }
            type = type.clone(this.program.getDataTypeManager());
            if (storage.isValid() && storage.size() != type.getLength()) {
                try {
                    storage = VariableUtilities.resizeStorage(storage, type, true, this);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            this.getReturn().setDataType(type, storage, true, source);
        }
        finally {
            this.endUpdate();
            this.manager.lock.release();
        }
    }

    @Override
    public void setReturnType(DataType type, SourceType source) throws InvalidInputException {
        this.manager.lock.acquire();
        try {
            this.startUpdate();
            this.checkDeleted();
            if (this.thunkedFunction != null) {
                this.thunkedFunction.setReturnType(type, source);
                return;
            }
            this.getReturn().setDataType(type, source);
        }
        finally {
            this.endUpdate();
            this.manager.lock.release();
        }
    }

    void setReturnStorageAndDataType(VariableStorage storage, DataType type) throws IOException {
        if (storage != null && storage.isUnassignedStorage()) {
            storage = null;
        }
        long typeId = this.program.getDataTypeManager().getResolvedID(type);
        this.rec.setLongValue(0, typeId);
        this.rec.setString(6, storage != null ? storage.getSerializationString() : null);
        this.manager.getFunctionAdapter().updateFunctionRecord(this.rec);
    }

    DataType getReturnDataType() {
        long typeId = this.rec.getLongValue(0);
        DataType dt = this.program.getDataTypeManager().getDataType(typeId);
        if (dt == null) {
            dt = DataType.DEFAULT;
            if (this.hasCustomVariableStorage()) {
                VariableStorage storage = this.deserializeStorage(this.rec.getString(6));
                dt = storage.isVoidStorage() ? VoidDataType.dataType : Undefined.getUndefinedDataType(storage.size());
            }
        }
        return dt;
    }

    private VariableStorage deserializeStorage(String serializedStorage) {
        if (serializedStorage == null) {
            return VariableStorage.UNASSIGNED_STORAGE;
        }
        try {
            return VariableStorage.deserialize(this.program, serializedStorage);
        }
        catch (InvalidInputException e) {
            return VariableStorage.BAD_STORAGE;
        }
    }

    @Override
    public FunctionSignature getSignature(boolean formalSignature) {
        this.manager.lock.acquire();
        try {
            this.startUpdate();
            this.checkIsValid();
            if (this.thunkedFunction == null) {
                this.loadVariables();
            }
            FunctionDefinitionDataType functionDefinitionDataType = new FunctionDefinitionDataType(this, formalSignature);
            return functionDefinitionDataType;
        }
        finally {
            this.endUpdate();
            this.manager.lock.release();
        }
    }

    @Override
    public FunctionSignature getSignature() {
        return this.getSignature(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getPrototypeString(boolean formalSignature, boolean includeCallingConvention) {
        this.manager.lock.acquire();
        try {
            String callingConvention;
            if (!this.checkIsValid()) {
                String string = "undefined " + this.getName() + "()";
                return string;
            }
            if (this.thunkedFunction == null) {
                this.loadVariables();
            }
            StringBuffer buf = new StringBuffer();
            ReturnParameterDB rtn = this.getReturn();
            buf.append(formalSignature ? rtn.getFormalDataType().getDisplayName() : rtn.getDataType().getDisplayName());
            buf.append(" ");
            if (includeCallingConvention && (callingConvention = this.getRealCallingConventionName()) != null) {
                buf.append(callingConvention);
                buf.append(" ");
            }
            buf.append(this.getName());
            buf.append("(");
            boolean hasVarArgs = this.hasVarArgs();
            Parameter[] parameters = this.getParameters();
            int n = parameters.length;
            boolean emptyList = true;
            for (int i = 0; i < n; ++i) {
                Parameter param = parameters[i];
                if (formalSignature && param.isAutoParameter()) continue;
                DataType dt = formalSignature ? param.getFormalDataType() : param.getDataType();
                buf.append(dt.getDisplayName());
                buf.append(" ");
                buf.append(param.getName());
                emptyList = false;
                if (i >= n - 1 && !hasVarArgs) continue;
                buf.append(", ");
            }
            if (hasVarArgs) {
                buf.append("...");
            } else if (emptyList && this.getSignatureSource() != SourceType.DEFAULT) {
                buf.append("void");
            }
            buf.append(")");
            String string = buf.toString();
            return string;
        }
        finally {
            this.manager.lock.release();
        }
    }

    void updateSignatureSourceAfterVariableChange(SourceType variableSourceType, DataType variableDataType) {
        if (Undefined.isUndefined(variableDataType)) {
            return;
        }
        SourceType type = SourceType.ANALYSIS;
        if (variableSourceType != type && variableSourceType.isHigherPriorityThan(type)) {
            type = variableSourceType;
        }
        if (type.isHigherPriorityThan(this.getStoredSignatureSource())) {
            this.setSignatureSource(type);
        }
    }

    SourceType getInferredSignatureSource() {
        Parameter[] parameters;
        DataType returnType = this.getReturnType();
        boolean isReturnUndefined = Undefined.isUndefined(returnType);
        SourceType type = isReturnUndefined ? SourceType.DEFAULT : SourceType.ANALYSIS;
        for (Parameter parameter : parameters = this.getParameters()) {
            if (Undefined.isUndefined(parameter.getDataType())) continue;
            SourceType paramSourceType = parameter.getSource();
            type = paramSourceType != SourceType.ANALYSIS && paramSourceType.isHigherPriorityThan(SourceType.ANALYSIS) ? paramSourceType : SourceType.ANALYSIS;
        }
        return type;
    }

    @Override
    public StackFrame getStackFrame() {
        this.manager.lock.acquire();
        try {
            this.checkIsValid();
            if (this.thunkedFunction != null) {
                FunctionStackFrame functionStackFrame = this.thunkedFunction.frame;
                return functionStackFrame;
            }
            FunctionStackFrame functionStackFrame = this.frame;
            return functionStackFrame;
        }
        finally {
            this.manager.lock.release();
        }
    }

    @Override
    public int getStackPurgeSize() {
        this.manager.lock.acquire();
        try {
            this.checkIsValid();
            if (this.thunkedFunction != null) {
                int n = this.thunkedFunction.getStackPurgeSize();
                return n;
            }
            int n = this.rec.getIntValue(1);
            return n;
        }
        finally {
            this.manager.lock.release();
        }
    }

    @Override
    public void setStackPurgeSize(int change) {
        this.manager.lock.acquire();
        try {
            this.startUpdate();
            if (change == this.getStackPurgeSize()) {
                return;
            }
            this.checkDeleted();
            if (this.thunkedFunction != null) {
                this.thunkedFunction.setStackPurgeSize(change);
                return;
            }
            try {
                this.rec.setIntValue(1, change);
                this.manager.getFunctionAdapter().updateFunctionRecord(this.rec);
                this.manager.functionChanged(this, 1);
            }
            catch (IOException e) {
                this.manager.dbError(e);
            }
            this.frame.setInvalid();
        }
        finally {
            this.endUpdate();
            this.manager.lock.release();
        }
    }

    @Override
    public boolean isStackPurgeSizeValid() {
        this.manager.lock.acquire();
        try {
            this.checkIsValid();
            if (this.thunkedFunction != null) {
                boolean bl = this.thunkedFunction.isStackPurgeSizeValid();
                return bl;
            }
            if (this.getStackPurgeSize() > 0xFFFFFF) {
                boolean bl = false;
                return bl;
            }
            boolean bl = true;
            return bl;
        }
        finally {
            this.manager.lock.release();
        }
    }

    @Override
    public long getID() {
        return this.key;
    }

    private static boolean isBadVariable(VariableSymbolDB varSym) {
        return varSym.getAddress() == Address.NO_ADDRESS || varSym.getVariableStorage().isBadStorage();
    }

    private void loadVariables() {
        this.manager.lock.acquire();
        try {
            if (!this.loadSymbolBasedVariables()) {
                return;
            }
            boolean hasCustomVariableStorage = this.hasCustomVariableStorage();
            this.loadReturn(hasCustomVariableStorage);
            if (this.foundBadVariables) {
                Msg.warn((Object)this, (Object)("Found one or more bad variables in function " + this.getName() + " at " + this.getEntryPoint()));
            }
            if (!hasCustomVariableStorage) {
                this.updateParametersAndReturn();
            }
        }
        finally {
            this.manager.lock.release();
        }
    }

    private boolean loadSymbolBasedVariables() {
        if (this.symbolMap != null) {
            return false;
        }
        this.symbolMap = new HashMap<SymbolDB, VariableDB>();
        this.locals = new ArrayList<VariableDB>();
        this.params = new ArrayList<ParameterDB>();
        this.autoParams = null;
        SymbolIterator it = this.program.getSymbolTable().getChildren(this.functionSymbol);
        while (it.hasNext()) {
            SymbolDB s = (SymbolDB)it.next();
            if (!(s instanceof VariableSymbolDB)) continue;
            VariableSymbolDB varSym = (VariableSymbolDB)s;
            if (FunctionDB.isBadVariable(varSym)) {
                this.foundBadVariables = true;
                continue;
            }
            if (s.getSymbolType() == SymbolType.PARAMETER) {
                ParameterDB p = new ParameterDB(this, s);
                this.symbolMap.put(s, p);
                this.params.add(p);
                continue;
            }
            LocalVariableDB var = new LocalVariableDB(this, s);
            this.symbolMap.put(s, var);
            this.locals.add(var);
        }
        Collections.sort(this.params);
        Collections.sort(this.locals);
        return true;
    }

    private boolean loadReturn(boolean hasCustomVariableStorage) {
        String serializedStorage;
        if (this.returnParam != null) {
            return false;
        }
        DataType dt = this.getReturnDataType();
        VariableStorage returnStorage = VariableStorage.UNASSIGNED_STORAGE;
        if (hasCustomVariableStorage && (serializedStorage = this.rec.getString(6)) != null && (returnStorage = this.deserializeStorage(serializedStorage)).isBadStorage()) {
            this.foundBadVariables = true;
        }
        this.returnParam = new ReturnParameterDB(this, dt, returnStorage);
        return true;
    }

    void updateParametersAndReturn() {
        if (this.params == null) {
            this.loadVariables();
            return;
        }
        if (this.hasCustomVariableStorage()) {
            this.autoParams = null;
            this.renumberParameterOrdinals();
            return;
        }
        DataType[] dataTypes = new DataType[this.params.size() + 1];
        for (int i = 0; i < this.params.size(); ++i) {
            ParameterDB param = this.params.get(i);
            param.setDynamicStorage(VariableStorage.UNASSIGNED_STORAGE);
            dataTypes[i + 1] = param.getDataType();
        }
        dataTypes[0] = this.returnParam.getFormalDataType();
        DataType baseType = dataTypes[0];
        if (baseType instanceof TypeDef) {
            baseType = ((TypeDef)baseType).getBaseDataType();
        }
        this.returnParam.setDynamicStorage(baseType instanceof VoidDataType ? VariableStorage.VOID_STORAGE : VariableStorage.UNASSIGNED_STORAGE);
        PrototypeModel callingConvention = this.getCallingConvention();
        if (callingConvention == null) {
            callingConvention = this.getDefaultCallingConvention();
        }
        if (callingConvention == null) {
            return;
        }
        VariableStorage[] variableStorage = callingConvention.getStorageLocations(this.program, dataTypes, true);
        this.returnParam.setDynamicStorage(variableStorage[0]);
        int autoIndex = 0;
        int paramIndex = 0;
        this.autoParams = null;
        for (int i = 1; i < variableStorage.length; ++i) {
            VariableStorage storage = variableStorage[i];
            if (storage.isAutoStorage()) {
                if (this.autoParams == null) {
                    this.autoParams = new ArrayList<AutoParameterImpl>();
                }
                DataType dt = VariableUtilities.getAutoDataType(this, this.returnParam.getFormalDataType(), storage);
                try {
                    this.autoParams.add(new AutoParameterImpl(dt, autoIndex++, storage, this));
                    continue;
                }
                catch (InvalidInputException e) {
                    Msg.error((Object)this, (Object)("Unexpected error during dynamic storage assignment for function at " + this.getEntryPoint()), (Throwable)e);
                    break;
                }
            }
            ParameterDB parameterDB = this.params.get(paramIndex++);
            parameterDB.setDynamicStorage(storage);
        }
        this.renumberParameterOrdinals();
    }

    int getAutoParamCount() {
        return this.autoParams != null ? this.autoParams.size() : 0;
    }

    private void renumberParameterOrdinals() {
        int ordinal = this.autoParams != null ? this.autoParams.size() : 0;
        for (ParameterDB param : this.params) {
            param.setOrdinal(ordinal++);
        }
    }

    private void purgeBadVariables() {
        ReturnParameterDB rtnParam;
        if (!this.foundBadVariables) {
            return;
        }
        ArrayList<SymbolDB> badSymbols = new ArrayList<SymbolDB>();
        SymbolIterator it = this.program.getSymbolTable().getChildren(this.functionSymbol);
        while (it.hasNext()) {
            VariableSymbolDB variableSymbolDB;
            SymbolDB s = (SymbolDB)it.next();
            if (!(s instanceof VariableSymbolDB) || !FunctionDB.isBadVariable(variableSymbolDB = (VariableSymbolDB)s)) continue;
            badSymbols.add(s);
        }
        this.program.getBookmarkManager().setBookmark(this.getEntryPoint(), "Error", "Bad Variables Removed", "Removed " + badSymbols.size() + " bad variables");
        for (Symbol symbol : badSymbols) {
            symbol.delete();
        }
        if (this.hasCustomVariableStorage() && (rtnParam = this.getReturn()).getVariableStorage().isBadStorage()) {
            DataType dataType = rtnParam.getDataType();
            DataType baseType = dataType;
            if (baseType instanceof TypeDef) {
                baseType = ((TypeDef)baseType).getBaseDataType();
            }
            VariableStorage storage = baseType instanceof VoidDataType ? VariableStorage.VOID_STORAGE : VariableStorage.UNASSIGNED_STORAGE;
            rtnParam.setStorageAndDataType(storage, dataType);
        }
        this.foundBadVariables = false;
    }

    FunctionManagerDB getFunctionManager() {
        return this.manager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public VariableDB addLocalVariable(Variable var, SourceType source) throws DuplicateNameException, InvalidInputException {
        this.manager.lock.acquire();
        try {
            this.startUpdate();
            this.checkDeleted();
            if (this.thunkedFunction != null) {
                VariableDB variableDB = this.thunkedFunction.addLocalVariable(var, source);
                return variableDB;
            }
            this.loadVariables();
            this.purgeBadVariables();
            var = this.getResolvedVariable(var, false, false);
            String name = var.getName();
            if (name == null || name.length() == 0 || SymbolUtilities.isDefaultParameterName(name)) {
                name = "local_";
                source = SourceType.DEFAULT;
            }
            VariableStorage storage = var.getVariableStorage();
            int firstUseOffset = var.getFirstUseOffset();
            if (var.hasStackStorage() && firstUseOffset != 0) {
                Msg.info((Object)this, (Object)("WARNING! Stack variable firstUseOffset forced to 0 for function " + this + " at " + storage));
                firstUseOffset = 0;
            }
            Variable v = null;
            for (VariableDB oldVar : this.locals) {
                if (oldVar.getFirstUseOffset() != firstUseOffset || !oldVar.getVariableStorage().intersects(storage)) continue;
                v = oldVar;
                break;
            }
            try {
                if (this.validateEnabled) {
                    VariableUtilities.checkVariableConflict(this, v != null ? v : var, storage, true);
                }
                if (v != null) {
                    Msg.info((Object)this, (Object)("WARNING! Adding overlapping local variable for function " + this + " at " + ((VariableDB)v).getVariableStorage() + " - Modifying existing variable!"));
                    if (!"local_".equals(name)) {
                        ((VariableDB)v).setName(name, source);
                    }
                    ((VariableDB)v).setStorageAndDataType(storage, var.getDataType());
                } else {
                    SymbolManager symbolMgr = this.program.getSymbolTable();
                    VariableSymbolDB s = symbolMgr.createVariableSymbol(name, this, SymbolType.LOCAL_VAR, firstUseOffset, storage, source);
                    s.setStorageAndDataType(storage, var.getDataType());
                    v = new LocalVariableDB(this, s);
                    this.locals.add((VariableDB)v);
                    Collections.sort(this.locals);
                    this.symbolMap.put(((VariableDB)v).symbol, (VariableDB)v);
                }
                if (var.getComment() != null) {
                    ((VariableDB)v).symbol.setSymbolStringData(var.getComment());
                }
                this.manager.functionChanged(this, 0);
                Variable variable = v;
                this.frame.setInvalid();
                return variable;
            }
            catch (Throwable throwable) {
                this.frame.setInvalid();
                throw throwable;
            }
        }
        finally {
            this.endUpdate();
            this.manager.lock.release();
        }
    }

    private Variable[] adjustThunkThisParameter(Variable[] variables) {
        Symbol s = this.getSymbol();
        if (s.getParentNamespace().getID() == 0L) {
            return variables;
        }
        for (int i = 0; i < variables.length; ++i) {
            if (!(variables[i] instanceof AutoParameterImpl)) continue;
            variables[i] = this.adjustThunkThisParameter((AutoParameterImpl)variables[i]);
        }
        return variables;
    }

    private Parameter[] adjustThunkThisParameter(Parameter[] parameters) {
        Symbol s = this.getSymbol();
        if (s.getParentNamespace().getID() == 0L) {
            return parameters;
        }
        for (int i = 0; i < parameters.length; ++i) {
            if (!(parameters[i] instanceof AutoParameterImpl)) continue;
            parameters[i] = this.adjustThunkThisParameter(parameters[i]);
        }
        return parameters;
    }

    private Parameter adjustThunkThisParameter(Parameter parameter) {
        if (!parameter.isAutoParameter()) {
            return parameter;
        }
        Symbol s = this.getSymbol();
        if (s.getParentNamespace().getID() == 0L) {
            return parameter;
        }
        VariableStorage variableStorage = parameter.getVariableStorage();
        if (variableStorage.getAutoParameterType() == AutoParameterType.THIS) {
            DataType dt = VariableUtilities.getAutoDataType(this, null, variableStorage);
            try {
                return new AutoParameterImpl(dt, parameter.getOrdinal(), variableStorage, this);
            }
            catch (InvalidInputException e) {
                Msg.error((Object)this, (Object)("Unexpected error during dynamic storage assignment for function at " + this.getEntryPoint()), (Throwable)e);
            }
        }
        return parameter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Variable[] getVariables(VariableFilter filter) {
        this.manager.lock.acquire();
        try {
            this.checkIsValid();
            if (this.thunkedFunction != null) {
                Variable[] variables = this.thunkedFunction.getVariables(new ThunkVariableFilter(filter));
                Variable[] variableArray = this.adjustThunkThisParameter(variables);
                return variableArray;
            }
            this.loadVariables();
            ArrayList<Variable> list = new ArrayList<Variable>();
            if (this.autoParams != null) {
                for (AutoParameterImpl variableArray : this.autoParams) {
                    if (filter != null && !filter.matches(variableArray)) continue;
                    list.add(variableArray);
                }
            }
            for (ParameterDB parameterDB : this.params) {
                if (filter != null && !filter.matches(parameterDB)) continue;
                list.add(parameterDB);
            }
            for (VariableDB variableDB : this.locals) {
                if (filter != null && !filter.matches(variableDB)) continue;
                list.add(variableDB);
            }
            Variable[] vars = new Variable[list.size()];
            Variable[] variableArray = list.toArray(vars);
            return variableArray;
        }
        finally {
            this.manager.lock.release();
        }
    }

    @Override
    public Variable[] getAllVariables() {
        return this.getVariables(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Parameter[] getParameters(VariableFilter filter) {
        this.manager.lock.acquire();
        try {
            this.checkIsValid();
            if (this.thunkedFunction != null) {
                Parameter[] parameters = this.thunkedFunction.getParameters(filter);
                Parameter[] parameterArray = this.adjustThunkThisParameter(parameters);
                return parameterArray;
            }
            this.loadVariables();
            ArrayList<Parameter> list = new ArrayList<Parameter>();
            if (this.autoParams != null) {
                for (AutoParameterImpl parameterArray : this.autoParams) {
                    if (filter != null && !filter.matches(parameterArray)) continue;
                    list.add(parameterArray);
                }
            }
            for (ParameterDB parameterDB : this.params) {
                if (filter != null && !filter.matches(parameterDB)) continue;
                list.add(parameterDB);
            }
            Parameter[] vars = new Parameter[list.size()];
            Parameter[] parameterArray = list.toArray(vars);
            return parameterArray;
        }
        finally {
            this.manager.lock.release();
        }
    }

    @Override
    public Parameter[] getParameters() {
        return this.getParameters(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Variable[] getLocalVariables(VariableFilter filter) {
        this.manager.lock.acquire();
        try {
            this.checkIsValid();
            if (this.thunkedFunction != null) {
                Variable[] variableArray = new Variable[]{};
                return variableArray;
            }
            this.loadVariables();
            ArrayList<VariableDB> list = new ArrayList<VariableDB>();
            for (VariableDB var : this.locals) {
                if (filter != null && !filter.matches(var)) continue;
                list.add(var);
            }
            Variable[] vars = new Variable[list.size()];
            Variable[] variableArray = list.toArray(vars);
            return variableArray;
        }
        finally {
            this.manager.lock.release();
        }
    }

    @Override
    public Variable[] getLocalVariables() {
        return this.getLocalVariables(null);
    }

    @Override
    public int getParameterCount() {
        this.manager.lock.acquire();
        try {
            this.checkIsValid();
            if (this.thunkedFunction != null) {
                int n = this.thunkedFunction.getParameterCount();
                return n;
            }
            this.loadVariables();
            int count = this.params.size();
            if (this.autoParams != null) {
                count += this.autoParams.size();
            }
            int n = count;
            return n;
        }
        finally {
            this.manager.lock.release();
        }
    }

    @Override
    public int getAutoParameterCount() {
        this.manager.lock.acquire();
        try {
            this.checkIsValid();
            if (this.thunkedFunction != null) {
                int n = this.thunkedFunction.getParameterCount();
                return n;
            }
            this.loadVariables();
            if (this.autoParams != null) {
                int n = this.autoParams.size();
                return n;
            }
            int n = 0;
            return n;
        }
        finally {
            this.manager.lock.release();
        }
    }

    Variable getResolvedVariable(Variable var, boolean voidOK, boolean useUnassignedStorage) throws InvalidInputException {
        DataType dt = var.getDataType();
        if (var instanceof Parameter) {
            dt = ((Parameter)var).getFormalDataType();
        }
        dt = VariableUtilities.checkDataType(dt, voidOK, Math.min(1, var.getLength()), this.program);
        DataType resolvedDt = this.program.getDataTypeManager().resolve(dt, null);
        VariableStorage storage = VariableStorage.UNASSIGNED_STORAGE;
        if (!useUnassignedStorage) {
            storage = var.getVariableStorage();
            if (storage.isAutoStorage()) {
                storage = new VariableStorage((Program)this.program, storage.getVarnodes());
            }
            if (resolvedDt.getLength() != storage.size()) {
                try {
                    storage = VariableUtilities.resizeStorage(storage, resolvedDt, true, this);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        LocalVariableImpl resolvedVar = new LocalVariableImpl(var.getName(), var.getFirstUseOffset(), resolvedDt, storage, true, this.program, var.getSource());
        resolvedVar.setComment(var.getComment());
        return resolvedVar;
    }

    @Override
    public void replaceParameters(Function.FunctionUpdateType updateType, boolean force, SourceType source, Variable ... newParams) throws DuplicateNameException, InvalidInputException {
        this.updateFunction(null, null, Arrays.asList(newParams), updateType, force, source);
    }

    @Override
    public void replaceParameters(List<? extends Variable> newParams, Function.FunctionUpdateType updateType, boolean force, SourceType source) throws DuplicateNameException, InvalidInputException {
        this.updateFunction(null, null, newParams, updateType, force, source);
    }

    @Override
    public void updateFunction(String callingConvention, Variable returnValue, Function.FunctionUpdateType updateType, boolean force, SourceType source, Variable ... newParams) throws DuplicateNameException, InvalidInputException {
        this.updateFunction(callingConvention, returnValue, Arrays.asList(newParams), updateType, force, source);
    }

    synchronized void startUpdate() {
        ++this.updateInProgressCount;
    }

    synchronized void endUpdate() {
        if (--this.updateInProgressCount == 0 && this.updateRefreshRequired) {
            this.refresh();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateFunction(String callingConvention, Variable returnVar, List<? extends Variable> newParams, Function.FunctionUpdateType updateType, boolean force, SourceType source) throws DuplicateNameException, InvalidInputException {
        this.manager.lock.acquire();
        try {
            this.startUpdate();
            this.checkDeleted();
            if (this.thunkedFunction != null) {
                this.thunkedFunction.updateFunction(callingConvention, returnVar, newParams, updateType, force, source);
                return;
            }
            this.loadVariables();
            this.purgeBadVariables();
            boolean useCustomStorage = updateType == Function.FunctionUpdateType.CUSTOM_STORAGE;
            this.setCustomVariableStorage(useCustomStorage);
            if (callingConvention != null) {
                this.setCallingConvention(callingConvention);
            }
            callingConvention = this.getCallingConventionName();
            if (returnVar == null) {
                returnVar = this.returnParam;
            } else if (returnVar.isUniqueVariable()) {
                throw new IllegalArgumentException("Invalid return specified: UniqueVariable not allowed");
            }
            DataType returnType = returnVar.getDataType();
            VariableStorage returnStorage = returnVar.getVariableStorage();
            if (!useCustomStorage) {
                Object firstParam;
                newParams = new ArrayList<Variable>(newParams);
                boolean thisParamRemoved = FunctionDB.removeExplicitThisParameter(newParams, callingConvention);
                if (FunctionDB.removeExplicitReturnStorageParameter(newParams)) {
                    returnVar = FunctionDB.revertIndirectParameter(returnVar, true);
                }
                if (returnVar instanceof Parameter) {
                    returnType = ((Parameter)returnVar).getFormalDataType();
                }
                returnStorage = VariableStorage.UNASSIGNED_STORAGE;
                if (updateType == Function.FunctionUpdateType.DYNAMIC_STORAGE_ALL_PARAMS && !thisParamRemoved && "__thiscall".equals(callingConvention) && newParams.size() != 0 && (firstParam = newParams.get(0)).getSource() == SourceType.DEFAULT && firstParam.getLength() == this.program.getDefaultPointerSize()) {
                    newParams.remove(0);
                }
            }
            this.getReturn().setDataType(returnType, returnStorage, true, source);
            HashSet<String> nonParamNames = new HashSet<String>();
            for (Symbol s : this.program.getSymbolTable().getSymbols(this)) {
                if (s.getSource() == SourceType.DEFAULT || s.getSymbolType() == SymbolType.PARAMETER) continue;
                nonParamNames.add(s.getName());
            }
            ArrayList<? extends Variable> clonedParams = new ArrayList<Variable>();
            for (int i = 0; i < newParams.size(); ++i) {
                Variable p = newParams.get(i);
                if (!useCustomStorage && p instanceof AutoParameterImpl) continue;
                if (p.isUniqueVariable()) {
                    throw new IllegalArgumentException("Invalid parameter specified: UniqueVariable not allowed");
                }
                this.checkForParameterNameConflict(p, newParams, nonParamNames);
                clonedParams.add(this.getResolvedVariable(p, false, !useCustomStorage));
            }
            newParams = clonedParams;
            if (useCustomStorage) {
                this.checkStorageConflicts(newParams, force);
            }
            List<ParameterDB> oldParams = this.params;
            this.params = new ArrayList<ParameterDB>();
            for (ParameterDB param : oldParams) {
                param.setName(null, SourceType.DEFAULT);
            }
            int newParamIndex = 0;
            while (newParamIndex < oldParams.size() && newParamIndex < newParams.size()) {
                Variable newParam;
                ParameterDB oldParam = oldParams.get(newParamIndex);
                DataType dt = (newParam = newParams.get(newParamIndex++)) instanceof Parameter && !useCustomStorage ? ((Parameter)newParam).getFormalDataType() : newParam.getDataType();
                oldParam.setName(newParam.getName(), newParam.getSource());
                oldParam.setStorageAndDataType(newParam.getVariableStorage(), dt);
                oldParam.setComment(newParam.getComment());
                this.params.add(oldParam);
            }
            for (int i = newParamIndex; i < oldParams.size(); ++i) {
                ParameterDB oldParam = oldParams.get(i);
                Symbol s = oldParam.getSymbol();
                this.symbolMap.remove(s);
                s.delete();
            }
            SymbolManager symbolMgr = this.program.getSymbolTable();
            for (int i = newParamIndex; i < newParams.size(); ++i) {
                Variable newParam = newParams.get(i);
                DataType dt = newParam instanceof Parameter && !useCustomStorage ? ((Parameter)newParam).getFormalDataType() : newParam.getDataType();
                VariableStorage storage = useCustomStorage ? newParam.getVariableStorage() : VariableStorage.UNASSIGNED_STORAGE;
                String name = newParam.getName();
                if (name == null || name.length() == 0) {
                    name = SymbolUtilities.getDefaultParamName(i);
                }
                VariableSymbolDB s = symbolMgr.createVariableSymbol(name, this, SymbolType.PARAMETER, i, storage, newParam.getSource());
                s.setStorageAndDataType(storage, dt);
                ParameterDB paramDb = new ParameterDB(this, s);
                paramDb.setComment(newParam.getComment());
                this.params.add(i, paramDb);
                this.symbolMap.put(s, paramDb);
            }
            if (source.isHigherPriorityThan(this.getStoredSignatureSource())) {
                this.setSignatureSource(source);
            }
            this.updateParametersAndReturn();
            this.manager.functionChanged(this, 6);
        }
        finally {
            this.frame.setInvalid();
            this.endUpdate();
            this.manager.lock.release();
        }
    }

    private void checkForParameterNameConflict(Variable param, List<? extends Variable> newParams, Set<String> nonParamNames) throws DuplicateNameException {
        String name = param.getName();
        if (name == null || name.length() == 0 || SymbolUtilities.isDefaultParameterName(name)) {
            return;
        }
        for (Variable variable : newParams) {
            if (param == variable || !name.equals(variable.getName())) continue;
            throw new DuplicateNameException("Duplicate parameter name '" + name + "'");
        }
        if (nonParamNames.contains(name)) {
            throw new DuplicateNameException("Parameter name conflicts with a symbol within function named '" + name + "'");
        }
    }

    private void checkStorageConflicts(List<? extends Variable> newParams, boolean removeConflictingLocals) throws VariableSizeException {
        VariableUtilities.VariableConflictHandler localConflictHandler = null;
        if (removeConflictingLocals) {
            localConflictHandler = conflicts -> {
                for (Variable var : conflicts) {
                    this.removeVariable(var);
                }
                return true;
            };
        }
        for (Variable variable : newParams) {
            VariableUtilities.checkVariableConflict(newParams, variable, variable.getVariableStorage(), null);
            VariableUtilities.checkVariableConflict(this.locals, variable, variable.getVariableStorage(), localConflictHandler);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Parameter addParameter(Variable var, SourceType source) throws DuplicateNameException, InvalidInputException {
        this.manager.lock.acquire();
        try {
            this.startUpdate();
            this.checkDeleted();
            if (this.thunkedFunction != null) {
                Parameter parameter = this.thunkedFunction.addParameter(var, source);
                return parameter;
            }
            this.loadVariables();
            this.purgeBadVariables();
            ParameterDB parameterDB = this.insertParameter(this.getParameterCount(), var, source);
            return parameterDB;
        }
        finally {
            this.endUpdate();
            this.manager.lock.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ParameterDB insertParameter(int ordinal, Variable var, SourceType source) throws DuplicateNameException, InvalidInputException {
        this.manager.lock.acquire();
        try {
            int stackOffset;
            this.startUpdate();
            this.checkDeleted();
            if (this.thunkedFunction != null) {
                ParameterDB parameterDB = this.thunkedFunction.insertParameter(ordinal, var, source);
                return parameterDB;
            }
            this.loadVariables();
            this.purgeBadVariables();
            int autoCnt = 0;
            if (this.autoParams != null && ordinal < (autoCnt = this.autoParams.size())) {
                throw new InvalidInputException("Parameter may not be inserted before auto-parameter");
            }
            if ((ordinal -= autoCnt) < 0 || ordinal > this.params.size()) {
                throw new IndexOutOfBoundsException("Ordinal value must be " + autoCnt + " <= ordinal < " + (this.params.size() + autoCnt) + ": " + (ordinal + autoCnt));
            }
            if (var.isUniqueVariable()) {
                throw new IllegalArgumentException("Invalid parameter specified: UniqueVariable not allowed");
            }
            boolean hasCustomStorage = this.hasCustomVariableStorage();
            if (hasCustomStorage && this.validateEnabled && var.hasStackStorage() && !this.frame.isParameterOffset(stackOffset = (int)var.getLastStorageVarnode().getOffset())) {
                throw new InvalidInputException("Variable contains invalid stack parameter offset: " + var.getName() + "  offset " + stackOffset);
            }
            var = this.getResolvedVariable(var, false, !hasCustomStorage);
            String name = var.getName();
            SourceType paramSource = source;
            if (name == null || name.length() == 0 || paramSource == SourceType.DEFAULT || SymbolUtilities.isDefaultParameterName(name)) {
                name = "param_";
                paramSource = SourceType.DEFAULT;
            }
            VariableStorage storage = var.getVariableStorage();
            if (!hasCustomStorage) {
                storage = VariableStorage.UNASSIGNED_STORAGE;
            } else if (storage.isAutoStorage()) {
                storage = new VariableStorage((Program)this.program, storage.getVarnodes());
            }
            try {
                VariableDB p = null;
                if (storage != VariableStorage.UNASSIGNED_STORAGE) {
                    for (ParameterDB oldParam : this.params) {
                        if (!oldParam.getVariableStorage().intersects(storage)) continue;
                        p = oldParam;
                        break;
                    }
                    if (this.validateEnabled) {
                        VariableUtilities.checkVariableConflict(this, p != null ? p : var, storage, true);
                    }
                }
                if (p != null) {
                    if (ordinal >= this.params.size()) {
                        ordinal = this.params.size() - 1;
                    }
                    Msg.info((Object)this, (Object)("WARNING! Inserting overlapping parameter for function " + this + " at " + p.getVariableStorage() + " - Replacing existing parameter!"));
                    if (((ParameterDB)p).getOrdinal() != ordinal) {
                        if (p != this.params.remove(((ParameterDB)p).getOrdinal())) {
                            throw new AssertException("Inconsistent function parameter cache");
                        }
                        this.params.add(ordinal, (ParameterDB)p);
                        this.updateParametersAndReturn();
                        this.manager.functionChanged(this, 6);
                    }
                    if (!"param_".equals(name)) {
                        p.setName(name, paramSource);
                    }
                    p.setStorageAndDataType(storage, var.getDataType());
                } else {
                    if (ordinal > this.params.size()) {
                        ordinal = this.params.size();
                    }
                    if (ordinal != this.params.size()) {
                        for (ParameterDB param : this.params) {
                            int paramOrdinal = param.getOrdinal();
                            if (paramOrdinal < ordinal) continue;
                            param.setOrdinal(paramOrdinal + 1);
                        }
                    }
                    SymbolManager symbolMgr = this.program.getSymbolTable();
                    VariableSymbolDB s = symbolMgr.createVariableSymbol(name, this, SymbolType.PARAMETER, ordinal, storage, paramSource);
                    s.setStorageAndDataType(storage, var.getDataType());
                    p = new ParameterDB(this, s);
                    this.params.add(ordinal, (ParameterDB)p);
                    this.updateParametersAndReturn();
                    this.symbolMap.put(((ParameterDB)p).symbol, p);
                    this.manager.functionChanged(this, 6);
                }
                if (var.getComment() != null) {
                    ((ParameterDB)p).symbol.setSymbolStringData(var.getComment());
                }
                this.updateSignatureSourceAfterVariableChange(source, ((ParameterDB)p).getDataType());
                VariableDB variableDB = p;
                this.frame.setInvalid();
                return variableDB;
            }
            catch (Throwable throwable) {
                this.frame.setInvalid();
                throw throwable;
            }
        }
        finally {
            this.endUpdate();
            this.manager.lock.release();
        }
    }

    @Override
    public void removeVariable(Variable variable) {
        this.manager.lock.acquire();
        try {
            VariableSymbolDB s;
            this.startUpdate();
            this.checkDeleted();
            if (this.thunkedFunction != null) {
                this.thunkedFunction.removeVariable(variable);
                return;
            }
            this.loadVariables();
            if (variable instanceof VariableDB && this.symbolMap.containsKey(s = ((VariableDB)variable).symbol)) {
                s.delete();
            }
        }
        finally {
            this.endUpdate();
            this.manager.lock.release();
        }
    }

    @Override
    public void removeParameter(int ordinal) {
        this.manager.lock.acquire();
        try {
            this.startUpdate();
            this.checkDeleted();
            if (this.thunkedFunction != null) {
                this.thunkedFunction.removeParameter(ordinal);
                return;
            }
            this.loadVariables();
            if (ordinal < 0) {
                throw new IndexOutOfBoundsException();
            }
            if (this.autoParams != null) {
                if (ordinal < this.autoParams.size()) {
                    return;
                }
                ordinal -= this.autoParams.size();
            }
            if (ordinal >= this.params.size()) {
                throw new IndexOutOfBoundsException();
            }
            ParameterDB param = this.params.get(ordinal);
            param.symbol.delete();
        }
        finally {
            this.endUpdate();
            this.manager.lock.release();
        }
    }

    @Override
    protected boolean refresh() {
        return this.refresh(null);
    }

    @Override
    protected boolean refresh(DBRecord refreshRec) {
        if (this.updateInProgressCount != 0) {
            this.updateRefreshRequired = true;
            return true;
        }
        this.symbolMap = null;
        this.params = null;
        this.locals = null;
        this.autoParams = null;
        this.returnParam = null;
        this.foundBadVariables = false;
        this.tags = null;
        try {
            if (refreshRec == null) {
                refreshRec = this.manager.getFunctionAdapter().getFunctionRecord(this.key);
            }
            if (refreshRec != null) {
                this.rec = refreshRec;
                this.init();
                boolean bl = true;
                return bl;
            }
        }
        catch (IOException e) {
            this.manager.dbError(e);
        }
        finally {
            this.frame.setInvalid();
        }
        return false;
    }

    public void doDeleteVariable(VariableSymbolDB symbol) {
        this.manager.lock.acquire();
        try {
            this.startUpdate();
            if (!this.checkIsValid()) {
                return;
            }
            if (FunctionDB.isBadVariable(symbol)) {
                return;
            }
            this.loadVariables();
            VariableDB var = this.symbolMap.remove(symbol);
            if (var != null) {
                if (var instanceof Parameter) {
                    if (this.removeVariable(this.params, var)) {
                        this.updateParametersAndReturn();
                    }
                } else {
                    this.removeVariable(this.locals, var);
                }
            }
            this.manager.functionChanged(this, var instanceof Parameter ? 6 : 0);
            this.frame.setInvalid();
        }
        finally {
            this.endUpdate();
            this.manager.lock.release();
        }
    }

    private boolean removeVariable(List<?> list, VariableDB var) {
        int cnt = list.size();
        for (int i = 0; i < cnt; ++i) {
            if (var != list.get(i)) continue;
            list.remove(i);
            return true;
        }
        return false;
    }

    public Variable getVariable(VariableSymbolDB symbol) {
        this.manager.lock.acquire();
        try {
            this.checkIsValid();
            this.loadVariables();
            Variable variable = this.symbolMap.get(symbol);
            return variable;
        }
        finally {
            this.manager.lock.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Parameter getParameter(int ordinal) {
        this.manager.lock.acquire();
        try {
            this.checkIsValid();
            if (this.thunkedFunction != null) {
                Parameter parameter = this.thunkedFunction.getParameter(ordinal);
                Parameter parameter2 = parameter != null ? this.adjustThunkThisParameter(parameter) : null;
                return parameter2;
            }
            if (ordinal == -1) {
                ReturnParameterDB returnParameterDB = this.getReturn();
                return returnParameterDB;
            }
            if (ordinal < 0) {
                Parameter parameter = null;
                return parameter;
            }
            this.loadVariables();
            if (this.autoParams != null) {
                if (ordinal < this.autoParams.size()) {
                    Parameter parameter = this.autoParams.get(ordinal);
                    return parameter;
                }
                ordinal -= this.autoParams.size();
            }
            if (ordinal < this.params.size()) {
                Parameter parameter = this.params.get(ordinal);
                return parameter;
            }
            Parameter parameter = null;
            return parameter;
        }
        finally {
            this.manager.lock.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Parameter moveParameter(int fromOrdinal, int toOrdinal) throws InvalidInputException {
        if (toOrdinal < 0) {
            throw new InvalidInputException("invalid toOrdinal specified: " + toOrdinal);
        }
        this.manager.lock.acquire();
        try {
            this.startUpdate();
            this.checkDeleted();
            if (this.thunkedFunction != null) {
                Parameter parameter = this.thunkedFunction.moveParameter(fromOrdinal, toOrdinal);
                return parameter;
            }
            this.loadVariables();
            int autoCnt = 0;
            if (this.autoParams != null) {
                autoCnt = this.autoParams.size();
                if (fromOrdinal < autoCnt) {
                    throw new InvalidInputException("Auto-parameter may not be moved");
                }
                if (toOrdinal < autoCnt) {
                    throw new InvalidInputException("Parameter may not be moved before an auto-parameter");
                }
            }
            toOrdinal -= autoCnt;
            if ((fromOrdinal -= autoCnt) < 0 || fromOrdinal >= this.params.size()) {
                Parameter parameter = null;
                return parameter;
            }
            ParameterDB param = this.params.get(fromOrdinal);
            if (param.getOrdinal() == toOrdinal) {
                ParameterDB parameterDB = param;
                return parameterDB;
            }
            this.params.remove(fromOrdinal);
            if (toOrdinal >= this.params.size()) {
                this.params.add(param);
            } else {
                this.params.add(toOrdinal, param);
            }
            this.updateParametersAndReturn();
            this.manager.functionChanged(this, 6);
            ParameterDB parameterDB = param;
            return parameterDB;
        }
        finally {
            this.endUpdate();
            this.manager.lock.release();
        }
    }

    void setLocalSize(int size) {
        this.manager.lock.acquire();
        try {
            this.startUpdate();
            this.checkDeleted();
            if (size < 0) {
                throw new IllegalArgumentException("invalid local size: " + size);
            }
            this.rec.setIntValue(3, size);
            try {
                this.manager.getFunctionAdapter().updateFunctionRecord(this.rec);
                this.manager.functionChanged(this, 0);
            }
            catch (IOException e) {
                this.manager.dbError(e);
            }
            this.frame.setInvalid();
        }
        finally {
            this.endUpdate();
            this.manager.lock.release();
        }
    }

    int getReturnAddressOffset() {
        this.manager.lock.acquire();
        try {
            this.checkIsValid();
            int n = this.rec.getIntValue(2);
            return n;
        }
        finally {
            this.manager.lock.release();
        }
    }

    void setReturnAddressOffset(int offset) {
        this.manager.lock.acquire();
        try {
            this.startUpdate();
            this.checkDeleted();
            this.rec.setIntValue(2, offset);
            try {
                this.manager.getFunctionAdapter().updateFunctionRecord(this.rec);
                this.manager.functionChanged(this, 0);
            }
            catch (IOException e) {
                this.manager.dbError(e);
            }
            this.frame.setInvalid();
        }
        finally {
            this.endUpdate();
            this.manager.lock.release();
        }
    }

    @Override
    public Symbol getSymbol() {
        return this.functionSymbol;
    }

    @Override
    public void setParentNamespace(Namespace newParentScope) throws DuplicateNameException, InvalidInputException, CircularDependencyException {
        if (this.functionSymbol.getParentNamespace().equals(newParentScope)) {
            return;
        }
        this.functionSymbol.setNamespace(newParentScope);
    }

    @Override
    public Namespace getParentNamespace() {
        return this.functionSymbol.getParentNamespace();
    }

    @Override
    public String getName(boolean includeNamespacePath) {
        return this.functionSymbol.getName(includeNamespacePath);
    }

    @Override
    public boolean hasVarArgs() {
        return this.isFunctionFlagSet((byte)1);
    }

    @Override
    public void setVarArgs(boolean hasVarArgs) {
        this.manager.lock.acquire();
        try {
            this.startUpdate();
            this.checkDeleted();
            if (this.thunkedFunction != null) {
                this.thunkedFunction.setVarArgs(hasVarArgs);
            } else if (hasVarArgs != this.hasVarArgs()) {
                this.setFunctionFlag((byte)1, hasVarArgs);
                this.manager.functionChanged(this, 6);
            }
        }
        finally {
            this.endUpdate();
            this.manager.lock.release();
        }
    }

    @Override
    public boolean isInline() {
        return this.isFunctionFlagSet((byte)2);
    }

    @Override
    public void setInline(boolean isInline) {
        this.manager.lock.acquire();
        try {
            this.startUpdate();
            this.checkDeleted();
            if (this.thunkedFunction != null) {
                this.thunkedFunction.setInline(isInline);
            } else if (!this.isExternal() && isInline != this.isInline()) {
                this.setFunctionFlag((byte)2, isInline);
                this.manager.functionChanged(this, 2);
            }
        }
        finally {
            this.endUpdate();
            this.manager.lock.release();
        }
    }

    @Override
    public boolean hasNoReturn() {
        return this.isFunctionFlagSet((byte)4);
    }

    @Override
    public void setNoReturn(boolean hasNoReturn) {
        this.manager.lock.acquire();
        try {
            this.startUpdate();
            this.checkDeleted();
            if (this.thunkedFunction != null) {
                this.thunkedFunction.setNoReturn(hasNoReturn);
            } else if (hasNoReturn != this.hasNoReturn()) {
                this.setFunctionFlag((byte)4, hasNoReturn);
                this.manager.functionChanged(this, 3);
            }
        }
        finally {
            this.endUpdate();
            this.manager.lock.release();
        }
    }

    @Override
    public boolean hasCustomVariableStorage() {
        return this.isFunctionFlagSet((byte)8);
    }

    private static int findExplicitThisParameter(List<? extends Variable> params) {
        for (int i = 0; i < params.size(); ++i) {
            Variable p = params.get(i);
            if (!THIS_PARAM_NAME.equals(p.getName()) || !(p.getDataType() instanceof Pointer)) continue;
            return i;
        }
        return -1;
    }

    private static boolean removeExplicitThisParameter(List<? extends Variable> params, String callingConventionName) {
        int thisIndex;
        if ("__thiscall".equals(callingConventionName) && (thisIndex = FunctionDB.findExplicitThisParameter(params)) >= 0) {
            params.remove(thisIndex);
            return true;
        }
        return false;
    }

    private boolean removeExplicitThisParameter() {
        int thisIndex;
        if ("__thiscall".equals(this.getCallingConventionName()) && (thisIndex = FunctionDB.findExplicitThisParameter(this.params)) >= 0) {
            this.removeParameter(thisIndex);
            return true;
        }
        return false;
    }

    private static int findExplicitReturnStorageParameter(List<? extends Variable> params) {
        for (int i = 0; i < params.size(); ++i) {
            Variable p = params.get(i);
            if (!RETURN_PTR_PARAM_NAME.equals(p.getName()) || !(p.getDataType() instanceof Pointer)) continue;
            return i;
        }
        return -1;
    }

    private static boolean removeExplicitReturnStorageParameter(List<? extends Variable> params) {
        int paramIndex = FunctionDB.findExplicitReturnStorageParameter(params);
        if (paramIndex >= 0) {
            params.remove(paramIndex);
            return true;
        }
        return false;
    }

    private boolean removeExplicitReturnStorageParameter() {
        int paramIndex = FunctionDB.findExplicitReturnStorageParameter(this.params);
        if (paramIndex >= 0) {
            this.removeParameter(paramIndex);
            return true;
        }
        return false;
    }

    private static Variable revertIndirectParameter(Variable param, boolean create) {
        DataType dt = param.getDataType();
        if (dt instanceof Pointer) {
            try {
                dt = ((Pointer)dt).getDataType();
                if (create) {
                    param = new ParameterImpl(param.getName(), dt, param.getProgram());
                } else {
                    param.setDataType(dt, VariableStorage.UNASSIGNED_STORAGE, false, param.getSource());
                }
            }
            catch (InvalidInputException e) {
                throw new AssertException((Throwable)e);
            }
        }
        return param;
    }

    @Override
    public void setCustomVariableStorage(boolean hasCustomVariableStorage) {
        this.manager.lock.acquire();
        try {
            this.startUpdate();
            this.checkDeleted();
            if (this.thunkedFunction != null) {
                this.thunkedFunction.setCustomVariableStorage(hasCustomVariableStorage);
                return;
            }
            if (hasCustomVariableStorage == this.hasCustomVariableStorage()) {
                return;
            }
            this.loadVariables();
            if (!hasCustomVariableStorage) {
                this.removeExplicitThisParameter();
                if (this.removeExplicitReturnStorageParameter()) {
                    FunctionDB.revertIndirectParameter(this.returnParam, false);
                }
            }
            Parameter[] parameters = this.getParameters();
            this.autoParams = null;
            this.setFunctionFlag((byte)8, hasCustomVariableStorage);
            int ordinal = 0;
            for (Parameter p : parameters) {
                if (p.isAutoParameter()) {
                    try {
                        this.insertParameter(ordinal, new ParameterImpl(p, this.program), SourceType.ANALYSIS);
                        ++ordinal;
                    }
                    catch (DuplicateNameException duplicateNameException) {}
                    continue;
                }
                VariableStorage storage = hasCustomVariableStorage ? p.getVariableStorage().clone(this.program) : VariableStorage.UNASSIGNED_STORAGE;
                ((ParameterDB)p).setStorageAndDataType(storage, p.getDataType());
            }
            VariableStorage storage = hasCustomVariableStorage ? this.returnParam.getVariableStorage().clone(this.program) : VariableStorage.UNASSIGNED_STORAGE;
            this.returnParam.setStorageAndDataType(storage, this.returnParam.getDataType());
            if (!hasCustomVariableStorage) {
                this.updateParametersAndReturn();
            }
            this.manager.functionChanged(this, 6);
        }
        catch (InvalidInputException e) {
            throw new AssertException((Throwable)e);
        }
        finally {
            this.endUpdate();
            this.manager.lock.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isFunctionFlagSet(byte functionFlagIndicator) {
        this.manager.lock.acquire();
        try {
            this.checkIsValid();
            if (this.thunkedFunction != null) {
                boolean bl = this.thunkedFunction.isFunctionFlagSet(functionFlagIndicator);
                return bl;
            }
            byte flags = this.rec.getByteValue(4);
            boolean bl = (flags & functionFlagIndicator) != 0;
            return bl;
        }
        finally {
            this.manager.lock.release();
        }
    }

    private void setFunctionFlag(byte functionFlagIndicator, boolean shouldBeSet) {
        byte flags = this.rec.getByteValue(4);
        flags = shouldBeSet ? (byte)(flags | functionFlagIndicator) : (byte)(flags & ~functionFlagIndicator);
        this.rec.setByteValue(4, flags);
        try {
            this.manager.getFunctionAdapter().updateFunctionRecord(this.rec);
        }
        catch (IOException e) {
            this.manager.dbError(e);
        }
        this.frame.setInvalid();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SourceType getSignatureSource() {
        this.manager.lock.acquire();
        try {
            this.checkIsValid();
            if (this.thunkedFunction != null) {
                SourceType sourceType = this.thunkedFunction.getSignatureSource();
                return sourceType;
            }
            if (!this.getReturn().isValid()) {
                SourceType sourceType = SourceType.DEFAULT;
                return sourceType;
            }
            for (Parameter param : this.getParameters()) {
                if (param.isValid()) continue;
                SourceType sourceType = SourceType.DEFAULT;
                return sourceType;
            }
            SourceType sourceType = this.getStoredSignatureSource();
            return sourceType;
        }
        finally {
            this.manager.lock.release();
        }
    }

    SourceType getStoredSignatureSource() {
        byte flags = this.rec.getByteValue(4);
        int typeOrdinal = (flags & 0x30) >>> 4;
        return SourceType.values()[typeOrdinal];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setSignatureSource(SourceType signatureSource) {
        this.manager.lock.acquire();
        try {
            this.startUpdate();
            this.checkDeleted();
            if (this.thunkedFunction != null) {
                this.thunkedFunction.setSignatureSource(signatureSource);
                return;
            }
            byte flags = this.rec.getByteValue(4);
            flags = (byte)(flags & 0xFFFFFFCF);
            flags = (byte)(flags | FunctionAdapter.getSignatureSourceFlagBits(signatureSource));
            this.rec.setByteValue(4, flags);
            try {
                this.manager.getFunctionAdapter().updateFunctionRecord(this.rec);
                this.manager.functionChanged(this, 0);
            }
            catch (IOException e) {
                this.manager.dbError(e);
            }
        }
        finally {
            this.endUpdate();
            this.manager.lock.release();
        }
    }

    @Override
    public PrototypeModel getCallingConvention() {
        String name = this.getCallingConventionName();
        if (name == null || name.equals("unknown")) {
            return null;
        }
        FunctionManagerDB functionMgr = this.getFunctionManager();
        if (name.equals("default")) {
            return functionMgr.getDefaultCallingConvention();
        }
        return functionMgr.getCallingConvention(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getCallingConventionName() {
        this.manager.lock.acquire();
        try {
            if (!this.checkIsValid()) {
                String string = null;
                return string;
            }
            if (this.thunkedFunction != null) {
                String string = this.thunkedFunction.getCallingConventionName();
                return string;
            }
            byte callingConventionID = this.rec.getByteValue(5);
            if (callingConventionID == 0) {
                String string = "unknown";
                return string;
            }
            if (callingConventionID == 1) {
                String string = "default";
                return string;
            }
            String name = this.manager.getCallingConventionName(callingConventionID);
            String string = name != null ? name : "unknown";
            return string;
        }
        finally {
            this.manager.lock.release();
        }
    }

    private String getRealCallingConventionName() {
        if (this.thunkedFunction != null) {
            return this.thunkedFunction.getRealCallingConventionName();
        }
        String name = null;
        byte callingConventionID = this.rec.getByteValue(5);
        if (callingConventionID != 0 && callingConventionID != 1) {
            name = this.manager.getCallingConventionName(callingConventionID);
        }
        return name;
    }

    private PrototypeModel getDefaultCallingConvention() {
        CompilerSpec compilerSpec = this.getProgram().getCompilerSpec();
        if (compilerSpec != null) {
            return compilerSpec.getDefaultCallingConvention();
        }
        return null;
    }

    @Override
    public String getDefaultCallingConventionName() {
        String defaultPrototypeName;
        PrototypeModel defaultPrototype = this.getDefaultCallingConvention();
        if (defaultPrototype != null && (defaultPrototypeName = defaultPrototype.getName()) != null) {
            return defaultPrototypeName;
        }
        return "default";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setCallingConvention(String name) throws InvalidInputException {
        this.manager.lock.acquire();
        try {
            this.startUpdate();
            this.checkDeleted();
            if (this.thunkedFunction != null) {
                this.thunkedFunction.setCallingConvention(name);
                return;
            }
            byte newCallingConventionID = this.manager.getCallingConventionID(name);
            byte oldCallingConventionID = this.rec.getByteValue(5);
            if (oldCallingConventionID != newCallingConventionID) {
                this.loadVariables();
                this.rec.setByteValue(5, newCallingConventionID);
                this.manager.getFunctionAdapter().updateFunctionRecord(this.rec);
                boolean hasCustomStorage = this.hasCustomVariableStorage();
                if (!hasCustomStorage) {
                    this.removeExplicitThisParameter();
                }
                this.frame.setInvalid();
                if (!hasCustomStorage) {
                    this.createClassStructIfNeeded();
                    this.loadVariables();
                    this.removeExplicitThisParameter();
                    this.updateParametersAndReturn();
                    this.manager.functionChanged(this, 6);
                    this.manager.functionChanged(this, 5);
                } else {
                    this.manager.functionChanged(this, 0);
                }
            }
        }
        catch (IOException e) {
            this.manager.dbError(e);
        }
        finally {
            this.endUpdate();
            this.manager.lock.release();
        }
    }

    void createClassStructIfNeeded() {
        PrototypeModel callingConvention = this.getCallingConvention();
        if (callingConvention == null || callingConvention.getGenericCallingConvention() != GenericCallingConvention.thiscall) {
            return;
        }
        Namespace parent = this.getParentNamespace();
        if (!(parent instanceof GhidraClass)) {
            return;
        }
        ProgramDataTypeManager dataTypeManager = this.program.getDataTypeManager();
        Structure classStruct = VariableUtilities.findExistingClassStruct(this);
        if (classStruct == null) {
            classStruct = VariableUtilities.findOrCreateClassStruct(this);
            dataTypeManager.resolve(classStruct, null);
        }
    }

    void dataTypeChanged(VariableDB var) {
        this.manager.functionChanged(this, var instanceof Parameter ? 6 : 0);
    }

    @Override
    public String getCallFixup() {
        this.manager.lock.acquire();
        try {
            this.checkIsValid();
            if (this.thunkedFunction != null) {
                String string = this.thunkedFunction.getCallFixup();
                return string;
            }
            StringPropertyMap callFixupMap = this.manager.getCallFixupMap(false);
            if (callFixupMap == null) {
                String string = null;
                return string;
            }
            String string = callFixupMap.getString(this.entryPoint);
            return string;
        }
        finally {
            this.manager.lock.release();
        }
    }

    @Override
    public void setCallFixup(String name) {
        this.manager.lock.acquire();
        try {
            this.startUpdate();
            this.checkDeleted();
            if (this.thunkedFunction != null) {
                this.thunkedFunction.setCallFixup(name);
                return;
            }
            if (SystemUtilities.isEqual((Object)name, (Object)this.getCallFixup())) {
                return;
            }
            StringPropertyMap callFixupMap = this.manager.getCallFixupMap(name != null);
            if (callFixupMap == null) {
                return;
            }
            if (name == null) {
                callFixupMap.remove(this.entryPoint);
            } else {
                if (this.program.getCompilerSpec().getPcodeInjectLibrary().getPayload(1, name) == null) {
                    Msg.warn((Object)this, (Object)("Undefined CallFixup set at " + this.entryPoint + ": " + name));
                }
                callFixupMap.add(this.entryPoint, name);
            }
            this.manager.functionChanged(this, 4);
        }
        finally {
            this.endUpdate();
            this.manager.lock.release();
        }
    }

    @Override
    public Set<Function> getCallingFunctions(TaskMonitor monitor) {
        monitor = TaskMonitor.dummyIfNull((TaskMonitor)monitor);
        HashSet<Function> set = new HashSet<Function>();
        ReferenceIterator iter = this.program.getReferenceManager().getReferencesTo(this.getEntryPoint());
        while (iter.hasNext()) {
            if (monitor.isCancelled()) {
                return set;
            }
            Reference reference = iter.next();
            Address fromAddress = reference.getFromAddress();
            Function callerFunction = this.manager.getFunctionContaining(fromAddress);
            if (callerFunction == null) continue;
            set.add(callerFunction);
        }
        return set;
    }

    @Override
    public Set<Function> getCalledFunctions(TaskMonitor monitor) {
        monitor = TaskMonitor.dummyIfNull((TaskMonitor)monitor);
        HashSet<Function> set = new HashSet<Function>();
        Set<Reference> references = this.getReferencesFromBody(monitor);
        for (Reference reference : references) {
            if (monitor.isCancelled()) {
                return set;
            }
            Address toAddress = reference.getToAddress();
            Function calledFunction = this.manager.getFunctionAt(toAddress);
            if (calledFunction == null) continue;
            set.add(calledFunction);
        }
        return set;
    }

    private Set<Reference> getReferencesFromBody(TaskMonitor monitor) {
        HashSet<Reference> set = new HashSet<Reference>();
        ReferenceDBManager referenceManager = this.program.getReferenceManager();
        AddressSetView addresses = this.getBody();
        AddressIterator addressIterator = addresses.getAddresses(true);
        while (addressIterator.hasNext()) {
            if (monitor.isCancelled()) {
                return set;
            }
            Address address = addressIterator.next();
            Reference[] referencesFrom = referenceManager.getReferencesFrom(address);
            if (referencesFrom == null) continue;
            for (Reference reference : referencesFrom) {
                set.add(reference);
            }
        }
        return set;
    }

    @Override
    public Set<FunctionTag> getTags() {
        this.manager.lock.acquire();
        try {
            if (this.checkIsValid() && this.tags != null) {
                Set<FunctionTag> set = this.tags;
                return set;
            }
            FunctionTagManagerDB tagManager = (FunctionTagManagerDB)this.manager.getFunctionTagManager();
            this.tags = tagManager.getFunctionTagsByFunctionID(this.getID());
        }
        catch (IOException e) {
            this.manager.dbError(e);
        }
        finally {
            this.manager.lock.release();
        }
        return this.tags;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean addTag(String name) {
        this.manager.lock.acquire();
        try {
            this.startUpdate();
            this.checkDeleted();
            FunctionTagManagerDB tagManager = (FunctionTagManagerDB)this.manager.getFunctionTagManager();
            FunctionTag tag = tagManager.getFunctionTag(name);
            if (tag == null) {
                tag = tagManager.createFunctionTag(name, "");
            }
            if (!tagManager.isTagApplied(this.getID(), tag.getId())) {
                tagManager.applyFunctionTag(this.getID(), tag.getId());
                Address addr = this.getEntryPoint();
                this.program.setChanged(156, addr, addr, tag, tag);
            }
            if (this.tags != null) {
                this.tags.add(tag);
            }
        }
        finally {
            this.endUpdate();
            this.manager.lock.release();
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeTag(String name) {
        this.manager.lock.acquire();
        try {
            this.startUpdate();
            this.checkDeleted();
            FunctionTag tag = this.manager.getFunctionTagManager().getFunctionTag(name);
            if (tag == null) {
                return;
            }
            FunctionTagManagerDB tagManager = (FunctionTagManagerDB)this.manager.getFunctionTagManager();
            boolean removed = tagManager.removeFunctionTag(this.getID(), tag.getId());
            if (removed) {
                Address addr = this.getEntryPoint();
                this.program.setChanged(157, addr, addr, tag, tag);
                if (this.tags != null) {
                    this.tags.remove(tag);
                }
            }
        }
        finally {
            this.endUpdate();
            this.manager.lock.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void promoteLocalUserLabelsToGlobal() {
        if (this.isExternal()) {
            return;
        }
        this.manager.lock.acquire();
        try {
            this.checkDeleted();
            ArrayList<Symbol> list = new ArrayList<Symbol>(20);
            for (Symbol childSymbol : this.program.getSymbolTable().getSymbols(this)) {
                if (childSymbol.getSymbolType() != SymbolType.LABEL || childSymbol.getSource() != SourceType.USER_DEFINED) continue;
                list.add(childSymbol);
            }
            Namespace globalNamespace = this.program.getGlobalNamespace();
            for (Symbol s : list) {
                try {
                    s.setNamespace(globalNamespace);
                }
                catch (DuplicateNameException e) {
                    s.delete();
                }
                catch (CircularDependencyException | InvalidInputException e) {
                    throw new AssertException((Throwable)e);
                    return;
                }
            }
        }
        finally {
            this.manager.lock.release();
        }
    }

    private static class ThunkVariableFilter
    implements VariableFilter {
        private VariableFilter otherFilter;

        ThunkVariableFilter(VariableFilter otherFilter) {
            this.otherFilter = otherFilter;
        }

        @Override
        public boolean matches(Variable variable) {
            return variable instanceof Parameter && (this.otherFilter == null || this.otherFilter.matches(variable));
        }
    }
}

