/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.database.data;

import com.google.common.base.Predicate;
import db.DBRecord;
import ghidra.docking.settings.Settings;
import ghidra.docking.settings.SettingsDefinition;
import ghidra.program.database.DBObjectCache;
import ghidra.program.database.data.DataTypeDB;
import ghidra.program.database.data.DataTypeManagerDB;
import ghidra.program.database.data.DataTypeSettingsDB;
import ghidra.program.database.data.DataTypeUtilities;
import ghidra.program.database.data.TypedefDBAdapter;
import ghidra.program.model.data.BuiltInDataTypeManager;
import ghidra.program.model.data.CategoryPath;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.DataTypeDisplayOptions;
import ghidra.program.model.data.DataTypeManager;
import ghidra.program.model.data.Dynamic;
import ghidra.program.model.data.FactoryDataType;
import ghidra.program.model.data.ProgramBasedDataTypeManager;
import ghidra.program.model.data.TypeDef;
import ghidra.program.model.data.TypeDefSettingsDefinition;
import ghidra.program.model.data.TypedefDataType;
import ghidra.program.model.mem.MemBuffer;
import ghidra.util.UniversalID;
import ghidra.util.exception.DuplicateNameException;
import java.io.IOException;

class TypedefDB
extends DataTypeDB
implements TypeDef {
    private TypedefDBAdapter adapter;
    private SettingsDefinition[] settingsDef;

    public TypedefDB(DataTypeManagerDB dataMgr, DBObjectCache<DataTypeDB> cache, TypedefDBAdapter adapter, DBRecord record) {
        super(dataMgr, cache, record);
        this.adapter = adapter;
        this.defaultSettings = null;
    }

    private void setFlags(int flags) {
        this.record.setShortValue(1, (short)flags);
    }

    private int getFlags() {
        return this.record.getShortValue(1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void enableAutoNaming() {
        if (this.isAutoNamed()) {
            return;
        }
        this.lock.acquire();
        try {
            this.checkDeleted();
            String oldName = this.getName();
            this.setFlags(this.getFlags() | 1);
            this.adapter.updateRecord(this.record, true);
            CategoryPath oldPath = this.getCategoryPath();
            CategoryPath currentPath = this.getDataType().getCategoryPath();
            String newName = this.generateTypedefName(currentPath);
            this.record.setString(2, newName);
            this.adapter.updateRecord(this.record, true);
            this.refreshName();
            if (!currentPath.equals(oldPath)) {
                try {
                    super.setCategoryPath(currentPath);
                }
                catch (DuplicateNameException duplicateNameException) {
                    // empty catch block
                }
            }
            this.notifyNameChanged(oldName);
        }
        catch (IOException e) {
            this.dataMgr.dbError(e);
        }
        finally {
            this.lock.release();
        }
    }

    @Override
    public boolean isAutoNamed() {
        int flags = this.getFlags();
        if (this.isInvalid()) {
            this.lock.acquire();
            try {
                this.checkIsValid();
                flags = this.getFlags();
            }
            finally {
                this.lock.release();
            }
        }
        return (flags & 1) != 0;
    }

    @Override
    protected long doGetCategoryID() {
        return this.record.getLongValue(3);
    }

    @Override
    protected String doGetName() {
        return this.record.getString(2);
    }

    @Override
    public boolean hasLanguageDependantLength() {
        return this.getDataType().hasLanguageDependantLength();
    }

    @Override
    protected void doSetNameRecord(String name) throws IOException {
        this.record.setString(2, name);
        this.setFlags(this.getFlags() & 0xFFFFFFFE);
        this.adapter.updateRecord(this.record, true);
    }

    @Override
    public String getMnemonic(Settings settings) {
        return this.getDisplayName();
    }

    @Override
    public boolean isZeroLength() {
        return this.getDataType().isZeroLength();
    }

    @Override
    public int getLength() {
        return this.getDataType().getLength();
    }

    @Override
    public String getDescription() {
        return this.getDataType().getDescription();
    }

    @Override
    public Object getValue(MemBuffer buf, Settings settings, int length) {
        return this.getDataType().getValue(buf, settings, length);
    }

    @Override
    public Class<?> getValueClass(Settings settings) {
        return this.getDataType().getValueClass(settings);
    }

    @Override
    public String getRepresentation(MemBuffer buf, Settings settings, int length) {
        return this.getDataType().getRepresentation(buf, settings, length);
    }

    @Override
    public void dataTypeSizeChanged(DataType dt) {
        this.lock.acquire();
        try {
            if (this.checkIsValid() && dt == this.getDataType()) {
                this.notifySizeChanged(true);
            }
        }
        finally {
            this.lock.release();
        }
    }

    @Override
    public void dataTypeAlignmentChanged(DataType dt) {
        this.lock.acquire();
        try {
            if (this.checkIsValid() && dt == this.getDataType()) {
                this.notifyAlignmentChanged(true);
            }
        }
        finally {
            this.lock.release();
        }
    }

    @Override
    public DataType getBaseDataType() {
        this.lock.acquire();
        try {
            this.checkIsValid();
            DataType dataType = this.getDataType();
            if (dataType instanceof TypeDef) {
                DataType dataType2 = ((TypeDef)dataType).getBaseDataType();
                return dataType2;
            }
            DataType dataType3 = dataType;
            return dataType3;
        }
        finally {
            this.lock.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DataType getDataType() {
        this.lock.acquire();
        try {
            this.checkIsValid();
            long dataTypeID = this.record.getLongValue(0);
            DataType dt = this.dataMgr.getDataType(dataTypeID);
            if (dt == null) {
                dt = DataType.DEFAULT;
            }
            DataType dataType = dt;
            return dataType;
        }
        finally {
            this.lock.release();
        }
    }

    @Override
    public TypeDef clone(DataTypeManager dtm) {
        return TypedefDataType.clone(this, dtm);
    }

    @Override
    public TypedefDataType copy(DataTypeManager dtm) {
        return TypedefDataType.copy(this, dtm);
    }

    @Override
    public boolean isEquivalent(DataType obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || !(obj instanceof TypeDef)) {
            return false;
        }
        TypeDef td = (TypeDef)obj;
        this.validate(this.lock);
        boolean autoNamed = this.isAutoNamed();
        if (autoNamed != td.isAutoNamed()) {
            return false;
        }
        if (!autoNamed && !DataTypeUtilities.equalsIgnoreConflict(this.getName(), td.getName())) {
            return false;
        }
        if (!this.hasSameTypeDefSettings(td)) {
            return false;
        }
        return DataTypeUtilities.isSameOrEquivalentDataType(this.getDataType(), td.getDataType());
    }

    @Override
    public void setCategoryPath(CategoryPath path) throws DuplicateNameException {
        if (this.isAutoNamed()) {
            return;
        }
        super.setCategoryPath(path);
    }

    @Override
    protected void doSetCategoryPathRecord(long categoryID) throws IOException {
        this.record.setLongValue(3, categoryID);
        this.adapter.updateRecord(this.record, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void dataTypeReplaced(DataType oldDt, DataType newDt) {
        block10: {
            if (newDt == this || newDt instanceof Dynamic || newDt instanceof FactoryDataType) {
                newDt = DataType.DEFAULT;
            }
            this.lock.acquire();
            try {
                if (!this.checkIsValid() || this.getDataType() != oldDt) break block10;
                this.settingsDef = null;
                this.defaultSettings = null;
                oldDt.removeParent(this);
                newDt = this.resolve(newDt);
                newDt.addParent(this);
                this.record.setLongValue(0, this.dataMgr.getResolvedID(newDt));
                try {
                    this.adapter.updateRecord(this.record, true);
                }
                catch (IOException e) {
                    this.dataMgr.dbError(e);
                }
                if (oldDt.getLength() != newDt.getLength()) {
                    this.notifySizeChanged(false);
                } else if (oldDt.getAlignment() != newDt.getAlignment()) {
                    this.notifyAlignmentChanged(false);
                } else {
                    this.dataMgr.dataTypeChanged(this, false);
                }
            }
            finally {
                this.lock.release();
            }
        }
    }

    @Override
    public void dataTypeDeleted(DataType dt) {
        if (this.getDataType() == dt) {
            this.dataMgr.addDataTypeToDelete(this.key);
        }
    }

    @Override
    public void dataTypeNameChanged(DataType dt, String oldName) {
        if (this.getDataType() == dt) {
            this.updateAutoName(true);
        }
    }

    @Override
    public boolean dependsOn(DataType dt) {
        DataType myDt = this.getDataType();
        return myDt == dt || myDt.dependsOn(dt);
    }

    @Override
    protected boolean refresh() {
        try {
            DBRecord rec = this.adapter.getRecord(this.key);
            if (rec != null) {
                this.settingsDef = null;
                this.record = rec;
                return super.refresh();
            }
        }
        catch (IOException e) {
            this.dataMgr.dbError(e);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SettingsDefinition[] getSettingsDefinitions() {
        this.lock.acquire();
        try {
            this.checkIsValid();
            if (this.settingsDef == null) {
                DataType dt = this.getDataType();
                SettingsDefinition[] settingsDefinitions = dt.getSettingsDefinitions();
                TypeDefSettingsDefinition[] typeDefSettingsDefinitions = dt.getTypeDefSettingsDefinitions();
                this.settingsDef = new SettingsDefinition[settingsDefinitions.length + typeDefSettingsDefinitions.length];
                System.arraycopy(settingsDefinitions, 0, this.settingsDef, 0, settingsDefinitions.length);
                System.arraycopy(typeDefSettingsDefinitions, 0, this.settingsDef, settingsDefinitions.length, typeDefSettingsDefinitions.length);
            }
            SettingsDefinition[] settingsDefinitionArray = this.settingsDef;
            return settingsDefinitionArray;
        }
        finally {
            this.lock.release();
        }
    }

    @Override
    public TypeDefSettingsDefinition[] getTypeDefSettingsDefinitions() {
        return this.getDataType().getTypeDefSettingsDefinitions();
    }

    @Override
    protected Settings doGetDefaultSettings() {
        DataTypeSettingsDB settings = new DataTypeSettingsDB(this.dataMgr, this, this.key);
        settings.setLock(this.dataMgr instanceof BuiltInDataTypeManager);
        settings.setAllowedSettingPredicate((Predicate<String>)((Predicate)n -> this.isAllowedSetting((String)n)));
        settings.setDefaultSettings(this.getDataType().getDefaultSettings());
        return settings;
    }

    private boolean isAllowedSetting(String settingName) {
        if (this.dataMgr instanceof ProgramBasedDataTypeManager) {
            return true;
        }
        for (TypeDefSettingsDefinition def : this.getTypeDefSettingsDefinitions()) {
            if (!def.getStorageKey().equals(settingName)) continue;
            return true;
        }
        return false;
    }

    @Override
    public String toString() {
        if (this.isAutoNamed()) {
            return this.getName();
        }
        return "typedef " + this.getName() + " " + this.getDataType().getName();
    }

    @Override
    public String getDefaultLabelPrefix() {
        if (this.isAutoNamed()) {
            return this.getDataType().getDefaultLabelPrefix();
        }
        return this.getName();
    }

    @Override
    public String getDefaultLabelPrefix(MemBuffer buf, Settings settings, int len, DataTypeDisplayOptions options) {
        if (this.isAutoNamed()) {
            return this.getDataType().getDefaultLabelPrefix(buf, settings, len, options);
        }
        return super.getDefaultLabelPrefix(buf, settings, len, options);
    }

    @Override
    public String getDefaultAbbreviatedLabelPrefix() {
        if (this.isAutoNamed()) {
            return this.getDataType().getDefaultAbbreviatedLabelPrefix();
        }
        return super.getDefaultAbbreviatedLabelPrefix();
    }

    @Override
    public String getDefaultOffcutLabelPrefix(MemBuffer buf, Settings settings, int len, DataTypeDisplayOptions options, int offcutLength) {
        if (this.isAutoNamed()) {
            return this.getDataType().getDefaultOffcutLabelPrefix(buf, settings, len, options, offcutLength);
        }
        return super.getDefaultOffcutLabelPrefix(buf, settings, len, options, offcutLength);
    }

    @Override
    public long getLastChangeTime() {
        return this.record.getLongValue(7);
    }

    @Override
    public long getLastChangeTimeInSourceArchive() {
        return this.record.getLongValue(6);
    }

    @Override
    public UniversalID getUniversalID() {
        return new UniversalID(this.record.getLongValue(5));
    }

    @Override
    protected void setUniversalID(UniversalID id) {
        this.lock.acquire();
        try {
            this.checkDeleted();
            this.record.setLongValue(5, id.getValue());
            this.adapter.updateRecord(this.record, false);
            this.dataMgr.dataTypeChanged(this, false);
        }
        catch (IOException e) {
            this.dataMgr.dbError(e);
        }
        finally {
            this.lock.release();
        }
    }

    @Override
    protected UniversalID getSourceArchiveID() {
        return new UniversalID(this.record.getLongValue(4));
    }

    @Override
    protected void setSourceArchiveID(UniversalID id) {
        this.lock.acquire();
        try {
            this.checkDeleted();
            this.record.setLongValue(4, id.getValue());
            this.adapter.updateRecord(this.record, false);
            this.dataMgr.dataTypeChanged(this, false);
        }
        catch (IOException e) {
            this.dataMgr.dbError(e);
        }
        finally {
            this.lock.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setLastChangeTime(long lastChangeTime) {
        this.lock.acquire();
        try {
            this.checkDeleted();
            this.record.setLongValue(7, lastChangeTime);
            this.adapter.updateRecord(this.record, false);
            this.dataMgr.dataTypeChanged(this, false);
        }
        catch (IOException e) {
            this.dataMgr.dbError(e);
        }
        finally {
            this.lock.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setLastChangeTimeInSourceArchive(long lastChangeTimeInSourceArchive) {
        this.lock.acquire();
        try {
            this.checkDeleted();
            this.record.setLongValue(6, lastChangeTimeInSourceArchive);
            this.adapter.updateRecord(this.record, false);
            this.dataMgr.dataTypeChanged(this, false);
        }
        catch (IOException e) {
            this.dataMgr.dbError(e);
        }
        finally {
            this.lock.release();
        }
    }

    @Override
    public void replaceWith(DataType dataType) {
        if (!(dataType instanceof TypeDef)) {
            throw new UnsupportedOperationException();
        }
        if (dataType == this) {
            return;
        }
        this.lock.acquire();
        try {
            TypeDef td = (TypeDef)dataType;
            this.dataTypeReplaced(this.getDataType(), td.getDataType());
            TypedefDataType.copyTypeDefSettings(td, this, true);
        }
        finally {
            this.lock.release();
        }
    }

    @Override
    protected void updatePath(DataTypeDB dt) {
        if (this.isAutoNamed() && dt == this.getDataType()) {
            CategoryPath oldPath = this.getCategoryPath();
            CategoryPath currentPath = dt.getCategoryPath();
            if (!currentPath.equals(oldPath)) {
                try {
                    boolean nameChanged = false;
                    String oldName = this.getName();
                    String newName = this.generateTypedefName(currentPath);
                    if (!newName.equals(oldName)) {
                        nameChanged = true;
                        this.record.setString(2, newName);
                        this.refreshName();
                    }
                    super.setCategoryPath(currentPath);
                    if (nameChanged) {
                        this.notifyNameChanged(oldName);
                    }
                }
                catch (DuplicateNameException duplicateNameException) {
                    // empty catch block
                }
            }
        }
    }

    private String generateTypedefName(CategoryPath path) {
        Object newName = TypedefDataType.generateTypedefName(this);
        DataType dt = this.dataMgr.getDataType(path, (String)newName);
        if (dt == null || dt == this) {
            return newName;
        }
        String baseName = (String)newName + ".conflict";
        newName = baseName;
        int count = 0;
        while ((dt = this.dataMgr.getDataType(path, (String)newName)) != null && dt != this) {
            newName = baseName + ++count;
        }
        return newName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean updateAutoName(boolean notify) {
        this.lock.acquire();
        try {
            String newName;
            this.checkIsValid();
            if (!this.isAutoNamed()) {
                boolean bl = false;
                return bl;
            }
            String oldName = this.getName();
            if (oldName.equals(newName = this.generateTypedefName(this.getCategoryPath()))) {
                boolean bl = false;
                return bl;
            }
            this.record.setString(2, newName);
            this.adapter.updateRecord(this.record, false);
            this.refreshName();
            if (notify) {
                this.notifyNameChanged(oldName);
            }
        }
        catch (IOException e) {
            this.dataMgr.dbError(e);
        }
        finally {
            this.lock.release();
        }
        return true;
    }
}

