/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.assembler.sleigh.sem;

import ghidra.app.plugin.assembler.sleigh.expr.MaskedLong;
import ghidra.app.plugin.assembler.sleigh.sem.AssemblyPatternBlock;
import ghidra.app.plugin.assembler.sleigh.sem.AssemblyResolvedBackfill;
import ghidra.app.plugin.assembler.sleigh.sem.AssemblyResolvedError;
import ghidra.app.plugin.assembler.sleigh.sem.AssemblyResolvedPatterns;
import ghidra.app.plugin.processors.sleigh.Constructor;
import ghidra.app.plugin.processors.sleigh.expression.PatternExpression;
import ghidra.app.plugin.processors.sleigh.pattern.DisjointPattern;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public abstract class AssemblyResolution
implements Comparable<AssemblyResolution> {
    protected final String description;
    protected final List<AssemblyResolution> children;
    protected final AssemblyResolution right;
    private boolean hashed = false;
    private int hash;

    public int hashCode() {
        if (!this.hashed) {
            this.hash = this.computeHash();
            this.hashed = true;
        }
        return this.hash;
    }

    protected abstract int computeHash();

    AssemblyResolution(String description, List<? extends AssemblyResolution> children, AssemblyResolution right) {
        this.description = description;
        this.children = children == null ? List.of() : Collections.unmodifiableList(children);
        this.right = right;
    }

    public static AssemblyResolvedPatterns resolved(AssemblyPatternBlock ins, AssemblyPatternBlock ctx, String description, Constructor cons, List<? extends AssemblyResolution> children, AssemblyResolution right) {
        return new AssemblyResolvedPatterns(description, cons, children, right, ins, ctx, null, null);
    }

    public static AssemblyResolvedPatterns instrOnly(AssemblyPatternBlock ins, String description) {
        return AssemblyResolution.resolved(ins, AssemblyPatternBlock.nop(), description, null, null, null);
    }

    public static AssemblyResolvedPatterns contextOnly(AssemblyPatternBlock ctx, String description) {
        return AssemblyResolution.resolved(AssemblyPatternBlock.nop(), ctx, description, null, null, null);
    }

    public static AssemblyResolvedPatterns fromPattern(DisjointPattern pat, int minLen, String description, Constructor cons) {
        AssemblyPatternBlock ins = AssemblyPatternBlock.fromPattern(pat, minLen, false);
        AssemblyPatternBlock ctx = AssemblyPatternBlock.fromPattern(pat, 0, true);
        return AssemblyResolution.resolved(ins, ctx, description, cons, null, null);
    }

    public static AssemblyResolvedBackfill backfill(PatternExpression exp, MaskedLong goal, int inslen, String description) {
        return new AssemblyResolvedBackfill(description, exp, goal, inslen, 0);
    }

    public static AssemblyResolvedPatterns nop(String description, List<? extends AssemblyResolution> children, AssemblyResolution right) {
        return AssemblyResolution.resolved(AssemblyPatternBlock.nop(), AssemblyPatternBlock.nop(), description, null, children, right);
    }

    public static AssemblyResolvedPatterns nop(String description) {
        return AssemblyResolution.resolved(AssemblyPatternBlock.nop(), AssemblyPatternBlock.nop(), description, null, null, null);
    }

    public static AssemblyResolvedError error(String error, String description, List<? extends AssemblyResolution> children, AssemblyResolution right) {
        return new AssemblyResolvedError(description, children, right, error);
    }

    public static AssemblyResolvedError error(String error, String description) {
        return new AssemblyResolvedError(description, null, null, error);
    }

    public static AssemblyResolution error(String error, AssemblyResolvedPatterns res) {
        return AssemblyResolution.error(error, res.description, res.children, res.right);
    }

    public abstract boolean isError();

    public abstract boolean isBackfill();

    protected abstract String lineToString();

    protected List<AssemblyResolution> getAllRight() {
        ArrayList<AssemblyResolution> result = new ArrayList<AssemblyResolution>();
        this.collectAllRight(result);
        return result;
    }

    protected void collectAllRight(Collection<AssemblyResolution> into) {
        into.add(this);
        if (this.right == null) {
            return;
        }
        this.right.collectAllRight(into);
    }

    protected String childrenToString(String indent) {
        StringBuilder sb = new StringBuilder();
        for (AssemblyResolution child : this.children) {
            sb.append(child.toString(indent) + "\n");
        }
        return sb.substring(0, sb.length() - 1);
    }

    public String toString(String indent) {
        StringBuilder sb = new StringBuilder();
        sb.append(indent);
        sb.append(this.lineToString());
        if (this.hasChildren()) {
            sb.append(":\n");
            String newIndent = indent + "  ";
            sb.append(this.childrenToString(newIndent));
        }
        return sb.toString();
    }

    public String toString() {
        return this.toString("");
    }

    @Override
    public int compareTo(AssemblyResolution that) {
        return this.toString().compareTo(that.toString());
    }

    public boolean hasChildren() {
        if (this.children == null) {
            return false;
        }
        return this.children.size() != 0;
    }

    public abstract AssemblyResolution shift(int var1);

    public AssemblyResolution withoutRight() {
        return this.withRight(null);
    }

    public abstract AssemblyResolution withRight(AssemblyResolution var1);

    public abstract AssemblyResolution parent(String var1, int var2);
}

