/*
 * Decompiled with CFR 0.152.
 */
package org.jf.baksmali.Adaptors;

import java.io.IOException;
import java.io.Writer;
import org.jf.dexlib.FieldIdItem;
import org.jf.dexlib.Item;
import org.jf.dexlib.MethodIdItem;
import org.jf.dexlib.StringIdItem;
import org.jf.dexlib.TypeIdItem;
import org.jf.dexlib.Util.Utf8Utils;
import org.jf.util.IndentingWriter;

public class ReferenceFormatter {
    public static void writeReference(IndentingWriter writer, Item item) throws IOException {
        switch (item.getItemType()) {
            case TYPE_METHOD_ID_ITEM: {
                ReferenceFormatter.writeMethodReference(writer, (MethodIdItem)item);
                return;
            }
            case TYPE_FIELD_ID_ITEM: {
                ReferenceFormatter.writeFieldReference(writer, (FieldIdItem)item);
                return;
            }
            case TYPE_STRING_ID_ITEM: {
                ReferenceFormatter.writeStringReference(writer, (StringIdItem)item);
                return;
            }
            case TYPE_TYPE_ID_ITEM: {
                ReferenceFormatter.writeTypeReference(writer, (TypeIdItem)item);
                return;
            }
        }
    }

    public static void writeMethodReference(IndentingWriter writer, MethodIdItem item) throws IOException {
        writer.write(item.getContainingClass().getTypeDescriptor());
        writer.write("->");
        writer.write(item.getMethodName().getStringValue());
        writer.write(item.getPrototype().getPrototypeString());
    }

    public static void writeFieldReference(IndentingWriter writer, FieldIdItem item) throws IOException {
        writer.write(item.getContainingClass().getTypeDescriptor());
        writer.write("->");
        writer.write(item.getFieldName().getStringValue());
        writer.write(58);
        writer.write(item.getFieldType().getTypeDescriptor());
    }

    public static void writeStringReference(IndentingWriter writer, StringIdItem item) throws IOException {
        writer.write(34);
        Utf8Utils.writeEscapedString((Writer)writer, (String)item.getStringValue());
        writer.write(34);
    }

    public static void writeTypeReference(IndentingWriter writer, TypeIdItem item) throws IOException {
        writer.write(item.getTypeDescriptor());
    }
}

