/*
 * Decompiled with CFR 0.152.
 */
package ghidra.graph.program;

import docking.widgets.EventTrigger;
import ghidra.framework.plugintool.PluginTool;
import ghidra.graph.DataFlowGraphType;
import ghidra.graph.ProgramGraphDisplayOptions;
import ghidra.graph.ProgramGraphType;
import ghidra.graph.program.DataReferenceGraph;
import ghidra.graph.program.DataReferenceGraphDisplayListener;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressSet;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.listing.CodeUnit;
import ghidra.program.model.listing.Program;
import ghidra.program.util.ProgramLocation;
import ghidra.program.util.ProgramSelection;
import ghidra.service.graph.AttributedGraph;
import ghidra.service.graph.AttributedVertex;
import ghidra.service.graph.GraphDisplay;
import ghidra.service.graph.GraphDisplayListener;
import ghidra.service.graph.GraphDisplayOptions;
import ghidra.service.graph.GraphDisplayProvider;
import ghidra.util.Msg;
import ghidra.util.exception.CancelledException;
import ghidra.util.exception.GraphException;
import ghidra.util.task.Task;
import ghidra.util.task.TaskMonitor;

public class DataReferenceGraphTask
extends Task {
    private static final String VERTEX_COLOR_OVERRIDE = "Color";
    private String graphTitle;
    private GraphDisplayProvider graphProvider;
    private boolean reuseGraph;
    private boolean appendGraph;
    private PluginTool tool;
    private Program program;
    private int totalMaxDepth;
    private int maxLabelLength;
    private ProgramLocation location;
    private DataReferenceGraph.Directions direction;
    private AddressSet addresses;
    private GraphDisplay display;

    public DataReferenceGraphTask(boolean reuseGraph, boolean appendToGraph, PluginTool tool, ProgramSelection selection, ProgramLocation location, GraphDisplayProvider graphProvider, int maxDepth, int maxLines, DataReferenceGraph.Directions direction) {
        super("Graph Data References", true, false, true);
        this.reuseGraph = reuseGraph;
        this.appendGraph = appendToGraph;
        this.tool = tool;
        this.graphProvider = graphProvider;
        this.program = location.getProgram();
        this.graphTitle = "Data references for: ";
        this.totalMaxDepth = maxDepth;
        this.maxLabelLength = maxLines;
        this.location = location;
        this.direction = direction;
        this.display = null;
        this.graphTitle = this.graphTitle + location.getAddress().toString();
        Address locationAddress = location.getAddress();
        this.addresses = new AddressSet(locationAddress);
        if (selection != null && selection.contains(locationAddress)) {
            this.addresses.add((AddressSetView)selection);
        } else {
            Address unitAddress = this.program.getListing().getCodeUnitContaining(locationAddress).getAddress();
            this.addresses.add(unitAddress);
        }
    }

    public DataReferenceGraphTask(PluginTool tool, Program program, AddressSet addresses, GraphDisplay display, int maxDepth, DataReferenceGraph.Directions direction) {
        super("Graph Data References", true, false, true);
        this.reuseGraph = true;
        this.appendGraph = true;
        this.tool = tool;
        this.display = display;
        this.program = program;
        this.graphTitle = display.getGraphTitle();
        this.totalMaxDepth = maxDepth;
        this.maxLabelLength = 10;
        this.direction = direction;
        this.addresses = addresses;
    }

    public void run(TaskMonitor monitor) throws CancelledException {
        block7: {
            DataReferenceGraph graph = new DataReferenceGraph(this.program, this.totalMaxDepth);
            monitor.setMessage("Generating Graph...");
            monitor.setIndeterminate(true);
            try {
                for (CodeUnit unit : this.program.getListing().getCodeUnits((AddressSetView)this.addresses, true)) {
                    monitor.checkCanceled();
                    AttributedVertex centerVertex = graph.graphFrom(unit.getAddress(), this.direction, monitor);
                    centerVertex.setAttribute(VERTEX_COLOR_OVERRIDE, "Orange");
                }
            }
            catch (CancelledException e) {
                monitor.setMessage("Cancelling");
                this.graphTitle = this.graphTitle + " (partial)";
            }
            try {
                if (this.display == null) {
                    this.display = this.graphProvider.getGraphDisplay(this.reuseGraph, monitor);
                    DataReferenceGraphDisplayListener listener = new DataReferenceGraphDisplayListener(this.tool, this.display, this.program, this.totalMaxDepth);
                    this.display.setGraphDisplayListener((GraphDisplayListener)listener);
                }
                ProgramGraphDisplayOptions graphDisplayOptions = new ProgramGraphDisplayOptions((ProgramGraphType)new DataFlowGraphType(), this.tool);
                graphDisplayOptions.setVertexColorOverrideAttributeKey(VERTEX_COLOR_OVERRIDE);
                this.display.setGraph((AttributedGraph)graph, (GraphDisplayOptions)graphDisplayOptions, this.graphTitle, this.appendGraph, monitor);
                if (this.location != null) {
                    AttributedVertex vertex = graph.getVertex(graph.makeName(this.location.getAddress()));
                    this.display.setFocusedVertex(vertex, EventTrigger.INTERNAL_ONLY);
                }
            }
            catch (GraphException e) {
                if (monitor.isCancelled()) break block7;
                Msg.showError((Object)((Object)this), null, (String)"Reference Graph Error", (Object)("Unexpected error while graphing: " + e.getMessage()), (Throwable)e);
            }
        }
    }
}

