/*
 * Decompiled with CFR 0.152.
 */
package agent.dbgmodel.impl.dbgmodel.concept;

import agent.dbgmodel.dbgmodel.DbgModel;
import agent.dbgmodel.dbgmodel.UnknownEx;
import agent.dbgmodel.dbgmodel.main.KeyStore;
import agent.dbgmodel.dbgmodel.main.ModelObject;
import agent.dbgmodel.impl.dbgmodel.UnknownExInternal;
import agent.dbgmodel.impl.dbgmodel.concept.DynamicConceptProviderConceptInternal;
import agent.dbgmodel.impl.dbgmodel.main.KeyStoreInternal;
import agent.dbgmodel.jna.dbgmodel.WrapIUnknownEx;
import agent.dbgmodel.jna.dbgmodel.concept.IDynamicConceptProviderConcept;
import agent.dbgmodel.jna.dbgmodel.main.WrapIKeyStore;
import com.sun.jna.Pointer;
import com.sun.jna.platform.win32.COM.COMUtils;
import com.sun.jna.platform.win32.Guid;
import com.sun.jna.platform.win32.WinDef;
import com.sun.jna.platform.win32.WinNT;
import com.sun.jna.ptr.PointerByReference;

public class DynamicConceptProviderConceptImpl
implements DynamicConceptProviderConceptInternal {
    private final DbgModel.OpaqueCleanable cleanable;
    private final IDynamicConceptProviderConcept jnaData;
    private UnknownEx conceptInterface;
    private KeyStore conceptMetadata;
    private KeyStore metadata;

    public DynamicConceptProviderConceptImpl(IDynamicConceptProviderConcept jnaData) {
        this.cleanable = DbgModel.releaseWhenPhantom((Object)this, jnaData);
        this.jnaData = jnaData;
    }

    @Override
    public Pointer getPointer() {
        return this.jnaData.getPointer();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean getConcept(ModelObject contextObject, Guid.REFIID conceptId) {
        Pointer pContextObject = contextObject.getPointer();
        PointerByReference ppConceptInterface = new PointerByReference();
        PointerByReference ppConceptMetadata = new PointerByReference();
        WinDef.BOOLByReference pHasConcept = new WinDef.BOOLByReference();
        COMUtils.checkRC((WinNT.HRESULT)this.jnaData.GetConcept(pContextObject, conceptId, ppConceptInterface, ppConceptMetadata, pHasConcept));
        WrapIUnknownEx wrap0 = new WrapIUnknownEx(ppConceptInterface.getValue());
        try {
            this.conceptInterface = UnknownExInternal.tryPreferredInterfaces(wrap0::QueryInterface);
        }
        finally {
            wrap0.Release();
        }
        WrapIKeyStore wrap1 = new WrapIKeyStore(ppConceptInterface.getValue());
        try {
            this.conceptMetadata = KeyStoreInternal.tryPreferredInterfaces(wrap1::QueryInterface);
        }
        finally {
            wrap1.Release();
        }
        return pHasConcept.getValue().booleanValue();
    }

    @Override
    public void setConcept(ModelObject contextObject, Guid.REFIID conceptId, UnknownEx conceptInterface, KeyStore conceptMetadata) {
        Pointer pContextObject = contextObject.getPointer();
        Pointer pConceptInterface = conceptInterface.getPointer();
        Pointer pConceptMetadata = conceptMetadata.getPointer();
        COMUtils.checkRC((WinNT.HRESULT)this.jnaData.SetConcept(pContextObject, conceptId, pConceptInterface, pConceptMetadata));
    }

    @Override
    public void notifyParent(ModelObject parentModel) {
        Pointer pParentModel = parentModel.getPointer();
        COMUtils.checkRC((WinNT.HRESULT)this.jnaData.NotifyParent(pParentModel));
    }

    @Override
    public void notifyParentChange(ModelObject parentModel) {
        Pointer pParentModel = parentModel.getPointer();
        COMUtils.checkRC((WinNT.HRESULT)this.jnaData.NotifyParent(pParentModel));
    }

    @Override
    public void notifyDestruct() {
        COMUtils.checkRC((WinNT.HRESULT)this.jnaData.NotifyDestruct());
    }

    public UnknownEx getConceptInterface() {
        return this.conceptInterface;
    }

    public KeyStore getConceptMetadata() {
        return this.conceptMetadata;
    }

    @Override
    public KeyStore getMetadata() {
        return this.metadata;
    }

    @Override
    public void setMetadata(KeyStore metdata) {
        this.metadata = metdata;
    }
}

