/*
 * Decompiled with CFR 0.152.
 */
package ghidra.feature.vt.gui.provider.onetomany;

import docking.ActionContext;
import docking.ComponentProvider;
import docking.action.DockingActionIf;
import docking.widgets.label.GDLabel;
import docking.widgets.table.GTable;
import docking.widgets.table.RowObjectTableModel;
import docking.widgets.table.threaded.ThreadedTableModel;
import ghidra.feature.vt.api.main.VTMarkupItem;
import ghidra.feature.vt.api.main.VTMatch;
import ghidra.feature.vt.api.main.VTSession;
import ghidra.feature.vt.gui.actions.AcceptMatchAction;
import ghidra.feature.vt.gui.actions.ClearMatchAction;
import ghidra.feature.vt.gui.actions.SetVTMatchFromOneToManyAction;
import ghidra.feature.vt.gui.filters.Filter;
import ghidra.feature.vt.gui.filters.FilterDialogModel;
import ghidra.feature.vt.gui.filters.FilterStatusListener;
import ghidra.feature.vt.gui.plugin.VTController;
import ghidra.feature.vt.gui.plugin.VTControllerListener;
import ghidra.feature.vt.gui.plugin.VTPlugin;
import ghidra.feature.vt.gui.plugin.VTSubToolManager;
import ghidra.feature.vt.gui.plugin.VTSubToolManagerListener;
import ghidra.feature.vt.gui.provider.markuptable.DisplayableListingAddress;
import ghidra.feature.vt.gui.provider.matchtable.MatchTableRenderer;
import ghidra.feature.vt.gui.provider.onetomany.VTMatchOneToManyContext;
import ghidra.feature.vt.gui.provider.onetomany.VTMatchOneToManyTableModel;
import ghidra.feature.vt.gui.util.AbstractVTMatchTableModel;
import ghidra.feature.vt.gui.util.MatchInfo;
import ghidra.feature.vt.gui.util.MatchStatusRenderer;
import ghidra.framework.model.DomainObjectChangeRecord;
import ghidra.framework.model.DomainObjectChangedEvent;
import ghidra.framework.options.Options;
import ghidra.framework.plugintool.ComponentProviderAdapter;
import ghidra.framework.plugintool.PluginTool;
import ghidra.program.model.address.Address;
import ghidra.program.model.listing.Program;
import ghidra.program.model.symbol.Symbol;
import ghidra.program.model.symbol.SymbolTable;
import ghidra.util.HelpLocation;
import ghidra.util.SystemUtilities;
import ghidra.util.layout.HorizontalLayout;
import ghidra.util.table.GhidraTable;
import ghidra.util.table.GhidraThreadedTablePanel;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.JTable;
import javax.swing.JToggleButton;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import resources.ResourceManager;

public abstract class VTMatchOneToManyTableProvider
extends ComponentProviderAdapter
implements FilterDialogModel<VTMatch>,
VTControllerListener,
VTSubToolManagerListener {
    private static final String TITLE_PREFIX = "Version Tracking Matches for ";
    private static final Icon ICON = ResourceManager.loadImage((String)"images/text_list_bullets.png");
    protected static final Color LOCAL_INFO_FOREGROUND_COLOR = new Color(0, 128, 0);
    private JComponent component;
    private MatchThreadedTablePanel tablePanel;
    protected GhidraTable matchesTable;
    private ListSelectionListener matchSelectionListener;
    protected VTMatchOneToManyTableModel oneToManyTableModel;
    private JToggleButton ancillaryFilterButton;
    private Set<Filter<VTMatch>> filters = new HashSet<Filter<VTMatch>>();
    private FilterStatusListener refilterListener = new RefilterListener();
    protected final VTController controller;
    protected final VTSubToolManager subToolManager;
    private Address matchAddress = null;
    private JPanel localPanel;
    private JLabel label;
    private JLabel labelValue;
    private JLabel labelType;
    private JLabel labelTypeValue;
    private JLabel address;
    private JLabel addressValue;
    private boolean isSource;
    private VTMatch latestMatch;
    private boolean filteringFrozen;
    private VTMatch pendingMatchSelection;

    public VTMatchOneToManyTableProvider(PluginTool tool, VTController controller, VTSubToolManager subToolManager, boolean isSource) {
        super(tool, TITLE_PREFIX + (isSource ? "Source" : "Destination"), VTPlugin.OWNER);
        this.controller = controller;
        this.subToolManager = subToolManager;
        this.isSource = isSource;
        this.setWindowGroup("VTResults");
        this.setIcon(ICON);
        this.component = this.createComponent();
        this.createActions();
        controller.addListener(this);
        subToolManager.addListener(this);
        this.addToTool();
        HelpLocation helpLocation = new HelpLocation("VersionTrackingPlugin", "Related Matches Table");
        this.setHelpLocation(helpLocation);
        this.setVisible(true);
    }

    public String getTitle() {
        return TITLE_PREFIX + (this.isSource ? "Source" : "Destination");
    }

    private void createActions() {
        this.addLocalAction((DockingActionIf)new SetVTMatchFromOneToManyAction(this.controller, true));
        this.addLocalAction((DockingActionIf)new ClearMatchAction(this.controller));
        this.addLocalAction((DockingActionIf)new AcceptMatchAction(this.controller));
    }

    public void componentHidden() {
        this.matchesTable.getSelectionModel().clearSelection();
        this.loadLocalInfo(null);
        this.oneToManyTableModel.setAddress(null);
    }

    public void componentShown() {
        this.oneToManyTableModel.sessionChanged();
        this.setSelectedMatch(this.latestMatch);
        this.setAddress(this.matchAddress);
    }

    JTable getTable() {
        return this.matchesTable;
    }

    private JComponent createComponent() {
        JPanel localMatchInfoPanel = this.createLocalInfoPanel();
        this.matchesTable = this.initializeMatchesTable();
        JPanel matchDestinationTablePanel = new JPanel(new BorderLayout());
        matchDestinationTablePanel.add((Component)((Object)this.tablePanel), "Center");
        JPanel parentPanel = new JPanel(new BorderLayout());
        parentPanel.add((Component)localMatchInfoPanel, "North");
        parentPanel.add((Component)matchDestinationTablePanel, "Center");
        return parentPanel;
    }

    protected GhidraTable initializeMatchesTable() {
        this.oneToManyTableModel = this.getMatchesTableModel();
        this.oneToManyTableModel.addTableModelListener(e -> {
            if (this.pendingMatchSelection != null) {
                this.setSelectedMatch(this.pendingMatchSelection);
            }
        });
        this.tablePanel = new MatchThreadedTablePanel((ThreadedTableModel<VTMatch, ?>)this.oneToManyTableModel);
        final GhidraTable table = this.tablePanel.getTable();
        this.matchSelectionListener = new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                VTMatch match;
                if (e.getValueIsAdjusting()) {
                    return;
                }
                RowObjectTableModel model = (RowObjectTableModel)table.getModel();
                int selectedRow = table.getSelectedRow();
                VTMatch vTMatch = match = table.getSelectedRowCount() == 1 ? (VTMatch)model.getRowObject(selectedRow) : null;
                if (!SystemUtilities.isEqual((Object)VTMatchOneToManyTableProvider.this.latestMatch, (Object)match) && match != null) {
                    VTMatchOneToManyTableProvider.this.latestMatch = match;
                    VTMatchOneToManyTableProvider.this.subToolManager.setMatch(match);
                }
                VTMatchOneToManyTableProvider.this.notifyContextChanged();
            }
        };
        ListSelectionModel selectionModel = table.getSelectionModel();
        selectionModel.addListSelectionListener(this.matchSelectionListener);
        TableColumnModel columnModel = table.getColumnModel();
        int statusColumnIndex = this.oneToManyTableModel.getColumnIndex(AbstractVTMatchTableModel.StatusTableColumn.class);
        TableColumn statusColumn = columnModel.getColumn(statusColumnIndex);
        statusColumn.setCellRenderer((TableCellRenderer)((Object)new MatchStatusRenderer()));
        Dimension size = table.getPreferredScrollableViewportSize();
        Dimension preferredSize = table.getPreferredSize();
        JScrollBar scrollBar = new JScrollBar(1);
        Dimension scrollBarSize = scrollBar.getMinimumSize();
        size.width = preferredSize.width + scrollBarSize.width;
        table.setPreferredScrollableViewportSize(size);
        return table;
    }

    protected abstract VTMatchOneToManyTableModel getMatchesTableModel();

    private void refilter() {
        if (this.filteringFrozen) {
            return;
        }
        this.oneToManyTableModel.reFilter();
    }

    @Override
    public void setSelectedMatch(VTMatch match) {
        int row = this.oneToManyTableModel.getRowIndex(match);
        if (row < 0) {
            this.pendingMatchSelection = match;
            return;
        }
        this.pendingMatchSelection = null;
        this.matchesTable.getSelectionModel().setSelectionInterval(row, row);
        Rectangle rect = this.matchesTable.getCellRect(row, 0, false);
        this.matchesTable.scrollRectToVisible(rect);
    }

    public void repaint() {
        if (this.matchesTable == null) {
            return;
        }
        this.matchesTable.repaint();
    }

    public void reload() {
        this.oneToManyTableModel.clearData();
        this.oneToManyTableModel.reload();
    }

    public JComponent getComponent() {
        return this.component;
    }

    @Override
    public void disposed() {
        if (this.matchesTable == null) {
            return;
        }
        ListSelectionModel selectionModel = this.matchesTable.getSelectionModel();
        selectionModel.removeListSelectionListener(this.matchSelectionListener);
        this.oneToManyTableModel.dispose();
        for (Filter<VTMatch> filter : this.filters) {
            filter.dispose();
        }
    }

    public ActionContext getActionContext(MouseEvent event) {
        List<VTMatch> selectedMatches = this.getSelectedMatches();
        return new VTMatchOneToManyContext(this, selectedMatches);
    }

    private List<VTMatch> getSelectedMatches() {
        ArrayList<VTMatch> list = new ArrayList<VTMatch>();
        int selectedRowCount = this.matchesTable.getSelectedRowCount();
        if (selectedRowCount == 1) {
            int row = this.matchesTable.getSelectedRow();
            VTMatch mySelectedMatch = (VTMatch)this.oneToManyTableModel.getRowObject(row);
            list.add(mySelectedMatch);
        }
        return list;
    }

    private void notifyContextChanged() {
        this.tool.contextChanged((ComponentProvider)this);
    }

    public void setAddress(Address matchAddress) {
        boolean sameAsLastAddress = SystemUtilities.isEqual((Object)this.matchAddress, (Object)matchAddress);
        if (!sameAsLastAddress) {
            this.matchAddress = matchAddress;
        }
        if (!this.isVisible() || this.controller.getSession() == null) {
            return;
        }
        if (!sameAsLastAddress) {
            this.matchesTable.getSelectionModel().clearSelection();
        }
        this.loadLocalInfo(matchAddress);
        this.oneToManyTableModel.setAddress(matchAddress);
    }

    protected JPanel createLocalInfoPanel() {
        this.localPanel = new JPanel((LayoutManager)new HorizontalLayout(10));
        JPanel labelPanel = new JPanel();
        JPanel labelTypePanel = new JPanel();
        JPanel addressPanel = new JPanel();
        String labelText = (this.isSource ? "Source" : "Destination") + " Label: ";
        this.label = new GDLabel(labelText);
        this.labelValue = new GDLabel("     ");
        this.labelValue.setForeground(LOCAL_INFO_FOREGROUND_COLOR);
        labelPanel.add(this.label);
        labelPanel.add(this.labelValue);
        String labelTypeText = "Label Type: ";
        this.labelType = new GDLabel(labelTypeText);
        this.labelTypeValue = new GDLabel("     ");
        this.labelTypeValue.setForeground(LOCAL_INFO_FOREGROUND_COLOR);
        labelTypePanel.add(this.labelType);
        labelTypePanel.add(this.labelTypeValue);
        String addressText = (this.isSource ? "Source" : "Destination") + " Address: ";
        this.address = new GDLabel(addressText);
        this.addressValue = new GDLabel("     ");
        this.addressValue.setForeground(LOCAL_INFO_FOREGROUND_COLOR);
        addressPanel.add(this.address);
        addressPanel.add(this.addressValue);
        this.localPanel.add(labelPanel);
        this.localPanel.add(labelTypePanel);
        this.localPanel.add(addressPanel);
        return this.localPanel;
    }

    public void loadLocalInfo(Address infoAddress) {
        if (infoAddress == null) {
            this.labelValue.setText("");
            this.labelTypeValue.setText("");
            this.addressValue.setText("");
            return;
        }
        VTSession session = this.controller.getSession();
        Program program = this.isSource ? session.getSourceProgram() : session.getDestinationProgram();
        SymbolTable symbolTable = program.getSymbolTable();
        Symbol symbol = symbolTable.getPrimarySymbol(infoAddress);
        String labelValueText = symbol == null ? "<No Symbol>" : symbol.getName();
        this.labelValue.setText(labelValueText);
        String labelTypeValueText = symbol == null ? "<none>" : symbol.getSource().getDisplayString();
        this.labelTypeValue.setText(labelTypeValueText);
        DisplayableListingAddress displayableAddress = new DisplayableListingAddress(program, infoAddress);
        this.addressValue.setText(displayableAddress.getDisplayString());
        this.localPanel.validate();
        this.localPanel.invalidate();
    }

    @Override
    public void matchSelected(MatchInfo matchInfo) {
        VTMatch match;
        VTMatch vTMatch = match = matchInfo == null ? null : matchInfo.getMatch();
        if (match == this.latestMatch) {
            return;
        }
        this.latestMatch = match;
        if (!this.isVisible()) {
            return;
        }
        this.setSelectedMatch(match);
    }

    @Override
    public void sessionChanged(VTSession session) {
        this.latestMatch = null;
        if (!this.isVisible()) {
            return;
        }
        this.oneToManyTableModel.sessionChanged();
    }

    @Override
    public void sessionUpdated(DomainObjectChangedEvent ev) {
        if (!this.isVisible()) {
            return;
        }
        boolean matchesContextChanged = false;
        for (int i = 0; i < ev.numRecords(); ++i) {
            DomainObjectChangeRecord doRecord = ev.getChangeRecord(i);
            int eventType = doRecord.getEventType();
            if (eventType == 1027 || eventType == 1021 || eventType == 1024) {
                this.oneToManyTableModel.refresh();
                this.repaint();
                matchesContextChanged = true;
                continue;
            }
            if (eventType != 4 && eventType != 1010 && eventType != 1022 && eventType != 1023) continue;
            this.reload();
            this.repaint();
            matchesContextChanged = true;
        }
        if (matchesContextChanged) {
            this.tool.contextChanged((ComponentProvider)this);
        }
    }

    @Override
    public void optionsChanged(Options options) {
    }

    @Override
    public void markupItemSelected(VTMarkupItem markupItem) {
    }

    @Override
    public void addFilter(Filter<VTMatch> filter) {
        filter.addFilterStatusListener(this.refilterListener);
        this.filters.add(filter);
        this.oneToManyTableModel.addFilter(filter);
    }

    @Override
    public void forceRefilter() {
        this.oneToManyTableModel.reFilter();
    }

    @Override
    public void dialogVisibilityChanged(boolean isVisible) {
        if (!isVisible) {
            this.ancillaryFilterButton.setSelected(false);
        }
        this.filteringFrozen = isVisible;
        this.refilter();
    }

    private class RefilterListener
    implements FilterStatusListener {
        private RefilterListener() {
        }

        @Override
        public void filterStatusChanged(Filter.FilterEditingStatus status) {
            if (status != Filter.FilterEditingStatus.ERROR) {
                VTMatchOneToManyTableProvider.this.refilter();
            }
        }
    }

    private class MatchThreadedTablePanel
    extends GhidraThreadedTablePanel<VTMatch> {
        MatchThreadedTablePanel(ThreadedTableModel<VTMatch, ?> model) {
            super(model);
        }

        protected GTable createTable(ThreadedTableModel<VTMatch, ?> model) {
            return new MatchTable((RowObjectTableModel<VTMatch>)model);
        }

        private class MatchTable
        extends GhidraTable {
            private TableCellRenderer renderer;

            MatchTable(RowObjectTableModel<VTMatch> model) {
                super(model);
                this.renderer = new MatchTableRenderer();
            }

            public TableCellRenderer getCellRenderer(int row, int col) {
                return this.renderer;
            }
        }
    }
}

